/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class TimelineModel {
    private final int mode;
    private ArrayList<TimelineSelectionListener> selectionListeners = new ArrayList();
    private ArrayList<TimelineModelListener> modelListeners = new ArrayList();
    private TimelineIndex totalStart;
    private TimelineIndex totalEnd;
    private int stepsInTotalDuration;
    private TimelineIndex selectionStart;
    private TimelineIndex selectionEnd;

    public TimelineModel(long totalStart, long totalEnd, int mode) {
        this.mode = mode;
        this.setTotalDuration(totalStart, totalEnd);
        this.setTimeSelection(totalStart, totalEnd);
    }

    public int getDaysBetween(TimelineIndex start, TimelineIndex end) {
        if (end.year == start.year) {
            return end.dayOfYear - start.dayOfYear;
        }
        int yearsInBetween = Math.max(end.year - start.year - 1, 0);
        return start.getRemainingDayInYear() + yearsInBetween * 365 + end.dayOfYear;
    }

    public int getMonthsBetween(TimelineIndex start, TimelineIndex end) {
        if (end.year == start.year) {
            return end.monthOfYear - start.monthOfYear;
        }
        int yearsInBetween = Math.max(end.year - start.year - 1, 0);
        return start.getRemainingMonthsInYear() + yearsInBetween * 12 + end.monthOfYear;
    }

    public void setTotalDuration(long totalStart, long totalEnd) {
        this.totalStart = new TimelineIndex(totalStart, true);
        this.totalEnd = new TimelineIndex(totalEnd, false);
        this.stepsInTotalDuration = this.getUnitsBetween(this.totalStart, this.totalEnd);
        if (this.selectionStart != null) {
            long leftBound = this.totalStart.getTime();
            if (this.selectionStart.getTime() < leftBound) {
                this.selectionStart = new TimelineIndex(leftBound, true);
            }
        }
        if (this.selectionEnd != null) {
            long rightBound = this.totalEnd.getTime();
            if (this.selectionEnd.getTime() > rightBound) {
                this.selectionEnd = new TimelineIndex(rightBound, false);
            }
        }
        this.notifyModelChanged();
    }

    private int getUnitsBetween(TimelineIndex start, TimelineIndex end) {
        if (this.mode == 1) {
            return this.getDaysBetween(start, end);
        }
        return this.getMonthsBetween(start, end);
    }

    public void addTimelineListener(TimelineSelectionListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public void addTimelineModelListener(TimelineModelListener listener) {
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public int getTotalSteps() {
        return this.stepsInTotalDuration;
    }

    public long getSelectionStartTime() {
        return this.selectionStart.getTime();
    }

    public long getSelectionEndTime() {
        return this.selectionEnd.getTime();
    }

    public long getAbsoluteStartTime() {
        return this.totalStart.getTime();
    }

    public long getAbsoluteEndTime() {
        return this.totalEnd.getTime();
    }

    public int getLeftIndex() {
        return this.getIndexFor(this.selectionStart);
    }

    private int getIndexFor(TimelineIndex index) {
        if (this.mode == 1) {
            return this.getDaysBetween(this.totalStart, index);
        }
        return this.getMonthsBetween(this.totalStart, index);
    }

    public int getRightIndex() {
        return this.getIndexFor(this.selectionEnd) - 1;
    }

    public void setLeftIndex(int leftIndex) {
        long prev = this.selectionStart == null ? -1L : this.selectionStart.getTime();
        this.selectionStart = this.totalStart.getNewIndex(leftIndex, true);
        if (this.selectionStart.getTime() != prev) {
            this.notifyDurationChanged();
        }
    }

    public void setRightIndex(int rightIndex) {
        long prev = this.selectionEnd == null ? -1L : this.selectionEnd.getTime();
        this.selectionEnd = this.totalStart.getNewIndex(rightIndex, false);
        if (this.selectionEnd.getTime() != prev) {
            this.notifyDurationChanged();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void notifyModelChanged() {
        for (TimelineModelListener listener : this.modelListeners) {
            listener.modelChanged();
        }
    }

    public void notifyDurationChanged() {
        for (TimelineSelectionListener listener : this.selectionListeners) {
            listener.timelineChanged(this.selectionStart.getTime(), this.selectionEnd.getTime());
        }
    }

    public boolean hasTimePeriods() {
        return this.getLeftIndex() != this.getRightIndex();
    }

    public void setTimeSelection(long start, long end) {
        this.selectionStart = new TimelineIndex(start, true);
        this.selectionEnd = new TimelineIndex(end, false);
    }

    public void setSliderToShowAllData() {
        this.setTimeSelection(this.totalStart.getTime(), this.totalEnd.getTime());
    }

    class TimelineIndex {
        private final boolean inclusive;
        int dayOfYear;
        int dayOfMonth;
        int monthOfYear;
        int year;

        public TimelineIndex(long time, boolean inclusive) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(time);
            this.inclusive = inclusive;
            if (!inclusive) {
                if (TimelineModel.this.mode == 1) {
                    c.add(5, 1);
                } else {
                    c.set(5, 1);
                    c.add(2, 1);
                }
            }
            this.dayOfMonth = c.get(5);
            this.year = c.get(1);
            this.monthOfYear = c.get(2);
            this.dayOfYear = c.get(6);
        }

        public String toString() {
            if (TimelineModel.this.mode == 1) {
                return this.year + "/" + this.monthOfYear + "/" + this.dayOfMonth;
            }
            return this.year + "/" + this.monthOfYear;
        }

        public int getRemainingMonthsInYear() {
            return 12 - this.monthOfYear;
        }

        public int getRemainingDayInYear() {
            boolean isLeapYear;
            boolean bl = isLeapYear = this.year % 4 == 0;
            if (isLeapYear) {
                return 366 - this.dayOfYear;
            }
            return 365 - this.dayOfYear;
        }

        public long getTime() {
            Calendar c = Calendar.getInstance();
            c.set(1, this.year);
            c.set(6, this.dayOfYear);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            if (!this.inclusive) {
                c.add(14, -1);
            }
            return c.getTimeInMillis();
        }

        public TimelineIndex getNewIndex(int index, boolean inclusive) {
            Calendar c = Calendar.getInstance();
            c.setTimeZone(TimeZone.getTimeZone("GMT"));
            c.set(1, this.year);
            c.set(2, this.monthOfYear);
            c.set(6, this.dayOfYear);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            if (TimelineModel.this.mode == 0) {
                c.add(2, index);
            } else {
                c.add(6, index);
            }
            return new TimelineIndex(c.getTimeInMillis(), inclusive);
        }
    }

    public static interface TimelineModelListener {
        public void modelChanged();
    }

    public static interface TimelineSelectionListener {
        public void timelineChanged(long var1, long var3);
    }
}

