/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.history.HistoryListener;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.PleaseWaitDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.files.FileUtil;
import utils.progtools.StackTracer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.LeftRightButton;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class MultiSessionPanel
extends GbPanel
implements ActionListener {
    private final HistoryListener historyListener;
    private LeftRightButton exportButton;
    private LeftRightButton deleteButton;
    private AbstractSession[] sessions;
    private JLabel summaryLabel;
    private JLabel deleteLabel;

    public MultiSessionPanel(HistoryListener historyListener) {
        super(new ScaledInsets(3, 3, 3, 3));
        this.historyListener = historyListener;
        this.initUI();
    }

    private JLabel getDescLabel(String text) {
        JWrapLabel descLabel = new JWrapLabel("<html>" + text);
        descLabel.setFont(SHStyle.smallerFont);
        descLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        return descLabel;
    }

    public void initUI() {
        this.summaryLabel = new JLabel(Language.get("MULTI_SESSION_OPTIONS"));
        this.summaryLabel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)5, (int)0));
        this.summaryLabel.setFont(SHStyle.largeFont);
        this.summaryLabel.setVisible(false);
        int Y = 0;
        this.add(this.summaryLabel, 0, Y++, 2, 1, 1, 0, 11, 2);
        this.exportButton = new LeftRightButton(Language.get("EXPORT"), ImageLoader.getImageIcon((String)"images/svg/arrows/share.svg,16"));
        this.exportButton.setRightColour(Color.GRAY);
        this.exportButton.addActionListener(this);
        this.exportButton.setHorizontalAlignment(2);
        String label = Language.exists("DELETE_HISTORY") ? Language.get("DELETE_HISTORY") : Language.get("REMOVE");
        this.deleteButton = new LeftRightButton(label, ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.deleteButton.setRightColour(Color.GRAY);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setHorizontalAlignment(2);
        JLabel descLabel = this.getDescLabel(Language.get("EXPORT_SESSIONS_DESC"));
        this.add(this.exportButton, 0, Y, 1, 1, 0, 0, 10, 2, (Insets)new ScaledInsets(3, 5, 3, 10));
        this.add(descLabel, 1, Y++, 1, 1, 1000, 0, 17, 2);
        this.deleteLabel = this.getDescLabel(Language.get("DELETE_SESSIONS_DESC"));
        this.add(this.deleteButton, 0, Y, 1, 1, 0, 0, 10, 2, (Insets)new ScaledInsets(3, 5, 3, 10));
        this.add(this.deleteLabel, 1, Y++, 1, 1, 1000, 0, 17, 2);
        this.add(new JPanel(), 0, Y++, 1, 1, 1, 1, 10, 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exportButton) {
            this.performExport();
        } else if (e.getSource() == this.deleteButton) {
            this.performDelete();
        }
    }

    private void performDelete() {
        try {
            if (SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)((Object)this)), (String)Language.get("DELETE_HISTORY_MSG"), (String)Language.get("DELETE_HISTORY_TITLE"), (Icon)ImageLoader.getImageIcon((String)Icons.HISTORY_DELETE_LARGE), (String)Language.get("DELETE_HISTORY"))) {
                new DeleteThread().start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performExport() {
        File file;
        Frame frame = null;
        RootPaneContainer rootPaneContainer = SwingUtil.getRootPaneContainer((Component)((Object)this));
        if (rootPaneContainer instanceof Frame) {
            frame = (Frame)((Object)rootPaneContainer);
        }
        FileDialog fd = new FileDialog(frame);
        fd.setDirectory(System.getProperty(System.getProperty("user.home")));
        fd.setMode(1);
        fd.setVisible(true);
        StringBuffer csvOutput = new StringBuffer();
        csvOutput.append(this.sessions[0].csvHeaders()).append("\n");
        for (int i = 0; i < this.sessions.length; ++i) {
            csvOutput.append(this.sessions[i].toCSV()).append("\n");
        }
        String name = fd.getFile();
        if (name.indexOf(46) == -1) {
            name = name + ".csv";
        }
        if ((file = new File(fd.getDirectory(), name)).exists()) {
            file.delete();
        }
        try {
            FileUtil.writeFile((File)file, (byte[])csvOutput.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            ErrorDialogs.ErrorGlassDialog ui = new ErrorDialogs.ErrorGlassDialog(SwingUtil.getRootPaneContainer((Component)((Object)this)), Language.get("SAVE_TO_CSV_ERROR"), ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), false);
            ui.setText(Language.get("SAVE_TO_CSV_ERROR"), Language.get("SAVE_TO_CSV_ERROR_DESC"), StackTracer.getStacktrace((Throwable)e));
            ui.setVisible(true);
        }
    }

    public void setSelectedSessions(AbstractSession[] sessions) {
        this.sessions = sessions;
        this.summaryLabel.setVisible(true);
        this.exportButton.setRightText("" + sessions.length);
        this.deleteButton.setRightText("" + sessions.length);
    }

    public void setSelectedSession(AbstractSession selectedSession) {
        this.sessions = new AbstractSession[]{selectedSession};
    }

    public void setTechClient(TechClient client) {
        this.deleteButton.setVisible(client.getTechUser().isServerAdmin());
        this.deleteLabel.setVisible(client.getTechUser().isServerAdmin());
    }

    class DeleteThread
    extends Thread {
        DeleteThread() {
        }

        @Override
        public void run() {
            PleaseWaitDialog dialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)((Object)MultiSessionPanel.this)), Language.get("DELETE_HISTORY_TITLE"), Language.get("DELETE_HISTORY_WAIT") + "...");
            try {
                try {
                    MultiSessionPanel.this.historyListener.deleteSessions(MultiSessionPanel.this.sessions);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                dialog.setVisible(false);
            }
        }
    }
}

