/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.ui;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.access.MachineHierarchyPanel;
import com.aem.shelp.tech.access.dnd.MachineTransferable;
import com.aem.shelp.tech.access.dnd.ReScheduler;
import com.aem.shelp.tech.access.dnd.TransferEntry;
import com.aem.shelp.tech.access.model.subgroups.BlankRowGroup;
import com.aem.shelp.tech.access.model.subgroups.ClosableGroupInterface;
import com.aem.shelp.tech.access.model.subgroups.FilterResultsGroup;
import com.aem.shelp.tech.access.model.subgroups.HeadingGroup;
import com.aem.shelp.tech.access.model.subgroups.IconnedInterface;
import com.aem.shelp.tech.access.utils.AutoscrollJTree;
import com.aem.shelp.tech.access.utils.RestrictedTreeSelectionModel;
import com.aem.shelp.tech.alerts.alerts.model.FilterAlertResultsGroup;
import com.aem.shelp.tech.alerts.alerts.model.subgroups.AlertBlankRowGroup;
import com.aem.shelp.tech.alerts.alerts.model.subgroups.AlertHeadingGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.jtree.SimpleTreeModel;
import utils.switches.Switches;

public abstract class AbstractHierarchyPanel<TG extends TreeGroup<TG, TE>, TE extends TreeElement>
implements ActionListener,
DropTargetListener {
    private final String id;
    public JPanel rootComponent = new JPanel(new BorderLayout());
    protected AbstractTreeModel<TG, TE> machineModel;
    private AutoscrollJTree hierarchyTree;
    protected HierarchyPanelListener<TG, TE> accessListener;
    private HierarchyRenderer cellRenderer = new HierarchyRenderer();
    private HierarchyEditor cellEditor;
    private GbPanel hierarchyHeader;
    private BasicTreeUI.NodeDimensionsHandler handler;
    private ReScheduler hoverScheduler = new ReScheduler();
    public TreePath treePathCurrentlyHoveredOver;
    public long treeSelectionChangedTime;
    private JButton addButton;
    private JScrollPane rootScrollPane;
    private TG editingValue;
    private String[] editingPath;
    private DropTarget dataTarget;
    private static final int RIGHT_CLOSE_PADDING = SimpleHelpLookAndFeel.scale((int)10);
    private boolean allowRenaming = true;
    public static final long REMOVE_FILTER_TIMEOUT = 500L;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public AbstractHierarchyPanel(String id, AbstractTreeModel<TG, TE> machineModel, HierarchyPanelListener<TG, TE> accessListener) {
        this.id = id;
        this.machineModel = machineModel;
        this.accessListener = accessListener;
        this.initUI();
    }

    public void showButtonBar(boolean showBar) {
        this.hierarchyHeader.setVisible(showBar);
    }

    protected abstract String getAddButtonTooltip();

    private void initUI() {
        this.hierarchyHeader = new GbPanel(new ScaledInsets(0, 3, 0, 3));
        this.hierarchyHeader.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        this.hierarchyHeader.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)3)));
        this.addButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
        this.addButton.setToolTipText(this.getAddButtonTooltip());
        this.addButton.addActionListener(this);
        int X = 0;
        this.hierarchyHeader.add((Component)this.addButton, X++, 0, 1, 1, 1, 1, 13, 0);
        this.hierarchyTree = new AutoscrollJTree(this.id, this.machineModel.getTreeModel()){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            @Override
            protected void rebuild() {
                ((MachineTreeUI)this.ui).rebuild();
            }

            @Override
            protected void paintComponent(Graphics g) {
                Insets insets = this.getInsets();
                g.setColor(this.getBackground());
                g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                int fromRow = this.getRowForPath(this.getSelectionPath());
                if (fromRow != -1) {
                    int toRow = fromRow + 1;
                    Rectangle fromBounds = this.getRowBounds(fromRow);
                    Rectangle toBounds = this.getRowBounds(toRow - 1);
                    if (fromBounds != null && toBounds != null) {
                        g.setColor(AccessStyle.TREE_SELECTION_COLOR);
                        g.fillRect(insets.left, fromBounds.y, this.getWidth() - insets.left - insets.right, toBounds.y - fromBounds.y + toBounds.height);
                    }
                }
                this.setOpaque(false);
                super.paintComponent(g);
                this.setOpaque(true);
            }
        };
        this.hierarchyTree.setSelectionModel(new RestrictedTreeSelectionModel());
        this.hierarchyTree.getSelectionModel().setSelectionMode(1);
        this.hierarchyTree.setAutoscrolls(true);
        HoverDeleteFilterListener hoverDeleteFilterListener = new HoverDeleteFilterListener();
        this.hierarchyTree.addMouseMotionListener(hoverDeleteFilterListener);
        this.hierarchyTree.addMouseListener(hoverDeleteFilterListener);
        this.dataTarget = new DropTarget(this.hierarchyTree, 2, this);
        this.hierarchyTree.setDragEnabled(false);
        this.hierarchyTree.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.hierarchyTree.setShowsRootHandles(true);
        this.hierarchyTree.setRootVisible(false);
        this.hierarchyTree.setCellRenderer(this.cellRenderer);
        this.hierarchyTree.setLargeModel(true);
        MachineTreeUI treeUI = new MachineTreeUI();
        this.hierarchyTree.setUI(treeUI);
        this.cellEditor = new HierarchyEditor(this.hierarchyTree, this.cellRenderer);
        this.cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String previousName;
                String newName = AbstractHierarchyPanel.this.cellEditor.getCellEditorValue().toString();
                if (newName.equals(previousName = AbstractHierarchyPanel.this.editingPath[AbstractHierarchyPanel.this.editingPath.length - 1])) {
                    return;
                }
                int childIndex = AbstractHierarchyPanel.this.machineModel.getIndexOf(AbstractHierarchyPanel.this.editingValue);
                AbstractHierarchyPanel.this.machineModel.renameGroup(AbstractHierarchyPanel.this.editingValue, newName, childIndex);
                AbstractHierarchyPanel.this.recursiveMachineRename(AbstractHierarchyPanel.this.editingValue);
                AbstractHierarchyPanel.this.hierarchyTree.setSelectionPath(new TreePath(AbstractHierarchyPanel.this.machineModel.getPathToRoot(AbstractHierarchyPanel.this.editingValue)));
                AbstractHierarchyPanel.this.machineModel.notifyFilterProcessorChange();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.hierarchyTree.setEditable(true);
        this.hierarchyTree.setCellEditor(this.cellEditor);
        this.hierarchyTree.addTreeSelectionListener(new TreeListener());
        this.rootComponent.add((Component)this.hierarchyHeader, "North");
        this.rootScrollPane = new JScrollPane(this.hierarchyTree);
        this.rootScrollPane.setBorder(null);
        this.rootComponent.add((Component)this.rootScrollPane, "Center");
        treeUI.setLeftChildIndent(SimpleHelpLookAndFeel.scale((int)7));
        treeUI.setRightChildIndent(SimpleHelpLookAndFeel.scale((int)7));
    }

    private void recursiveMachineRename(TG group) {
        TreeGroup[] childGroups;
        TreeElement[] machines = this.machineModel.getDescendentElementsArray((TreeGroup)group);
        this.accessListener.moveElements(machines, (TreeGroup)group);
        for (TreeGroup childGroup : childGroups = this.machineModel.getGroupsIn((TreeGroup)group)) {
            this.recursiveMachineRename(childGroup);
        }
    }

    public void setSelectedGroup(TG group) {
        Object[] treeNodePath = this.machineModel.getPathToRoot(group);
        TreePath path = new TreePath(treeNodePath);
        this.hierarchyTree.setSelectionPaths(new TreePath[]{path});
    }

    public abstract TG[] initGroupArray(int var1);

    private void updateButtonsState() {
        TreePath path = this.hierarchyTree.getSelectionPath();
        if (path == null) {
            this.addButton.setEnabled(false);
        } else {
            TreeGroup group;
            SimpleTreeModel.TreeNode leaf = (SimpleTreeModel.TreeNode)path.getLastPathComponent();
            if (leaf.value instanceof TreeGroup && this.machineModel.isInRootElementBranch(group = (TreeGroup)leaf.value)) {
                this.addButton.setEnabled(true);
                return;
            }
            this.addButton.setEnabled(false);
        }
    }

    public void setSelectedGroups(TG[] selectedGroups) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (TG group : selectedGroups) {
            Object[] treeNodePath;
            if (group == null || (treeNodePath = this.machineModel.getPathToRoot(group)) == null || treeNodePath.length <= 1) continue;
            paths.add(new TreePath(treeNodePath));
        }
        this.hierarchyTree.setSelectionPaths(paths.toArray(new TreePath[0]));
    }

    public void renameSelectedNode(TG nodeValue) {
        this.cellEditor.allowEdit = true;
        this.editingValue = nodeValue;
        this.editingPath = this.machineModel.getGroupPath(nodeValue);
        this.hierarchyTree.startEditingAtPath(new TreePath(this.machineModel.getPathToRoot(nodeValue)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addNewGroup();
        }
    }

    public void addNewGroup() {
        TreeGroup parentGroup = (TreeGroup)((SimpleTreeModel.TreeNode)this.hierarchyTree.getSelectionPath().getLastPathComponent()).value;
        String[] parentPath = this.machineModel.getGroupPath(parentGroup);
        String[] path = new String[parentPath.length + 1];
        System.arraycopy(parentPath, 0, path, 0, parentPath.length);
        path[path.length - 1] = Language.get("NEW_GROUP_TREE_NODE");
        TG newGroup = this.machineModel.getOrCreateGroup(path);
        this.renameSelectedNode(newGroup);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (Switches.SH_accessHierarchyRejectFileDrops) {
            List<DataFlavor> flavors = dtde.getCurrentDataFlavorsAsList();
            for (DataFlavor flav : flavors) {
                if (!flav.isFlavorJavaFileListType()) continue;
                dtde.rejectDrag();
                return;
            }
        }
        Point pt = dtde.getLocation();
        final TreePath path = this.hierarchyTree.getClosestPathForLocation(pt.x, pt.y);
        this.hierarchyTree.getSelectionModel().setSelectionPath(path);
        Object[] pathObjects = path.getPath();
        if (pathObjects.length <= 1) {
            System.out.println("[MachineHierarchyPanel] Rejecting drop because pathObjects.length == " + pathObjects.length);
            this.setDragCursor(false);
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
        this.setDragCursor(true);
        this.hoverScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractHierarchyPanel.this.hierarchyTree.expandPath(path);
                    }
                });
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void setDragCursor(boolean allowed) {
        if (allowed) {
            this.hierarchyTree.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.hierarchyTree.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setDefaultCursor();
        this.hoverScheduler.cancel();
    }

    private void setDefaultCursor() {
        Cursor cursor = new Cursor(0);
        this.hierarchyTree.setCursor(cursor);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        System.out.println("[MachineHierarchyPanel] Drop detected");
        this.setDefaultCursor();
        this.hoverScheduler.cancel();
        int action = dtde.getDropAction();
        Transferable transferable = dtde.getTransferable();
        Point pt = dtde.getLocation();
        try {
            System.out.println("[MachineHierarchyPanel] Checking drop flavor");
            if (transferable.isDataFlavorSupported(MachineTransferable.machineFlavors[0])) {
                TreePath pathTarget = this.hierarchyTree.getPathForLocation(pt.x, pt.y);
                TreeGroup group = (TreeGroup)((SimpleTreeModel.TreeNode)pathTarget.getLastPathComponent()).value;
                TransferEntry[] entries = (TransferEntry[])transferable.getTransferData(MachineTransferable.machineFlavors[0]);
                TreeGroup availableMachinesTarget = this.machineModel.translatedGroupIntoAvailableMachinesTree(group);
                boolean doit = false;
                int machineCount = 0;
                TransferEntry[] transferEntryArray = entries;
                int n = transferEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    TransferEntry entry = transferEntryArray[i];
                    machineCount += entry.machines.length;
                }
                if (machineCount > 0) {
                    doit = this instanceof MachineHierarchyPanel ? SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.getRootComponent()), (String)Language.get(machineCount == 1 ? "MOVE_MACHINE_DESC" : "MOVE_MACHINES_DESC", Integer.toString(machineCount), availableMachinesTarget.groupName), (String)Language.get("MOVE_MACHINES_TITLE", availableMachinesTarget.groupName), (Icon)ImageLoader.getImageIcon((String)Icons.MOVE_MACHINES), (String)Language.get("MOVE_MACHINES")) : SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.getRootComponent()), (String)Language.get(machineCount == 1 ? "MOVE_ALERT_DESC" : "MOVE_ALERTS_DESC", Integer.toString(machineCount), availableMachinesTarget.groupName), (String)Language.get("MOVE_ALERTS_TITLE", availableMachinesTarget.groupName), (Icon)ImageLoader.getImageIcon((String)Icons.MOVE_ALERTS), (String)Language.get("MOVE_ALERTS"));
                }
                if (doit) {
                    for (TransferEntry entry : entries) {
                        TG availableMachinesSource = this.machineModel.translatedGroupIntoAvailableMachinesTree(entry.parent);
                        this.accessListener.moveElements((TreeElement[])entry.machines, availableMachinesTarget);
                        this.machineModel.moveElements((TreeGroup)availableMachinesSource, (TreeElement[])entry.machines, availableMachinesTarget);
                    }
                    dtde.dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
                return;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        dtde.rejectDrop();
        dtde.dropComplete(false);
    }

    protected void setCanManageHierarchy(boolean canManage) {
        this.hierarchyHeader.setVisible(canManage);
        this.allowRenaming = canManage;
    }

    class HierarchyEditor
    extends DefaultTreeCellEditor {
        boolean allowEdit;

        public HierarchyEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.allowEdit = false;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editingIcon = value instanceof FilterResultsGroup ? ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16") : ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16");
            Component component = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            this.editingComponent.setBackground(AccessStyle.TREE_SELECTION_COLOR);
            this.editingComponent.setForeground(Color.WHITE);
            if (this.editingComponent instanceof JTextField) {
                ((JTextField)this.editingComponent).setSelectionColor(Color.WHITE);
                ((JTextField)this.editingComponent).setSelectedTextColor(AccessStyle.TREE_SELECTION_COLOR);
            }
            return component;
        }

        @Override
        protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (this.renderer != null) {
                this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
            } else {
                this.editingIcon = null;
                this.offset = 0;
            }
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (this.allowEdit) {
                this.allowEdit = false;
                return true;
            }
            return false;
        }
    }

    class HierarchyRenderer
    extends DefaultTreeCellRenderer {
        private int machineCount = 0;
        private boolean selected = false;
        private Object nodeValue;
        private Font font;

        public HierarchyRenderer() {
            this.setBackgroundSelectionColor(null);
            this.setBorderSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.machineCount = 0;
            this.nodeValue = ((SimpleTreeModel.TreeNode)value).value;
            this.font = null;
            if (this.nodeValue instanceof HeadingGroup || this.nodeValue instanceof BlankRowGroup || this.nodeValue instanceof AlertBlankRowGroup || this.nodeValue instanceof AlertHeadingGroup) {
                component.setEnabled(false);
                component.setIcon(null);
                component.setText(component.getText().toUpperCase());
                component.setForeground(Color.GRAY);
            } else if (this.nodeValue instanceof FilterResultsGroup || this.nodeValue instanceof FilterAlertResultsGroup) {
                if (this.nodeValue instanceof IconnedInterface) {
                    component.setIcon(((IconnedInterface)this.nodeValue).getIconForGroup());
                } else {
                    component.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
                }
            } else if (this.nodeValue instanceof TreeGroup) {
                this.machineCount = ((TreeGroup)this.nodeValue).getTreeElementDescendents();
                if (this.nodeValue instanceof IconnedInterface) {
                    component.setIcon(((IconnedInterface)this.nodeValue).getIconForGroup());
                } else {
                    component.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"));
                }
            } else if (this.nodeValue instanceof IconnedInterface) {
                component.setIcon(((IconnedInterface)this.nodeValue).getIconForGroup());
            } else {
                component.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"));
            }
            this.selected = sel;
            return component;
        }

        private Object getGroupCurrentlyHoveredOver() {
            if (AbstractHierarchyPanel.this.treePathCurrentlyHoveredOver == null) {
                return null;
            }
            SimpleTreeModel.TreeNode node = (SimpleTreeModel.TreeNode)AbstractHierarchyPanel.this.treePathCurrentlyHoveredOver.getLastPathComponent();
            return node.value;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.font != null) {
                g.setFont(this.font);
            }
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selected) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(AccessStyle.TREE_SELECTION_COLOR);
            }
            if (this.selected && this.nodeValue == this.getGroupCurrentlyHoveredOver()) {
                boolean canGroupBeDeleted;
                boolean isClosable = this.nodeValue != null && this.nodeValue instanceof ClosableGroupInterface;
                TreeGroup group = (TreeGroup)this.nodeValue;
                boolean bl = canGroupBeDeleted = this.nodeValue instanceof TreeGroup && group.getElementCount() == 0 && group.getParent() != null && AbstractHierarchyPanel.this.machineModel.getGroupsIn(group).length == 0;
                if (isClosable || canGroupBeDeleted) {
                    Icon rightButton = this.selected ? ImageLoader.getImageIcon((String)"images/svg/general/cancel-white.svg,16") : ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16");
                    if (rightButton != null) {
                        int y = this.getHeight() / 2 - rightButton.getIconHeight() / 2;
                        int x = this.getWidth() - RIGHT_CLOSE_PADDING - rightButton.getIconWidth();
                        rightButton.paintIcon(null, g, x, y);
                    }
                    return;
                }
            }
            if (this.machineCount > 0) {
                TextLayout tl = new TextLayout(this.machineCount + "", g2d.getFont(), g2d.getFontRenderContext());
                int width = this.getWidth();
                tl.draw(g2d, (float)width - tl.getAdvance() - (float)SimpleHelpLookAndFeel.scale((int)5), (float)(this.getHeight() / 2) + tl.getAscent() / 2.0f);
            }
        }
    }

    class HoverDeleteFilterListener
    implements MouseListener,
    MouseMotionListener {
        HoverDeleteFilterListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreeGroup group;
            TreePath path = AbstractHierarchyPanel.this.hierarchyTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            if (!AbstractHierarchyPanel.this.hierarchyTree.getSelectionModel().isPathSelected(path) || System.currentTimeMillis() - AbstractHierarchyPanel.this.treeSelectionChangedTime < 500L) {
                return;
            }
            Rectangle pathBounds = AbstractHierarchyPanel.this.hierarchyTree.getPathBounds(path);
            if (pathBounds == null) {
                return;
            }
            Rectangle bounds = new Rectangle(AbstractHierarchyPanel.this.hierarchyTree.getWidth() - RIGHT_CLOSE_PADDING - SimpleHelpLookAndFeel.scale((int)16), (int)((double)pathBounds.y + (pathBounds.getHeight() - (double)SimpleHelpLookAndFeel.scale((int)16)) / 2.0), SimpleHelpLookAndFeel.scale((int)16), SimpleHelpLookAndFeel.scale((int)16));
            Object pathValue = ((SimpleTreeModel.TreeNode)path.getLastPathComponent()).value;
            if (bounds.contains(e.getPoint())) {
                System.out.println("[MachineHierarchyTree] Node " + pathValue + " to be removed.");
                if (pathValue instanceof FilterResultsGroup) {
                    AbstractHierarchyPanel.this.machineModel.removeFilter((TreeGroup)pathValue);
                    AbstractHierarchyPanel.this.accessListener.setSelectedGroup(AbstractHierarchyPanel.this, AbstractHierarchyPanel.this.machineModel.getAvailableMachinesGroup());
                } else if (pathValue instanceof TreeGroup) {
                    AbstractHierarchyPanel.this.machineModel.removeAllGroupsAndMachines((TreeGroup)pathValue);
                    AbstractHierarchyPanel.this.machineModel.removeGroup((TreeGroup)pathValue);
                    AbstractHierarchyPanel.this.accessListener.setSelectedGroup(AbstractHierarchyPanel.this, AbstractHierarchyPanel.this.machineModel.getAvailableMachinesGroup());
                } else {
                    System.out.println("[MachineHierarchyTree] Filter cannot be removed because root group is " + pathValue + " of class " + pathValue.getClass().getName());
                }
            }
            if (pathValue instanceof TreeGroup && AbstractHierarchyPanel.this.allowRenaming && AbstractHierarchyPanel.this.machineModel.isInRootElementBranch(group = (TreeGroup)pathValue) && pathValue != AbstractHierarchyPanel.this.machineModel.getAvailableMachinesGroup()) {
                AbstractHierarchyPanel.this.renameSelectedNode(group);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle pathBounds;
            TreePath newPath;
            TreePath oldPath = AbstractHierarchyPanel.this.treePathCurrentlyHoveredOver;
            AbstractHierarchyPanel.this.treePathCurrentlyHoveredOver = newPath = AbstractHierarchyPanel.this.hierarchyTree.getPathForLocation(e.getX(), e.getY());
            if (oldPath != null && newPath != null && oldPath.equals(newPath) || oldPath == null && newPath == null) {
                return;
            }
            if (oldPath != null && (pathBounds = AbstractHierarchyPanel.this.hierarchyTree.getPathBounds(oldPath)) != null) {
                AbstractHierarchyPanel.this.hierarchyTree.repaint(pathBounds);
            }
            if (newPath != null && (pathBounds = AbstractHierarchyPanel.this.hierarchyTree.getPathBounds(AbstractHierarchyPanel.this.treePathCurrentlyHoveredOver)) != null) {
                AbstractHierarchyPanel.this.hierarchyTree.repaint(pathBounds);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class MachineTreeUI
    extends BasicTreeUI {
        public void rebuild() {
            this.setModel(this.treeModel);
        }

        @Override
        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        @Override
        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            AbstractHierarchyPanel.this.handler = new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    Insets insets = MachineTreeUI.this.tree.getInsets();
                    dimensions.width = MachineTreeUI.this.tree.getWidth() - this.getRowX(row, depth) - insets.left - insets.right;
                    return dimensions;
                }
            };
            return AbstractHierarchyPanel.this.handler;
        }
    }

    class TreeListener
    implements TreeSelectionListener {
        TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            AbstractHierarchyPanel.this.treeSelectionChangedTime = System.currentTimeMillis();
            TreePath[] paths = AbstractHierarchyPanel.this.hierarchyTree.getSelectionPaths();
            ArrayList<TreeGroup> selectedGroups = new ArrayList<TreeGroup>();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    SimpleTreeModel.TreeNode lastNode = (SimpleTreeModel.TreeNode)paths[i].getLastPathComponent();
                    Object value = lastNode.value;
                    if (!(value instanceof TreeGroup)) continue;
                    selectedGroups.add((TreeGroup)value);
                }
                TreeGroup[] result = AbstractHierarchyPanel.this.initGroupArray(0);
                AbstractHierarchyPanel.this.accessListener.setSelectedGroups(AbstractHierarchyPanel.this, selectedGroups.toArray(result));
                AbstractHierarchyPanel.this.updateButtonsState();
            } else {
                AbstractHierarchyPanel.this.accessListener.setSelectedGroup(AbstractHierarchyPanel.this, AbstractHierarchyPanel.this.machineModel.getAvailableMachinesGroup());
                AbstractHierarchyPanel.this.updateButtonsState();
            }
        }
    }
}

