/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.customer.CustomerListListener;
import com.aem.shelp.tech.customer.CustomerModel;
import com.aem.shelp.tech.customer.CustomerTypePanel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.mouse.SafeMouseAdapter;

public class CustomerTypePanelList {
    private JPanel rootComponent;
    private GlobalListener mouseListener = new GlobalListener();
    private CustomerModel customerModel;
    private CustomerListListener listener;
    private boolean isSession;
    private TransientTechUser tech;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public CustomerTypePanelList(CustomerModel model, CustomerListListener listener, boolean isSession) {
        this.listener = listener;
        this.isSession = isSession;
        this.rootComponent = new JPanel();
        this.rootComponent.setLayout(new BoxLayout(this.rootComponent, 1));
        this.rootComponent.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.customerModel = model;
    }

    public void updateFromModel() {
        Customer customer;
        int i;
        boolean majorChange = false;
        ArrayList<Customer> list = new ArrayList<Customer>();
        for (i = 0; i < this.customerModel.getSize(); ++i) {
            list.add(this.customerModel.getCustomer(i));
        }
        for (i = this.rootComponent.getComponentCount() - 1; i >= 0; --i) {
            CustomerTypePanel panel = (CustomerTypePanel)((Object)this.rootComponent.getComponent(i));
            if (list.contains(panel.getCustomer())) continue;
            this.rootComponent.remove((Component)((Object)panel));
            majorChange = true;
        }
        block2: for (int customerIndex = list.size() - 1; customerIndex >= 0; --customerIndex) {
            customer = (Customer)list.get(customerIndex);
            for (int i2 = 0; i2 < this.rootComponent.getComponentCount(); ++i2) {
                CustomerTypePanel panel = (CustomerTypePanel)((Object)this.rootComponent.getComponent(i2));
                if (!panel.getCustomer().equals(customer)) continue;
                list.remove(customer);
                panel.getCustomer().copyDataFrom(customer);
                panel.updateCustomerInfo();
                continue block2;
            }
        }
        for (i = 0; i < list.size(); ++i) {
            customer = (Customer)list.get(i);
            this.addNewCustomer(customer, this.customerModel.getSelectedDetailsToShow(), this.customerModel.getSessionFor(customer));
            majorChange = true;
        }
        if (majorChange) {
            this.rootComponent.revalidate();
            this.rootComponent.repaint();
        }
    }

    public void removeCustomer(Customer customer) {
        this.customerModel.removeCustomer(customer);
    }

    private void addNewCustomer(Customer testCustomer, ArrayList<String> detailsToShow, SupportSession session) {
        CustomerTypePanel customerTypePanel = new CustomerTypePanel(this, testCustomer, session, detailsToShow, this.listener, this.isSession);
        this.rootComponent.add((Component)((Object)customerTypePanel));
        customerTypePanel.addMouseListener(this.mouseListener);
        customerTypePanel.addKeyListener(this.mouseListener);
    }

    public void recreateUI() {
        this.rootComponent.removeAll();
        this.updateFromModel();
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public void setTechClient(TechClient client) {
        this.tech = client.getTechUser();
    }

    public TransientTechUser getTech() {
        return this.tech;
    }

    class GlobalListener
    extends SafeMouseAdapter
    implements KeyListener {
        CustomerTypePanel previousSelected = null;
        CustomerTypePanel previousHover = null;

        GlobalListener() {
        }

        @Override
        public void safeMouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                return;
            }
            CustomerTypePanel panel = (CustomerTypePanel)e.getSource();
            if (e.getClickCount() == 2 && !e.isConsumed() && !CustomerTypePanelList.this.isSession) {
                e.consume();
                panel.doConnect(0, false);
            } else {
                this.select(panel);
            }
        }

        @Override
        public void safeMouseReleased(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                return;
            }
            CustomerTypePanel panel = (CustomerTypePanel)e.getSource();
            this.select(panel);
        }

        private void select(CustomerTypePanel panel) {
            if (panel == this.previousSelected) {
                panel.setSelected(false);
                panel.repaint();
                this.previousSelected = null;
                return;
            }
            if (this.previousSelected != null) {
                this.previousSelected.setSelected(false);
                this.previousSelected.repaint();
            }
            panel.setSelected(true);
            panel.requestFocusInWindow();
            this.previousSelected = this.previousSelected != panel ? panel : null;
            this.previousSelected.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CustomerTypePanel panel = (CustomerTypePanel)e.getSource();
            if (this.previousHover == panel) {
                return;
            }
            if (this.previousHover != null) {
                this.previousHover.setHover(false);
            }
            panel.setHover(true);
            this.previousHover = panel;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CustomerTypePanel panel = (CustomerTypePanel)e.getSource();
            if (!panel.getVisibleRect().contains(e.getPoint())) {
                panel.setHover(false);
                if (panel == this.previousHover) {
                    this.previousHover = null;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private int getIndexForPanel(Component c) {
            Component[] components = CustomerTypePanelList.this.rootComponent.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i] != c) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.previousSelected == null) {
                return;
            }
            CustomerTypePanel panel = (CustomerTypePanel)e.getSource();
            int index = this.getIndexForPanel((Component)((Object)panel));
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                if (--index < 0) {
                    return;
                }
                panel = (CustomerTypePanel)((Object)CustomerTypePanelList.this.rootComponent.getComponent(index));
                this.select(panel);
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                if (++index >= CustomerTypePanelList.this.rootComponent.getComponentCount()) {
                    return;
                }
                panel = (CustomerTypePanel)((Object)CustomerTypePanelList.this.rootComponent.getComponent(index));
                this.select(panel);
            } else if (e.getKeyCode() == 10) {
                panel.doConnect(0, false);
            }
        }
    }
}

