/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import utils.swing.components.animated.jlist.ReorderableJList;
import utils.swing.components.checklist.CheckListRenderer;

public abstract class ColumnSelector
extends ReorderableJList {
    private ArrayList<Column> model;

    public ColumnSelector(ArrayList<String> columnNames, ArrayList<String> selectedNames) {
        this.initWith(columnNames, selectedNames);
        this.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return ColumnSelector.this.model.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ColumnSelector.this.model.get(index);
            }
        });
        this.setCellRenderer(new CheckListRenderer(){

            @Override
            public boolean isObjectSelected(Object it) {
                return ((Column)it).isSelected;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                Column c = (Column)ColumnSelector.this.model.get(index);
                c.isSelected = !((Column)((ColumnSelector)ColumnSelector.this).model.get((int)index)).isSelected;
                ColumnSelector.this.modelChanged();
                list.repaint(list.getCellBounds(index, index));
            }
        });
    }

    public void initWith(ArrayList<String> columnNames, ArrayList<String> selectedNames) {
        this.model = new ArrayList();
        for (int i = 0; i < columnNames.size(); ++i) {
            Column c = new Column();
            c.name = columnNames.get(i);
            c.isSelected = selectedNames.contains(c.name);
            this.model.add(c);
        }
    }

    public abstract void modelChanged();

    public ArrayList<String> getSelectedColumns() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.model.size(); ++i) {
            Column c = this.model.get(i);
            if (!c.isSelected) continue;
            result.add(c.name);
        }
        return result;
    }

    public ArrayList<String> getAllColumns() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.model.size(); ++i) {
            Column c = this.model.get(i);
            result.add(c.name);
        }
        return result;
    }

    @Override
    protected void reorderElements(int fromIndex, int toIndex) {
        Column from = this.model.get(fromIndex);
        this.model.set(fromIndex, this.model.get(toIndex));
        this.model.set(toIndex, from);
        this.modelChanged();
    }

    class Column {
        boolean isSelected;
        String name;

        Column() {
        }

        public String toString() {
            return this.name;
        }
    }
}

