/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.tree.CheckNodeSelectionListener;
import utils.swing.tree.CheckRenderer;
import utils.swing.tree.IconCheckNode;
import utils.swing.tree.IconNode;

public class TechGroupsPanel
implements ActionListener,
ProfileAccountsConfig.ProfileAccountsReadyListener {
    private JPanel rootComponent = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
    private JButton edit = new JButton(Language.get("EDIT"), ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
    private AppProfile profile;
    private JTree tree = new JTree(new DefaultTreeModel(null));
    private boolean amEditing = false;
    private TechClient client;
    private String[][] groups;
    private static final String sep = "@@@&";
    private ProfileAccountsConfig pconfig;
    private boolean loadedConfig = false;

    public TechGroupsPanel(TechClient client, ProfileAccountsConfig config) {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)0));
        this.client = client;
        this.pconfig = config;
        config.addProfileAccountsReadyListener(this);
        this.initGraphics();
    }

    @Override
    public void profileAccountsReady() {
        this.loadedConfig = true;
        System.out.println("[TechGroupsPanel] Loaded config");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TechGroupsPanel.this.loadTreeFromProfile();
                TechGroupsPanel.this.edit.setEnabled(true);
            }
        });
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void loadFromProfile(AppProfile profile) {
        this.profile = profile;
        if (this.loadedConfig) {
            this.loadTreeFromProfile();
        }
    }

    private static void buildTree(HashMap<String, IconNode> map, IconNode root, String[] paths, boolean withCheck) {
        IconNode parent = root;
        String pathKey = "";
        for (String path : paths) {
            IconNode current = map.get(pathKey = pathKey + path + sep);
            if (current == null) {
                current = withCheck ? new IconCheckNode(path) : new IconNode(path);
                TechGroupsPanel.setIcon(current);
                parent.add(current);
                map.put(pathKey, current);
            }
            parent = current;
        }
    }

    private static void setIcon(IconNode node) {
        try {
            node.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void loadTreeFromProfile() {
        IconNode root = new IconNode(Language.get("ALL_SELECTED_GROUPS"));
        TechGroupsPanel.setIcon(root);
        if (this.profile == null) {
            return;
        }
        System.out.println("[TechGroupsPanel] Loading groups to show from " + this.profile.objectCode());
        HashMap<String, IconNode> map = new HashMap<String, IconNode>();
        TechGroup profileGroup = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        ArrayList<ArrayList<String>> allowed = profileGroup.getRemoteAccessGroupRestrictions();
        boolean childrenPresent = false;
        for (ArrayList<String> group : allowed) {
            if (group.size() > 1) {
                childrenPresent = true;
            }
            TechGroupsPanel.buildTree(map, root, group.toArray(new String[0]), false);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree.setModel(model);
        this.tree.revalidate();
        this.tree.repaint();
        this.tree.setShowsRootHandles(childrenPresent);
        this.edit.setText(Language.get("EDIT"));
        this.edit.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
        this.edit.setHorizontalAlignment(2);
        this.amEditing = false;
    }

    private void loadTreeToEdit() {
        IconNode root = new IconNode(Language.get("ALL_MACHINE_GROUPS"));
        TechGroupsPanel.setIcon(root);
        boolean childrenPresent = false;
        HashMap<String, IconNode> map = new HashMap<String, IconNode>();
        for (String[] group : this.groups) {
            if (group.length > 1) {
                childrenPresent = true;
            }
            TechGroupsPanel.buildTree(map, root, group, true);
        }
        if (this.profile != null) {
            System.out.println("Loading groups to edit from " + this.profile.objectCode());
            ArrayList<ArrayList<String>> groups = this.pconfig.getGroupForAppProfile(this.profile).getRemoteAccessGroupRestrictions();
            for (ArrayList<String> group : groups) {
                String pathKey = "";
                for (String path : group) {
                    pathKey = pathKey + path + sep;
                }
                IconNode node = map.get(pathKey);
                if (node == null || !(node instanceof IconCheckNode)) continue;
                ((IconCheckNode)node).setSelected(true);
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree.setModel(model);
        this.tree.revalidate();
        this.tree.repaint();
        this.tree.setShowsRootHandles(childrenPresent);
        this.edit.setText(Language.get("DONE"));
        this.edit.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
        this.amEditing = true;
    }

    private void initGraphics() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        JPanel treePanel = new JPanel(new GridLayout(1, 1));
        JScrollPane scroll = new JScrollPane(this.tree){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 200);
            }
        };
        treePanel.add(scroll);
        treePanel.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)0, (int)5, (int)0));
        this.tree.setRootVisible(false);
        BorderPanel controls = new BorderPanel();
        controls.addEast((JComponent)this.edit);
        this.rootComponent.add((Component)treePanel, "Center");
        this.rootComponent.add((Component)controls, "South");
        this.edit.addActionListener(this);
        this.edit.setEnabled(false);
        CheckNodeSelectionListener select = new CheckNodeSelectionListener(this.tree);
        select.setButtonWidth(22);
        this.edit.setText(Language.get("DONE"));
        int max = this.edit.getPreferredSize().width;
        this.edit.setText(Language.get("EDIT"));
        max = Math.max(max, this.edit.getPreferredSize().width);
        this.edit.setPreferredSize(new Dimension(max, this.edit.getPreferredSize().height));
        this.tree.setRowHeight(SimpleHelpLookAndFeel.scale((int)22));
        this.tree.setCellRenderer(new CheckRenderer());
        this.tree.addMouseListener(select);
    }

    public ArrayList<JComponent> getButtons() {
        ArrayList<JComponent> buts = new ArrayList<JComponent>();
        buts.add(this.edit);
        return buts;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.edit) {
            if (!this.amEditing) {
                this.edit.setEnabled(false);
                this.edit.setIcon(new SHProgressAnimatedIcon());
                this.edit.repaint();
                new ConfigLoader().start();
            } else {
                ArrayList<ArrayList<String>> saved = new ArrayList<ArrayList<String>>();
                this.savePaths((IconNode)this.tree.getModel().getRoot(), saved);
                System.out.println("[TechGroupsPanel] Setting groups on " + this.profile.objectCode());
                TechGroup techGroup = this.pconfig.getGroupForAppProfile(this.profile);
                techGroup.setFilterByAllowedGroups(true);
                techGroup.setRemoteAccessGroupRestrictions(saved);
                this.pconfig.saveAsync();
                this.loadTreeFromProfile();
            }
        }
    }

    private void savePaths(IconNode node, ArrayList<ArrayList<String>> saved) {
        if (node instanceof IconCheckNode && ((IconCheckNode)node).isSelected()) {
            ArrayList<String> list = new ArrayList<String>();
            IconNode path = (IconCheckNode)node;
            while (path.getParent() != null) {
                list.add(0, path.getUserObject() + "");
                path = (IconNode)path.getParent();
            }
            saved.add(list);
        }
        int N = node.getChildCount();
        for (int i = 0; i < N; ++i) {
            IconCheckNode child = (IconCheckNode)node.getChildAt(i);
            this.savePaths(child, saved);
        }
    }

    static /* synthetic */ String[][] access$202(TechGroupsPanel x0, String[][] x1) {
        x0.groups = x1;
        return x1;
    }

    class ConfigLoader
    extends Thread {
        ConfigLoader() {
        }

        @Override
        public void run() {
            try {
                TechGroupsPanel.access$202(TechGroupsPanel.this, TechGroupsPanel.this.client.getEntireMachineGroupList());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.out.println("[TechGroupsPanel] Loaded tree");
                    TechGroupsPanel.this.loadTreeToEdit();
                    TechGroupsPanel.this.edit.setEnabled(true);
                    TechGroupsPanel.this.edit.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
                }
            });
        }
    }
}

