/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.ProfileType;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.color.ConfigurableColor;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageHelper;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ProfileTypePanel
implements MouseListener {
    private GbPanel rootComponent = new GbPanel();
    private ProfileType[] profileTypes;
    private ProfileUIListener listener;
    private JPanel tooltip;
    private static final Color SELECTED_BUTTON_BACKGROUND = new Color(169, 207, 245);
    private boolean useDarkTheme;
    private static final boolean UI_SHADOW = false;
    private static final boolean UI_BANNER = true;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public ProfileTypePanel(ProfileUIListener listener, ProfileType[] profileTypes, boolean useDarkTheme) {
        this.useDarkTheme = useDarkTheme;
        this.listener = listener;
        this.profileTypes = profileTypes;
        this.initUI();
        new ConfigurableColor(SELECTED_BUTTON_BACKGROUND, "ProfileTypePanel.ButtonBackground", (JComponent)this.rootComponent);
    }

    private Color getLeftBackground() {
        if (this.useDarkTheme) {
            return SHStyle.SLACK_STYLE_DARK_BACKGROUND;
        }
        return SHStyle.PANEL_BACKGROUND_MEDIUM;
    }

    private void initUI() {
        this.rootComponent.setBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)0, (int)1, (Color)SHStyle.BORDER_COLOR));
        this.rootComponent.setBackground(this.getLeftBackground());
        int Y = 0;
        for (ProfileType type : this.profileTypes) {
            ButtonPanel buttonPanel = new ButtonPanel(type);
            buttonPanel.addMouseListener(this);
            this.rootComponent.add((Component)buttonPanel, 0, Y++, 1, 1, 1, 0, 10, 1);
            if (Y != 1) continue;
            buttonPanel.setSelected(true);
        }
        JPanel filler = new JPanel();
        filler.setBackground(this.getLeftBackground());
        this.rootComponent.add((Component)filler, 0, Y++, 1, 1, 1, 1, 10, 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() instanceof ButtonPanel) {
            ButtonPanel bp = (ButtonPanel)e.getSource();
            for (Component c : this.rootComponent.getComponents()) {
                if (!(c instanceof ButtonPanel)) continue;
                if (c == bp) {
                    bp.setSelected(true);
                    continue;
                }
                ((ButtonPanel)c).setSelected(false);
            }
            this.rootComponent.repaint();
            this.listener.showAppsOfType(bp.type);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setShowToolTip(true, e);
    }

    private void setShowToolTip(boolean showIt, MouseEvent e) {
        JLayeredPane pane = SwingUtil.getRootPane((Component)this.rootComponent).getLayeredPane();
        if (showIt) {
            ButtonPanel button = (ButtonPanel)e.getSource();
            if (this.tooltip != null) {
                pane.remove(this.tooltip);
            }
            this.tooltip = new TagPanel(button.type.getName());
            Point p = new Point();
            p.x = button.getWidth() - SimpleHelpLookAndFeel.scale((int)15);
            this.tooltip.setSize(pane.getWidth() - p.x, SimpleHelpLookAndFeel.scale((int)50));
            p.y = button.getHeight() / 2 - this.tooltip.getHeight() / 2;
            p = SwingUtilities.convertPoint(button, p, pane);
            this.tooltip.setLocation(p.x, p.y);
            pane.add((Component)this.tooltip, JLayeredPane.POPUP_LAYER);
            pane.repaint();
        } else if (this.tooltip != null) {
            pane.remove(this.tooltip);
            this.tooltip = null;
            pane.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setShowToolTip(false, null);
    }

    private class ButtonPanel
    extends JPanel {
        private ProfileType type;
        private Icon unselectedIcon;
        private Icon selectedIcon;
        private boolean selected;
        private int HEIGHT;

        public ButtonPanel(ProfileType type) {
            super(new GridLayout(1, 1));
            this.HEIGHT = SimpleHelpLookAndFeel.scale((int)70);
            this.type = type;
            Icon icon = ImageLoader.getImageIcon((String)(type.getIconKey() + ",48"));
            this.unselectedIcon = ProfileTypePanel.this.useDarkTheme ? ImageLoader.getImageIconDimmer((String)(type.getIconKey() + ",48")) : icon;
            this.selectedIcon = icon;
            SwingUtil.setHeight((JComponent)this, (int)this.HEIGHT);
            this.setOpaque(true);
            super.setBackground(ProfileTypePanel.this.getLeftBackground());
            this.setSelected(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Icon icon;
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHints(ImageHelper.getQualityRenderingHints());
            if (this.selected) {
                icon = this.selectedIcon;
                g2d.setColor(SELECTED_BUTTON_BACKGROUND);
                int buffer = SimpleHelpLookAndFeel.scale((int)8);
                g2d.fillRect(0, buffer, this.getWidth(), this.getHeight() - 2 * buffer);
                int gradHeight = SimpleHelpLookAndFeel.scale((int)3);
                int Y = buffer - gradHeight;
                GradientPaint gp1 = new GradientPaint(0.0f, Y, ProfileTypePanel.this.getLeftBackground(), 0.0f, Y + gradHeight, SELECTED_BUTTON_BACKGROUND);
                Paint old = g2d.getPaint();
                try {
                    g2d.setPaint(gp1);
                    g2d.fillRect(0, Y, this.getWidth(), gradHeight);
                    Y = this.getHeight() - buffer;
                    gp1 = new GradientPaint(0.0f, Y, SELECTED_BUTTON_BACKGROUND, 0.0f, Y + gradHeight, ProfileTypePanel.this.getLeftBackground());
                    g2d.setPaint(gp1);
                    g2d.fillRect(0, Y, this.getWidth(), gradHeight);
                }
                finally {
                    g2d.setPaint(old);
                }
            } else {
                icon = this.unselectedIcon;
            }
            icon.paintIcon(null, g2d, (this.getWidth() - icon.getIconWidth()) / 2, (this.getHeight() - icon.getIconHeight()) / 2);
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.repaint();
        }
    }

    class TagPanel
    extends JPanel {
        private String text;
        private JLabel label;

        public TagPanel(String text) {
            this.text = text;
            this.label = new JLabel(text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            float requiredWidth = SimpleHelpLookAndFeel.scale((int)50) + SwingUtilities.computeStringWidth(g.getFontMetrics(), this.text);
            float originalW = Math.min((float)this.getWidth(), requiredWidth);
            float originalH = this.getHeight();
            float w = originalW - (float)SimpleHelpLookAndFeel.scale((int)25);
            float h = originalH - (float)SimpleHelpLookAndFeel.scale((int)25);
            float arc = SimpleHelpLookAndFeel.scale((int)3);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(1.0f, 1, 1));
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, h / 2.0f);
            path.lineTo(h / 2.0f - arc, arc);
            path.quadTo(h / 2.0f, 0.0f, h / 2.0f + arc, 0.0f);
            path.lineTo(w - 1.0f - arc, 0.0f);
            path.quadTo(w - 1.0f, 0.0f, w - 1.0f, arc);
            path.lineTo(w - 1.0f, h - 1.0f - 2.0f * arc);
            path.quadTo(w - 1.0f, h - 1.0f, w - 1.0f - arc, h - 1.0f);
            path.lineTo(h / 2.0f + arc, h - 1.0f);
            path.quadTo(h / 2.0f, h - 1.0f, h / 2.0f - arc, h - 1.0f - arc);
            path.closePath();
            BufferedImage image = new BufferedImage((int)originalW, (int)originalH, 2);
            Graphics2D graphics = image.createGraphics();
            SwingUtil.setRenderingHints((Graphics2D)graphics);
            float targetHeight = (originalH - h) / 2.0f;
            graphics.translate((originalW - w) / 2.0f, targetHeight);
            graphics.setPaint(SHStyle.BORDER_COLOR_LIGHT);
            graphics.fill(path);
            graphics.setPaint(SHStyle.BORDER_COLOR);
            graphics.draw(path);
            graphics.setPaint(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
            this.label.setSize(this.label.getPreferredSize());
            AffineTransform oldTransform = graphics.getTransform();
            try {
                graphics.translate(SimpleHelpLookAndFeel.scale((double)15.0), h / 2.0f - (float)(this.label.getHeight() / 2) - 1.0f);
                this.label.paint(graphics);
            }
            finally {
                graphics.setTransform(oldTransform);
            }
            graphics.dispose();
            BufferedImage shadow = ImageHelper.applyShadow((BufferedImage)image, (int)SimpleHelpLookAndFeel.scale((int)50), (int)SimpleHelpLookAndFeel.scale((int)-47), (int)SimpleHelpLookAndFeel.scale((int)-47), (Color)Color.BLACK, (float)0.1f);
            g2d.drawImage((Image)shadow, 0, 0, null);
        }
    }

    class ToolTipFrame
    extends JPanel {
        ToolTipFrame() {
        }
    }
}

