/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import com.aem.shelp.tech.appprofile.TranslatedException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;

public class ProfileAccountsPanel
extends BorderPanel
implements ActionListener,
ProfileAccountsConfig.ProfileAccountsReadyListener,
ListSelectionListener {
    private TechClient client;
    private AppProfile profile;
    private JList list = new JList();
    DefaultListModel model;
    private GbPanel controls = new GbPanel(new ScaledInsets(5, 0, 0, 5));
    private JButton create = new JButton(Language.get("NEW"), ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,16"));
    private JButton add = new JButton(Language.get("ADD"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
    private JButton remove = new JButton(Language.get("REMOVE"), ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
    private ProfileAccountsConfig pconfig;
    private RootPaneContainer rpc;
    private JPanel inner;

    public ProfileAccountsPanel(RootPaneContainer rpc, TechClient client, AppProfile profile, ProfileAccountsConfig config) {
        this.pconfig = config;
        this.client = client;
        this.rpc = rpc;
        this.pconfig.addProfileAccountsReadyListener(this);
        if (client == null) {
            System.out.println("[ProfileAccountsPanel] Created with NULL techClient!");
        }
        this.initGraphics();
        this.loadFromProfile(profile);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.inner != null) {
            this.inner.setBackground(c);
        }
        if (this.controls != null) {
            this.controls.setBackground(c);
        }
    }

    public ArrayList<JComponent> getButtons() {
        ArrayList<JComponent> buts = new ArrayList<JComponent>();
        buts.add(this.create);
        buts.add(this.add);
        buts.add(this.remove);
        return buts;
    }

    private void initGraphics() {
        this.create.setHorizontalAlignment(2);
        this.add.setHorizontalAlignment(2);
        this.remove.setHorizontalAlignment(2);
        this.inner = new JPanel();
        this.inner.setLayout(new GridLayout(1, 1));
        this.inner.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        JScrollPane scroll = new JScrollPane(this.list);
        this.inner.add(scroll);
        this.list.setFixedCellHeight(SimpleHelpLookAndFeel.scale((int)22));
        this.list.setCellRenderer(new TechListRenderer());
        this.addCenter(this.inner);
        this.addEast((JComponent)this.controls);
        JPanel tmp = new JPanel();
        tmp.setOpaque(false);
        this.controls.add((Component)this.create, 0, 0, 1, 1, 100, 1, 11, 2);
        this.controls.add((Component)this.add, 0, 1, 1, 1, 100, 1, 11, 2);
        this.controls.add((Component)this.remove, 0, 2, 1, 1, 100, 1, 11, 2);
        this.controls.add((Component)tmp, 0, 3, 1, 1, 100, 10000, 11, 1);
        this.setOpaque(false);
        this.inner.setOpaque(false);
        this.controls.setOpaque(false);
        this.create.addActionListener(this);
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.list.addListSelectionListener(this);
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.list.getSelectedIndex() == -1) {
            this.remove.setEnabled(false);
        } else {
            this.remove.setEnabled(true);
        }
    }

    public void loadFromProfile(AppProfile appProfile) {
        this.profile = appProfile;
        System.out.println("[ProfileAccountsPanel] loading " + this.profile.getName());
        this.setEnabled(false);
        this.updateListModel();
    }

    private void updateListModel() {
        this.model = new DefaultListModel();
        ArrayList<TechUser> users = this.pconfig.listTechUsersForProfile(this.profile);
        for (TechUser user : users) {
            this.model.addElement(user);
        }
        this.list.setModel(this.model);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.create) {
            TechCreateDialog dialog = new TechCreateDialog();
            System.out.println("[ProfileAccountsPanel] Showing tech create dialog");
            dialog.showDialog(this.rpc);
            System.out.println("[ProfileAccountsPanel] Dialog done " + dialog.isOK());
            if (dialog.isOK()) {
                System.out.println("[ProfileAccountsPanel] Creating new tech... " + dialog.getUsername() + " / " + dialog.getName());
                try {
                    this.pconfig.createNewTechForAppProfile(this.profile, dialog.getName(), dialog.getUsername(), dialog.getPassword(), dialog.getEmail());
                    System.out.println("[ProfileAccountsPanel] Created tech " + dialog.getUsername() + " / " + dialog.getName() + " OK");
                }
                catch (TranslatedException x) {
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)this.rpc, (String)x.getMessage(), (String)Language.get("UNABLE_TO_CREATE_USER_TITLE"), null, (String)Language.get("OK"));
                }
            }
            System.out.println("[ProfileAccountsPanel] Updating list");
            this.updateListModel();
            this.markSaveRequired();
        } else if (src == this.add) {
            Object[] array;
            TechUser[] users = this.pconfig.listAllTechUsers();
            JList<TechUser> choice = new JList<TechUser>(users);
            JScrollPane pane = new JScrollPane(choice);
            choice.setCellRenderer(new TechListRenderer());
            BorderPanel bp = new BorderPanel();
            bp.addCenter((JComponent)pane);
            if (SHGlassOptionPane.showOkCancelPanelDialog((RootPaneContainer)this.rpc, (JPanel)bp, (String)Language.get("CHOOSE_USER_ACCOUNT"), (int)400, (String)Language.get("OK"), (String)Language.get("CANCEL")) && (array = choice.getSelectedValues()) != null) {
                for (Object obj : array) {
                    TechUser chosen = (TechUser)obj;
                    System.out.println("[ProfileAccountsPanel] Chosen tech: " + chosen.getLogin());
                    this.pconfig.addTechToProfile(chosen, this.profile);
                }
            }
            System.out.println("[ProfileAccountsPanel] Updating list");
            this.updateListModel();
            this.markSaveRequired();
        } else if (src == this.remove) {
            Object[] array = this.list.getSelectedValues();
            if (array != null) {
                for (Object obj : array) {
                    TechUser chosen = (TechUser)obj;
                    this.pconfig.removeTechFromProfile(chosen, this.profile);
                }
            }
            System.out.println("[ProfileAccountsPanel] Updating list");
            this.updateListModel();
            this.markSaveRequired();
        }
    }

    private void markSaveRequired() {
        this.pconfig.saveAsync();
    }

    @Override
    public void profileAccountsReady() {
        this.updateListModel();
        this.setEnabled(true);
    }

    public void setEnabled(boolean b) {
        this.create.setEnabled(b);
        this.add.setEnabled(b);
        this.remove.setEnabled(b);
        this.updateEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    public static class TechCreateDialog
    extends OKCancelDialogPanel {
        GbPanel main;
        JTextField name;
        JTextField username;
        JFixedWidthPasswordField passw;
        JTextField email;

        public String getName() {
            return this.name.getText().trim();
        }

        public String getUsername() {
            return this.username.getText().trim();
        }

        public String getPassword() {
            return this.passw.getText().trim();
        }

        public String getEmail() {
            return this.email.getText().trim();
        }

        public TechCreateDialog() {
            super(Language.get("CREATE_ACCOUNT"), Language.get("CANCEL"));
            JPanel contentPanel = this.getContentPanel();
            FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
            this.setContent((FixedWidthComponent)panel);
            this.setIcon(ImageLoader.getImageIcon((String)"O[images/svg/users/technician.svg,48 | images/svg/general/add.svg,16]"));
        }

        public void showDialog(RootPaneContainer rpc) {
            AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 450, (AbstractDialogPanel)this);
            abstractGlassDialog.setTitle(Language.get("CREATE_TECH"));
            abstractGlassDialog.showDialog();
        }

        protected JPanel getContentPanel() {
            KeyAdapter changedListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    TechCreateDialog.this.setOkEnabled(TechCreateDialog.this.isValid());
                    if (e.getKeyCode() == 10 && TechCreateDialog.this.isValid()) {
                        TechCreateDialog.this.okPressed();
                    }
                }
            };
            this.main = new GbPanel(new ScaledInsets(0, 0, 5, 0));
            this.name = new JTextField(16);
            this.username = new JTextField(16);
            this.passw = new JFixedWidthPasswordField();
            this.email = new JTextField();
            this.name.addKeyListener(changedListener);
            this.username.addKeyListener(changedListener);
            this.passw.addKeyListener(changedListener);
            this.email.addKeyListener(changedListener);
            JPanel userPanel = new JPanel();
            userPanel.setLayout(new BorderLayout());
            userPanel.add((Component)this.main, "Center");
            int N = 0;
            this.main.add((Component)new JLabel(Language.get("NAME"), 4), 0, N, 1, 1, 0, 1, 13, 2, (Insets)new ScaledInsets(0, 0, 0, 10));
            this.main.add((Component)this.name, 1, N++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
            this.main.add((Component)new JLabel(Language.get("USERNAME"), 4), 0, N, 1, 1, 0, 1, 13, 2, (Insets)new ScaledInsets(5, 0, 0, 10));
            this.main.add((Component)this.username, 1, N++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
            this.main.add((Component)new JLabel(Language.get("INFO_EMAIL"), 4), 0, N, 1, 1, 0, 1, 13, 2, (Insets)new ScaledInsets(5, 0, 0, 10));
            this.main.add((Component)this.email, 1, N++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
            this.main.add((Component)new JLabel(Language.get("PASSWORD"), 4), 0, N, 1, 1, 0, 1, 13, 2, (Insets)new ScaledInsets(5, 0, 0, 10));
            this.main.add((Component)this.passw, 1, N++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
            return userPanel;
        }

        protected boolean isValid() {
            return this.name.getText().length() > 0 && this.username.getText().length() > 0 && this.passw.getPassword().length > 0;
        }
    }

    class TechListRenderer
    extends DefaultListCellRenderer {
        TechListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            TechUser user = (TechUser)value;
            value = user.getDefaultName() + " (" + user.getLogin() + ")";
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,16"));
            return label;
        }
    }
}

