/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.BorderPanel;

public class GroupPermissionsPanel
extends BorderPanel
implements ActionListener,
KeyListener,
ProfileAccountsConfig.ProfileAccountsReadyListener {
    private final ColorPropagatingGBPanel rootComponent;
    private AppProfile profile;
    private ProfileAccountsConfig pconfig;
    private TechClient client;
    private RootPaneContainer rpc;
    private JTextField group;
    private JTextField user;
    private boolean loadedConfig = false;

    public GroupPermissionsPanel(RootPaneContainer rpc, TechClient client, AppProfile profile, ProfileAccountsConfig config) {
        this.profile = profile;
        this.pconfig = config;
        this.client = client;
        this.rpc = rpc;
        config.addProfileAccountsReadyListener(this);
        JLabel maxGroup = new JLabel(Language.get("ADMIN_GROUP_MAX_SG_SESSIONS"));
        JLabel maxUser = new JLabel(Language.get("ADMIN_USER_MAX_SG_SESSIONS"));
        this.rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 5));
        this.group = TextField.getTextFieldForType((int)1, (String)Language.get("UNLIMITED"));
        this.user = TextField.getTextFieldForType((int)1, (String)Language.get("UNLIMITED"));
        SwingUtil.setWidth((JComponent)this.group, (int)SimpleHelpLookAndFeel.scale((int)100));
        SwingUtil.setWidth((JComponent)this.user, (int)SimpleHelpLookAndFeel.scale((int)100));
        this.group.addKeyListener(this);
        this.user.addKeyListener(this);
        int N = 0;
        this.rootComponent.add(maxGroup, 0, N, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add(this.group, 1, N++, 1, 1, 1, 1, 17, 0);
        this.rootComponent.add(maxUser, 0, N, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add(this.user, 1, N++, 1, 1, 1, 1, 17, 0);
        this.addCenter((JComponent)((Object)this.rootComponent));
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.rootComponent != null) {
            this.rootComponent.setBackground(c);
        }
    }

    private void loadProfile() {
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        System.out.println("[Group Perms] Tech Group is " + tg.getName() + " / " + tg.getAssociatedAppProfileID());
        if (tg.isSgConcurrencyLimited()) {
            if (tg.getMaxSgGroupConcurrency() != -1) {
                this.group.setText(String.valueOf(tg.getMaxSgGroupConcurrency()));
            } else {
                this.group.setText(null);
            }
            if (tg.getMaxSgUserConcurrency() != -1) {
                this.user.setText(String.valueOf(tg.getMaxSgUserConcurrency()));
            } else {
                this.user.setText(null);
            }
        } else {
            this.group.setText(null);
            this.user.setText(null);
        }
    }

    public void loadFromProfile(AppProfile appProfile) {
        this.profile = appProfile;
        if (this.loadedConfig) {
            this.loadProfile();
        }
    }

    @Override
    public void profileAccountsReady() {
        this.loadedConfig = true;
        if (this.profile != null) {
            this.loadFromProfile(this.profile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.keyReleased(null);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.profile == null) {
            return;
        }
        if (this.pconfig == null) {
            return;
        }
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        if (tg == null) {
            return;
        }
        String grouptext = this.group.getText().trim();
        String usertext = this.user.getText().trim();
        int groupmax = 0;
        int usermax = 0;
        try {
            groupmax = Integer.parseInt(grouptext);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            usermax = Integer.parseInt(usertext);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (groupmax < 0) {
            groupmax = 0;
        }
        if (usermax < 0) {
            usermax = 0;
        }
        if (groupmax == 0) {
            tg.setMaxSgGroupConcurrency(-1);
        } else {
            tg.setMaxSgGroupConcurrency(groupmax);
        }
        if (usermax == 0) {
            tg.setMaxSgUserConcurrency(-1);
        } else {
            tg.setMaxSgUserConcurrency(usermax);
        }
        this.pconfig.saveAsync();
    }
}

