/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server.contents;

import com.aem.shelp.tech.alerts.alerts.utils.StatusIcon;
import java.awt.Graphics;

public class ServerEventsTableColumns {
    public static int[] cumulativeColumnWidths;
    public static int columnsToShow;
    public static final int PADDING = 4;
    public static final int STATUS_ICON_WIDTH;
    public static int statusCenter;
    private static int availableWidth;

    public static void setAvailableWidth(int width) {
        if (width == availableWidth) {
            return;
        }
        availableWidth = width;
        int metricsWidth = width - 200;
        if (metricsWidth < 0) {
            ServerEventsTableColumns.setColumnsToShow(1);
        } else {
            int colCount;
            for (colCount = cumulativeColumnWidths.length - 1; colCount > 0 && cumulativeColumnWidths[colCount] > metricsWidth; --colCount) {
            }
            ServerEventsTableColumns.setColumnsToShow(++colCount);
        }
    }

    public static int getColumnsWidth() {
        if (columnsToShow == 0) {
            return -1;
        }
        return cumulativeColumnWidths[columnsToShow - 1];
    }

    private static void setColumnsToShow(int count) {
        columnsToShow = count;
        switch (columnsToShow) {
            case 2: {
                statusCenter = -4 - STATUS_ICON_WIDTH / 2;
            }
        }
    }

    public static void callPaintMethods(Graphics g, int width, int height, ServerEventsColumnPainter painter) {
        switch (columnsToShow) {
            case 2: {
                painter.paintStatus(g, width, height);
            }
            case 0: 
            case 1: {
                painter.paintAlertName(g, width, height);
            }
        }
    }

    static {
        columnsToShow = 0;
        STATUS_ICON_WIDTH = StatusIcon.getStdWidth();
        cumulativeColumnWidths = new int[2];
        ServerEventsTableColumns.cumulativeColumnWidths[0] = 0;
        ServerEventsTableColumns.cumulativeColumnWidths[1] = cumulativeColumnWidths[0] + STATUS_ICON_WIDTH;
        ServerEventsTableColumns.setColumnsToShow(2);
    }

    public static interface ServerEventsColumnPainter {
        public void paintStatus(Graphics var1, int var2, int var3);

        public void paintAlertName(Graphics var1, int var2, int var3);

        public void paintPreviousTriggerTime(Graphics var1, int var2, int var3);

        public void paintDuration(Graphics var1, int var2, int var3);
    }
}

