/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server.contents;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertGroupPanelLabel;
import com.aem.shelp.tech.alerts.alerts.model.AlertModelChangeListener;
import com.aem.shelp.tech.alerts.events.server.contents.ServerEventsTable;
import com.aem.shelp.tech.alerts.events.server.model.ServerEventsTreeModel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupPanel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.ui.GroupPanelLabel;
import java.awt.Component;
import javax.swing.ListSelectionModel;

public class ServerEventsGroupPanel
extends AbstractGroupPanel<ResourceContainerGroup, ResourceContainer>
implements AlertModelChangeListener {
    private ServerEventsTable machineTable;

    public ServerEventsGroupPanel(ServerEventsTreeModel machineModel, ResourceContainerGroup group, AlertPanelListener accessPanelListener, boolean isFirstGroupAdded, AbstractGroupsList<ResourceContainerGroup, ResourceContainer> groupsList, boolean showMachineIcons) {
        super(machineModel, group, accessPanelListener, isFirstGroupAdded, groupsList);
        this.machineTable = new ServerEventsTable(machineModel, group, accessPanelListener, this);
        this.rootComponent.add((Component)this.machineTable.getRootComponent(), "Center");
    }

    @Override
    public boolean isEmpty() {
        return this.machineTable.isEmpty();
    }

    public void groupsRemoved(ResourceContainerGroup parentGroup, ResourceContainerGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    @Override
    protected void selectAllElementsInGroup(ResourceContainerGroup machineGroup) {
        this.machineTable.getRootComponent().selectAll();
    }

    @Override
    protected void selectElements(boolean selectAfterAnchorRow) {
        ListSelectionModel selectionModel = this.machineTable.getRootComponent().getSelectionModel();
        int anchorSelectionIndex = selectionModel.getAnchorSelectionIndex();
        if (selectAfterAnchorRow) {
            selectionModel.setSelectionInterval(anchorSelectionIndex, this.machineTable.getRootComponent().getRowCount() - 1);
        } else {
            selectionModel.setSelectionInterval(0, anchorSelectionIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void machinesChanged(ResourceContainerGroup parentGroup, ResourceContainer[] inserted, ResourceContainer[] removed, ResourceContainer[] updated, Machine.MachineChanges updateResults) {
        if ((parentGroup == this.group || parentGroup != null && this.group != null && parentGroup.equals(this.group)) && updated != null) {
            ((ResourceContainerGroup)this.group).getElements().startBatch();
            try {
                for (ResourceContainer m : updated) {
                    ((ResourceContainerGroup)this.group).getElements().notifyElementUpdate(m);
                }
            }
            finally {
                ((ResourceContainerGroup)this.group).getElements().endBatch();
            }
        }
    }

    @Override
    protected void clearSelection() {
        this.machineTable.getRootComponent().clearSelection();
    }

    @Override
    protected void selectLastElement() {
        int row = this.machineTable.getRootComponent().getRowCount();
        this.machineTable.getRootComponent().getSelectionModel().setSelectionInterval(row - 1, row - 1);
    }

    @Override
    protected void selectFirstElement() {
        this.machineTable.getRootComponent().getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    protected boolean allElementsSelected() {
        return this.machineTable.getRootComponent().getSelectedRowCount() == this.machineTable.getRootComponent().getRowCount();
    }

    public ResourceContainer[] getSelectedElements() {
        return this.machineTable.getSelectedAlerts();
    }

    @Override
    public void ensureElementIsSelected(ResourceContainerGroup group, ResourceContainer machine) {
        this.machineTable.select(machine);
    }

    @Override
    protected GroupPanelLabel<ResourceContainerGroup, ResourceContainer> initLabel(HierarchyPanelListener panelListener, ResourceContainerGroup group, boolean isFirstGroupAdded) {
        return new AlertGroupPanelLabel((AlertPanelListener)panelListener, group, isFirstGroupAdded);
    }
}

