/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server;

import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.access.RemoteMachineOfflineExtended;
import com.aem.shelp.proxy.logging.targets.runtool.RunToolTarget;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AbstractAlertsDetailsPanel;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.events.server.details.ServerEventsInfoPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.TargetUIListener;
import utils.loggingframework.ui.MultipleSelectTargetComponent;
import utils.loggingframework.ui.SpecifyFiltersUI;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerEventsDetailsPanel
extends AbstractAlertsDetailsPanel
implements SimpleMachineGroupList.ButtonClickListener,
TargetUIListener {
    private GbPanel filtersPanel;
    private GbPanel actionsPanel;
    private JScrollPane infoPanelScrollPane;
    private JScrollPane filtersScrollPane;
    private JScrollPane actionsScrollPane;
    private JToggleButton infoViewButton;
    private JToggleButton filterButton;
    private JToggleButton actionButton;
    private ServerEventsInfoPanel infoPanel;
    private SpecifyFiltersUI filterUI;
    private MultipleSelectTargetComponent targetUI;
    private GbPanel bottomFiltersPanel;
    private JTextField remoteAccessExtendedField;

    @Override
    public void setTechClient(TechClient client) {
        super.setTechClient(client);
        this.infoPanel.setTechClient(client);
        this.infoPanel.setMachineTreeModel(this.machineModel);
        boolean canManageAlerts = client.getPermissions().canManageServerEvents();
        this.deleteButton.setVisible(canManageAlerts);
        this.saveButton.setVisible(canManageAlerts);
        this.activeButton.setVisible(canManageAlerts);
        this.activeLabel.setVisible(canManageAlerts);
    }

    public ServerEventsDetailsPanel(MachineTreeModel machineModel, AlertPanelListener alertPanelListener) {
        super(machineModel, alertPanelListener);
    }

    @Override
    public void initUI() {
        this.initInfoPanel();
        this.initFiltersPane();
        this.initActionsPanel();
        this.infoViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/spanner-dark.svg,16"));
        this.filterButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/funnel.svg,16"));
        this.actionButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/users/runner.svg,16"));
        this.infoViewButton.setToolTipText(Language.get("SERVER_EVENT_VIEW_TOOLTIP"));
        this.filterButton.setToolTipText(Language.get("SERVER_EVENT_FILTER_TOOLTIP"));
        this.actionButton.setToolTipText(Language.get("SERVER_EVENT_ACTION_TOOLTIP"));
        this.infoPanelScrollPane = new JScrollPane((Component)((Object)this.infoPanel));
        this.infoPanelScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoPanelScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.filtersScrollPane = new JScrollPane((Component)this.filtersPanel);
        this.filtersScrollPane.setHorizontalScrollBarPolicy(31);
        this.filtersScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.actionsScrollPane = new JScrollPane((Component)this.actionsPanel);
        this.actionsScrollPane.setHorizontalScrollBarPolicy(31);
        this.actionsScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.infoPanelScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.infoPanelScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.filtersScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.filtersScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.actionsScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.actionsScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.setViewButtons(new AbstractButton[]{this.infoViewButton, this.filterButton, this.actionButton}, new JComponent[]{this.infoPanelScrollPane, this.filtersScrollPane, this.actionsScrollPane});
        super.initUI();
    }

    @Override
    public void alertModified() {
        this.selectedEventsChanged();
        ServerEvent se = (ServerEvent)this.alert;
        se.setFilters(this.filterUI.getFilters());
        se.setTargets(this.targetUI.getTargets().toArray(new AbstractTarget[0]));
        if (se.includesRemoteAccessOfflineExtendedEvent()) {
            se.setRemoteAccessExtendedTimeout((long)Integer.parseInt(this.remoteAccessExtendedField.getText()) * 60000L);
        }
        super.alertModified();
    }

    private void selectedEventsChanged() {
        this.filterUI.setEvents(this.infoPanel.getSelectedEvents());
        this.targetUI.setLogEventsToTarget(this.infoPanel.getSelectedEvents());
        LogEvent[] selectedEvents = this.infoPanel.getSelectedEvents();
        boolean containsRemoteMachineOfflineExtendedEvent = false;
        for (LogEvent event : selectedEvents) {
            if (!(event instanceof RemoteMachineOfflineExtended)) continue;
            containsRemoteMachineOfflineExtendedEvent = true;
            break;
        }
        this.bottomFiltersPanel.setVisible(containsRemoteMachineOfflineExtendedEvent);
        this.bottomFiltersPanel.repaint();
    }

    private void initFiltersPane() {
        this.filtersPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.filterUI = new SpecifyFiltersUI(Language.DEFLANG, (SwingStyleInterface)SHStyle.INSTANCE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerEventsDetailsPanel.this.alertModified();
            }
        });
        this.bottomFiltersPanel = new GbPanel(new ScaledInsets(0, 3, 3, 3));
        JLabel label = new JLabel(Language.get("REMOTE_MACHINE_TIMEOUT"));
        this.remoteAccessExtendedField = new JTextField(3);
        this.remoteAccessExtendedField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerEventsDetailsPanel.this.alertModified();
            }
        });
        JLabel mins = new JLabel(Language.get("UNIT_MINUTES"));
        SwingUtil.setWidth((JComponent)this.remoteAccessExtendedField, (int)SimpleHelpLookAndFeel.scale((int)50));
        this.bottomFiltersPanel.add((Component)label, 0, 0, 1, 1, 0, 1, 10, 1);
        this.bottomFiltersPanel.add((Component)this.remoteAccessExtendedField, 1, 0, 1, 1, 0, 1, 10, 1);
        this.bottomFiltersPanel.add((Component)mins, 2, 0, 1, 1, 1, 1, 17, 1);
        JLabel nameLabel = new JLabel(Language.get("LOGGING_UI_FILTER_EVENTS_DESC"));
        nameLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/funnel.svg,24"));
        nameLabel.setIconTextGap(SimpleHelpLookAndFeel.scale((int)8));
        this.filtersPanel.add((Component)nameLabel, 0, 0, 1, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(10, 3, 10, 3));
        this.filtersPanel.add(this.filterUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 1);
        this.filtersPanel.add((Component)this.bottomFiltersPanel, 0, 2, 1, 1, 1, 0, 10, 1);
    }

    private void initInfoPanel() {
        this.infoPanel = new ServerEventsInfoPanel(this);
    }

    private void initActionsPanel() {
        this.targetUI = new MultipleSelectTargetComponent(Language.DEFLANG, this, (SwingStyleInterface)SHStyle.INSTANCE, false, new Class[]{RunToolTarget.class});
        this.actionsPanel = new GbPanel();
        JLabel desc = new JLabel(Language.get("LOGGING_UI_SELECT_TARGET_DESC"));
        desc.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/runner.svg,24"));
        desc.setIconTextGap(8);
        this.actionsPanel.add((Component)desc, 0, 0, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(10, 3, 10, 3));
        this.actionsPanel.add((Component)this.targetUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(3, 3, 3, 3));
    }

    @Override
    protected void initUIForSingleAlert(ResourceContainer alert) {
        super.initUIForSingleAlert(alert);
        if (alert instanceof ServerEvent) {
            ServerEvent se = (ServerEvent)alert;
            this.infoPanel.initPanelWith(se);
            this.selectedEventsChanged();
            if (se.getTargets() != null) {
                this.targetUI.setTargets(new ArrayList<AbstractTarget>(Arrays.asList(se.getTargets())));
            } else {
                this.targetUI.setTargets(new ArrayList<AbstractTarget>());
            }
            this.filterUI.loadFromExistingFilters(se.getFilters());
            if (se.includesRemoteAccessOfflineExtendedEvent()) {
                this.remoteAccessExtendedField.setText(String.valueOf(se.getRemoteAccessMachineExtendedTimeout() / 60000L));
            }
        }
    }

    @Override
    public void buttonClicked(Object machineID) {
        this.alertPanelListener.showMachineInUI((String)machineID);
    }

    @Override
    public void targetUIComplete() {
    }

    @Override
    public void targetUIIncomplete() {
    }

    @Override
    public void targetChanged() {
        this.alertModified();
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }
}

