/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.alerts.threshold.AntiVirusThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.DiskHealthThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.DiskSpaceThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FileAccessibleThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FileLengthThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FileModifiedThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.FirewallThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ProcRunningThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ServiceRunningThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.TcpAccessibleThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.ToolboxDatapointThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WebsiteAccessibleThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WebsiteResponseTimeThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WindowsEventLogThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.WindowsRegistryThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimplePercentThreshold;
import com.aem.shelp.proxy.types.alerts.threshold.generic.SimpleProcessThreshold;
import com.aem.shelp.tech.access.MachineFileChooser;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.ScheduleField;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerConfigListener;
import com.aem.shelp.tech.utils.tools.popup.PickToolPopup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.components.SHJTable;
import utils.swing.cui.layouts.CUIHorizontalPanel;
import utils.swing.cui.layouts.MarkRedChangeListener;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.CUIPopulateDialog;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.ComboBoxField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.switches.Switches;

public class TriggerConfigPanel
extends JPanel
implements AbstractField.ChangeListener,
CUIPopulateDialog {
    private Alert alert;
    private CUIHorizontalPanel cuiPanel;
    private boolean isValid = false;
    private TextField trigname;
    private ComboBoxField overunder;
    private TextField threshold;
    private ComboBoxField chooser;
    private TextField match;
    private TextField folder;
    private ScheduleField schedule;
    private ExclusionList exclusionList;
    private TextFieldWithComboUnits comboUnits;
    private TextFieldWithComboUnits comboUnits2;
    private TriggerConfigListener listener;
    private ConfigChangeListener change;
    private TechClient client;
    private MachineTreeModel machines;
    private ComboBoxField registryModeBox;
    private TextField key;
    private TextField valueName;
    private TextField valueData;
    private ComboBoxField logNameBox;
    private ComboBoxField eventTypeBox;
    private TextField eventMessage;
    private TextField eventUser;
    private TextField eventSource;
    private TextField eventComputer;
    private ToolBoxItem pickedToolDef;

    public void changed(AbstractField source) {
        this.change.changed(source);
    }

    public void setTriggerConfigListener(TriggerConfigListener listener) {
        this.listener = listener;
        this.changed(null);
    }

    public TriggerConfigPanel(TechClient client, MachineTreeModel machines, Alert alert) {
        this.client = client;
        this.machines = machines;
        this.initUI(alert);
    }

    void initUI(Alert alert) {
        this.alert = alert;
        this.cuiPanel = new CUIHorizontalPanel(new ScaledInsets(3, 3, 3, 3), true);
        this.cuiPanel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        this.change = new ConfigChangeListener(this.cuiPanel);
        this.trigname = Language.exists("ALERT_THRESHOLD_TITLE") ? new TextField(Language.get("ALERT_THRESHOLD_TITLE"), (AbstractField.ChangeListener)this) : new TextField(Language.get("TRIGGER_NAME"), (AbstractField.ChangeListener)this);
        this.trigname.setWidthPercentage(100);
        if (Language.exists("ALERT_THRESHOLD_AUTODETECT")) {
            this.trigname.setExampleValue(Language.get("ALERT_THRESHOLD_AUTODETECT"));
        } else {
            this.trigname.setExampleValue(Language.get("ALERT_DEF_NAME"));
        }
        try {
            if (!alert.isUsingDefaultName()) {
                this.trigname.setDefaultValue(alert.getName());
            }
        }
        catch (Exception x) {
            this.trigname.setDefaultValue(Language.get(alert.getTypeNameKey()));
        }
        this.cuiPanel.add((CUIField)this.trigname);
        this.cuiPanel.add((CUIField)new LabelField(""));
        if (alert instanceof SimplePercentThreshold) {
            int index;
            long sizeUnits;
            String[] options;
            DiskSpaceThreshold dst;
            SimplePercentThreshold src = (SimplePercentThreshold)((Object)alert);
            if (alert instanceof DiskSpaceThreshold && Switches.SH_minimum_disk_size) {
                dst = (DiskSpaceThreshold)alert;
                this.chooser = new ComboBoxField(Language.get("DISK_ALERT_TYPE"), (AbstractField.ChangeListener)this, new String[]{Language.get("DISK_DISK_USED"), Language.get("DISK_FREE_SPACE")});
                this.chooser.setWidthPercentage(1);
                this.chooser.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TriggerConfigPanel.this.chooser.getComboBox().getSelectedIndex() == 0) {
                            TriggerConfigPanel.this.comboUnits.setVisible(false);
                            TriggerConfigPanel.this.threshold.setVisible(true);
                        } else {
                            TriggerConfigPanel.this.comboUnits.setVisible(true);
                            TriggerConfigPanel.this.threshold.setVisible(false);
                        }
                    }
                });
                this.cuiPanel.add((CUIField)this.chooser);
                options = new String[]{Language.get("GBYTES"), Language.get("MBYTES"), Language.get("KBYTES"), Language.get("BYTES")};
                sizeUnits = dst.getFreeSpaceUnits();
                index = sizeUnits == 0L || (double)sizeUnits == Math.pow(1024.0, 3.0) ? 0 : ((double)sizeUnits == Math.pow(1024.0, 2.0) ? 1 : ((double)sizeUnits == Math.pow(1024.0, 1.0) ? 2 : 3));
                this.comboUnits = new TextFieldWithComboUnits(Language.get("MINIMUM_DISK_SIZE"), this, dst.getFreeSpaceValue() + "", index, options);
                this.comboUnits.setWidthPercentage(40);
                this.cuiPanel.add((CUIField)this.comboUnits);
                this.comboUnits.setVisible(false);
            }
            this.threshold = new TextField(Language.get(src.getResourceKey()), (AbstractField.ChangeListener)this, 1);
            this.threshold.setWidthPercentage(20);
            this.threshold.setUnits(src.getResourceUnit());
            this.threshold.setRequired(true);
            this.threshold.setExampleValue("80");
            this.threshold.setDefaultValue("" + (int)src.getTriggerPercent());
            this.cuiPanel.add((CUIField)this.threshold);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("OVER"), Language.get("UNDER")});
            this.overunder.setWidthPercentage(1);
            if (src.getTriggerOnOver()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
            this.cuiPanel.add((CUIField)this.overunder);
            this.cuiPanel.add((CUIField)new LabelField(""));
            if (alert instanceof SimpleProcessThreshold) {
                this.match = new TextField(Language.get("ALERT_PROCESS_MATCH"), (AbstractField.ChangeListener)this);
                this.match.setWidthPercentage(50);
                this.match.setExampleValue("database-*.exe");
                this.match.setDefaultValue(((SimpleProcessThreshold)((Object)alert)).getMatchString());
                this.cuiPanel.add((CUIField)this.match);
            } else if (alert instanceof DiskSpaceThreshold && Switches.SH_minimum_disk_size) {
                dst = (DiskSpaceThreshold)alert;
                options = new String[]{Language.get("GBYTES"), Language.get("MBYTES"), Language.get("KBYTES"), Language.get("BYTES")};
                sizeUnits = dst.getMinimumDiskSizeUnits();
                index = sizeUnits == 0L || (double)sizeUnits == Math.pow(1024.0, 3.0) ? 0 : ((double)sizeUnits == Math.pow(1024.0, 2.0) ? 1 : ((double)sizeUnits == Math.pow(1024.0, 1.0) ? 2 : 3));
                this.comboUnits2 = new TextFieldWithComboUnits(Language.get("MINIMUM_DISK_SIZE"), this, dst.getMinimumDiskSize() + "", index, options);
                this.comboUnits2.setWidthPercentage(40);
                this.cuiPanel.add((CUIField)this.comboUnits2);
                this.exclusionList = new ExclusionList(this, dst.getExclusions());
                this.exclusionList.setExclude(dst.isExclude());
                this.exclusionList.setWidthPercentage(70);
                this.cuiPanel.add((CUIField)this.exclusionList);
                if (dst.isPercentageMode()) {
                    this.chooser.setSelectedIndex(0);
                } else {
                    this.chooser.setSelectedIndex(1);
                }
            }
        } else if (alert instanceof AntiVirusThreshold) {
            AntiVirusThreshold trig = (AntiVirusThreshold)alert;
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("AV_NOT_OK"), Language.get("AV_OK")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            if (trig.getTriggerIfMissing()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
            this.chooser = new ComboBoxField("", (AbstractField.ChangeListener)this, new String[]{Language.get("ACCEPT_WDEF"), Language.get("REJECT_WDEF")});
            this.chooser.setWidthPercentage(1);
            if (trig.canAcceptDefender()) {
                this.chooser.setSelectedIndex(0);
            } else {
                this.chooser.setSelectedIndex(1);
            }
            this.cuiPanel.add((CUIField)this.chooser);
        } else if (alert instanceof FirewallThreshold) {
            FirewallThreshold trig = (FirewallThreshold)alert;
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("AV_NOT_OK"), Language.get("AV_OK")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            if (trig.getTriggerIfMissing()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof DiskHealthThreshold) {
            DiskHealthThreshold trig = (DiskHealthThreshold)alert;
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("MAY_FAIL"), Language.get("IS_OK")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            if (trig.getTriggerIfBroken()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof FileAccessibleThreshold) {
            FileAccessibleThreshold trig = (FileAccessibleThreshold)alert;
            this.folder = new TextField(Language.get("FOLDER"), (AbstractField.ChangeListener)this);
            this.folder.setCUIPopulateDialog((CUIPopulateDialog)this, ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
            this.folder.setWidthPercentage(50);
            this.folder.setRequired(true);
            this.cuiPanel.add((CUIField)this.folder);
            this.match = new TextField(Language.get("ALERT_FILENAME_MATCH"), (AbstractField.ChangeListener)this);
            this.match.setWidthPercentage(50);
            this.cuiPanel.add((CUIField)this.match);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("EXISTS"), Language.get("DOESNT_EXIST")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.folder.setDefaultValue(trig.getSearchFolder());
            this.match.setDefaultValue(trig.getNameMatch());
            this.match.setExampleValue("output*.log");
            if (trig.getTriggerIfExists()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof FileLengthThreshold) {
            FileLengthThreshold trig = (FileLengthThreshold)alert;
            this.folder = new TextField(Language.get("FILE_PATH"), (AbstractField.ChangeListener)this);
            this.folder.setCUIPopulateDialog((CUIPopulateDialog)this, ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
            this.folder.setWidthPercentage(50);
            this.folder.setRequired(true);
            this.cuiPanel.add((CUIField)this.folder);
            this.threshold = new TextField(Language.get("KB_MAX"), (AbstractField.ChangeListener)this, 1);
            this.threshold.setUnits(Language.get("KBYTES"));
            this.threshold.setWidthPercentage(30);
            this.threshold.setRequired(true);
            this.cuiPanel.add((CUIField)this.threshold);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("OVER"), Language.get("UNDER")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.folder.setExampleValue("output.log");
            this.folder.setDefaultValue(trig.getFilePath());
            this.threshold.setDefaultValue(trig.getThresholdKB() + "");
            this.threshold.setExampleValue("100");
            if (trig.getTriggerIfOver()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof FileModifiedThreshold) {
            FileModifiedThreshold trig = (FileModifiedThreshold)alert;
            this.folder = new TextField(Language.get("FILE_PATH"), (AbstractField.ChangeListener)this);
            this.folder.setWidthPercentage(50);
            this.folder.setCUIPopulateDialog((CUIPopulateDialog)this, ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
            this.folder.setRequired(true);
            this.cuiPanel.add((CUIField)this.folder);
            this.threshold = new TextField(Language.get("MINS_OLD"), (AbstractField.ChangeListener)this, 1);
            this.threshold.setWidthPercentage(30);
            this.threshold.setUnits(Language.get("UNIT_MINUTES"));
            this.threshold.setRequired(true);
            this.cuiPanel.add((CUIField)this.threshold);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_MODIFIED"), (AbstractField.ChangeListener)this, new String[]{Language.get("OLDER"), Language.get("NEWER")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.folder.setExampleValue("example.dat");
            this.folder.setDefaultValue(trig.getFilePath());
            this.threshold.setExampleValue("60");
            this.threshold.setDefaultValue(trig.getThresholdMS() / 60000L + "");
            if (trig.getTriggerIfOlder()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof ToolboxDatapointThreshold) {
            ToolboxDatapointThreshold trig = (ToolboxDatapointThreshold)alert;
            this.pickedToolDef = trig.getToolBoxItem();
            this.match = new TextField(Language.get("ALERT_TBOX_TOOLNAME"), (AbstractField.ChangeListener)this);
            this.match.setEditable(false);
            this.match.setWidthPercentage(70);
            this.match.setRequired(true);
            ToolPickerDialog dialog = new ToolPickerDialog();
            this.match.setCUIPopulateDialog((CUIPopulateDialog)dialog, ImageLoader.getImageIcon((String)"images/svg/general/box.svg,16"));
            dialog.entry = this.match;
            dialog.button = this.match.getPickingButton();
            this.cuiPanel.add((CUIField)this.match);
            this.schedule = new ScheduleField(Language.get("SCHEDULE"), this);
            this.schedule.setWidthPercentage(1);
            if (trig.getBlockCount() > 0.0) {
                this.schedule.setBlockCount(trig.getBlockCount());
                this.schedule.setBlockUnit(trig.getBlockUnit());
                this.schedule.setStartTime(trig.getStartTime());
                this.schedule.setUseGMT(trig.useGMT());
            }
            this.cuiPanel.add((CUIField)this.schedule);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("RET_NONZERO"), Language.get("RET_ZERO")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            if (this.pickedToolDef != null) {
                this.match.setDefaultValue(this.pickedToolDef.getName());
            }
            if (trig.getTriggerIfNonZero()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof ServiceRunningThreshold) {
            ServiceRunningThreshold trig = (ServiceRunningThreshold)alert;
            this.match = new TextField(Language.get("ALERT_SERVICE_NAME"), (AbstractField.ChangeListener)this);
            this.match.setWidthPercentage(50);
            this.match.setRequired(true);
            this.cuiPanel.add((CUIField)this.match);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("RUNNING"), Language.get("NOT_RUNNING")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.match.setExampleValue("SimpleHelp*");
            this.match.setDefaultValue(trig.getServiceName());
            if (trig.getTriggerIfRunning()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof ProcRunningThreshold) {
            ProcRunningThreshold trig = (ProcRunningThreshold)alert;
            this.match = new TextField(Language.get("ALERT_PROCESS_NAME"), (AbstractField.ChangeListener)this);
            this.match.setWidthPercentage(50);
            this.match.setRequired(true);
            this.cuiPanel.add((CUIField)this.match);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("EXISTS"), Language.get("DOESNT_EXIST")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.match.setExampleValue("example*.exe");
            this.match.setDefaultValue(trig.getProcessName());
            if (trig.getTriggerIfRunning()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof TcpAccessibleThreshold) {
            TcpAccessibleThreshold trig = (TcpAccessibleThreshold)alert;
            this.match = new TextField(Language.get("ALERT_TCP_HOST"), (AbstractField.ChangeListener)this);
            this.match.setWidthPercentage(50);
            this.match.setRequired(true);
            this.cuiPanel.add((CUIField)this.match);
            this.threshold = new TextField(Language.get("ALERT_TCP_PORT"), (AbstractField.ChangeListener)this, 8);
            this.threshold.setWidthPercentage(20);
            this.threshold.setRequired(true);
            this.cuiPanel.add((CUIField)this.threshold);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("ACCESSIBLE"), Language.get("INACCESSIBLE")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.match.setExampleValue("http://google.com");
            this.match.setDefaultValue(trig.getHost());
            this.threshold.setExampleValue("80");
            this.threshold.setDefaultValue("" + trig.getPort());
            if (trig.getTriggerIfAccessible()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof WebsiteAccessibleThreshold) {
            WebsiteAccessibleThreshold trig = (WebsiteAccessibleThreshold)alert;
            this.match = new TextField(Language.get("ALERT_WEBSITE"), (AbstractField.ChangeListener)this);
            this.match.setWidthPercentage(50);
            this.match.setRequired(true);
            this.cuiPanel.add((CUIField)this.match);
            this.folder = new TextField(Language.get("ALERT_WEBSITE_VALIDATE"), (AbstractField.ChangeListener)this);
            this.folder.setWidthPercentage(100);
            this.cuiPanel.add((CUIField)this.folder);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("ACCESSIBLE"), Language.get("INACCESSIBLE")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.match.setExampleValue("http://google.com");
            this.match.setDefaultValue(trig.getSite());
            this.folder.setDefaultValue(trig.getValidationText());
            if (trig.getTriggerIfAccessible()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof WebsiteResponseTimeThreshold) {
            WebsiteResponseTimeThreshold trig = (WebsiteResponseTimeThreshold)alert;
            this.match = new TextField(Language.get("ALERT_WEBSITE"), (AbstractField.ChangeListener)this);
            this.match.setWidthPercentage(50);
            this.match.setRequired(true);
            this.cuiPanel.add((CUIField)this.match);
            this.threshold = new TextField(Language.get("ALERT_RT_SECS"), (AbstractField.ChangeListener)this, 2);
            this.threshold.setWidthPercentage(30);
            this.threshold.setUnits(Language.get("UNIT_SECONDS"));
            this.threshold.setRequired(true);
            this.cuiPanel.add((CUIField)this.threshold);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("ACCESSIBLE"), Language.get("INACCESSIBLE")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            this.match.setExampleValue("http://google.com");
            this.match.setDefaultValue(trig.getSite());
            this.threshold.setDefaultValue("" + (double)trig.getResponseTimeMS() / 1000.0);
            this.threshold.setExampleValue("60");
            if (trig.getTriggerIfOver()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
        } else if (alert instanceof WindowsRegistryThreshold) {
            WindowsRegistryThreshold trig = (WindowsRegistryThreshold)alert;
            this.registryModeBox = new ComboBoxField(null, (AbstractField.ChangeListener)this, new String[]{Language.get("ALERT_EVENT_REGISTRY_MODE_KEY"), Language.get("ALERT_EVENT_REGISTRY_MODE_VALUE"), Language.get("ALERT_EVENT_REGISTRY_MODE_DATA")});
            this.cuiPanel.add((CUIField)this.registryModeBox);
            this.key = new TextField(Language.get("ALERT_REGISTRY_KEY"), (AbstractField.ChangeListener)this);
            this.key.setWidthPercentage(100);
            this.cuiPanel.add((CUIField)this.key);
            this.valueName = new TextField(Language.get("ALERT_REGISTRY_VALUE"), (AbstractField.ChangeListener)this);
            this.valueName.setWidthPercentage(50);
            this.cuiPanel.add((CUIField)this.valueName);
            this.valueData = new TextField(Language.get("ALERT_REGISTRY_DATA"), (AbstractField.ChangeListener)this);
            this.valueData.setWidthPercentage(50);
            this.cuiPanel.add((CUIField)this.valueData);
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{Language.get("REGISTRY_MATCH_FOUND"), Language.get("REGISTRY_MATCH_NOT_FOUND")});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            switch (trig.getMode()) {
                case 0: {
                    this.registryModeBox.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.registryModeBox.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.registryModeBox.setSelectedIndex(2);
                    break;
                }
                default: {
                    this.registryModeBox.setSelectedIndex(0);
                }
            }
            this.key.setDefaultValue(trig.getRegistryKey());
            this.valueName.setDefaultValue(trig.getValueName());
            this.valueData.setDefaultValue(trig.getValue());
            if (trig.triggerIfMatchFound()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
            this.updateRegistryBoxVisible();
        } else if (alert instanceof WindowsEventLogThreshold) {
            WindowsEventLogThreshold trig = (WindowsEventLogThreshold)alert;
            this.logNameBox = new ComboBoxField(Language.get("ALERT_EVENT_LOGNAME"), (AbstractField.ChangeListener)this, new String[]{"Application", "System", "Security"});
            ((JComboBox)this.logNameBox.getComponent()).setEditable(true);
            this.cuiPanel.add((CUIField)this.logNameBox);
            String one = Language.exists("ALERT_EVENT_LOG_RECEIVED") ? Language.get("ALERT_EVENT_LOG_RECEIVED") : "found a matching event recently";
            String two = Language.exists("ALERT_EVENT_LOG_NOT_RECEIVED") ? Language.get("ALERT_EVENT_LOG_NOT_RECEIVED") : "did not find a matching event recently";
            this.overunder = new ComboBoxField(Language.get("ALERT_CONFIG_TRIGGER_IF_OVER"), (AbstractField.ChangeListener)this, new String[]{one, two});
            this.overunder.setWidthPercentage(1);
            this.cuiPanel.add((CUIField)this.overunder);
            if (trig.triggerIfEventReceived()) {
                this.overunder.setSelectedIndex(0);
            } else {
                this.overunder.setSelectedIndex(1);
            }
            this.cuiPanel.add((CUIField)new LabelField(""));
            this.cuiPanel.add((CUIField)new LabelField(Language.get("ALERT_EVENT_CONFIG")));
            this.eventTypeBox = new ComboBoxField(Language.get("ALERT_EVENT_TYPE"), (AbstractField.ChangeListener)this, new String[]{Language.get("TRANSPORT_ANY"), Language.get("INFORMATION"), Language.get("WARNING"), Language.get("ERROR"), Language.get("AUDIT_SUCCESS"), Language.get("AUDIT_FAILURE")});
            this.cuiPanel.add((CUIField)this.eventTypeBox);
            this.eventSource = new TextField(Language.get("ALERT_EVENT_SOURCE"), (AbstractField.ChangeListener)this);
            this.eventSource.setExampleValue(Language.get("TRANSPORT_ANY"));
            this.eventSource.setWidthPercentage(50);
            this.cuiPanel.add((CUIField)this.eventSource);
            this.eventUser = new TextField(Language.get("ALERT_EVENT_USER"), (AbstractField.ChangeListener)this);
            this.eventUser.setExampleValue(Language.get("TRANSPORT_ANY"));
            this.eventUser.setWidthPercentage(50);
            this.cuiPanel.add((CUIField)this.eventUser);
            this.eventComputer = new TextField(Language.get("ALERT_EVENT_COMPUTER"), (AbstractField.ChangeListener)this);
            this.eventComputer.setExampleValue(Language.get("TRANSPORT_ANY"));
            this.eventComputer.setWidthPercentage(50);
            this.cuiPanel.add((CUIField)this.eventComputer);
            this.eventMessage = new TextField(Language.get("ALERT_EVENT_MESSAGE"), (AbstractField.ChangeListener)this);
            this.eventMessage.setExampleValue(Language.get("TRANSPORT_ANY"));
            this.cuiPanel.add((CUIField)this.eventMessage);
            this.logNameBox.setEditableText(trig.getLogName());
            this.eventMessage.setDefaultValue(trig.getMessage());
            this.eventUser.setDefaultValue(trig.getUser());
            this.eventSource.setDefaultValue(trig.getSource());
            this.eventComputer.setDefaultValue(trig.getComputer());
            switch (trig.getEventType()) {
                case 0: {
                    this.eventTypeBox.setSelectedIndex(0);
                    break;
                }
                case 4: {
                    this.eventTypeBox.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.eventTypeBox.setSelectedIndex(2);
                    break;
                }
                case 1: {
                    this.eventTypeBox.setSelectedIndex(3);
                    break;
                }
                case 8: {
                    this.eventTypeBox.setSelectedIndex(4);
                    break;
                }
                case 16: {
                    this.eventTypeBox.setSelectedIndex(5);
                    break;
                }
                default: {
                    this.eventTypeBox.setSelectedIndex(0);
                    break;
                }
            }
        } else {
            this.cuiPanel.add((CUIField)new LabelField(Language.get("ALERT_CONFIG_TRIGGER_OOPS") + " (" + alert.getClass().getName() + ")"));
        }
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.cuiPanel.getRootComponent());
        this.change.changed(null);
    }

    private void updateRegistryBoxVisible() {
        if (this.registryModeBox == null) {
            return;
        }
        switch (this.registryModeBox.getSelectedIndex()) {
            case 0: {
                this.valueName.setVisible(false);
                this.valueData.setVisible(false);
                break;
            }
            case 1: {
                this.valueName.setVisible(true);
                this.valueData.setVisible(false);
                break;
            }
            case 2: {
                this.valueName.setVisible(true);
                this.valueData.setVisible(true);
            }
        }
    }

    public Alert getConfiguredAlert() {
        try {
            Alert newb = (Alert)this.alert.getClass().newInstance();
            newb.importIDfrom(this.alert);
            if (newb instanceof SimplePercentThreshold) {
                ((SimplePercentThreshold)((Object)newb)).setTriggerOnOver(this.overunder.getSelectedIndex() == 0);
                ((SimplePercentThreshold)((Object)newb)).setTriggerPercent(Integer.parseInt(this.threshold.getTextFieldValue()));
                if (newb instanceof SimpleProcessThreshold) {
                    ((SimpleProcessThreshold)((Object)newb)).setMatchString(this.match.getTextFieldValue());
                } else if (newb instanceof DiskSpaceThreshold) {
                    try {
                        DiskSpaceThreshold dst = (DiskSpaceThreshold)newb;
                        double minDiskSize = Double.parseDouble(this.comboUnits2.getText());
                        long minDiskUnits = (long)Math.pow(1024.0, 3 - this.comboUnits2.getSelectedIndex());
                        double freeSpaceSize = Double.parseDouble(this.comboUnits.getText());
                        long freeSpaceUnits = (long)Math.pow(1024.0, 3 - this.comboUnits.getSelectedIndex());
                        if (this.chooser.getSelectedIndex() == 0) {
                            ((DiskSpaceThreshold)newb).setMode((byte)0);
                        } else {
                            ((DiskSpaceThreshold)newb).setMode((byte)1);
                        }
                        dst.setFreeSpace(freeSpaceSize, freeSpaceUnits);
                        dst.setMinimumDiskSize(minDiskSize, minDiskUnits);
                        dst.setExclusions(this.exclusionList.getIncludeExemptionList());
                        dst.setExclude(this.exclusionList.isExclude());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else if (newb instanceof DiskHealthThreshold) {
                DiskHealthThreshold trig = (DiskHealthThreshold)newb;
                trig.setTriggerIfBroken(this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof FirewallThreshold) {
                FirewallThreshold trig = (FirewallThreshold)newb;
                trig.setTriggerIfMissing(this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof AntiVirusThreshold) {
                AntiVirusThreshold trig = (AntiVirusThreshold)newb;
                trig.setTriggerIfMissing(this.overunder.getSelectedIndex() == 0);
                trig.setAcceptDefender(this.chooser.getSelectedIndex() == 0);
            } else if (newb instanceof FileAccessibleThreshold) {
                FileAccessibleThreshold trig = (FileAccessibleThreshold)newb;
                trig.setTriggerOnFileExists(this.folder.getTextFieldValue(), this.match.getTextFieldValue(), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof FileLengthThreshold) {
                FileLengthThreshold trig = (FileLengthThreshold)newb;
                trig.setTriggerOnFileLength(this.folder.getTextFieldValue(), Integer.parseInt(this.threshold.getTextFieldValue()), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof FileModifiedThreshold) {
                FileModifiedThreshold trig = (FileModifiedThreshold)newb;
                trig.setTriggerOn(this.folder.getTextFieldValue(), 60000 * Integer.parseInt(this.threshold.getTextFieldValue()), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof ServiceRunningThreshold) {
                ServiceRunningThreshold trig = (ServiceRunningThreshold)newb;
                trig.setTriggerOnService(this.match.getTextFieldValue(), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof ProcRunningThreshold) {
                ProcRunningThreshold trig = (ProcRunningThreshold)newb;
                trig.setTriggerOnProcess(this.match.getTextFieldValue(), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof ToolboxDatapointThreshold) {
                ToolboxDatapointThreshold trig = (ToolboxDatapointThreshold)newb;
                trig.setTriggerOnToolResult(this.pickedToolDef, this.overunder.getSelectedIndex() == 0);
                trig.setBlockCount(this.schedule.getBlockCount());
                trig.setBlockUnit(this.schedule.getBlockUnit());
                trig.setStartTime(this.schedule.getStartTime());
                trig.setUseGMT(this.schedule.useGMT());
            } else if (newb instanceof TcpAccessibleThreshold) {
                TcpAccessibleThreshold trig = (TcpAccessibleThreshold)newb;
                trig.setTriggerOn(this.match.getTextFieldValue(), Integer.parseInt(this.threshold.getTextFieldValue()), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof WebsiteAccessibleThreshold) {
                WebsiteAccessibleThreshold trig = (WebsiteAccessibleThreshold)newb;
                trig.setTriggerOn(this.match.getTextFieldValue(), this.overunder.getSelectedIndex() == 0, this.folder.getTextFieldValue().trim());
            } else if (newb instanceof WebsiteResponseTimeThreshold) {
                WebsiteResponseTimeThreshold trig = (WebsiteResponseTimeThreshold)newb;
                trig.setTriggerOn(this.match.getTextFieldValue(), (long)(1000.0 * Double.parseDouble(this.threshold.getTextFieldValue())), this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof WindowsRegistryThreshold) {
                WindowsRegistryThreshold trig = (WindowsRegistryThreshold)newb;
                trig.setKey(this.key.getTextFieldValue());
                trig.setValueName(this.valueName.getTextFieldValue());
                trig.setValueData(this.valueData.getTextFieldValue());
                switch (this.registryModeBox.getSelectedIndex()) {
                    case 0: {
                        trig.setMode(0);
                    }
                    case 1: {
                        trig.setMode(1);
                    }
                    case 2: {
                        trig.setMode(2);
                    }
                }
                trig.setTriggerIfMatch(this.overunder.getSelectedIndex() == 0);
            } else if (newb instanceof WindowsEventLogThreshold) {
                WindowsEventLogThreshold trig = (WindowsEventLogThreshold)newb;
                trig.setLogName(this.logNameBox.getEditorValue());
                switch (this.eventTypeBox.getSelectedIndex()) {
                    case 0: {
                        trig.setEventType(0);
                        break;
                    }
                    case 1: {
                        trig.setEventType(4);
                        break;
                    }
                    case 2: {
                        trig.setEventType(2);
                        break;
                    }
                    case 3: {
                        trig.setEventType(1);
                        break;
                    }
                    case 4: {
                        trig.setEventType(8);
                        break;
                    }
                    case 5: {
                        trig.setEventType(16);
                        break;
                    }
                    default: {
                        trig.setEventType(0);
                    }
                }
                trig.setEventMessage(this.eventMessage.getTextFieldValue());
                trig.setEventUser(this.eventUser.getTextFieldValue());
                trig.setEventSource(this.eventSource.getTextFieldValue());
                trig.setEventComputer(this.eventComputer.getTextFieldValue());
                trig.setTriggerIfEventReceived(this.overunder.getSelectedIndex() == 0);
            } else {
                return null;
            }
            if (this.trigname.getTextFieldValue().trim().length() == 0) {
                newb.setUsingDefaultName(true);
                newb.setName(newb.getDefaultName());
            } else {
                newb.setUsingDefaultName(false);
                newb.setName(this.trigname.getTextFieldValue());
            }
            return newb;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public String launchDialog() {
        try {
            ArrayList available = new ArrayList();
            MachineGroup mg = (MachineGroup)this.machines.getAvailableMachinesGroup();
            Iterator it = this.machines.getDescendentElements(mg);
            ArrayList<Machine> list = new ArrayList<Machine>();
            while (it.hasNext()) {
                Machine machine = (Machine)it.next();
                if (!machine.isAvailable()) continue;
                list.add(machine);
            }
            Machine[] tmp = new Machine[list.size()];
            list.toArray(tmp);
            String result = MachineFileChooser.launchMachineFileChooser(SwingUtil.getRootPaneContainer((Component)this), tmp, this.client);
            return result;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public boolean canCreateCorollary() {
        return this.alert.canCreateCorollary();
    }

    class ConfigChangeListener
    extends MarkRedChangeListener {
        public ConfigChangeListener(CUIHorizontalPanel cui) {
            super(cui);
        }

        @Override
        public void changed(AbstractField source) {
            super.changed(source);
            if (source == TriggerConfigPanel.this.registryModeBox) {
                TriggerConfigPanel.this.updateRegistryBoxVisible();
            }
            TriggerConfigPanel.this.isValid = TriggerConfigPanel.this.cuiPanel.getInvalidFieldTypes().size() == 0;
            if (TriggerConfigPanel.this.listener != null) {
                TriggerConfigPanel.this.listener.isAcceptable(TriggerConfigPanel.this.isValid);
            }
        }
    }

    class ExampleLabel
    extends LabelField {
        public ExampleLabel(String text) {
            super(text, true);
            this.getBackingJLabel().setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        }
    }

    class ExclusionList
    extends AbstractField
    implements ListSelectionListener,
    ActionListener {
        private static final String EXCLUSION_TYPE = "exclusion_list";
        private boolean exclude;
        private JPanel rootComponent;
        private SimpleList<StringWrapper> list;
        private SHJTable table;
        private TableStructure ts;
        private SimpleTableModel model;
        private JButton add;
        private JButton remove;
        private JButton toggle;

        public ExclusionList(AbstractField.ChangeListener changeListener, String[] data) {
            super(EXCLUSION_TYPE, "", changeListener);
            this.exclude = true;
            this.rootComponent = new JPanel(new BorderLayout());
            this.list = new SimpleList();
            this.table = new SHJTable();
            this.add = new JButton(Language.get("ADD"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
            this.remove = new JButton(Language.get("DELETE_COLUMN"), ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
            this.toggle = new JButton(Language.get("INCLUDE_COLUMN"), ImageLoader.getImageIcon((String)"images/svg/general/include.svg,16"));
            if (data != null) {
                for (String s : data) {
                    this.list.add(new StringWrapper(s));
                }
            }
            this.initUI();
            this.setExclude(this.exclude);
            SwingUtil.setHeight((JComponent)this.rootComponent, (int)SimpleHelpLookAndFeel.scale((int)100));
        }

        public boolean isExclude() {
            return this.exclude;
        }

        public void setExclude(boolean exclude) {
            this.exclude = exclude;
            if (exclude) {
                this.toggle.setText(Language.get("INCLUDE_COLUMN"));
                this.toggle.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/include.svg,16"));
                this.setLabelText(Language.get("IGNORE_DRIVE_NAMES"));
            } else {
                this.toggle.setText(Language.get("EXCLUDE_COLUMN"));
                this.toggle.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/exclude.svg,16"));
                this.setLabelText(Language.get("INCLUDE_DRIVE_NAMES"));
            }
        }

        public void initUI() {
            this.ts = TableStructure.createTableStructure(StringWrapper.class, new String[]{"content"}, new String[]{""}, new int[]{100}, new boolean[]{true});
            this.model = new SimpleTableModel(this.list, this.ts);
            this.table = new SHJTable(this.model);
            this.table.setTableHeader(null);
            this.table.getSelectionModel().addListSelectionListener(this);
            JScrollPane pane = new JScrollPane(this.table);
            this.rootComponent.add((Component)pane, "Center");
            GbPanel right = new GbPanel(new ScaledInsets(0, 5, 5, 0));
            right.add((Component)this.add, 0, 0, 1, 1, 1, 0, 10, 2);
            right.add((Component)this.remove, 0, 1, 1, 1, 1, 0, 10, 2);
            right.add((Component)this.toggle, 0, 2, 1, 1, 1, 0, 10, 2);
            right.add((Component)new JPanel(), 0, 3, 1, 1, 1, 1, 10, 2);
            this.rootComponent.add((Component)right, "East");
            this.add.setHorizontalAlignment(2);
            this.remove.setHorizontalAlignment(2);
            this.toggle.setHorizontalAlignment(2);
            this.add.addActionListener(this);
            this.remove.addActionListener(this);
            this.toggle.addActionListener(this);
            this.updateEnabled();
        }

        public String[] getIncludeExemptionList() {
            String[] result = new String[this.list.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.list.get((int)i).content;
            }
            return result;
        }

        public void updateEnabled() {
            if (this.table.getSelectedRows().length > 0) {
                this.remove.setEnabled(true);
            } else {
                this.remove.setEnabled(false);
            }
        }

        public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
            return null;
        }

        public ResultPair getStorableFilledOutData() {
            return null;
        }

        public void setStorableFilledOutData(ResultPair storableFilledOutData) {
        }

        public void clearContents() {
        }

        public JComponent getComponent() {
            return this.rootComponent;
        }

        protected void toXML(StringBuffer buffer, int tabs) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.add) {
                this.list.add(new StringWrapper("Example filter"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int last = ExclusionList.this.list.size();
                        ExclusionList.this.table.getSelectionModel().setSelectionInterval(last - 1, last - 1);
                        ExclusionList.this.table.editCellAt(last - 1, 0);
                    }
                });
            } else if (e.getSource() == this.remove) {
                int[] rows = this.table.getSelectedRows();
                Arrays.sort(rows);
                this.list.startBatch();
                try {
                    for (int i = rows.length - 1; i >= 0; --i) {
                        int row = rows[i];
                        this.list.remove(row);
                    }
                }
                finally {
                    this.list.endBatch();
                }
            } else if (e.getSource() == this.toggle) {
                this.setExclude(!this.exclude);
            }
        }
    }

    class StringWrapper {
        String content;

        public StringWrapper(String s) {
            this.content = s;
        }

        public String toString() {
            return this.content;
        }
    }

    class TextFieldWithComboUnits
    extends AbstractField {
        private static final String EXCLUSION_TYPE = "tf_with_units";
        private JPanel rootComponent;
        private TextField textField;
        private JComboBox box;

        public TextFieldWithComboUnits(String label, AbstractField.ChangeListener changeListener, String text, int index, String[] options) {
            super(EXCLUSION_TYPE, label, changeListener);
            this.rootComponent = new JPanel(new BorderLayout());
            this.textField = new TextField(null, changeListener, 2);
            this.textField.setDefaultValue(text);
            this.textField.setExampleValue("10");
            this.box = new JComboBox<String>(options);
            this.box.setSelectedIndex(index);
            this.rootComponent.add((Component)this.textField.getComponent(), "Center");
            this.rootComponent.add((Component)this.box, "East");
        }

        public String getText() {
            return ((JTextField)this.textField.getComponent()).getText();
        }

        public int getSelectedIndex() {
            return this.box.getSelectedIndex();
        }

        public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
            return null;
        }

        public ResultPair getStorableFilledOutData() {
            return null;
        }

        public void setStorableFilledOutData(ResultPair storableFilledOutData) {
        }

        public void clearContents() {
        }

        public JComponent getComponent() {
            return this.rootComponent;
        }

        protected void toXML(StringBuffer buffer, int tabs) {
        }
    }

    class ToolPickerDialog
    implements CUIPopulateDialog {
        TextField entry;
        JButton button;

        ToolPickerDialog() {
        }

        public String launchDialog() {
            final PickToolPopup toolPopup = new PickToolPopup(1, new int[]{0, 1, 2}){

                @Override
                protected void pickedTool(ToolBoxItem pickedItem) {
                    TriggerConfigPanel.this.pickedToolDef = pickedItem;
                    ToolPickerDialog.this.entry.setDefaultValue(pickedItem.getName());
                    ToolPickerDialog.this.entry.fireChangeListener();
                }
            };
            new Thread(){

                @Override
                public void run() {
                    try {
                        final ToolBox toolBox = TriggerConfigPanel.this.client.fetchToolBox();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                toolPopup.show(toolBox, ToolPickerDialog.this.button);
                            }
                        });
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }.start();
            return null;
        }
    }
}

