/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.contents.table;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.dnd.AlertTransferable;
import com.aem.shelp.tech.access.dnd.TransferEntry;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertGroupPanel;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertLiveInfoProvider;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertTableRenderer;
import com.aem.shelp.tech.alerts.alerts.model.AlertModelChangeListener;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.ui.SelectionUtil;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.renderers.BorderedTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class AlertTable
implements AlertModelChangeListener {
    private SimpleTableModel model;
    private SHJTable table;
    private AlertPanelListener accessPanelListener;
    private ResourceContainerGroup group;
    private SimpleList<ResourceContainer> alertList;
    private AlertGroupPanel tableGroupPanel;
    private AlertLiveInfoProvider alertInfo;

    public AlertTable(AlertTreeModel model, ResourceContainerGroup group, AlertPanelListener accessPanelListener, AlertGroupPanel tableGroupPanel, AlertLiveInfoProvider alertInfo) {
        this.accessPanelListener = accessPanelListener;
        this.alertList = group.getElements();
        this.tableGroupPanel = tableGroupPanel;
        this.group = group;
        this.alertInfo = alertInfo;
        this.initUI();
        this.table.setDragEnabled(true);
        this.table.setTransferHandler(new AlertTableTransferHandler());
    }

    public SHJTable getRootComponent() {
        return this.table;
    }

    private void initUI() {
        TableStructure ts = TableStructure.createTableStructure(Alert.class, new String[]{""}, new String[]{Language.get("ALERT_NAME")});
        this.model = new SimpleTableModel(this.alertList, ts);
        this.table = new SHJTable(this.model){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                SelectionUtil<ResourceContainerGroup, ResourceContainer> model = AlertTable.this.tableGroupPanel.getGroupsList().getSelectionModel();
                model.changeSelection(AlertTable.this.tableGroupPanel, rowIndex, toggle, extend);
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean result = super.processKeyBinding(ks, e, condition, pressed);
                if (result) {
                    Object binding;
                    InputMap map = this.getInputMap(condition);
                    ActionMap am = this.getActionMap();
                    if (map != null && am != null && this.isEnabled() && (binding = map.get(ks)).equals("selectAll")) {
                        AlertTable.this.tableGroupPanel.getGroupsList().selectAllExceptIn(AlertTable.this.tableGroupPanel);
                    }
                }
                return result;
            }
        };
        this.table.getSelectionModel().addListSelectionListener(new AlertSelectionListener());
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.table.setDefaultRenderer(Object.class, new BorderedTableCellRendererWrapper(new AlertTableRenderer(this.tableGroupPanel, this.alertInfo), SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)0)));
    }

    public void groupsRemoved(ResourceContainerGroup parentGroup, ResourceContainerGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void machinesChanged(ResourceContainerGroup parent, ResourceContainer[] inserted, ResourceContainer[] removed, ResourceContainer[] updated, Machine.MachineChanges updateResults) {
    }

    public boolean isEmpty() {
        return this.alertList.size() == 0;
    }

    public static Alert[] getSelectedAlerts(JTable table) {
        int[] selectedRows = table.getSelectedRows();
        ArrayList<Alert> selectedAlerts = new ArrayList<Alert>();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object selection = table.getValueAt(i, 0);
            if (!(selection instanceof Alert)) continue;
            selectedAlerts.add((Alert)selection);
        }
        return selectedAlerts.toArray(new Alert[0]);
    }

    public LocatedAlert[] getSelectedAlerts() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<LocatedAlert> selectedAlerts = new ArrayList<LocatedAlert>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            int alertListSize = this.alertList.size();
            try {
                ResourceContainer selection = this.alertList.get(selectedRow);
                if (!(selection instanceof LocatedAlert)) continue;
                selectedAlerts.add((LocatedAlert)selection);
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
                System.out.println("Selected row = " + selectedRow);
                System.out.println("AlertListSize = " + alertListSize + " vs " + this.alertList.size());
            }
        }
        return selectedAlerts.toArray(new LocatedAlert[0]);
    }

    @Override
    public void filterProcessorChanged() {
    }

    public void select(ResourceContainer alert) {
        int index = this.alertList.indexOf(alert);
        this.table.getSelectionModel().setSelectionInterval(index, index);
    }

    class AlertSelectionListener
    implements ListSelectionListener {
        AlertSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            AlertTable.this.tableGroupPanel.getGroupsList().notifySelectionChange();
        }
    }

    class AlertTableTransferHandler
    extends TransferHandler {
        AlertTableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            TreeElement[] selectedAlerts = AlertTable.this.getSelectedAlerts();
            TransferEntry entry = new TransferEntry((TreeGroup)AlertTable.this.group, selectedAlerts);
            return new AlertTransferable(new TransferEntry[]{entry});
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }
    }
}

