/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.alertlocs.AllMachinesAloc;
import com.aem.shelp.proxy.types.alerts.BasicAlert;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.ContentsMetrics;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertTableGroupList;
import com.aem.shelp.tech.alerts.alerts.model.AlertModelChangeListener;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.alerts.alerts.model.FilterAlertResultsGroup;
import com.aem.shelp.tech.alerts.alerts.model.filters.TextAlertFilter;
import com.aem.shelp.tech.alerts.alerts.utils.AlertSelection;
import com.aem.shelp.tech.alerts.alerts.utils.LocatedAlertSelection;
import com.aem.shelp.tech.alerts.events.AlertContentsPanelInterface;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import utils.swing.SwingUtil;
import utils.swing.components.JIconTextField;
import utils.swing.components.JSearchTextField;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AlertContentsPanel
implements MessageFieldHandler.FilterListener,
AlertModelChangeListener,
ActionListener,
AlertContentsPanelInterface {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private AlertTableGroupList currentContentsPanel;
    private AlertTableGroupList alertsTableGroupList;
    private CardLayout contentsCardLayout;
    private AlertPanelListener alertPanelListener;
    private AlertTreeModel alertModel;
    private JPanel cardPanel;
    private GbPanel buttonPanel;
    private FilterSetter delayedFilterSetter = null;
    private Object setFilterLock = new Object();
    private ButtonListener buttonListener = new ButtonListener();
    private JToggleButton toggleDetailsButton;
    private JButton newAlertButton;
    private boolean isTableSelected = true;
    private JSearchTextField filterField;
    private ResourceContainerGroup resultsGroup;
    private TextAlertFilter searchFilter;
    private ResourceContainerGroup[] selectedGroups;
    private boolean isDetailsPanelVisible = true;
    private AlertSelection selection;
    private TechClient client;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public AlertContentsPanel(AlertTreeModel machineInterface, AlertPanelListener listener) {
        this.alertPanelListener = listener;
        this.alertModel = machineInterface;
        this.initUI();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
        this.alertsTableGroupList.setAlertLiveInfoProvider(client);
        this.newAlertButton.setVisible(client.getTechUser().getPermissions().canManageAlerts());
        this.newAlertButton.repaint();
    }

    @Override
    public void setDetailsPanelIsShowing(boolean isDetailsPanelVisible) {
        this.isDetailsPanelVisible = isDetailsPanelVisible;
        this.toggleDetailsButton.setSelected(isDetailsPanelVisible);
        this.setDetailsButtonTooltip();
    }

    public void setDetailsButtonTooltip() {
        if (this.toggleDetailsButton.isSelected()) {
            this.toggleDetailsButton.setToolTipText(Language.get("HIDE_DETAILS_TOOLTIP"));
        } else {
            this.toggleDetailsButton.setToolTipText(Language.get("SHOW_DETAILS_TOOLTIP"));
        }
    }

    @Override
    public void updateUIWithMetrics(ContentsMetrics metrics) {
    }

    private void initUI() {
        this.resultsGroup = FilterAlertResultsGroup.newResultsGroup(Language.get("SEARCH_RESULTS"));
        this.searchFilter = new TextAlertFilter(this.resultsGroup);
        this.alertsTableGroupList = new AlertTableGroupList(this.alertPanelListener);
        this.alertModel.addModelChangeListener(this.alertsTableGroupList);
        this.contentsCardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.contentsCardLayout);
        this.cardPanel.add((Component)this.alertsTableGroupList.getRootComponent(), "TABLE");
        this.currentContentsPanel = this.alertsTableGroupList;
        this.initButtonPanel();
        this.rootComponent.add((Component)this.cardPanel, "Center");
        this.rootComponent.add((Component)this.buttonPanel, "North");
        this.newAlertButton.addActionListener(this.buttonListener);
        this.toggleDetailsButton.addActionListener(this.buttonListener);
        this.alertsTableGroupList.initUI(this.alertModel, this.alertModel.getRootGroups());
        this.setSelectedAlerts(LocatedAlertSelection.EMPTY);
    }

    private void initButtonPanel() {
        this.buttonPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.buttonPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        MatteBorder outer = SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP);
        Border inner = SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2);
        this.buttonPanel.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)outer, (Border)inner));
        this.newAlertButton = new JButton(Language.get("NEW_ALERT")){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width, ((AlertContentsPanel)AlertContentsPanel.this).toggleDetailsButton.getSize().height);
            }
        };
        this.toggleDetailsButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/dialogs/information-square-green.svg,16"));
        this.setDetailsButtonTooltip();
        this.toggleDetailsButton.setSelected(true);
        this.isTableSelected = true;
        this.updateSelectedView();
        this.filterField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.filterField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.filterField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.filterField.setFilterListener(this);
        this.filterField.addIconClickListener(new JIconTextField.IconClickListener(){

            @Override
            public void iconClicked(String id) {
                if (id.equals("SEARCH") && AlertContentsPanel.this.filterField.getText().length() > 0) {
                    ResourceContainerGroup groupToSave = AlertContentsPanel.this.resultsGroup;
                    AlertContentsPanel.this.resultsGroup = FilterAlertResultsGroup.newResultsGroup(Language.get("SEARCH_RESULTS"));
                    AlertContentsPanel.this.alertModel.moveGroupToFinalChild(groupToSave);
                    AlertContentsPanel.this.alertModel.renameGroup(groupToSave, AlertContentsPanel.this.filterField.getText().trim());
                    if (groupToSave instanceof FilterAlertResultsGroup) {
                        ((FilterAlertResultsGroup)groupToSave).setTemporary(false);
                    }
                    AlertContentsPanel.this.filterField.setText(null);
                    AlertContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), "SEARCH");
                    AlertContentsPanel.this.filterField.repaint();
                    AlertContentsPanel.this.alertPanelListener.renameSelectedNode(groupToSave);
                    AlertContentsPanel.this.alertModel.notifyFilterProcessorChange();
                }
            }
        });
        this.filterField.setSize(SimpleHelpLookAndFeel.scale((int)250), SimpleHelpLookAndFeel.scale((int)26));
        this.filterField.setPreferredSize(this.filterField.getSize());
        SwingUtil.setWidth((JComponent)this.filterField, (int)this.filterField.getSize().width);
        int X = 0;
        this.buttonPanel.add((Component)this.toggleDetailsButton, X++, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.buttonPanel.add((Component)this.newAlertButton, X++, 0, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 5, 3, 3));
        this.buttonPanel.add((Component)this.filterField, X++, 0, 1, 1, 1, 1, 13, 0, (Insets)new ScaledInsets(2, 0, 2, 3));
    }

    @Override
    public void setSelectedGroups(ResourceContainerGroup[] selectedGroups) {
        if (Arrays.equals(selectedGroups, this.selectedGroups)) {
            return;
        }
        this.selectedGroups = selectedGroups;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlertContentsPanel.this.currentContentsPanel.initUI(AlertContentsPanel.this.alertModel, AlertContentsPanel.this.selectedGroups);
            }
        });
    }

    @Override
    public void setSelectedGroup(ResourceContainerGroup selectedGroup) {
        this.setSelectedGroups(new ResourceContainerGroup[]{selectedGroup});
    }

    public void updateSelectedView() {
        this.currentContentsPanel.setVisible(false);
        this.contentsCardLayout.show(this.cardPanel, "TABLE");
        this.currentContentsPanel = this.alertsTableGroupList;
        this.currentContentsPanel.initUI(this.alertModel, this.selectedGroups);
        this.currentContentsPanel.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String filter, boolean immediately) {
        Object object = this.setFilterLock;
        synchronized (object) {
            if (this.delayedFilterSetter != null) {
                this.delayedFilterSetter.setFilter(filter, immediately);
            } else {
                this.delayedFilterSetter = new FilterSetter(filter, immediately);
            }
        }
    }

    public void clearSearchResults() {
        TreeGroup[] groupsIn = (ResourceContainerGroup[])this.alertModel.getGroupsIn(this.resultsGroup);
        if (groupsIn != null) {
            this.alertModel.removeGroups(groupsIn);
        }
    }

    public void groupsRemoved(ResourceContainerGroup parentGroup, ResourceContainerGroup[] removedChildren, int[] removedIndices) {
        if (this.isSelectedGroup(parentGroup)) {
            this.setSelectedGroups(this.selectedGroups);
        }
    }

    public void groupsAdded(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
        if (this.isSelectedGroup(parentGroup)) {
            this.setSelectedGroups(this.selectedGroups);
        }
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    private boolean isSelectedGroup(ResourceContainerGroup group) {
        if (this.selectedGroups == null || group == null) {
            return false;
        }
        for (ResourceContainerGroup selectedGroup : this.selectedGroups) {
            if (selectedGroup.equals(group)) {
                return true;
            }
            if (!this.isSelectedGroup((ResourceContainerGroup)group.getParent())) continue;
            return true;
        }
        return false;
    }

    public void machinesChanged(ResourceContainerGroup parent, ResourceContainer[] inserted, ResourceContainer[] removed, ResourceContainer[] updated, Machine.MachineChanges updateResults) {
    }

    @Override
    public void setSelectedAlerts(AlertSelection selection) {
        this.selection = selection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void filterProcessorChanged() {
    }

    @Override
    public boolean isAlertSelected(ResourceContainer alert) {
        return this.selection.getMachineCount() == 1 && ((ResourceContainer[])this.selection.getAllElements())[0].equals(alert);
    }

    @Override
    public void ensureAlertIsSelected(ResourceContainerGroup group, ResourceContainer machine) {
        this.alertPanelListener.setSelectedGroup(null, group);
        this.currentContentsPanel.ensureMachineIsSelected(group, machine);
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == AlertContentsPanel.this.newAlertButton) {
                if (!AlertContentsPanel.this.client.allowsAlerts() && !TrialUtils.amTriallingBizOrEnt()) {
                    TrialUtils.alertsDisallowedPopup(SwingUtil.getRootPaneContainer((Component)AlertContentsPanel.this.rootComponent), AlertContentsPanel.this.rootComponent, AlertContentsPanel.this.client);
                } else {
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            LocatedAlert alert = new LocatedAlert(new BasicAlert());
                            alert.setLocation(new AllMachinesAloc(), null);
                            MachineName name = new MachineName(Language.get("ALERT_NEW_NAME"));
                            alert.setName(name);
                            ResourceContainerGroup alertGroup = (ResourceContainerGroup)AlertContentsPanel.this.alertModel.getAvailableMachinesGroup();
                            if (AlertContentsPanel.this.selectedGroups != null) {
                                alertGroup = AlertContentsPanel.this.selectedGroups[0];
                                String[] path = AlertContentsPanel.this.alertModel.getGroupPath(alertGroup);
                                name.setGroup(path);
                            }
                            AlertContentsPanel.this.alertModel.addElements(new LocatedAlert[]{alert});
                            LocatedAlertSelection selection = new LocatedAlertSelection();
                            selection.addMachines(alertGroup, new ResourceContainer[]{alert});
                            AlertContentsPanel.this.alertPanelListener.setSelectedElements(this, selection, true);
                            AlertContentsPanel.this.alertPanelListener.ensureElementSelected(alertGroup, alert);
                            AlertContentsPanel.this.alertPanelListener.alertCreated(alert);
                        }
                    };
                    new Thread(task).start();
                }
            } else if (source == AlertContentsPanel.this.toggleDetailsButton) {
                boolean shouldShowDetails = AlertContentsPanel.this.toggleDetailsButton.isSelected();
                AlertContentsPanel.this.alertPanelListener.setDetailsPanelVisiblity(shouldShowDetails);
            }
        }
    }

    class FilterSetter
    extends Thread {
        private long endTime;
        private String filter;

        public FilterSetter(String filter, boolean immediately) {
            super("FilterSetter");
            this.setFilter(filter, immediately);
            this.start();
        }

        public void setEndTime(long time) {
            this.endTime = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFilter(String filter, boolean immediately) {
            Object object = AlertContentsPanel.this.setFilterLock;
            synchronized (object) {
                this.filter = filter;
                this.endTime = !immediately ? System.currentTimeMillis() + 500L : System.currentTimeMillis();
                AlertContentsPanel.this.setFilterLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AlertContentsPanel.this.setFilterLock;
            synchronized (object) {
                while (System.currentTimeMillis() < this.endTime) {
                    try {
                        AlertContentsPanel.this.setFilterLock.wait(this.endTime - System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                AlertContentsPanel.this.clearSearchResults();
                String[] newFilter = null;
                if (this.filter != null && this.filter.trim().length() != 0) {
                    newFilter = this.filter.toLowerCase().split("\\s+");
                    for (int i = 0; i < newFilter.length; ++i) {
                        newFilter[i] = newFilter[i].trim();
                    }
                }
                if (newFilter == null) {
                    AlertContentsPanel.this.alertModel.removeFilter(AlertContentsPanel.this.resultsGroup);
                    AlertContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), "SEARCH");
                    AlertContentsPanel.this.filterField.repaint();
                    AlertContentsPanel.this.delayedFilterSetter = null;
                    return;
                }
                final String[] finalFilter = newFilter;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertContentsPanel.this.filterField.changeIcon(ImageLoader.getImageIcon((String)"images/svg/general/star.svg,16"), "SEARCH");
                        AlertContentsPanel.this.filterField.repaint();
                        AlertContentsPanel.this.alertModel.removeAllGroupsAndMachines(AlertContentsPanel.this.resultsGroup);
                        AlertContentsPanel.this.searchFilter.setRoot(AlertContentsPanel.this.resultsGroup);
                        AlertContentsPanel.this.searchFilter.setConjunctionFilters(finalFilter);
                        AlertContentsPanel.this.alertModel.addFilterProcessor(AlertContentsPanel.this.searchFilter, AlertContentsPanel.this.resultsGroup, true);
                        AlertContentsPanel.this.alertPanelListener.setSelectedGroups(AlertContentsPanel.this, new ResourceContainerGroup[]{AlertContentsPanel.this.resultsGroup});
                        AlertContentsPanel.this.currentContentsPanel.initUI(AlertContentsPanel.this.alertModel, AlertContentsPanel.this.selectedGroups);
                    }
                });
                AlertContentsPanel.this.delayedFilterSetter = null;
            }
        }
    }
}

