/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.sessions;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.logging.SimpleHelpEventRepository;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;

public class AdminSessionSummary
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private JCheckBox techCommentsBox;
    private JCheckBox sendEmailToCustomerBox;
    private JComboBox custEmailAddress;
    private JCheckBox allowSkip;
    private JWrapLabel emailWarningLabel;
    private boolean isEmailEnabled;

    @Override
    protected void initUI() {
        this.initSessionPanel(this.rootComponent);
    }

    private void initSessionPanel(JPanel sessionPanel) {
        this.emailWarningLabel = new JWrapLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), "<html>" + Language.get("EMAIL_WARNING_LABEL") + "</html>");
        sessionPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_SUMMARY_DESC2") + "</html>");
        this.techCommentsBox = new JCheckBox(Language.get("ADMIN_SUMMARY_TECH_COMMENTS"));
        ColorPropagatingPanel panel = new ColorPropagatingPanel();
        panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        GridBagLayout gbl2 = new GridBagLayout();
        panel.setLayout((LayoutManager)gbl2);
        this.sendEmailToCustomerBox = new JCheckBox(Language.get("ADMIN_SUMMARY_CUST_EMAIL"));
        this.custEmailAddress = new JComboBox();
        this.custEmailAddress.setEditable(false);
        int Y = 0;
        gbl2.setConstraints(this.sendEmailToCustomerBox, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.custEmailAddress, new GridBagConstraints(1, Y++, 1, 1, 100.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints((Component)this.emailWarningLabel, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        panel.add((Component)this.techCommentsBox);
        panel.add((Component)this.sendEmailToCustomerBox);
        panel.add((Component)this.custEmailAddress);
        panel.add((Component)this.emailWarningLabel);
        RoundBorderPanel configPanel = new RoundBorderPanel(Language.get("ADMIN_SUMMARY_CONFIG_TITLE"));
        GridBagLayout gbl = new GridBagLayout();
        configPanel.setLayout(gbl);
        this.allowSkip = new JCheckBox(Language.get("ADMIN_SUMMARY_ALLOW_SKIP"));
        int Y2 = 0;
        gbl.setConstraints(this.techCommentsBox, new GridBagConstraints(0, Y2++, 2, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl.setConstraints(this.allowSkip, new GridBagConstraints(0, Y2++, 2, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl.setConstraints((Component)panel, new GridBagConstraints(0, Y2++, 2, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        ((Container)configPanel).add(this.techCommentsBox);
        ((Container)configPanel).add((Component)panel);
        ((Container)configPanel).add(this.allowSkip);
        JPanel paddy = new JPanel();
        GridBagLayout gbl3 = new GridBagLayout();
        sessionPanel.setLayout(gbl3);
        int Y3 = 0;
        gbl3.setConstraints((Component)desc, new GridBagConstraints(0, Y3++, 1, 1, 1.0, 1.0, 13, 2, (Insets)new ScaledInsets(0, 0, 10, 0), 0, 0));
        gbl3.setConstraints(configPanel, new GridBagConstraints(0, Y3++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 10, 0), 0, 0));
        gbl3.setConstraints(paddy, new GridBagConstraints(0, Y3++, 1, 1, 1.0, 1000.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        sessionPanel.add((Component)desc);
        sessionPanel.add(configPanel);
        sessionPanel.add(paddy);
        this.allowSkip.addActionListener(this.validateListener);
        this.techCommentsBox.addActionListener(this.validateListener);
        this.sendEmailToCustomerBox.addActionListener(this.validateListener);
        this.custEmailAddress.addActionListener(this.validateListener);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_NOTIFY_SESSION_TAB");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.allowSkip.setSelected(config.sessionSummaryAllowSkip);
        this.techCommentsBox.setSelected(config.sessionSummaryTechComment);
        this.sendEmailToCustomerBox.setSelected(config.sessionSummaryCustEmail);
        this.custEmailAddress.setSelectedItem(config.sessionSummaryEmailCustDetail);
        this.isEmailEnabled = config.emailSettingsEnabled;
        this.setDetails(config.getDetails());
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.sessionSummaryAllowSkip = this.allowSkip.isSelected();
        config.sessionSummaryTechComment = this.techCommentsBox.isSelected();
        config.sessionSummaryCustEmail = this.sendEmailToCustomerBox.isSelected();
        if (this.custEmailAddress.getSelectedItem() != null) {
            config.sessionSummaryEmailCustDetail = this.custEmailAddress.getSelectedItem().toString();
        }
    }

    @Override
    public void checkEnabled() {
        this.emailWarningLabel.setVisible(!this.isEmailEnabled);
        this.sendEmailToCustomerBox.setEnabled(this.isEmailEnabled);
        this.custEmailAddress.setEnabled(this.isEmailEnabled && this.sendEmailToCustomerBox.isSelected());
        this.allowSkip.setEnabled(true);
        this.techCommentsBox.setEnabled(true);
    }

    @Override
    public void saveComplete(ServerConfig config) {
        this.isEmailEnabled = config.emailSettingsEnabled;
        this.checkEnabled();
    }

    public void setDetailsLabels(String[] detailLabels) {
        String[] newDetails = new String[detailLabels.length];
        for (int i = 0; i < detailLabels.length; ++i) {
            newDetails[i] = detailLabels[i].trim();
        }
        Object selected = this.custEmailAddress.getSelectedItem();
        this.custEmailAddress.setModel(new DefaultComboBoxModel<String>(newDetails));
        if (selected != null) {
            this.custEmailAddress.setSelectedItem(selected);
            if (this.custEmailAddress.getSelectedIndex() == -1) {
                this.custEmailAddress.setSelectedIndex(0);
            }
        } else if (newDetails.length > 0) {
            this.custEmailAddress.setSelectedIndex(0);
        }
        SimpleHelpLogEvent.setCustomerDetails(newDetails);
        ((SimpleHelpEventRepository)SimpleHelpEventRepository.INSTANCE).setCustomerDetailsLabels(newDetails);
    }

    private void setDetails(CUIField[] fields) {
        if (fields != null) {
            String[] labels = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                labels[i] = fields[i].getLabel();
            }
            this.setDetailsLabels(labels);
        }
    }
}

