/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.sessions;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.ui.FieldListUI;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminCustomerDetails
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    public static AdminCustomerDetails INSTANCE = null;
    private ValidationKeyListener keyListener;
    private FieldListUI detailsList;
    private JTextField widthTextField;
    private JTextField heightTextField;
    private JLabel detailsSizelabel;
    private JLabel xLabel;
    private JLabel pixelsLabel;
    private JCheckBox fixSizeBox;
    private boolean skipSave = false;

    public AdminCustomerDetails() {
        INSTANCE = this;
    }

    private void initDetailsPanel(JPanel detailsTab) {
        this.keyListener = new ValidationKeyListener(this);
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)detailsTab, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.detailsList = new FieldListUI(Language.DEFLANG, (SwingStyleInterface)SHStyle.INSTANCE, new AbstractField.ChangeListener(){

            public void changed(AbstractField source) {
                AdminCustomerDetails.this.contentChanged(AdminCustomerDetails.this.checkIfValid());
                if (!AdminCustomerDetails.this.skipSave) {
                    AdminCustomerDetails.this.saveListener.detailsChanged();
                }
            }
        });
        this.detailsList.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.detailsList.getRootComponent().setBorder(SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR));
        this.detailsSizelabel = new JLabel(Language.get("DETAILS_DIALOG_SIZE"));
        this.pixelsLabel = new JLabel(Language.get("PIXELS") + ".");
        this.xLabel = new JLabel("x");
        TextField widthField = new TextField("", null, 1);
        TextField heightField = new TextField("", null, 1);
        widthField.setLengthConstraints(3, 1);
        heightField.setLengthConstraints(3, 1);
        this.widthTextField = (JTextField)widthField.getComponent();
        this.heightTextField = (JTextField)heightField.getComponent();
        SwingUtil.setWidth((JComponent)this.widthTextField, (int)SimpleHelpLookAndFeel.scale((int)40));
        SwingUtil.setWidth((JComponent)this.heightTextField, (int)SimpleHelpLookAndFeel.scale((int)40));
        this.fixSizeBox = new JCheckBox();
        this.fixSizeBox.addActionListener(this.keyListener);
        GbPanel configurationPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        configurationPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        int X = 0;
        configurationPanel.add((Component)this.fixSizeBox, X++, 0, 1, 1, 0, 1, 17, 0);
        configurationPanel.add((Component)this.detailsSizelabel, X++, 0, 1, 1, 0, 1, 17, 0);
        configurationPanel.add((Component)this.widthTextField, X++, 0, 1, 1, 0, 1, 10, 0);
        configurationPanel.add((Component)this.xLabel, X++, 0, 1, 1, 0, 1, 17, 0);
        configurationPanel.add((Component)this.heightTextField, X++, 0, 1, 1, 0, 1, 10, 0);
        configurationPanel.add((Component)this.pixelsLabel, X++, 0, 1, 1, 0, 1, 17, 0);
        JScrollPane pane = new JScrollPane((Component)this.detailsList.getRootComponent());
        pane.setBorder(null);
        SwingUtil.setHeight((JComponent)pane, (int)SimpleHelpLookAndFeel.scale((int)250));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_DETAILS_DESC") + "</html>");
        int Y = 0;
        wrapper.add((Component)desc, 0, Y++, 1, 1, 1, 1, 17, 2);
        wrapper.add((Component)pane, 0, Y++, 1, 1, 1, 1, 11, 2);
    }

    @Override
    protected void initUI() {
        this.initDetailsPanel(this.rootComponent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_DETAILS_TAB");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        CUIField[] fields = config.getDetails();
        try {
            this.skipSave = true;
            if (fields != null) {
                this.detailsList.initUIForList(fields);
            } else {
                this.detailsList.initUIForList(new CUIField[0]);
            }
        }
        finally {
            this.skipSave = false;
        }
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.setDetails(this.detailsList.getFields());
    }

    @Override
    public void checkEnabled() {
        this.widthTextField.setEnabled(this.fixSizeBox.isSelected());
        this.heightTextField.setEnabled(this.fixSizeBox.isSelected());
        this.detailsSizelabel.setEnabled(this.fixSizeBox.isSelected());
        this.xLabel.setEnabled(this.fixSizeBox.isSelected());
        this.pixelsLabel.setEnabled(this.fixSizeBox.isSelected());
    }
}

