/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.swing.ExampleLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanelWrapper;

public class AdminHostname
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private JTextField hostnameField;
    private ValidationKeyListener validationListener;

    @Override
    public ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (this.hostnameField.getText().length() == 0 || !this.isValidHostname(this.hostnameField.getText())) {
            list.add(this.hostnameField);
        } else {
            this.hostnameField.setBorder(this.defaultTextFieldBorder);
        }
        return list;
    }

    private boolean isValidHostname(String text) {
        return text.indexOf(32) == -1;
    }

    @Override
    protected void initUI() {
        this.validationListener = new ValidationKeyListener(this);
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.rootComponent);
        JWrapLabel wrapLabel = new JWrapLabel(Language.get("SERVER_HOSTNAME_DESC"));
        this.hostnameField = new JTextField();
        SwingUtil.setWidth((JComponent)this.hostnameField, (int)SimpleHelpLookAndFeel.scale((int)300));
        this.hostnameField.addKeyListener(this.validationListener);
        ExampleLabel exampleLabel = new ExampleLabel(Language.get("EXAMPLE") + ": support.yourcompany.com, www.yourserver.com:443");
        wrapper.add((Component)wrapLabel, 0, 0, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0));
        wrapper.add((Component)this.hostnameField, 0, 1, 1, 1, 0, 1, 17, 2);
        wrapper.add((Component)exampleLabel, 1, 1, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 10, 0, 0));
    }

    @Override
    public String getTitle() {
        return Language.get("SERVER_HOSTNAME_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.hostnameField.setText(config.hostname);
    }

    @Override
    public void saveTo(ServerConfig config) {
        String hostname = this.hostnameField.getText().trim();
        if (hostname.contains("://")) {
            hostname = hostname.substring(hostname.indexOf("://") + 3);
        }
        config.hostname = hostname;
    }

    @Override
    public void checkEnabled() {
    }
}

