/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.ScaledInsets;

public class AdminFeatures
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    ValidationKeyListener checkBoxListener = new ValidationKeyListener(this);
    private JCheckBox remoteAccessBox;
    private JCheckBox remoteSupportBox;
    private JCheckBox presentationBox;
    private JCheckBox mobileAccessBox;

    @Override
    protected void initUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.rootComponent.setLayout(gbl);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("ADMIN_SERVER_FEATURES_DESC") + "</html>");
        this.remoteAccessBox = new JCheckBox(Language.get("ADMIN_FEATURE_ACCESS"));
        this.remoteSupportBox = new JCheckBox(Language.get("ADMIN_FEATURE_SUPPORT"));
        this.presentationBox = new JCheckBox(Language.get("ADMIN_FEATURE_PRESENTATION"));
        this.mobileAccessBox = new JCheckBox(Language.get("ADMIN_FEATURE_MOBILE"));
        this.remoteAccessBox.addActionListener(this.checkBoxListener);
        this.remoteSupportBox.addActionListener(this.checkBoxListener);
        this.presentationBox.addActionListener(this.checkBoxListener);
        this.mobileAccessBox.addActionListener(this.checkBoxListener);
        int Y = 0;
        gbl.setConstraints((Component)descriptionLabel, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
        this.rootComponent.add((Component)descriptionLabel);
        gbl.setConstraints(this.remoteSupportBox, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
        this.rootComponent.add(this.remoteSupportBox);
        gbl.setConstraints(this.remoteAccessBox, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
        this.rootComponent.add(this.remoteAccessBox);
        if (OemBranding.OEM_IS_SH) {
            gbl.setConstraints(this.presentationBox, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
            this.rootComponent.add(this.presentationBox);
        }
        gbl.setConstraints(this.mobileAccessBox, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
        this.rootComponent.add(this.mobileAccessBox);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_CORE_FEATURES");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.remoteAccessBox.setSelected(config.enabledRemoteAccess);
        this.remoteSupportBox.setSelected(config.enabledRemoteSupport);
        this.presentationBox.setSelected(config.enabledPresentation);
        this.mobileAccessBox.setSelected(config.enabledMobileAccess);
    }

    @Override
    public void saveTo(ServerConfig config) {
        if (this.remoteSupportBox.isEnabled()) {
            config.enabledRemoteSupport = this.remoteSupportBox.isSelected();
        }
        if (this.remoteAccessBox.isEnabled()) {
            config.enabledRemoteAccess = this.remoteAccessBox.isSelected();
        }
        if (this.presentationBox.isEnabled()) {
            config.enabledPresentation = this.presentationBox.isSelected();
        }
        if (this.mobileAccessBox.isEnabled()) {
            config.enabledMobileAccess = this.mobileAccessBox.isSelected();
        }
    }

    @Override
    public void checkEnabled() {
    }
}

