/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.config.LazyHashPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.admin.PasswordDialog;
import com.aem.shelp.tech.admin.subsections.SubSection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminPassword
extends SubSection
implements ActionListener,
TechServerConfig.TechServerConfigListener {
    private JButton passwordButton;
    private LazyHashPassword serverPassword = LazyHashPassword.createWithNewPassword("password");
    private String modifiedAdminPassword;

    @Override
    public void setTechClient(TechClient client) {
        super.setTechClient(client);
        client.addNewServerConfigListener(this);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_PASSWORD_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.serverPassword = config.serverHashPassword;
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.serverHashPassword = this.serverPassword;
    }

    @Override
    public boolean insertDefaultPadding() {
        return true;
    }

    @Override
    public void initUI() {
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.rootComponent);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("SIMPLEHELP_ADMIN_PASSWORD") + " " + Language.get("ADMIN_PASSWORD_DESC") + "</html>");
        this.passwordButton = new JButton(Language.get("ADMIN_PASSWORD_RESET"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.passwordButton.addActionListener(this);
        wrapper.add((Component)descriptionLabel, 0, 0, 1, 1, 1, 1, 17, 1, (Insets)new ScaledInsets(30, 150, 20, 150));
        wrapper.add((Component)this.passwordButton, 0, 1, 1, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.passwordButton)) {
            PasswordDialog dialog;
            boolean requireOldPassword = true;
            if (ServerConfig.isDefaultPassword(this.serverPassword)) {
                requireOldPassword = false;
            }
            if ((dialog = new PasswordDialog(SwingUtil.getRootPaneContainer((Component)this.getRootComponent()), requireOldPassword, OemBranding.OEM_ADMIN_USERNAME, new PasswordDialog.HashPasswordValidator(this.serverPassword), true)).isOK()) {
                this.modifiedAdminPassword = new String(dialog.getSetPassword());
                this.serverPassword = LazyHashPassword.createWithNewPassword(this.modifiedAdminPassword);
            } else {
                this.modifiedAdminPassword = null;
            }
            this.saveListener.requestImmediateSave();
            this.contentChanged(this.checkIfValid());
        }
    }

    @Override
    public void loadedNewConfig(ServerConfig config) {
        if (this.techClient.getTechCredentials().isSimpleHelpAdminUser() && this.modifiedAdminPassword != null) {
            this.techClient.getTechCredentials().setPassword(this.modifiedAdminPassword);
        }
    }

    @Override
    public void serverConfigFetched() {
    }

    @Override
    public void localServerConfigChanged(String sourceID) {
    }

    @Override
    public TechServerConfig.ServerConfigMismatchHandler configMismatch(String reason) {
        return new TechServerConfig.ServerConfigMismatchHandler(false, false);
    }

    @Override
    public void configMismatchHandled() {
    }

    @Override
    public void failedToBind(String[] failedAddresses) {
    }
}

