/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.License;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.ClientFeatures;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.utils.StreamUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import utils.progtools.date.DateUtil;
import utils.site.transact.TrialUtil;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.LinePanel;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class AdminLicense
extends SubSection
implements ActionListener,
ListSelectionListener {
    public static AdminLicense INSTANCE = null;
    private LicenseSet licenses = null;
    private JButton addLicenseButton;
    private JButton updateButton;
    private JButton upgradeButton;
    private JButton purchaseButton;
    private JButton removeLicenseButton;
    private RoundBorderPanel licensesPanel;
    private JLabel licenseSummaryLabel1;
    private JLabel licenseSummaryLabel2;
    private LinePanel trialPanel;
    private PleaseWaitDialog pleaseWaitDialog;
    private TechClient client;
    private JPanel cardsPanel;
    private SimpleList<License> licenseList;
    private SHJTable table;
    private JPanel buttonsPanel;

    public AdminLicense() {
        INSTANCE = this;
    }

    public void setLicenses(LicenseSet licenses) {
        this.licenses = licenses;
        this.updateLicenseUI();
        this.updateEnabled();
    }

    private void initLicenseTable() {
        TableStructure tableStructure = TableStructure.createTableStructure(License.class, new String[]{"getName", "getCompany", "getEmail", "getSessions", "getLicenseTypeString", "getSupportFinishFormattedYMD"}, new String[]{Language.get("NAME"), Language.get("Company"), Language.get("EMAIL_ADDRESS"), Language.get("SESSIONS"), Language.get("TYPE"), Language.get("SUPPORT_UNTIL")});
        int[] alignment = new int[]{2, 2, 2, 0, 0, 4};
        tableStructure.setMinWidths(new int[]{150, 150, 100, 100, 100, 100});
        tableStructure.setMaxWidths(new int[]{-1, -1, -1, 150, 150, 150});
        tableStructure.setAlignment(alignment);
        this.licenseList = new SimpleList();
        this.table = new SHJTable();
        this.table.setRowHeight(SHStyle.ROW_HEIGHT);
        this.table.getSelectionModel().addListSelectionListener(this);
        SimpleTableModel tableModel = new SimpleTableModel(this.licenseList, tableStructure);
        tableModel.assignToTable(this.table);
        this.table.setDefaultRenderer(Object.class, new LicenseRenderer(this.table.getDefaultRenderer(Object.class)));
        this.table.setDefaultRenderer(Integer.class, new LicenseRenderer(this.table.getDefaultRenderer(Integer.class)));
        JTableHeader header = this.table.getTableHeader();
        header.setDefaultRenderer(new AlignTableCellRendererWrapper(header.getDefaultRenderer(), alignment));
        header.setReorderingAllowed(false);
    }

    @Override
    protected void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        GridBagLayout masterLayout = new GridBagLayout();
        this.rootComponent.setLayout(masterLayout);
        this.licenseSummaryLabel1 = new JWrapLabel();
        this.licenseSummaryLabel1.setHorizontalAlignment(0);
        this.licenseSummaryLabel2 = new JWrapLabel();
        this.licenseSummaryLabel2.setHorizontalAlignment(0);
        this.trialPanel = new LinePanel(0, true, false);
        this.trialPanel.setOpaque(false);
        this.licensesPanel = new RoundBorderPanel(Language.get("ADMIN_LICENSE_TITLE"));
        GridBagLayout licenseLayout = new GridBagLayout();
        this.licensesPanel.setLayout(licenseLayout);
        this.cardsPanel = new JPanel(new GridLayout(1, 1));
        this.cardsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        licenseLayout.setConstraints(this.cardsPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 2, (Insets)new ScaledInsets(0, 0, 5, 0), 0, 0));
        licenseLayout.setConstraints(this.licenseSummaryLabel1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(10, 0, 5, 0), 0, 0));
        licenseLayout.setConstraints(this.licenseSummaryLabel2, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(10, 0, 5, 0), 0, 0));
        licenseLayout.setConstraints((Component)this.trialPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, (Insets)new ScaledInsets(10, 0, 5, 0), 0, 0));
        this.licensesPanel.add(this.cardsPanel);
        this.licensesPanel.add(this.licenseSummaryLabel1);
        this.licensesPanel.add(this.licenseSummaryLabel2);
        this.licensesPanel.add((Component)this.trialPanel);
        this.addLicenseButton = new JButton(Language.get("LIC_INSTALL"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
        this.removeLicenseButton = new JButton(Language.get("LIC_REMOVE"), ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        this.updateButton = new JButton(Language.get("RENEW_SUPPORT"), ImageLoader.getImageIcon((String)"images/svg/commerce/basket-add.svg,16"));
        this.upgradeButton = new JButton(Language.get("INCREASE_SESSION_COUNT"), ImageLoader.getImageIcon((String)"images/svg/commerce/basket-add.svg,16"));
        this.purchaseButton = new JButton(Language.get("PURCHASE_LICENSE"), ImageLoader.getImageIcon((String)"images/svg/commerce/basket-add.svg,16"));
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.purchaseButton, this.upgradeButton, this.updateButton, this.addLicenseButton});
        this.buttonsPanel = new JPanel(new GridLayout(-1, 1, 0, SimpleHelpLookAndFeel.scale((int)10)));
        this.initButtonsPanel(false, false, false, false, false);
        JPanel paddy = new JPanel();
        int YY = 0;
        masterLayout.setConstraints(this.licensesPanel, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        masterLayout.setConstraints(this.buttonsPanel, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(10, 10, 0, 0), 0, 0));
        masterLayout.setConstraints(paddy, new GridBagConstraints(0, YY++, 2, 1, 1.0, 1000.0, 10, 1, (Insets)new ScaledInsets(10, 0, 0, 0), 0, 0));
        this.rootComponent.add(this.licensesPanel);
        this.rootComponent.add(this.buttonsPanel);
        this.rootComponent.add(paddy);
        this.addLicenseButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.upgradeButton.addActionListener(this);
        this.purchaseButton.addActionListener(this);
        this.removeLicenseButton.addActionListener(this);
        this.initLicenseTable();
    }

    private void initButtonsPanel(boolean showAdd, boolean showRemove, boolean showUpdate, boolean showUpgrade, boolean showPurchase) {
        this.buttonsPanel.removeAll();
        if (showAdd) {
            this.buttonsPanel.add(this.addLicenseButton);
        }
        if (showRemove) {
            this.buttonsPanel.add(this.removeLicenseButton);
        }
        if (showUpdate) {
            this.buttonsPanel.add(this.updateButton);
        }
        if (showUpgrade) {
            this.buttonsPanel.add(this.upgradeButton);
        }
        if (showPurchase) {
            this.buttonsPanel.add(this.purchaseButton);
        }
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    private void addLicenseLine(int Y, GbPanel parent, String title, String value) {
        JLabel titleLabel = new JLabel(title + "  ");
        titleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JLabel valueLabel = new JLabel("  " + value);
        titleLabel.setHorizontalAlignment(4);
        int height = titleLabel.getPreferredSize().height;
        int maxWidth = Math.max(titleLabel.getPreferredSize().width, valueLabel.getPreferredSize().width);
        titleLabel.setPreferredSize(new Dimension(maxWidth, height));
        valueLabel.setPreferredSize(new Dimension(maxWidth, height));
        parent.add((Component)titleLabel, 0, Y, 1, 1, 1, 1, 13, 0);
        parent.add((Component)valueLabel, 1, Y, 1, 1, 1, 1, 10, 2);
    }

    public String getAmountOrUnlimited(int amount, int unlimitedAmount) {
        if (amount < unlimitedAmount) {
            return amount + "";
        }
        return Language.get("UNLIMITED");
    }

    public void updateLicenseUI() {
        this.cardsPanel.removeAll();
        boolean haveLicense = false;
        if (this.licenses != null && this.licenses.size() > 0) {
            haveLicense = true;
            if (ClientFeatures.multiLicense) {
                this.licenseSummaryLabel1.setVisible(false);
                this.licenseSummaryLabel2.setVisible(false);
                this.trialPanel.setVisible(false);
                this.initButtonsPanel(true, true, false, false, false);
                this.updateLicenseTable();
                JScrollPane pane = new JScrollPane(this.table);
                SwingUtil.setHeight((JComponent)pane, (int)SimpleHelpLookAndFeel.scale((int)300));
                this.cardsPanel.add(pane);
            } else {
                this.initCardsPanel();
                if (haveLicense) {
                    boolean isTrial = this.licenses.isTrial();
                    if (isTrial) {
                        StringBuilder trialExpires = new StringBuilder();
                        if (this.licenses.getTrialExpiry() > 0L) {
                            long days = DateUtil.getDaysBetween(System.currentTimeMillis(), this.licenses.getTrialExpiry());
                            if (days == -1L) {
                                trialExpires.append(Language.get("ADMIN_LICENSE_TRIAL_EXPIRED"));
                            } else {
                                trialExpires.append(Language.get("ADMIN_LICENSE_EXPIRES_IN")).append(" ").append(days).append(" ").append(Language.get("ADMIN_LICENSE_EXPIRES_DAYS")).append(".");
                            }
                        }
                        this.licenseSummaryLabel1.setForeground(SHStyle.ERROR_TEXT_COLOR);
                        this.licenseSummaryLabel1.setText("<html>" + trialExpires.toString());
                        this.initButtonsPanel(true, false, false, false, true);
                    } else {
                        boolean inSupport;
                        boolean bl = inSupport = !this.licenses.isOutOfSupport();
                        if (inSupport) {
                            Date endOfSupportDate = new Date(this.licenses.getOldestSupportFinishedDate());
                            this.licenseSummaryLabel1.setText(Language.get("LICENSE_SUPPORT_OK"));
                            this.licenseSummaryLabel1.setForeground(Color.green.darker().darker());
                            this.licenseSummaryLabel2.setVisible(true);
                            this.licenseSummaryLabel2.setText(Language.get("LICENSE_MAINTENANCE") + " " + DateFormat.getDateInstance(1).format(endOfSupportDate) + ".");
                            this.initButtonsPanel(true, false, false, true, false);
                        } else {
                            this.licenseSummaryLabel1.setText(Language.get("LICENSE_SUPPORT_FINISHED"));
                            this.licenseSummaryLabel1.setForeground(SHStyle.ERROR_TEXT_COLOR);
                            this.licenseSummaryLabel2.setVisible(true);
                            this.licenseSummaryLabel2.setText(Language.get("LICENSE_MAINTENANCE_UPDATE"));
                            this.initButtonsPanel(true, false, true, true, false);
                        }
                    }
                } else {
                    this.initButtonsPanel(true, false, false, false, true);
                }
            }
        } else {
            JLabel label = new JLabel(Language.get("ADMIN_NO_LICENSE"));
            label.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
            this.cardsPanel.add(label);
        }
        String licenseSource = null;
        try {
            licenseSource = this.client.getLicenseSource();
        }
        catch (Exception inSupport) {
            // empty catch block
        }
        this.trialPanel.removeAll();
        TrialUtil tu = TrialUtils.getTU();
        ArrayList<String> feats = tu.getTrialledFeatures();
        for (String feat : feats) {
            System.out.println("[Trial] Feature: " + feat);
            if (feat.equals(TrialUtil.FEATURE_BIZ)) {
                if (this.licenses.isVersion2Business() || this.licenses.isVersion2Enterprise()) continue;
                JPanel tmp = new JPanel();
                tmp.setLayout((LayoutManager)new ScaledFlowLayout());
                tmp.setOpaque(false);
                String text = Language.get("MANAGEMENT_TRIAL_IN", tu.trialDaysLeft(feat));
                if (tu.hasTrialEnded(feat)) {
                    text = Language.get("MANAGEMENT_TRIAL_DONE", tu.trialDaysLeft(feat));
                }
                JLabel desc = new JLabel(text, 0);
                JButton buy = TrialUtils.getUpgradeButton(Language.get("TRIAL_INFO_UPGRADE"), licenseSource);
                tmp.add(desc);
                tmp.add(buy);
                this.trialPanel.add((Component)tmp);
                continue;
            }
            System.out.println("***Unhandled feature in AdminLicense pane: " + feat);
        }
        if (feats.size() > 0) {
            this.trialPanel.setVisible(true);
        } else {
            this.trialPanel.setVisible(false);
        }
        this.setBorderTitle();
    }

    private void updateLicenseTable() {
        this.licenseList.startBatch();
        try {
            this.licenseList.clear();
            for (License license : this.licenses) {
                this.licenseList.add(license);
            }
        }
        finally {
            this.licenseList.endBatch();
        }
    }

    private void initCardsPanel() {
        License license = this.licenses.getFirstLicense();
        GbPanel currentLicensePanel = new GbPanel();
        currentLicensePanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        String product = "SimpleSuite";
        String name = license.getName();
        String company = license.getCompany();
        String date = license.getSupportStartFormattedYMD();
        String expiry = license.getExpiryFormattedYMD();
        String commercialUse = license.isTrial() ? "false" : "true";
        String sessions = license.getSessions() + "";
        String notes = license.getNotes();
        String type = "";
        int demoAttendees = license.getDemoAttendees();
        int Y = 0;
        if (name != null && name.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_NAME"), name);
        }
        if (company != null && company.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_COMPANY"), company);
        }
        if (sessions != null && sessions.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_SESSIONS"), sessions);
        }
        if (date != null && date.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_DATE"), date);
        }
        if (product != null && product.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PRODUCT"), product);
        }
        if (license.isVersion2Enterprise()) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_ENT") + " (P2)");
        } else if (license.isVersion2Business()) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_BIZ") + " (P2)");
        } else if (license.isVersion2Standard()) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_STD") + " (P2)");
        } else if (license.allowsV1Management()) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_MGMT") + " (P1)");
        } else {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_PLAN"), Language.get("LIC_PLAN_STD") + " (P1)");
        }
        if (type != null && type.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_TYPE"), type);
        }
        if (expiry != null && expiry.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_EXPIRY"), expiry);
        }
        if (commercialUse != null && commercialUse.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_COMMERCIALUSE"), Boolean.parseBoolean(commercialUse) ? Language.get("YES") : Language.get("NO"));
        }
        if (notes != null && notes.length() != 0) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_NOTES"), notes);
        }
        if (demoAttendees >= 1000000) {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_DEMO_ATTENDEES"), Language.get("UNLIMITED"));
        } else {
            this.addLicenseLine(Y++, currentLicensePanel, Language.get("LIC_DEMO_ATTENDEES"), "" + demoAttendees);
        }
        this.cardsPanel.add((Component)currentLicensePanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.removeLicenseButton)) {
            int selectedRow = this.table.getSelectedRow();
            new RemoveLicenseThread(this.licenseList.get(selectedRow)).start();
        } else if (e.getSource().equals(this.addLicenseButton)) {
            File licenseFile = SafeJFileChooser.pickFile((Component)this.rootComponent, (String[])new String[]{"txt"});
            if (licenseFile != null) {
                try {
                    FileInputStream fin = new FileInputStream(licenseFile);
                    String licenseData = StreamUtils.readAllAsStringISO88951(fin);
                    fin.close();
                    this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_SAVING_LICENSE"));
                    new SaveLicenseThread(licenseData).start();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (this.pleaseWaitDialog != null) {
                        this.pleaseWaitDialog.setVisible(false);
                    }
                }
            }
        } else if (e.getSource() == this.purchaseButton) {
            SHWebsiteURLUtil.launchBuyPage();
        } else if (e.getSource() == this.upgradeButton) {
            try {
                SHWebsiteURLUtil.launchAccountPage();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (e.getSource() == this.updateButton) {
            AdminLicense.showUpdateInBrowser(this.client);
        }
    }

    public static void showUpdateInBrowser(TechClient client) {
        try {
            SHWebsiteURLUtil.launchAccountPage();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void setBorderTitle() {
        this.licensesPanel.setBorderText(Language.get("ADMIN_LICENSE_TITLE"));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean isActive;
        int selectedLicenseRow = this.table.getSelectedRow();
        if (selectedLicenseRow == -1) {
            this.removeLicenseButton.setEnabled(false);
            return;
        }
        License selectedLicense = this.licenseList.get(selectedLicenseRow);
        if (this.licenseList.size() <= 1) {
            this.removeLicenseButton.setEnabled(false);
            return;
        }
        boolean bl = isActive = !selectedLicense.isOutOfSupport();
        if (isActive) {
            int activeCount = 0;
            for (License license : this.licenseList) {
                if (license.isOutOfSupport()) continue;
                ++activeCount;
            }
            if (activeCount >= 2) {
                this.removeLicenseButton.setEnabled(true);
            } else {
                this.removeLicenseButton.setEnabled(false);
            }
            return;
        }
        this.removeLicenseButton.setEnabled(true);
    }

    @Override
    public void setTechClient(TechClient client) {
        this.client = client;
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_LICENSE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    class LicenseRenderer
    extends DefaultTableCellRenderer {
        private final TableCellRenderer defaultRenderer;

        public LicenseRenderer(TableCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            License license = (License)AdminLicense.this.licenseList.get(row);
            if (column == 5 && (license.isExpired() || license.isOutOfSupport())) {
                component.setForeground(SHStyle.ERROR_TEXT_COLOR);
            } else if (!isSelected) {
                if (!AdminLicense.this.licenses.isActiveLicense(license)) {
                    component.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                } else {
                    component.setForeground(UIManager.getColor("Table.foreground"));
                }
            } else {
                component.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            return component;
        }
    }

    class RemoveLicenseThread
    extends Thread {
        private License license;

        public RemoveLicenseThread(License license) {
            this.license = license;
        }

        @Override
        public void run() {
            String htmlError = null;
            try {
                AdminLicense.this.client.removeServerLicense(this.license.getV2LicenseID());
                LicenseSet licenseSet = new LicenseSet();
                AdminLicense.this.client.fetchServerConfiguration(null, licenseSet);
                AdminLicense.this.setLicenses(licenseSet);
                AdminLicense.this.client.updateServerManagement();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (AdminLicense.this.pleaseWaitDialog != null) {
                AdminLicense.this.pleaseWaitDialog.setVisible(false);
            }
            if (htmlError != null) {
                htmlError = Language.get("REMOVE_LIC_ERROR") + "\n\n" + htmlError;
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminLicense.this.rootComponent), (String)htmlError, (String)Language.get("FAILED_REMOVE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }

    class SaveLicenseThread
    extends Thread {
        private String data;

        public SaveLicenseThread(String licenseData) {
            this.data = licenseData;
        }

        @Override
        public void run() {
            String error;
            block6: {
                error = null;
                try {
                    AdminLicense.this.client.putServerLicense(this.data);
                    LicenseSet licenseSet = new LicenseSet();
                    AdminLicense.this.client.fetchServerConfiguration(null, licenseSet);
                    AdminLicense.this.setLicenses(licenseSet);
                    AdminLicense.this.client.updateServerManagement();
                }
                catch (Exception e) {
                    error = Language.get("FAILED_LICENSE_INVALID");
                    e.printStackTrace();
                    String message = e.getMessage();
                    if (message == null) break block6;
                    if (message.contains("VALID_LICENSE_EXPIRED")) {
                        error = Language.get("VALID_LICENSE_EXPIRED");
                    }
                    if (message.contains("LICENSE_ALREADY_EXISTS")) {
                        error = Language.get("LICENSE_ALREADY_EXISTS");
                    }
                    if (!message.contains("GETTING_STARTED_OLD_TITLE")) break block6;
                    error = Language.get("GETTING_STARTED_OLD_TITLE");
                }
            }
            if (AdminLicense.this.pleaseWaitDialog != null) {
                AdminLicense.this.pleaseWaitDialog.setVisible(false);
            }
            if (error != null) {
                String htmlError = Language.get("FAILED_SAVE_LICENSE_MSG") + "\n\n" + error;
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminLicense.this.rootComponent), (String)htmlError, (String)Language.get("FAILED_SAVE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }
}

