/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import build.BuildConstants;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.BrandingSettings;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.files.FileUtil;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.color.colorpicker.ColorPicker;
import utils.swing.components.ColorButton;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.ICOReader;
import utils.swing.images.ImageHelper;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminBranding
extends SubSection {
    public static AdminBranding INSTANCE = null;
    private TechClient client;
    private ColorButton headerWebpageColorButton;
    private ColorButton headerAppColorButton;
    private LogoPanel logoPanel;
    private ImageDescriptionPanel splash;
    private ImageDescriptionPanel fav;
    private JTextField nameField;
    private JCheckBox showTypeBox;
    private JCheckBox showOSBox;
    private JSearchTextField supportNameField;
    private JLabel example;
    private ChangeListener changeListener = null;
    private SaveListener saveListener = null;

    public AdminBranding() {
        INSTANCE = this;
    }

    @Override
    protected void initUI() {
        this.changeListener = new ChangeListener();
        this.saveListener = new SaveListener();
        GbPanel gbPanel = new GbPanel();
        this.rootComponent.setLayout(new GridLayout(1, 1));
        this.rootComponent.add((Component)gbPanel);
        SHStrippedContentPanel contentPanel = new SHStrippedContentPanel(gbPanel);
        JPanel splashPanel = this.initSplashPanel();
        JPanel namePanel = this.initNamePanel();
        JPanel exePanel = this.initExePanel();
        JPanel colourPanel = this.initColoursPanel();
        contentPanel.addContent(namePanel, Language.get("BRANDING_NAME"));
        contentPanel.addContent(splashPanel, Language.get("BRANDING_LOGO_TITLE"));
        contentPanel.addContent(exePanel, Language.get("BRANDING_SUPPORT_EXE"));
        contentPanel.addContent(colourPanel, Language.get("BRANDING_COLOURS"));
        contentPanel.addVerticalFiller();
        contentPanel.setBackgroundColours(true);
    }

    private void saveToServer(boolean saveImages) {
        System.out.println("[AdminBranding] Saving branding to server");
        new SaveThread(saveImages).start();
    }

    private JPanel initColoursPanel() {
        ColourButtonListener listener = new ColourButtonListener();
        ColorPropagatingGBPanel panel = new ColorPropagatingGBPanel();
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)20, (int)10, (int)20));
        this.headerWebpageColorButton = new ColorButton(Color.white, Language.get("COLOR_WEBSITE_HEADER"));
        this.headerAppColorButton = new ColorButton(Color.white, Language.get("SUPPORT_HEADER"));
        this.headerWebpageColorButton.addActionListener(listener);
        this.headerAppColorButton.addActionListener(listener);
        panel.add(this.headerWebpageColorButton, 0, 0, 1, 1, 1, 1, 17, 3);
        panel.add(this.headerAppColorButton, 1, 0, 1, 1, 1, 1, 17, 3);
        return panel;
    }

    private JPanel initExePanel() {
        JPanel panel = new JPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)panel, (Insets)new ScaledInsets(3, 3, 3, 3));
        JLabel supportNameLabel = new JLabel(Language.get("BRANDING_SUPPORT_NAME"));
        this.supportNameField = new JSearchTextField(BuildConstants.BUNDLE_CUSTOMER);
        this.showOSBox = new JCheckBox(Language.get("BRANDING_SHOW_OS"));
        this.showTypeBox = new JCheckBox(Language.get("BRANDING_SHOW_TYPE"));
        this.example = new JLabel();
        this.example.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        int Y = 0;
        wrapper.add((Component)supportNameLabel, 0, Y, 1, 1, 0, 0, 13, 1);
        wrapper.add((Component)this.supportNameField, 1, Y++, 2, 1, 100, 0, 17, 1);
        wrapper.add((Component)this.showOSBox, 1, Y, 1, 1, 0, 0, 17, 1);
        wrapper.add((Component)this.showTypeBox, 2, Y++, 1, 1, 1, 0, 17, 1);
        wrapper.add((Component)this.example, 1, Y++, 2, 1, 2, 0, 17, 1);
        this.supportNameField.addKeyListener(this.changeListener);
        this.showOSBox.addActionListener(this.changeListener);
        this.showTypeBox.addActionListener(this.changeListener);
        this.supportNameField.addFocusListener(this.saveListener);
        this.showOSBox.addActionListener(this.saveListener);
        this.showTypeBox.addActionListener(this.saveListener);
        return panel;
    }

    private void updateSupportExeExample() {
        StringBuilder name = new StringBuilder();
        if (this.supportNameField.getText().length() > 0) {
            name.append(this.supportNameField.getText());
        } else {
            name.append(BuildConstants.BUNDLE_CUSTOMER);
        }
        if (this.showOSBox.isSelected()) {
            name.append("-windows32");
        }
        if (this.showTypeBox.isSelected()) {
            name.append("-online");
        }
        name.append(".exe");
        this.example.setText(Language.get("EXAMPLE") + ": " + name.toString());
    }

    private JPanel initNamePanel() {
        JPanel panel = new JPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)panel, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.nameField = new JTextField();
        this.nameField.addFocusListener(this.saveListener);
        wrapper.add((Component)this.nameField, 0, 0, 1, 1, 1, 1, 10, 2);
        return panel;
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }

    public void setBrandingSettings(BrandingSettings settings) {
        if (settings.appName != null) {
            this.nameField.setText(settings.appName);
        }
        if (settings.supportExeFormat != null) {
            this.supportNameField.setText(settings.supportExeFormat);
        }
        this.showOSBox.setSelected(settings.supportExeKeepOS);
        this.showTypeBox.setSelected(settings.supportExeKeepType);
        if (settings.splashImagePNG != null) {
            ByteArrayInputStream bin = new ByteArrayInputStream(settings.splashImagePNG);
            try {
                BufferedImage logo = ImageIO.read(bin);
                this.loadSplash(settings.splashImagePNG.length, logo);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.splash.sizeLabel.setText(Language.get("UNKNOWN"));
                this.splash.dimensionsLabel.setText(Language.get("UNKNOWN"));
            }
            try {
                byte[] favIco = settings.favico;
                this.loadICO(favIco);
            }
            catch (Throwable t) {
                this.fav.sizeLabel.setText(Language.get("UNKNOWN"));
                this.fav.dimensionsLabel.setText(Language.get("UNKNOWN"));
            }
        }
        this.headerWebpageColorButton.setColor(settings.webHeaderColor);
        this.headerAppColorButton.setColor(settings.supportAppHeaderColor);
        this.updateSupportExeExample();
        this.logoPanel.repaint();
    }

    private void loadSplash(long length, BufferedImage logo) {
        this.splash.imagePanel.setImage(logo);
        this.splash.dimensionsLabel.setText(logo.getWidth() + " x " + logo.getHeight() + " " + Language.get("PIXELS"));
        this.splash.sizeLabel.setText(length / 1024L + " " + Language.get("KBYTES"));
    }

    private void loadICO(File favFile) throws IOException {
        ICOReader.ImageList imageList = ICOReader.readIcoFile(favFile);
        this.loadImageList(imageList, favFile.length());
    }

    private void loadICO(byte[] data) throws IOException {
        ICOReader.ImageList imageList = ICOReader.readIcoFile(data);
        this.loadImageList(imageList, data.length);
    }

    private void loadImageList(ICOReader.ImageList imageList, long length) {
        StringBuilder sizes = new StringBuilder();
        if (imageList.image16 != null) {
            sizes.append(sizes.length() > 0 ? " , " : "").append("16 x 16");
        }
        if (imageList.image24 != null) {
            sizes.append(sizes.length() > 0 ? " , " : "").append("24 x 24");
        }
        if (imageList.image32 != null) {
            sizes.append(sizes.length() > 0 ? " , " : "").append("32 x 32");
        }
        if (imageList.image48 != null) {
            sizes.append(sizes.length() > 0 ? " , " : "").append("48 x 48");
        }
        if (sizes.length() > 0) {
            this.fav.dimensionsLabel.setText(sizes + " " + Language.get("PIXELS"));
        } else {
            this.fav.dimensionsLabel.setText(Language.get("UNKNOWN"));
        }
        this.fav.sizeLabel.setText(length / 1024L + " " + Language.get("KBYTES"));
        this.fav.imagePanel.setImage(imageList.image16);
    }

    private JPanel initSplashPanel() {
        ColorPropagatingPanel panel = new ColorPropagatingPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)panel, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.logoPanel = new LogoPanel();
        FavIcoPanel favPanel = new FavIcoPanel();
        this.splash = new ImageDescriptionPanel(this.logoPanel, false, Language.get("BRANDING_LOGO_DESC"));
        this.fav = new ImageDescriptionPanel(favPanel, true, Language.get("BRANDING_FAVICON_DESC"));
        int Y = 0;
        wrapper.add((Component)this.splash.rootComponent, 0, Y++, 1, 1, 1, 0, 10, 1);
        wrapper.add((Component)this.fav.rootComponent, 0, Y++, 1, 1, 1, 0, 10, 1);
        return panel;
    }

    @Override
    public void setTechClient(TechClient client) {
        this.client = client;
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_BRANDING");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    public void fetchBrandingSettings() throws Exception {
        BrandingSettings settings = this.client.fetchBrandingSettings();
        this.setBrandingSettings(settings);
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    class ChangeListener
    implements KeyListener,
    ActionListener {
        ChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminBranding.this.updateSupportExeExample();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            AdminBranding.this.updateSupportExeExample();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            AdminBranding.this.updateSupportExeExample();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AdminBranding.this.updateSupportExeExample();
        }
    }

    class ColourButtonListener
    implements ActionListener {
        ColourButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorButton button = (ColorButton)e.getSource();
            ColorPicker cp = new ColorPicker(Language.DEFLANG);
            cp.setPreferredSize(SimpleHelpLookAndFeel.scaledDimension((int)500, (int)270));
            cp.setExpertControlsVisible(true);
            cp.setHSBControlsVisible(false);
            cp.setColor(button.getColor());
            if (SHGlassOptionPane.showOkCancelPanelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminBranding.this.rootComponent), (JComponent)((Object)cp), (String)Language.get("PICK_COLOUR"), (String)Language.get("PICK_COLOUR"), (String)Language.get("CANCEL"))) {
                button.setColor(cp.getColor());
                button.repaint();
                AdminBranding.this.saveToServer(false);
            }
        }
    }

    class FavIcoPanel
    extends LogoPanel {
        FavIcoPanel() {
        }

        @Override
        public Dimension getDesiredSize() {
            return SimpleHelpLookAndFeel.scale((Dimension)new Dimension(300, 16));
        }
    }

    class ImageDescriptionPanel
    implements ActionListener {
        private JLabel sizeHeading;
        private JLabel sizeLabel;
        private JLabel dimensionsHeading;
        private JLabel dimensionsLabel;
        private LogoPanel imagePanel;
        private JButton uploadNewSplashButton;
        public GbPanel rootComponent = new ColorPropagatingGBPanel();
        byte[] rawData = null;
        private boolean isICO;

        public ImageDescriptionPanel(LogoPanel logoPanel, boolean isICO, String description) {
            this.isICO = isICO;
            this.imagePanel = logoPanel;
            this.imagePanel.setBorder(SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR));
            this.sizeHeading = new JLabel(Language.get("BRANDING_SIZE"));
            this.sizeLabel = new JLabel();
            this.dimensionsHeading = new JLabel(Language.get("BRANDING_DIMENSIONS"));
            this.dimensionsLabel = new JLabel();
            this.uploadNewSplashButton = new JButton(Language.get("BRANDING_UPLOAD_IMAGE"));
            this.uploadNewSplashButton.addActionListener(this);
            this.sizeHeading.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            this.dimensionsHeading.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            int Y = 0;
            GbPanel rightPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
            rightPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)0));
            rightPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
            this.dimensionsHeading.setHorizontalAlignment(4);
            this.sizeHeading.setHorizontalAlignment(4);
            JWrapLabel descriptionLabel = new JWrapLabel("<html>" + description);
            rightPanel.add((Component)descriptionLabel, 0, Y++, 2, 1, 0, 0, 17, 2);
            rightPanel.add((Component)this.dimensionsHeading, 0, Y, 1, 1, 0, 0, 13, 2);
            rightPanel.add((Component)this.dimensionsLabel, 1, Y++, 1, 1, 1, 0, 17, 2);
            rightPanel.add((Component)this.sizeHeading, 0, Y, 1, 1, 0, 0, 13, 2);
            rightPanel.add((Component)this.sizeLabel, 1, Y++, 1, 1, 1, 0, 17, 2);
            rightPanel.add((Component)this.uploadNewSplashButton, 1, Y++, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(10, 3, 3, 3));
            this.rootComponent.add((Component)logoPanel, 0, 0, 1, 1, 0, 0, 11, 1);
            this.rootComponent.add((Component)rightPanel, 1, 0, 1, 1, 1, 1, 17, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            this.uploadNewSplashButton.setEnabled(false);
            try {
                String[] extensions = this.isICO ? new String[]{"ico"} : new String[]{"jpg", "jpeg", "gif", "png"};
                File file = SafeJFileChooser.pickFile((Component)this.uploadNewSplashButton, (String[])extensions);
                if (file != null) {
                    if (this.isICO) {
                        AdminBranding.this.loadICO(file);
                        this.rawData = FileUtil.readFile((File)file);
                        AdminBranding.this.saveToServer(true);
                    } else {
                        BufferedImage read = ImageIO.read(file);
                        read = ImageHelper.scaleDownToFitInside((BufferedImage)read, (int)SimpleHelpLookAndFeel.scale((int)850), (int)SimpleHelpLookAndFeel.scale((int)300), (boolean)true);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)read, "png", bout);
                        byte[] pngData = bout.toByteArray();
                        AdminBranding.this.loadSplash(pngData.length, read);
                        this.rawData = pngData;
                        AdminBranding.this.saveToServer(true);
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                this.uploadNewSplashButton.setEnabled(true);
            }
        }
    }

    class LogoPanel
    extends JPanel {
        private BufferedImage image;

        public void setImage(BufferedImage image) {
            this.image = image;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getDesiredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getDesiredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getDesiredSize();
        }

        protected Dimension getDesiredSize() {
            return SimpleHelpLookAndFeel.scale((Dimension)new Dimension(300, 120));
        }

        @Override
        public void paint(Graphics g) {
            this.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
            super.paint(g);
            if (this.image != null) {
                Insets insets = this.getInsets();
                int width = this.getWidth() - insets.left - insets.right;
                int height = this.getHeight() - insets.top - insets.bottom;
                int imageWidth = this.image.getWidth();
                int imageHeight = this.image.getHeight();
                if (imageWidth > width || imageHeight > height) {
                    int targetWidth = 0;
                    int targetHeight = 0;
                    double ratio = (double)imageWidth / (double)imageHeight;
                    int x = 0;
                    int y = 0;
                    if (imageWidth > width) {
                        targetWidth = width;
                        targetHeight = (int)((double)targetWidth / ratio);
                        x = insets.left;
                        y = insets.top + (height - targetHeight) / 2;
                    }
                    if (imageHeight > height) {
                        targetHeight = height;
                        targetWidth = (int)((double)targetHeight * ratio);
                        y = insets.top;
                        x = insets.left + (width - targetWidth) / 2;
                    }
                    g.drawImage(this.image, x, y, targetWidth, targetHeight, null);
                } else {
                    int x = insets.left + (width - imageWidth) / 2;
                    int y = insets.top + (height - imageHeight) / 2;
                    g.drawImage(this.image, x, y, null);
                }
            }
        }
    }

    class SaveListener
    implements FocusListener,
    ActionListener {
        SaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdminBranding.this.saveToServer(false);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            AdminBranding.this.saveToServer(false);
        }
    }

    class SaveThread
    extends Thread {
        private boolean saveImages;

        public SaveThread(boolean saveImages) {
            this.saveImages = saveImages;
        }

        @Override
        public void run() {
            BrandingSettings savedSettings = new BrandingSettings();
            savedSettings.appName = AdminBranding.this.nameField.getText().trim();
            savedSettings.supportExeFormat = AdminBranding.this.supportNameField.getText().trim();
            if (savedSettings.supportExeFormat.trim().length() == 0) {
                savedSettings.supportExeFormat = BuildConstants.BUNDLE_CUSTOMER;
            }
            savedSettings.supportExeKeepOS = AdminBranding.this.showOSBox.isSelected();
            savedSettings.supportExeKeepType = AdminBranding.this.showTypeBox.isSelected();
            savedSettings.webHeaderColor = AdminBranding.this.headerWebpageColorButton.getColor();
            savedSettings.supportAppHeaderColor = AdminBranding.this.headerAppColorButton.getColor();
            if (this.saveImages) {
                savedSettings.favico = ((AdminBranding)AdminBranding.this).fav.rawData;
                savedSettings.splashImagePNG = ((AdminBranding)AdminBranding.this).splash.rawData;
            }
            try {
                System.out.println("[AdminBranding] Sending branding settings now...");
                AdminBranding.this.client.saveBrandingSettings(savedSettings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

