/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.dataexport;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.dataexport.TokenDialog;
import com.aem.shelp.util.PatternWrapper;
import com.aem.shelp.util.swing.IconedAbstractListUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminAPI
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private JButton manageTokensButton;
    private JLabel address;
    private APIRestrictionList apiRestrictionList;
    private RoundBorderPanel restrictionsPanel;

    @Override
    protected void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_API_DESC"));
        this.manageTokensButton = new JButton(Language.get("ADMIN_API_MANAGE"));
        this.address = new JLabel("<html>" + Language.get("ADMIN_API_DESC_2"));
        this.restrictionsPanel = new RoundBorderPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.rootComponent);
        wrapper.add((Component)desc, 0, 0, 1, 1, 1, 1, 17, 1);
        wrapper.add((Component)this.manageTokensButton, 1, 0, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.address, 0, 1, 1, 1, 1, 0, 17, 1, (Insets)new ScaledInsets(10, 0, 0, 0));
        wrapper.add((Component)this.restrictionsPanel, 0, 2, 2, 1, 1, 0, 17, 1, (Insets)new ScaledInsets(10, 0, 0, 0));
        GbPanelWrapper restrictionsWrapper = new GbPanelWrapper((Container)this.restrictionsPanel);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.DEFLANG.getString("ADMIN_APIREST_DESC") + "</html>");
        this.apiRestrictionList = new APIRestrictionList(Language.DEFLANG, new String[0]);
        SwingUtil.setWidth((JComponent)((Object)this.apiRestrictionList), (int)SimpleHelpLookAndFeel.scale((int)350));
        SwingUtil.setHeight((JComponent)((Object)this.apiRestrictionList), (int)SimpleHelpLookAndFeel.scale((int)60));
        restrictionsWrapper.add((Component)descriptionLabel, 0, 2, 1, 1, 1, 0, 10, 1, (Insets)new ScaledInsets(0, 0, 5, 0));
        restrictionsWrapper.add((Component)((Object)this.apiRestrictionList), 0, 3, 1, 1, 1, 0, 17, 0);
        this.manageTokensButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminAPI.this.showManageTokensDialog();
            }
        });
    }

    private void showManageTokensDialog() {
        TokenDialog.showDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.techClient);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_API_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        if (config.apiRestrictions != null) {
            String[] objects = new String[config.apiRestrictions.length];
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = config.apiRestrictions[i].getRegularExpression();
            }
            this.apiRestrictionList.setObjects(objects);
        } else {
            this.apiRestrictionList.setObjects(new String[0]);
        }
    }

    @Override
    public void saveTo(ServerConfig config) {
        String[] objects = this.apiRestrictionList.getObjects(new String[0]);
        config.apiRestrictions = new PatternWrapper[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            config.apiRestrictions[i] = new PatternWrapper(objects[i], false);
        }
    }

    @Override
    public void checkEnabled() {
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
    }

    class APIRestrictionList
    extends IconedAbstractListUI<String> {
        public APIRestrictionList(ResourceBundle lang, String[] initialList) {
            super(lang, initialList, false, false);
        }

        @Override
        protected Icon getIconForObject(String element) {
            return ImageLoader.getImageIcon((String)"images/svg/computing/network.svg,16");
        }

        @Override
        protected String getNewObject() {
            return SHGlassOptionPane.showInputDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminAPI.this.rootComponent), (String)("<html>" + this.lang.getString("ADMIN_APIREST_DESC") + "<br><br>" + this.lang.getString("ADMIN_IP_RESTRICTION_1") + "<br>" + this.lang.getString("ADMIN_IP_RESTRICTION_2") + "</html>"), (String)this.lang.getString("ADMIN_APIREST_NEW_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/lock-open.svg,48"), (String)this.lang.getString("OK"), (String)"*");
        }

        @Override
        protected void listChanged() {
            AdminAPI.this.contentChanged(AdminAPI.this.checkIfValid());
        }
    }
}

