/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.enterprise;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.shelp.tech.admin.enterprise.PeerConfigRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import utils.message.Message;
import utils.message.TypedMap;

public class PeerConfig {
    private String identity;
    private String hostname;
    private String authToken;
    private String pubKeyHash;
    boolean syncHistory = false;
    boolean syncSessionTokens = false;
    private int licensesToIssue;
    private int transient_myIssuedLicenses;
    private long transient_lastConnectFailure;
    private long transient_lastValidConnected;
    private static int count = 0;

    public String toString() {
        if (this.pubKeyHash == null || this.pubKeyHash.length() < 20) {
            return "PeerConfig (id:" + this.identity + " hostname:" + this.hostname + " history:" + this.syncHistory + " sessions:" + this.syncSessionTokens + " pubkeyhash:" + this.pubKeyHash + ")";
        }
        return "PeerConfig (id:" + this.identity + " hostname:" + this.hostname + " history:" + this.syncHistory + " sessions:" + this.syncSessionTokens + " pubkeyhash:" + this.pubKeyHash.substring(0, 20) + "...)";
    }

    public int hashCode() {
        return this.authToken.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PeerConfig) {
            PeerConfig pc = (PeerConfig)o;
            return this.authToken.equals(pc.authToken);
        }
        return false;
    }

    public int getLicensesToIssue() {
        return this.licensesToIssue;
    }

    public void setLicensesToIssue(int sessions) {
        this.licensesToIssue = sessions;
    }

    public void setTransient_lastValidConnected(long t) {
        this.transient_lastValidConnected = t;
    }

    public long getTransient_lastValidConnected() {
        return this.transient_lastValidConnected;
    }

    public void setTransient_lastConnectFailure(long t) {
        this.transient_lastConnectFailure = t;
    }

    public long getTransient_lastConnectFailure() {
        return this.transient_lastConnectFailure;
    }

    public void setTransientMyIssuedLicenses(int n) {
        this.transient_myIssuedLicenses = n;
    }

    public int getTransientMyIssuedLicenses() {
        return this.transient_myIssuedLicenses;
    }

    public String getPubKeyHash() {
        return this.pubKeyHash;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void updateIdentity(String name) {
        this.identity = name;
    }

    public String getHostname() {
        return this.hostname;
    }

    private TypedMap toMap(boolean includeTransient) throws IOException {
        TypedMap map = new TypedMap();
        map.setString("id", this.identity);
        map.setString("host", this.hostname);
        map.setString("auth", this.authToken);
        map.setString("pkhash", this.pubKeyHash);
        map.setBoolean("sync_history", this.syncHistory);
        map.setBoolean("sync_sessionTokens", this.syncSessionTokens);
        map.setInt("issued", this.licensesToIssue);
        map.setInt("mylicenses", this.transient_myIssuedLicenses);
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[PeerConfig] Saving " + this);
        }
        return map;
    }

    public Message toMessage() throws IOException {
        return this.toMap(true).toCompressedMessage();
    }

    private static PeerConfig fromMap(TypedMap map) throws IOException {
        PeerConfig config = new PeerConfig();
        config.identity = map.getString("id");
        config.hostname = map.getString("host");
        config.authToken = map.getString("auth");
        config.pubKeyHash = map.getString("pkhash");
        config.syncHistory = map.getBoolean("sync_history", false);
        config.syncSessionTokens = map.getBoolean("sync_sessionTokens", false);
        config.licensesToIssue = map.contains("issued") ? map.getInt("issued") : 0;
        config.transient_myIssuedLicenses = map.contains("mylicenses") ? map.getInt("mylicenses") : 0;
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[PeerConfig] Loaded " + config);
        }
        return config;
    }

    public static PeerConfig fromMessage(Message m) throws IOException {
        TypedMap map = TypedMap.fromCompressedMessage((Message)m);
        PeerConfig config = PeerConfig.fromMap(map);
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[PeerConfig] Loaded from message - " + config);
        }
        return config;
    }

    public static PeerConfig fromFile(File file) throws IOException {
        TypedMap map = TypedMap.fromFile((File)file);
        PeerConfig config = PeerConfig.fromMap(map);
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[PeerConfig] Loaded from file - " + config);
        }
        return config;
    }

    public boolean isSyncHistory() {
        return this.syncHistory;
    }

    public boolean isSyncSessionTokens() {
        return this.syncSessionTokens;
    }

    public void saveToLocalFile(File target) throws IOException {
        if (CentralDebugging.PX_PEER_PROCESSING) {
            System.out.println("[Peer] Saving peer config to " + target.getCanonicalPath());
        }
        this.toMap(false).toFile(target);
    }

    public static String createAuthToken() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append(Long.toString(Math.abs(BCUtil.getSecureRandom().nextLong())));
        }
        return sb.toString();
    }

    public static PeerConfig createNewConfig(String identity, String hostname, String pubKeyHash, String authToken) {
        PeerConfig config = new PeerConfig();
        config.identity = identity;
        config.hostname = hostname;
        config.pubKeyHash = pubKeyHash;
        config.authToken = authToken;
        return config;
    }

    public static PeerConfig createTestConfig() {
        PeerConfig config = new PeerConfig();
        config.identity = "Primary " + count;
        config.hostname = "example" + count + ".simplehelp.io";
        config.pubKeyHash = "ABCDHASH" + count;
        config.authToken = PeerConfig.createAuthToken();
        ++count;
        return config;
    }

    public static PeerConfig getConnected(PeerConfig config, ArrayList<PeerConfig> connectedPeerList) {
        for (PeerConfig connected : connectedPeerList) {
            if (!config.getAuthToken().equals(connected.getAuthToken())) continue;
            return connected;
        }
        return config;
    }

    public static void updateToLatest(ArrayList<PeerConfig> connectedPeerList) {
        HashMap<String, PeerConfig> map = new HashMap<String, PeerConfig>();
        for (PeerConfig config : connectedPeerList) {
            map.put(config.getAuthToken(), config);
        }
        for (int i = 0; i < connectedPeerList.size(); ++i) {
            PeerConfig config;
            config = connectedPeerList.get(i);
            PeerConfig connected = (PeerConfig)map.get(config.getAuthToken());
            if (connected == null) continue;
            connected.copyStateFrom(config);
            connectedPeerList.set(i, connected);
        }
        map = new HashMap();
        for (PeerConfig config : PeerConfigRepository.INSTANCE.getAllConfigs()) {
            map.put(config.getAuthToken(), config);
        }
        for (PeerConfig config : connectedPeerList) {
            PeerConfig file = (PeerConfig)map.get(config.getAuthToken());
            if (file == null) continue;
            config.setLicensesToIssue(file.getLicensesToIssue());
            config.updateIdentity(file.getIdentity());
        }
    }

    public void copyStateFrom(PeerConfig config) {
        this.setLicensesToIssue(config.getLicensesToIssue());
        this.updateIdentity(config.getIdentity());
        this.setSyncHistory(config.isSyncHistory());
        this.setSyncSessionTokens(config.isSyncSessionTokens());
    }

    private void setSyncHistory(boolean syncHistory) {
        this.syncHistory = syncHistory;
    }

    private void setSyncSessionTokens(boolean syncSessionTokens) {
        this.syncSessionTokens = syncSessionTokens;
    }

    public boolean isConnectedtoLocalhost() {
        if (this.hostname == null) {
            return false;
        }
        if (this.hostname.equalsIgnoreCase("localhost") || this.hostname.equalsIgnoreCase("127.0.0.1")) {
            return true;
        }
        return this.hostname.toLowerCase().startsWith("localhost:") || this.hostname.startsWith("127.0.0.1:");
    }
}

