/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.utils.authentication.LDAPAuthenticator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import utils.swing.components.SHJTree;
import utils.swing.customlaf.SHStyle;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.jtree.SimpleTreeModel;
import utils.swing.simplelist.jtree.checked.CheckNodeSelectionListener;
import utils.swing.simplelist.jtree.checked.CheckedNode;
import utils.swing.simplelist.jtree.checked.CheckedRenderer;

public class LDAPGroupPickerDialog {
    private final TechClient client;
    private final GbPanel rootComponent = new GbPanel();
    private final PanelGlassDialog dialog;
    private final ArrayList<LDAPTreeNode> selectedList = new ArrayList();
    private final SHJTree tree = new SHJTree(AccessStyle.TREE_SELECTION_COLOR);
    private final SimpleTreeModel<LDAPTreeNode> slm = new SimpleTreeModel();

    public LDAPGroupPickerDialog(RootPaneContainer rpc, TechClient client, String baseDN, String[] selectedDNs) throws Exception {
        LDAPAuthenticator.LDAPSearchResult[] allGroups;
        this.client = client;
        this.tree.setModel(this.slm.getTreeModel());
        block0: for (LDAPAuthenticator.LDAPSearchResult result : allGroups = client.getLDAPGroups(baseDN)) {
            LDAPTreeNode treeNode = LDAPGroupPickerDialog.addToModel(this.slm, baseDN, result.DN);
            if (selectedDNs == null) continue;
            for (String s : selectedDNs) {
                if (!treeNode.DN.equals(s)) continue;
                treeNode.setChecked(true);
                this.selectedList.add(treeNode);
                continue block0;
            }
        }
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        scrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.rootComponent.add((Component)scrollPane, 0, 0, 1, 1, 1, 1, 10, 1);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new CheckNodeSelectionListener(this.tree){

            @Override
            protected void setChecked(CheckedNode node, boolean isChecked) {
                super.setChecked(node, isChecked);
                if (isChecked) {
                    LDAPGroupPickerDialog.this.selectedList.add((LDAPTreeNode)node);
                } else {
                    LDAPGroupPickerDialog.this.selectedList.remove(node);
                }
            }
        });
        this.tree.setCellRenderer(new LDAPGroupRenderer());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleTreeModel.TreeNode<Object> rootNode = LDAPGroupPickerDialog.this.slm.getTreeNodeFor(null);
                TreePath rootPath = new TreePath(rootNode);
                LDAPGroupPickerDialog.this.tree.expandPath(rootPath);
                for (SimpleTreeModel.TreeNode node : rootNode.children) {
                    LDAPGroupPickerDialog.this.tree.expandPath(new TreePath(new Object[]{rootNode, node}));
                }
            }
        });
        this.dialog = new PanelGlassDialog(rpc, Language.get("LDAP_PICK_GROUPS_TITLE"), 500, Language.get("CLOSE"), null);
        this.dialog.setContentPanel((JComponent)this.rootComponent);
        this.dialog.showDialog();
    }

    public static String[] getDNParts(String baseDN, boolean removeEquals) {
        String[] baseDNParts = baseDN.split(",");
        for (int i = 0; i < baseDNParts.length; ++i) {
            int equals;
            baseDNParts[i] = baseDNParts[i].trim();
            if (!removeEquals || (equals = baseDNParts[i].indexOf(61)) <= -1) continue;
            baseDNParts[i] = baseDNParts[i].substring(equals + 1);
        }
        return baseDNParts;
    }

    private static LDAPTreeNode addToModel(SimpleTreeModel slm, String baseDN, String DN) {
        String[] baseDNParts = LDAPGroupPickerDialog.getDNParts(baseDN, false);
        String[] parts = LDAPGroupPickerDialog.getDNParts(DN, false);
        LDAPTreeNode parent = new LDAPTreeNode(baseDN, baseDN, false);
        slm.addChild(null, parent);
        String intermediateDN = baseDN;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[parts.length - i - 1];
            int baseDNIndex = baseDNParts.length - i - 1;
            if (baseDNIndex >= 0 && part.equalsIgnoreCase(baseDNParts[baseDNParts.length - i - 1])) continue;
            intermediateDN = part + "," + intermediateDN;
            LDAPTreeNode child = new LDAPTreeNode(part, intermediateDN, i == parts.length - 1);
            slm.addChild(parent, child);
            parent = child;
        }
        return parent;
    }

    public String[] getSelectedGroupDNs() {
        ArrayList<String> result = new ArrayList<String>();
        for (LDAPTreeNode node : this.selectedList) {
            result.add(node.DN);
        }
        return result.toArray(new String[0]);
    }

    class LDAPGroupRenderer
    extends CheckedRenderer {
        public LDAPGroupRenderer() {
            this.setBackgroundSelectionColor(AccessStyle.TREE_SELECTION_COLOR);
            this.setTextSelectionColor(Color.WHITE);
            this.setBorderSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (row == 0) {
                this.setIcon(ImageLoader.getImageIcon((String)"images/svg/computing/database.svg,16"));
            } else if (this.box.isVisible()) {
                this.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16"));
            } else {
                this.setIcon(ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
            }
            return c;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }

    static class LDAPTreeNode
    implements CheckedNode,
    Comparable<LDAPTreeNode> {
        private final boolean isGroup;
        String label;
        String DN;
        boolean selected = false;

        public LDAPTreeNode(String label, String DN, boolean isGroup) {
            this.label = label;
            int equals = label.indexOf(61);
            int nextEquals = label.indexOf(61, equals + 1);
            if (equals > -1 && nextEquals == -1) {
                this.label = label.substring(equals + 1);
            }
            this.DN = DN;
            this.isGroup = isGroup;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object o) {
            return this.DN.equalsIgnoreCase(((LDAPTreeNode)o).DN);
        }

        public int hashCode() {
            return this.DN.hashCode();
        }

        @Override
        public boolean isChecked() {
            return this.selected;
        }

        @Override
        public void setChecked(boolean selected) {
            this.selected = selected;
        }

        @Override
        public boolean showCheckBox() {
            return this.isGroup;
        }

        @Override
        public int compareTo(LDAPTreeNode o) {
            return this.label.compareTo(o.label);
        }
    }
}

