/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.model.machine;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanel;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.filters.ConnectedMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.FavouriteMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.OfflineMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.OnlineMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.TextMachineFilter;
import com.aem.shelp.tech.access.model.subgroups.ActiveSessionIconnedMachineGroup;
import com.aem.shelp.tech.access.model.subgroups.BlankRowGroup;
import com.aem.shelp.tech.access.model.subgroups.HeadingGroup;
import com.aem.shelp.tech.access.model.subgroups.IconnedMachineGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.w3c.dom.Element;
import utils.swing.images.ImageLoader;

public class MachineTreeModel
extends AbstractTreeModel<MachineGroup, Machine> {
    protected TechClient client;
    protected MachineGroup connectedMachinesGroup;
    protected MachineGroup offlineMachinesGroup;
    protected MachineGroup onlineMachinesGroup;
    protected MachineGroup favouriteMachinesGroup;
    private HeadingGroup savedSearchHeading;
    private BlankRowGroup blankRowGroup1;
    private BlankRowGroup blankRowGroup2;
    private FavouriteMachineFilter favouriteFilter;

    public MachineTreeModel() {
        this.initSaveHeading();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    @Override
    protected void appendSpecificFilterProcessorXML(StringBuffer xml) {
        this.favouriteFilter.saveToXML(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFilterProcessors() {
        this.connectedMachinesGroup = ActiveSessionIconnedMachineGroup.newIconnedGroup(Language.get("ACTIVE_SESSIONS"), ImageLoader.getImageIcon((String)"images/svg/general/help.svg,16"));
        this.onlineMachinesGroup = IconnedMachineGroup.newIconnedGroup(Language.get("ONLINE_MACHINES"), ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
        this.offlineMachinesGroup = IconnedMachineGroup.newIconnedGroup(Language.get("OFFLINE_MACHINES"), ImageLoader.getImageIconDisabled((String)"images/svg/technology/screen.svg,16"));
        this.favouriteMachinesGroup = IconnedMachineGroup.newIconnedGroup(Language.get("FAVOURITES"), ImageLoader.getImageIcon((String)"images/svg/general/star.svg,16"));
        this.blankRowGroup1 = BlankRowGroup.newBlankRowGroup();
        this.blankRowGroup2 = BlankRowGroup.newBlankRowGroup();
        this.treeModel.addChild(null, this.blankRowGroup1);
        this.treeModel.addChild(null, this.blankRowGroup2);
        ArrayList arrayList = this.filterProcessors;
        synchronized (arrayList) {
            this.filterProcessors.add(new OnlineMachineFilter(this.onlineMachinesGroup));
            this.filterProcessors.add(new ConnectedMachineFilter(this.connectedMachinesGroup));
            this.filterProcessors.add(new OfflineMachineFilter(this.offlineMachinesGroup));
            this.favouriteFilter = new FavouriteMachineFilter(this.favouriteMachinesGroup);
            this.filterProcessors.add(this.favouriteFilter);
        }
    }

    private void initSaveHeading() {
        if (this.savedSearchHeading == null) {
            this.savedSearchHeading = HeadingGroup.newHeadingGroup(Language.get("SAVED_SEARCHES"));
        }
    }

    public TechClient getTechClient() {
        return this.client;
    }

    @Override
    protected void insertSpecialRootGroup(MachineGroup group) {
        if (this.containsRootGroup(group)) {
            return;
        }
        MachineGroup[] ordering = new MachineGroup[]{(MachineGroup)this.rootElementGroup, this.onlineMachinesGroup, this.connectedMachinesGroup, this.offlineMachinesGroup, this.favouriteMachinesGroup};
        if (group == this.savedSearchHeading) {
            this.treeModel.insertChildAfter(null, group, this.blankRowGroup2);
        } else {
            boolean added = false;
            MachineGroup lastExistingGroup = (MachineGroup)this.rootElementGroup;
            for (int i = 1; i < ordering.length && !added; ++i) {
                if (ordering[i] == group) {
                    this.treeModel.insertChildAfter(null, group, lastExistingGroup);
                    added = true;
                    continue;
                }
                if (!this.containsRootGroup(ordering[i])) continue;
                lastExistingGroup = ordering[i];
            }
        }
    }

    @Override
    protected MachineGroup initRootGroup() {
        return IconnedMachineGroup.newIconnedGroup(Language.get("ALL_MACHINES"), ImageLoader.getImageIcon((String)"images/svg/general/world.svg,16"));
    }

    @Override
    public MachineGroup newGroup(String name) {
        return MachineGroup.newGroup(name);
    }

    public MachineGroup[] initGroupArray(int size) {
        return new MachineGroup[size];
    }

    public Machine[] initElementArray(int size) {
        return new Machine[size];
    }

    public Image getThumbnailFor(Machine machine) {
        if (AccessPanel.TESTING) {
            return AccessPanel.TEST_THUMB;
        }
        try {
            if (machine.getMachineInfo() != null) {
                Image cached = (Image)machine.getMachineInfo().getSmallScreenImage();
                if (cached != null) {
                    return cached;
                }
                byte[] jpeg = machine.getMachineInfo().getSmallScreenJpeg();
                cached = ImageIO.read(new ByteArrayInputStream(jpeg));
                machine.getMachineInfo().setSmallScreenImage(cached);
                return cached;
            }
            return null;
        }
        catch (Exception x) {
            return null;
        }
    }

    @Override
    public String getXMLRootTag() {
        return "AccessModel";
    }

    public MachineGroup getOnlineFilterGroup() {
        return this.onlineMachinesGroup;
    }

    public MachineGroup getOfflineFilterGroup() {
        return this.offlineMachinesGroup;
    }

    @Override
    public void moveGroupToFinalChild(MachineGroup groupToSave) {
        this.insertSpecialRootGroup(this.savedSearchHeading);
        super.moveGroupToFinalChild(groupToSave);
    }

    @Override
    protected void startBatchAddMachines() {
        super.startBatchAddMachines();
        if (this.client != null) {
            this.client.ignoreSubscribeSends(true);
        }
    }

    @Override
    protected void endBatchAddMachines() {
        if (this.client != null) {
            this.client.ignoreSubscribeSends(false);
            this.client.sendSubscribeList();
        }
        super.endBatchAddMachines();
    }

    @Override
    public void addFilterProcessorGroup(MachineGroup searchResultGroup, boolean temporarySearch) {
        if (!temporarySearch) {
            this.treeModel.addChild(null, searchResultGroup);
        } else {
            this.treeModel.insertChildAfter(null, searchResultGroup, this.blankRowGroup1);
        }
    }

    public void addSessions(AccessSession[] sessions) {
        for (AccessSession session : sessions) {
            String machineID = session.getMachine().getMachineID();
            Machine m = (Machine)this.getElementWithID(machineID);
            if (m == null) continue;
            m.addActiveSession_ClientOnly(session);
            Machine.MachineChanges change = new Machine.MachineChanges();
            change.activeSessionCount = 1;
            change.sessionsAdded = new ArrayList();
            change.sessionsAdded.add(session);
            MachineGroup currentGroup = (MachineGroup)this.getOrCreateGroup(m.getMachineName().getGroup());
            this.notifyMachineChanged(currentGroup, null, null, new Machine[]{m}, change);
        }
    }

    public void removeSessions(AccessSession[] accessSessions) {
        for (AccessSession session : accessSessions) {
            String machineID = session.getMachine().getMachineID();
            Machine m = (Machine)this.getElementWithID(machineID);
            if (m == null) continue;
            m.removeActiveSession_ClientOnly(session);
            Machine.MachineChanges change = new Machine.MachineChanges();
            change.activeSessionCount = -1;
            change.sessionsRemoved = new ArrayList();
            change.sessionsRemoved.add(session);
            MachineGroup currentGroup = (MachineGroup)this.getOrCreateGroup(m.getMachineName().getGroup());
            this.notifyMachineChanged(currentGroup, null, null, new Machine[]{m}, change);
        }
    }

    @Override
    protected void loadFilterProcessor(Element filterProcessor) {
        String filterClass = filterProcessor.getAttribute("class");
        if (filterClass != null && filterClass.equals("FavouritesFilter")) {
            this.favouriteFilter.loadStateFrom(filterProcessor);
        } else {
            TextMachineFilter filter = new TextMachineFilter(null, null);
            filter.fromXML(this, filterProcessor);
            this.insertSpecialRootGroup(this.savedSearchHeading);
            this.addFilterProcessor(filter, filter.getRoot(), false);
        }
    }

    public boolean isMachineFavourite(Machine machine) {
        return this.favouriteFilter.includes(machine);
    }

    public void setMachineFavourite(Machine machine, boolean favourite) {
        this.favouriteFilter.setFavourite(machine, favourite);
        this.updateFilterProcessorsFor(machine);
    }
}

