/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.ui;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessStyle;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public class StatusIcon
implements Icon {
    private int width;
    private int height;
    private Machine machine;

    public StatusIcon() {
        Icon icon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/inuse.svg,16");
        if (icon != null) {
            this.width = icon.getIconWidth();
            this.height = icon.getIconHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderStatus(Graphics g, Machine machine, int xCenter, int yCenter) {
        Icon statusIcon = null;
        boolean drawSessionCount = false;
        if (machine.isAvailable()) {
            if (machine.hasAnyProblem()) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/dialogs/warning.svg,16");
            } else if (machine.needsRestarting()) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/restart.svg,16");
            } else if (machine.needsUpgrading()) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/upgrade.svg,16");
            } else if (machine.getActiveSessionCount_ClientOnly() > 0) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/inuse.svg,16");
                drawSessionCount = true;
            } else if (machine.isInUse() == 1) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/inuse.svg,16");
            } else if (machine.isInUse() == 0) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/headless.svg,16");
            } else if (machine.isInUse() == 2) {
                statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/online.svg,16");
            }
        } else {
            statusIcon = ImageLoader.getImageIconOriginal((String)"images/svg/machine-state/offline.svg,16");
        }
        if (statusIcon != null) {
            statusIcon.paintIcon(null, g, xCenter - statusIcon.getIconWidth() / 2, yCenter - statusIcon.getIconHeight() / 2);
        }
        if (drawSessionCount) {
            Font font = g.getFont();
            try {
                g.setColor(AccessStyle.SESSION_INDICATOR_COLOUR);
                g.setFont(new Font(null, 1, SimpleHelpLookAndFeel.scale((int)10)));
                int count = machine.getActiveSessionCount_ClientOnly();
                String countString = Integer.toString(count);
                int desiredWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), countString);
                int y = yCenter + g.getFontMetrics().getDescent() + 1;
                g.drawString(countString, xCenter - desiredWidth / 2, y);
            }
            finally {
                g.setFont(font);
            }
        }
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.machine == null) {
            return;
        }
        StatusIcon.renderStatus(g, this.machine, x + this.width / 2, y + this.height / 2);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

