/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.ui;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.contents.ui.StatusIcon;
import com.aem.shelp.util.ElapsedTimeFormatter;
import javax.swing.JLabel;

public class MachineStatusLabel
extends JLabel {
    private StatusIcon icon = new StatusIcon();
    private String machineStatus;
    private ElapsedTimeFormatter etf = new ElapsedTimeFormatter();
    private Machine machine;

    public MachineStatusLabel() {
        this.setIcon(this.icon);
    }

    public String getMachineStateText() {
        return this.machineStatus;
    }

    public void updateTimer() {
        if (this.machine == null) {
            return;
        }
        if (this.machine.isAvailable() && this.machine.isInUse() == 2) {
            String lastUsedTime = this.getLastUsedTimeString();
            if (!this.machine.needsRestarting() && !this.machine.needsUpgrading() && lastUsedTime != null && lastUsedTime.length() > 0) {
                this.setText("<html>" + this.machineStatus + " <font color=\"#999999\">" + lastUsedTime + "</font>");
            }
        }
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        this.icon.setMachine(machine);
        if (machine.isAvailable()) {
            String lastUsedTime = "";
            this.machineStatus = "";
            if (machine.getActiveSessionCount_ClientOnly() > 0) {
                this.machineStatus = Language.get("IN_SESSION");
            } else if (machine.isInUse() == 1) {
                this.machineStatus = Language.get("MACHINE_IN_USE");
            } else if (machine.isInUse() == 0) {
                this.machineStatus = "";
            } else if (machine.isInUse() == 2) {
                this.machineStatus = Language.get("MACHINE_NOT_IN_USE");
                lastUsedTime = this.getLastUsedTimeString();
            }
            String text = machine.needsRestarting() ? (this.machineStatus != null && this.machineStatus.length() > 0 ? this.machineStatus + " <font color=\"#999999\">(" + Language.get("NEEDS_UPDATING") + ")</font>" : Language.get("NEEDS_UPDATING")) : (machine.needsUpgrading() ? (this.machineStatus != null && this.machineStatus.length() > 0 ? this.machineStatus + " <font color=\"#999999\">(" + Language.get("NEEDS_UPGRADING") + ")</font>" : Language.get("NEEDS_UPGRADING")) : (lastUsedTime != null && lastUsedTime.length() > 0 ? this.machineStatus + " <font color=\"#999999\">" + lastUsedTime + "</font>" : this.machineStatus));
            text = "<html>" + text;
            this.setText(text);
        } else {
            this.machineStatus = Language.get("OFFLINE");
            this.setText(this.machineStatus);
        }
    }

    private String getLastUsedTimeString() {
        long time = this.machine.getLastInUseTimeMillis();
        if (time == 0L) {
            return null;
        }
        long diff = System.currentTimeMillis() - time;
        diff = diff < 1000L ? 1000L : diff / 1000L * 1000L;
        return "(" + Language.get("MACHINE_IN_USE") + " " + this.etf.getFormattedTimeAgo(diff) + ")";
    }
}

