/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table.sessions;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.table.TableGroupPanel;
import com.aem.shelp.tech.access.contents.table.sessions.SessionTableColumns;
import com.aem.shelp.tech.access.contents.table.sessions.SessionsTable;
import com.aem.shelp.tech.access.contents.ui.StatusIcon;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import utils.swing.RetinaImageIcon;
import utils.swing.SwingUtil;
import utils.swing.components.AlertGradientTableCellRenderer;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.SimpleList;

public class SessionsTableRenderer
extends AlertGradientTableCellRenderer
implements SessionTableColumns.SessionColumnPainter {
    private final SimpleList<SessionsTable.IndexedAbstractSession> sessionsList;
    private final TechClient client;
    private SessionsTable.IndexedAbstractSession session;
    private boolean isSelected = false;
    private TableGroupPanel tableGroupPanel;
    private boolean showMachineIcons = true;
    private Machine machine;
    private boolean paintName;
    private static BufferedImage hoverImage = SwingUtil.getButtonImage((String)Language.get("KILL_SESSION"), (boolean)true);
    private static BufferedImage nonHoverImage = SwingUtil.getButtonImage((String)Language.get("KILL_SESSION"), (boolean)false);
    private static RetinaImageIcon hoverIcon = new RetinaImageIcon(hoverImage);
    private static RetinaImageIcon nonHoverIcon = new RetinaImageIcon(nonHoverImage);
    private ElapsedTimeFormatter durationFormatter = new ElapsedTimeFormatter();

    public SessionsTableRenderer(TableGroupPanel tableGroupPanel, boolean showMachineIcons, SimpleList<SessionsTable.IndexedAbstractSession> sessionsList, TechClient client) {
        this.client = client;
        this.sessionsList = sessionsList;
        this.setShowMachineIcons(showMachineIcons);
        this.tableGroupPanel = tableGroupPanel;
    }

    public static int getTerminateButtonWidth() {
        return nonHoverIcon.getIconWidth();
    }

    public void setShowMachineIcons(boolean showMachineIcons) {
        this.showMachineIcons = showMachineIcons;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        AlertGradientTableCellRenderer label = (AlertGradientTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            label.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            label.setForeground(UIManager.getColor("Table.foreground"));
        }
        this.isSelected = isSelected;
        this.session = (SessionsTable.IndexedAbstractSession)value;
        if (this.session == null) {
            label.setText(" ");
            label.setIcon(null);
        } else {
            this.machine = this.session.remoteMachine;
            this.paintName = true;
            if (this.paintName) {
                if (this.machine.getMachineName() != null) {
                    label.setText(" " + this.machine.getMachineName().getName());
                } else {
                    label.setText(" ");
                }
            } else {
                label.setText(" ");
            }
            if (!isSelected) {
                if (this.session.machineIndex % 2 == 0) {
                    label.setBackground(UIManager.getColor("Table.background"));
                } else {
                    label.setBackground(UIManager.getColor("Table.alternateRowColor"));
                }
            }
        }
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (SessionTableColumns.getColumnsWidth() == -1) {
            return dim;
        }
        dim.width = this.getWidth() - SessionTableColumns.getColumnsWidth();
        return dim;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = super.getWidth();
        int height = super.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.setSize(prefSize.width, height);
        super.paint(g);
        this.setSize(width, height);
        g.setColor(this.getBackground());
        g.fillRect(prefSize.width, 0, width - prefSize.width, height);
        g.setColor(this.getForeground());
        g.setFont(AccessStyle.MACHINE_TABLE_FONT);
        SessionTableColumns.callPaintMethods(g, width, height, this, this.isSelected, this.paintName);
        this.tableGroupPanel.getGroupsList().justPainted(this.session.remoteMachine);
    }

    @Override
    public void paintIP(Graphics g, int width, int height) {
        String[] ipMacs;
        MachineInfo info = this.machine.getMachineInfo();
        if (info != null && (ipMacs = info.getLocalIpMacs()) != null && ipMacs.length > 0 && ipMacs[0] != null) {
            String ip = ipMacs[0];
            int index = ip.indexOf(47);
            if (index != -1) {
                ip = ip.substring(0, index);
            }
            this.paintText(g, ip, width, height, SessionTableColumns.ipCenter, SessionTableColumns.IP_WIDTH);
        }
    }

    @Override
    public void paintWANIP(Graphics g, int width, int height) {
        String ip;
        MachineInfo info = this.machine.getMachineInfo();
        if (info != null && (ip = info.getWanIP()) != null) {
            this.paintText(g, ip, width, height, SessionTableColumns.wanIpCenter, SessionTableColumns.WANIP_WIDTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintText(Graphics g, String text, int width, int height, int centerX, int columnWidth) {
        if (text == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g.getFontMetrics();
        int baseTextLine = height / 2 + fm.getDescent() + 1;
        Shape currentClip = g.getClip();
        Rectangle bounds = currentClip.getBounds();
        try {
            int x = width + centerX - columnWidth / 2;
            int y = 0;
            int w = columnWidth;
            int h = height;
            int x2 = x + w;
            int y2 = y + h;
            int newx = Math.max(x, bounds.x);
            int newy = Math.max(y, bounds.y);
            int newx2 = Math.min(bounds.x + bounds.width, x2);
            int newy2 = Math.min(bounds.y + bounds.height, y2);
            g.setClip(new Rectangle(newx, newy, newx2 - newx, newy2 - newy));
            g.drawString(text, width + centerX - columnWidth / 2, baseTextLine);
        }
        finally {
            g.setClip(currentClip);
        }
    }

    @Override
    public void paintHostname(Graphics g, int width, int height) {
        MachineInfo info = this.machine.getMachineInfo();
        if (info != null) {
            String hostname = info.getHostname();
            this.paintText(g, hostname, width, height, SessionTableColumns.hostnameCenter, SessionTableColumns.HOSTNAME_WIDTH);
        }
    }

    @Override
    public void paintUsername(Graphics g, int width, int height) {
        MachineInfo info = this.machine.getMachineInfo();
        if (info != null) {
            String user = info.getConsoleUser();
            this.paintText(g, user, width, height, SessionTableColumns.usernameCenter, SessionTableColumns.USERNAME_WIDTH);
        }
    }

    @Override
    public void paintDuration(Graphics g, int width, int height) {
        AbstractSession as = this.session.session;
        long duration = as.getIncrementedElapsedTime();
        String abbreviatedFormattedTime = this.durationFormatter.getFormattedTime(duration);
        this.paintText(g, abbreviatedFormattedTime, width, height, SessionTableColumns.durationCenter, SessionTableColumns.DURATION_WIDTH);
    }

    @Override
    public void paintOS(Graphics g, int width, int height, boolean isSelected) {
        Icon osIcon = this.machine != null ? OSIconLoader.getOSTag(this.machine, isSelected) : null;
        if (osIcon != null) {
            osIcon.paintIcon(null, g, width + SessionTableColumns.osCenter - osIcon.getIconWidth() / 2, (height - osIcon.getIconHeight()) / 2);
        }
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
        if (this.machine != null) {
            StatusIcon.renderStatus(g, this.machine, width + SessionTableColumns.statusCenter, height / 2);
        }
    }

    @Override
    public void paintMachineName(Graphics g, int width, int height) {
    }

    @Override
    public void paintTechnician(Graphics g, int width, int height) {
        String technician = "" + this.session.session.getTechnicianDisplayName();
        this.paintText(g, technician, width, height, SessionTableColumns.technicianCenter, SessionTableColumns.TECHNICIAN_WIDTH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTerminate(Graphics g, int width, int height, boolean isSelected) {
        TransientTechUser techUser = this.client.getTechUser();
        if (techUser.canTerminateSession(this.session.session)) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape currentClip = g.getClip();
            Rectangle bounds = currentClip.getBounds();
            try {
                int x = width - hoverIcon.getIconWidth() - SimpleHelpLookAndFeel.scale((int)2);
                int y = (height - hoverIcon.getIconHeight()) / 2;
                if (isSelected) {
                    hoverIcon.paintIcon(null, g, x, y);
                } else {
                    nonHoverIcon.paintIcon(null, g, x, y);
                }
            }
            finally {
                g.setClip(currentClip);
            }
        }
    }
}

