/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.access.contents.MachineGroupPanelLabel;
import com.aem.shelp.tech.access.contents.table.AbstractMachineTable;
import com.aem.shelp.tech.access.contents.table.MachineTable;
import com.aem.shelp.tech.access.contents.table.sessions.SessionsTable;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupPanel;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import com.aem.shelp.tech.hierarchy.ui.GroupPanelLabel;
import java.awt.Component;
import javax.swing.ListSelectionModel;

public class TableGroupPanel
extends AbstractGroupPanel<MachineGroup, Machine> {
    private AbstractMachineTable machineOrSessionTable;

    public TableGroupPanel(MachineTreeModel machineModel, MachineGroup group, AccessPanelListener accessPanelListener, boolean isFirstGroupAdded, AbstractGroupsList<MachineGroup, Machine> groupsList, boolean showMachineIcons, boolean showSessionTable) {
        super(machineModel, group, accessPanelListener, isFirstGroupAdded, groupsList);
        this.machineOrSessionTable = showSessionTable ? new SessionsTable(machineModel, group, accessPanelListener, this, showMachineIcons) : new MachineTable(machineModel, group, accessPanelListener, this, showMachineIcons);
        this.rootComponent.add((Component)this.machineOrSessionTable.getRootComponent(), "Center");
    }

    public void sortByColumn(int columnToSortBy, boolean ascending) {
        this.machineOrSessionTable.sortByColumn(columnToSortBy, ascending);
    }

    public boolean showingSessionsTable() {
        return this.machineOrSessionTable instanceof SessionsTable;
    }

    @Override
    public boolean isEmpty() {
        return this.machineOrSessionTable.isEmpty();
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    @Override
    protected void selectAllElementsInGroup(MachineGroup machineGroup) {
        this.machineOrSessionTable.getRootComponent().selectAll();
    }

    @Override
    protected void selectElements(boolean selectAfterAnchorRow) {
        ListSelectionModel selectionModel = this.machineOrSessionTable.getRootComponent().getSelectionModel();
        int anchorSelectionIndex = selectionModel.getAnchorSelectionIndex();
        if (selectAfterAnchorRow) {
            selectionModel.setSelectionInterval(anchorSelectionIndex, this.machineOrSessionTable.getRootComponent().getRowCount() - 1);
        } else {
            selectionModel.setSelectionInterval(0, anchorSelectionIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void machinesChanged(MachineGroup parentGroup, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
        if (parentGroup == this.group || parentGroup != null && parentGroup.equals(this.group)) {
            if (updated != null) {
                ((MachineGroup)this.group).getElements().startBatch();
                try {
                    for (Machine m : updated) {
                        ((MachineGroup)this.group).getElements().notifyElementUpdate(m);
                    }
                }
                finally {
                    ((MachineGroup)this.group).getElements().endBatch();
                }
            }
            if (this.showingSessionsTable() && updateResults.activeSessionCount != 0) {
                this.machineOrSessionTable.machinesChanged(parentGroup, inserted, removed, updated, updateResults);
            }
        }
    }

    @Override
    protected void clearSelection() {
        this.machineOrSessionTable.getRootComponent().clearSelection();
    }

    @Override
    protected void selectLastElement() {
        int row = this.machineOrSessionTable.getRootComponent().getRowCount();
        this.machineOrSessionTable.getRootComponent().getSelectionModel().setSelectionInterval(row - 1, row - 1);
    }

    @Override
    protected void selectFirstElement() {
        this.machineOrSessionTable.getRootComponent().getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    protected boolean allElementsSelected() {
        return this.machineOrSessionTable.getRootComponent().getSelectedRowCount() == this.machineOrSessionTable.getRootComponent().getRowCount();
    }

    public Machine[] getSelectedElements() {
        return this.machineOrSessionTable.getSelectedMachines();
    }

    @Override
    public void ensureElementIsSelected(MachineGroup group, Machine machine) {
        if (this.machineOrSessionTable instanceof MachineTable) {
            ((MachineTable)this.machineOrSessionTable).select(machine);
        }
    }

    @Override
    protected GroupPanelLabel<MachineGroup, Machine> initLabel(HierarchyPanelListener panelListener, MachineGroup group, boolean isFirstGroupAdded) {
        return new MachineGroupPanelLabel((AccessPanelListener)panelListener, group, isFirstGroupAdded);
    }
}

