/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.table.MachineTableColumns;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import sun.swing.DefaultLookup;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class MachineTableHeader
extends JPanel
implements ComponentListener,
MachineTableColumns.MachineColumnPainter {
    private final Icon ascendingIcon;
    private final Icon descendingIcon;
    private int sortColumn = -1;
    private boolean sortAscending;

    public MachineTableHeader() {
        this.setBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP));
        this.addComponentListener(this);
        this.ascendingIcon = DefaultLookup.getIcon(this, this.ui, "Table.ascendingSortIcon");
        this.descendingIcon = DefaultLookup.getIcon(this, this.ui, "Table.descendingSortIcon");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = SimpleHelpLookAndFeel.scale((int)20);
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        MachineTableColumns.setAvailableWidth(this.getWidth());
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setFont(AccessStyle.HEADER_TITLE_FONT);
        g2d.setColor(AccessStyle.HEADER_TITLE_COLOR);
        int width = super.getWidth();
        int height = super.getHeight();
        MachineTableColumns.callPaintMethods(g, width, height, this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTextCentered(Graphics g, String string, int centerX, int heightTotal, int width, boolean drawArrow) {
        Shape s = g.getClip();
        try {
            int startX = centerX - width / 2;
            g.setClip(startX, 0, startX + width, heightTotal);
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            int hgt = heightTotal / 2 + metrics.getMaxAscent() / 2;
            int adv = metrics.stringWidth(string);
            int xTextPos = centerX - adv / 2;
            boolean drawText = true;
            if (drawArrow) {
                int arrowWidth = this.descendingIcon.getIconWidth() + SimpleHelpLookAndFeel.scale((int)3);
                if (arrowWidth + adv > width) {
                    drawText = false;
                    adv = 0;
                } else {
                    xTextPos = centerX - adv / 2 + arrowWidth / 2;
                }
                this.drawArrow(g, centerX - adv / 2 - arrowWidth / 2);
            }
            if (drawText) {
                g.drawString(string, xTextPos, hgt);
            }
        }
        finally {
            g.setClip(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawText(Graphics g, String string, int x, int heightTotal, int width, boolean drawArrow) {
        Shape s = g.getClip();
        try {
            g.setClip(x, 0, x + width, heightTotal);
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            int hgt = heightTotal / 2 + metrics.getMaxAscent() / 2;
            int adv = metrics.stringWidth(string);
            int xTextPos = x;
            boolean drawText = true;
            if (drawArrow) {
                int arrowWidth = this.descendingIcon.getIconWidth() + SimpleHelpLookAndFeel.scale((int)3);
                if (arrowWidth + adv > width) {
                    drawText = false;
                } else {
                    xTextPos += arrowWidth;
                }
                this.drawArrow(g, x);
            }
            if (drawText) {
                g.drawString(string, xTextPos, hgt);
            }
        }
        finally {
            g.setClip(s);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        MachineTableColumns.setAvailableWidth(this.getWidth());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void paintIP(Graphics g, int width, int height) {
        this.drawText(g, Language.get("IP"), width + MachineTableColumns.ipCenter - MachineTableColumns.IP_WIDTH / 2, height, MachineTableColumns.IP_WIDTH, this.sortColumn == 6);
    }

    @Override
    public void paintWANIP(Graphics g, int width, int height) {
        this.drawText(g, Language.get("WAN"), width + MachineTableColumns.wanIpCenter - MachineTableColumns.WANIP_WIDTH / 2, height, MachineTableColumns.WANIP_WIDTH, this.sortColumn == 7);
    }

    @Override
    public void paintHostname(Graphics g, int width, int height) {
        this.drawText(g, Language.get("HOSTNAME"), width + MachineTableColumns.hostnameCenter - MachineTableColumns.HOSTNAME_WIDTH / 2, height, MachineTableColumns.HOSTNAME_WIDTH, this.sortColumn == 5);
    }

    @Override
    public void paintUsername(Graphics g, int width, int height) {
        this.drawText(g, Language.get("USERNAME"), width + MachineTableColumns.usernameCenter - MachineTableColumns.USERNAME_WIDTH / 2, height, MachineTableColumns.USERNAME_WIDTH, this.sortColumn == 4);
    }

    @Override
    public void paintGraphs(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("MEMORY_ABBREV"), width + MachineTableColumns.memCenter, height, MachineTableColumns.GRAPH_WIDTHS, false);
        this.drawTextCentered(g, Language.get("CPU_ABBREV"), width + MachineTableColumns.cpuCenter, height, MachineTableColumns.GRAPH_WIDTHS, false);
    }

    @Override
    public void paintOS(Graphics g, int width, int height, boolean isSelected) {
        this.drawTextCentered(g, Language.get("OPERATING_SYSTEM_ABBREV"), width + MachineTableColumns.osCenter, height, MachineTableColumns.OS_WIDTH, this.sortColumn == 3);
    }

    @Override
    public void paintStatus(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("STATUS"), width + MachineTableColumns.statusCenter, height, MachineTableColumns.STATUS_ICON_WIDTH, this.sortColumn == 2);
    }

    @Override
    public void paintMachineName(Graphics g, int width, int height) {
        int col0Width = width - MachineTableColumns.getNameColumnWidth();
        int x = 0;
        if (this.sortColumn != 0) {
            x = SimpleHelpLookAndFeel.scale((int)5);
        }
        this.drawText(g, Language.get("MACHINE_NAME"), x, height, col0Width, this.sortColumn == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArrow(Graphics g, int x) {
        Icon icon = this.sortAscending ? DefaultLookup.getIcon(this, this.ui, "Table.ascendingSortIcon") : DefaultLookup.getIcon(this, this.ui, "Table.descendingSortIcon");
        Color c = g.getColor();
        try {
            icon.paintIcon(this, g, x, this.getHeight() / 2 - icon.getIconHeight() / 2);
        }
        finally {
            g.setColor(c);
        }
    }

    @Override
    public void paintAlert(Graphics g, int width, int height) {
        this.drawTextCentered(g, Language.get("ALERTS"), width + MachineTableColumns.alertsCenter, height, MachineTableColumns.ALERTS_ICON_WIDTH, this.sortColumn == 1);
    }

    public void setSortingSelection(int column, boolean ascending) {
        this.sortColumn = column;
        this.sortAscending = ascending;
        this.repaint();
    }
}

