/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupsList;
import java.util.ArrayList;

public class ContinualViewableUpdates
extends Thread {
    public static ContinualViewableUpdates INSTANCE = new ContinualViewableUpdates();
    private static final int AUTO_RESEND_PERIOD = 110000;
    private static final int WAIT_TILL_SEND_TIME = 1000;
    private AbstractGroupsList<MachineGroup, Machine> sourceList;
    private AccessPanelListener accessPanelListener;
    private long nextUpdateTime = 0L;
    private final Object LOCK = new Object();

    public ContinualViewableUpdates() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AccessPanelListener accessPanelListener, AbstractGroupsList<MachineGroup, Machine> sourceList) {
        Object object = this.LOCK;
        synchronized (object) {
            this.accessPanelListener = accessPanelListener;
            this.sourceList = sourceList;
            long oldUpdateTime = this.nextUpdateTime;
            this.nextUpdateTime = System.currentTimeMillis() + 1000L;
            if (this.nextUpdateTime < oldUpdateTime) {
                this.LOCK.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ArrayList<Machine> paintedMachines = null;
            Object object = this.LOCK;
            synchronized (object) {
                if (this.nextUpdateTime < System.currentTimeMillis()) {
                    try {
                        if (this.sourceList != null) {
                            paintedMachines = this.sourceList.getPaintedElements();
                            System.out.println("[Access] (New expensive thumbs subscription...) [" + paintedMachines.size() + "]");
                            for (int i = 0; i < paintedMachines.size(); ++i) {
                                System.out.println("[Access] Subscribing to expensive thumbs for " + paintedMachines.get(i).getMachineName());
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.nextUpdateTime = System.currentTimeMillis() + 110000L;
                }
            }
            if (paintedMachines != null) {
                try {
                    this.accessPanelListener.subscribeToExpensiveThumbs(paintedMachines);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            object = this.LOCK;
            synchronized (object) {
                try {
                    long sleepTime = this.nextUpdateTime - System.currentTimeMillis();
                    sleepTime = Math.max(100L, sleepTime);
                    System.out.println("[Access] Thumbs subscription sleeping for " + sleepTime);
                    this.LOCK.wait(sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

