/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access;

import com.aem.VersionUtil;
import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.profiles.model.AppProfiles;
import com.aem.sdesktop.util.Version;
import com.aem.sgateway.ServiceConfigureListener;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.mdupload.fs.FSPane2;
import com.aem.shelp.mdupload.fs.FsAutoUpgrade;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.techclient.RAClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.NetAdapter;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.details.ActiveSessionTable;
import com.aem.shelp.tech.access.details.AdvancedPanel;
import com.aem.shelp.tech.access.details.MachineAlertsTable;
import com.aem.shelp.tech.access.details.MachineConfigurePanel;
import com.aem.shelp.tech.access.details.MachineNotificationPanel;
import com.aem.shelp.tech.access.details.ProblemsPanel;
import com.aem.shelp.tech.access.details.RDPSessionTable;
import com.aem.shelp.tech.access.details.SystemPanel;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineModelChangeListener;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.access.model.machine.filters.StopMachineFilter;
import com.aem.shelp.tech.access.model.machine.filters.UpdateMachineFilter;
import com.aem.shelp.tech.access.service.AbstractSGServiceUI;
import com.aem.shelp.tech.access.service.StopSGServiceUI;
import com.aem.shelp.tech.access.service.UpdateSGServiceUI;
import com.aem.shelp.tech.access.utils.MachineSelection;
import com.aem.shelp.tech.alerts.alerts.details.AlertConfigPanel;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.appprofile.AppProfileUI;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import com.aem.shelp.tech.hierarchy.ui.AbstractDetailsPanel;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import com.aem.shelp.tech.history.HistorySubPanel;
import com.aem.shelp.tech.portforward.AppTunnelUI;
import com.aem.shelp.tech.software.MachineSoftwarePanel;
import com.aem.shelp.tech.toolbox.RunToolResultsPanel;
import com.aem.shelp.tech.toolbox.ToolBoxResultWrapper;
import com.aem.shelp.tech.utils.BasicInfoUI;
import com.aem.shelp.tech.utils.MetricsRow;
import com.aem.shelp.tech.utils.MonitoringSwitch;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.util.LogGatherer;
import com.aem.shelp.util.swing.CopyToClipboardButton;
import com.aem.shelp.util.swing.ShPopupMenuButton;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import utils.message.Message;
import utils.osstats.types.BasicInfo;
import utils.progtools.Cache;
import utils.swing.SwingUtil;
import utils.swing.components.JEditableLabel;
import utils.swing.components.JWrapLabel;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class MachineDetailsPanel
extends AbstractDetailsPanel
implements MachineModelChangeListener,
JEditableLabel.EditListener,
ServiceConfigureListener,
ActionListener {
    private final GbPanel contentSingle = new GbPanel();
    private final StrippedContentPanel singleWrapper = new SHStrippedContentPanel(this.contentSingle, false);
    private AdvancedPanel contentMultiple;
    private final JPanel contentPreconfigured = new JPanel(new BorderLayout());
    private final JPanel contentConfigure = new JPanel(new BorderLayout());
    private final JPanel contentNotify = new JPanel(new BorderLayout());
    private final DecimalFormat df = new DecimalFormat("0.0");
    private final MachineTreeModel model;
    private final SystemPanel system = new SystemPanel(this);
    private final ProblemsPanel problemsPanel = new ProblemsPanel();
    private final FSPane2 fsPanel = new FSPane2();
    private final NotesPanel notesPanel = new NotesPanel();
    private MachineDetailsHistoryPanel historyPanel;
    private MachineDetailsSoftwarePanel softwarePanel;
    private RunToolResultsPanel runToolResultsPanel;
    private final JPanel servicesPanel = new JPanel();
    private MetricsRow cpuMemoryMetricsRow;
    private AdvancedPanel advancedPanel;
    private ActiveSessionTable sessionTable;
    private RDPSessionTable rdpSessionTable;
    private MachineAlertsTable alertTable;
    private final BasicInfoUI hardwareDetails = new BasicInfoUI();
    private final AccessPanelListener accessPanelListener;
    private Machine machine;
    private MachineGroup parentGroup;
    private TreeSelection.SelectedGroup selection;
    private MachineSelection multipleSelection;
    private JPanel problemsSection;
    private JPanel systemSection;
    private JPanel sessionSection;
    private JPanel rdpSection;
    private StrippedContentPanel.TitledSection alertSection;
    private JPanel statsSection;
    private JPanel cpuSection;
    private JPanel disksSection;
    private JPanel networkSection;
    private JPanel hardwareSection;
    private JLabel versionLabel;
    private GbPanel cpuPanel;
    private GbPanel disksPanel;
    private GbPanel networkPanel;
    private Image previousScreenshot;
    private int previousScreenshotHashcode;
    private final ArrayList<NetworkLabels> networkLabelList = new ArrayList();
    private final ArrayList<DiskLabels> diskLabelList = new ArrayList();
    private final ArrayList<CPULabels> cpuLabelList = new ArrayList();
    private final AlertTreeModel alertModel;
    private static final boolean SHOW_WIFI_STATS = false;
    private AppTunnelUI appTunnelUI;
    private final ShPopupMenuButton connect = new ShPopupMenuButton(Language.get("CONNECT"), null){

        @Override
        public JPopupMenu getPopupMenu() {
            return MachineDetailsPanel.this.accessPanelListener.getMachineConnectionMenu(MachineDetailsPanel.this.machine);
        }
    };
    private final ShPopupMenuButton terminalConnect = new ShPopupMenuButton(Language.get("CONNECT"), null){

        @Override
        public JPopupMenu getPopupMenu() {
            return MachineDetailsPanel.this.accessPanelListener.getMachineConnectionMenu(MachineDetailsPanel.this.machine);
        }
    };
    private final JToggleButton infoViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/dialogs/information-square.svg,16"));
    private final JToggleButton fileViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/files-folders/folder.svg,16"));
    private final JToggleButton historyViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/clock-simple.svg,16"));
    private final JToggleButton softwareViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/cube.svg,16"));
    private final JToggleButton notesViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
    private final JToggleButton appConnectionButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/computing/app-connection.svg,16"));
    private final JToggleButton advancedButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/gear.svg,16"));
    private final JToggleButton runToolResults = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/box.svg,16"));
    private final JButton upgradeButton = new JButton(Language.get("ACCESS_UPDATE"));
    private final JButton wol = new JButton(Language.get("SG_DO_WOL"));
    private final JButton linkButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/link.svg,16"));
    private final JToggleButton favouriteButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/star.svg,16"));
    private MonitoringSwitch monitorButton;
    private JLabel monitorLabel;
    private JLabel linkLabelURL;
    private JLabel linkLabelMobile;
    private JLabel linkLabelTech;
    private JLabel linkLabelCmd;
    private CopyToClipboardButton copyLinkButtonURL;
    private CopyToClipboardButton copyLinkButtonMobile;
    private CopyToClipboardButton copyLinkButtonTech;
    private CopyToClipboardButton copyLinkButtonCmd;
    private JPanel linkPanel;
    private JPanel linkPanelURL;
    private JPanel linkPanelMobile;
    private JPanel linkPanelTech;
    private JPanel linkPanelCmd;
    private JScrollPane scrollContent;
    private JScrollPane advancedContent;
    private MachineNotificationPanel notificationPanel;
    private MachineConfigurePanel configurePanel;
    private final Object CONFIGURE_LOCK = new Object();
    private TreeNodeFilterProcessor selectedFilterProcessor;
    private JPanel proconfiguredAppPanel;
    private String lastMachineID = "";
    private final Cache<String, GFile> dirs = new Cache("MachineDetailsPanel", 250);
    static RAClient previousRaClient;
    private MachineGroup parentGroupOfMachineToRename = null;
    private Machine machineToRename = null;
    boolean showDetailsPanel;

    public void showToolRunDialog(Machine machine, JButton source) {
        this.contentMultiple.runToolPopup(machine, source);
    }

    public MachineDetailsPanel(AccessPanelListener accessPanelListener, MachineTreeModel machineModel, AlertTreeModel alertModel) {
        super(accessPanelListener);
        this.accessPanelListener = accessPanelListener;
        this.model = machineModel;
        this.alertModel = alertModel;
        this.initUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.monitorButton) {
            this.accessPanelListener.setMonitoring(this.machine, this.monitorButton.isSelected());
        } else if (e.getSource() == this.linkButton) {
            this.showLinksFor(this.machine);
        } else if (e.getSource() == this.favouriteButton) {
            this.accessPanelListener.setMachineFavourite(this.machine, this.favouriteButton.isSelected());
        } else if (this.multipleSelection == null) {
            final AbstractButton source = (AbstractButton)e.getSource();
            source.setEnabled(false);
            Timer reenableTimer = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    source.setEnabled(true);
                    source.repaint();
                }
            });
            reenableTimer.setRepeats(false);
            reenableTimer.start();
            if (e.getSource() == this.connect.getSourceButton()) {
                this.accessPanelListener.connectToMachine(this.machine);
            } else if (e.getSource() == this.terminalConnect.getSourceButton()) {
                this.accessPanelListener.connectToMachine(this.machine, null, 4, false, false);
            } else if (e.getSource() == this.wol) {
                this.accessPanelListener.doWakeOnLan(new Machine[]{this.machine});
            } else if (e.getSource() == this.upgradeButton) {
                this.accessPanelListener.upgradeMachines(new Machine[]{this.machine});
            }
        }
    }

    private void switchToInfoView() {
        this.handleViewSwitch(this.infoViewButton);
    }

    private void showLinksFor(Machine machine) {
        if (this.linkPanel.isVisible()) {
            this.linkPanel.setVisible(false);
        } else {
            this.setLinkText(machine);
            this.linkPanel.setVisible(true);
        }
    }

    private void setLinkText(Machine machine) {
        String machineName = machine.getMachineName().toString();
        String machineID = machine.getMachineID();
        try {
            machineName = URLEncoder.encode(machineName, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        TechClient client = this.accessPanelListener.getTechClient();
        String linkByID = SHJWUtil.getUpdateURLProtocol() + "://" + client.getHost() + ":" + client.getPort() + "/technician?machine=" + machineID;
        String linkByTechClient = OemBranding.OEM_PROTOCOL_NAME + "://?JW_machine=" + machineID;
        String linkByCmdLine = "TechClient.exe JWVAPP SessionUI JW_launchapi=yes JW_machine=" + machineID;
        this.linkLabelURL.setText(linkByID);
        this.linkLabelTech.setText(linkByTechClient);
        this.linkLabelCmd.setText(linkByCmdLine);
        this.linkLabelMobile.setText(SHJWUtil.getUpdateURLProtocol() + "://" + client.getHost() + ":" + client.getPort() + "/mobile?mach=" + machineID);
    }

    private void initLinksPanel() {
        JLabel descMobile = null;
        JLabel descURL = new JLabel(Language.get("ACCESS_URL_LABEL") + ": ");
        if (Switches.SH_addDirectMobileLink) {
            descURL = new JLabel(Language.get("ACCESS_DIRECT_URL_DOWNLOAD") + ": ");
        }
        this.linkLabelURL = new JLabel(""){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale((int)10);
                return dim;
            }
        };
        descURL.setForeground(AccessStyle.GROUP_TITLE_FONT_COLOR);
        this.copyLinkButtonURL = new CopyToClipboardButton(){

            @Override
            public String getClipboardText() {
                return MachineDetailsPanel.this.linkLabelURL.getText();
            }
        };
        descURL.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkLabelURL.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkPanelURL = new JPanel(new BorderLayout(5, 5));
        this.linkPanelURL.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10)));
        this.linkPanelURL.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.linkPanelURL.add((Component)descURL, "West");
        this.linkPanelURL.add((Component)this.linkLabelURL, "Center");
        this.linkPanelURL.add(this.copyLinkButtonURL.getRootComponent(), "East");
        descMobile = new JLabel(Language.get("ACCESS_DIRECT_URL_MOBILE") + ": ");
        this.linkLabelMobile = new JLabel(""){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale((int)10);
                return dim;
            }
        };
        descMobile.setForeground(AccessStyle.GROUP_TITLE_FONT_COLOR);
        this.copyLinkButtonMobile = new CopyToClipboardButton(){

            @Override
            public String getClipboardText() {
                return MachineDetailsPanel.this.linkLabelMobile.getText();
            }
        };
        descMobile.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkLabelMobile.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkPanelMobile = new JPanel(new BorderLayout(5, 5));
        this.linkPanelMobile.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10)));
        this.linkPanelMobile.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.linkPanelMobile.add((Component)descMobile, "West");
        this.linkPanelMobile.add((Component)this.linkLabelMobile, "Center");
        this.linkPanelMobile.add(this.copyLinkButtonMobile.getRootComponent(), "East");
        JLabel descTech = new JLabel(Language.get("ACCESS_TECH_URL_LABEL") + ": ");
        this.linkLabelTech = new JLabel(""){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale((int)10);
                return dim;
            }
        };
        descTech.setForeground(AccessStyle.GROUP_TITLE_FONT_COLOR);
        this.copyLinkButtonTech = new CopyToClipboardButton(){

            @Override
            public String getClipboardText() {
                return MachineDetailsPanel.this.linkLabelTech.getText();
            }
        };
        descTech.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkLabelTech.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkPanelTech = new JPanel(new BorderLayout(5, 5));
        this.linkPanelTech.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10)));
        this.linkPanelTech.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.linkPanelTech.add((Component)descTech, "West");
        this.linkPanelTech.add((Component)this.linkLabelTech, "Center");
        this.linkPanelTech.add(this.copyLinkButtonTech.getRootComponent(), "East");
        JLabel descCmd = new JLabel(Language.get("ACCESS_TECH_CMD_LABEL") + ": ");
        this.linkLabelCmd = new JLabel(""){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale((int)10);
                return dim;
            }
        };
        descCmd.setForeground(AccessStyle.GROUP_TITLE_FONT_COLOR);
        this.copyLinkButtonCmd = new CopyToClipboardButton(){

            @Override
            public String getClipboardText() {
                return MachineDetailsPanel.this.linkLabelCmd.getText();
            }
        };
        descCmd.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkLabelCmd.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.linkPanelCmd = new JPanel(new BorderLayout(5, 5));
        this.linkPanelCmd.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10)));
        this.linkPanelCmd.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.linkPanelCmd.add((Component)descCmd, "West");
        this.linkPanelCmd.add((Component)this.linkLabelCmd, "Center");
        this.linkPanelCmd.add(this.copyLinkButtonCmd.getRootComponent(), "East");
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{descURL, descTech, descCmd});
        this.linkPanel = new JPanel();
        if (Switches.SH_addDirectMobileLink) {
            this.linkPanel.setLayout(new GridLayout(4, 1));
        } else {
            this.linkPanel.setLayout(new GridLayout(3, 1));
        }
        this.linkPanel.add(this.linkPanelURL);
        if (Switches.SH_addDirectMobileLink) {
            this.linkPanel.add(this.linkPanelMobile);
        }
        this.linkPanel.add(this.linkPanelTech);
        this.linkPanel.add(this.linkPanelCmd);
        SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{descURL, descMobile, descTech, descCmd});
        this.linkPanel.setVisible(false);
    }

    @Override
    protected void initButtonBar() {
        super.initButtonBar();
        this.infoViewButton.setToolTipText(Language.get("ACCESS_INFO_TOOLTIP"));
        this.fileViewButton.setToolTipText(Language.get("ACCESS_FILES_TOOLTIP"));
        this.historyViewButton.setToolTipText(Language.get("ACCESS_HISTORY_TOOLTIP"));
        this.softwareViewButton.setToolTipText(Language.get("ACCESS_SOFTWARE_TOOLTIP"));
        this.notesViewButton.setToolTipText(Language.get("ACCESS_NOTES_TOOLTIP"));
        this.appConnectionButton.setToolTipText(Language.get("ACCESS_SERVICE_TOOLTIP"));
        this.advancedButton.setToolTipText(Language.get("ACCESS_ADVANCED_TOOLTIP"));
        this.runToolResults.setToolTipText(Language.get("TOOLBOX_RESULTS"));
        if (GroupAccessKeyset.useTrimmedUI()) {
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.infoViewButton, this.fileViewButton});
        } else if (Switches.SH_softwareStore) {
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.infoViewButton, this.fileViewButton, this.runToolResults, this.appConnectionButton, this.historyViewButton, this.softwareViewButton, this.notesViewButton, this.advancedButton});
        } else {
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.infoViewButton, this.fileViewButton, this.runToolResults, this.appConnectionButton, this.historyViewButton, this.notesViewButton, this.advancedButton});
        }
        this.setViewsPanelButtons(true, true, true, true, true, true, true, true);
        this.infoViewButton.setSelected(true);
        this.buttonBarMiddle.add((Component)((Object)this.connect), 0);
        this.buttonBarMiddle.add((Component)((Object)this.terminalConnect), 1);
        if (!GroupAccessKeyset.useTrimmedUI()) {
            this.buttonBarMiddle.add((Component)this.upgradeButton, 2);
            this.buttonBarMiddle.add((Component)this.wol, 3);
        }
        JPanel smallButtonsPanel = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)5), 0));
        smallButtonsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        if (!GroupAccessKeyset.useTrimmedUI()) {
            smallButtonsPanel.add((Component)this.linkButton, "Center");
        }
        smallButtonsPanel.add((Component)this.favouriteButton, "East");
        this.linkButton.setToolTipText(Language.get("ACCESS_LINK_TOOLTIP"));
        this.favouriteButton.setToolTipText(Language.get("ACCESS_FAVOURITE_TOOLTIP"));
        SwingUtil.setWidth((JComponent)this.linkButton, (int)this.fileViewButton.getPreferredSize().width);
        SwingUtil.setWidth((JComponent)this.favouriteButton, (int)this.fileViewButton.getPreferredSize().width);
        JPanel monitorPanel = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5)));
        monitorPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.monitorButton = new MonitoringSwitch();
        this.monitorButton.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.monitorButton.addActionListener(this);
        this.monitorLabel = new JLabel(Language.get("MONITOR"));
        this.monitorLabel.setFont(AccessStyle.GROUP_MONITOR_FONT);
        this.monitorLabel.setForeground(AccessStyle.GROUP_TITLE_FONT_COLOR);
        if (!GroupAccessKeyset.useTrimmedUI()) {
            monitorPanel.add((Component)this.monitorLabel, "West");
            monitorPanel.add((Component)this.monitorButton, "Center");
        }
        monitorPanel.add((Component)smallButtonsPanel, "East");
        this.buttonBarRight.add((Component)monitorPanel, "West");
        this.terminalConnect.addActionListener(this);
        this.connect.addActionListener(this);
        this.wol.addActionListener(this);
        this.upgradeButton.addActionListener(this);
        this.linkButton.addActionListener(this);
        this.favouriteButton.addActionListener(this);
        int targetHeight = super.getButtonHeight();
        SwingUtil.setHeight((JComponent)((Object)this.terminalConnect), (int)targetHeight);
        SwingUtil.setHeight((JComponent)this.wol, (int)targetHeight);
        SwingUtil.setHeight((JComponent)this.runToolResults, (int)targetHeight);
        SwingUtil.setHeight((JComponent)this.upgradeButton, (int)targetHeight);
        SwingUtil.setHeight((JComponent)this.linkButton, (int)targetHeight);
        SwingUtil.setHeight((JComponent)this.favouriteButton, (int)targetHeight);
        this.initLinksPanel();
        this.buttonBar.add((Component)this.linkPanel, "South");
    }

    @Override
    protected void initUI() {
        this.historyPanel = new MachineDetailsHistoryPanel();
        this.softwarePanel = new MachineDetailsSoftwarePanel();
        this.scrollContent = new JScrollPane((Component)this.contentSingle);
        this.scrollContent.setBorder(SHBorderFactory.createEmptyBorder());
        this.advancedPanel = new AdvancedPanel(this.accessPanelListener);
        this.advancedContent = new JScrollPane((Component)((Object)this.advancedPanel));
        this.advancedContent.setBorder(SHBorderFactory.createEmptyBorder());
        this.scrollContent.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.scrollContent.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.advancedContent.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.advancedContent.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.runToolResultsPanel = new RunToolResultsPanel(this.accessPanelListener);
        super.initUI();
        this.contentMultiple = new AdvancedPanel(this.accessPanelListener);
        this.sessionTable = new ActiveSessionTable(this.model, this.accessPanelListener);
        this.rdpSessionTable = new RDPSessionTable(this.model, this.accessPanelListener);
        this.alertTable = new MachineAlertsTable(this.alertModel, this.accessPanelListener);
        this.systemSection = this.singleWrapper.addContent((JComponent)((Object)this.system), null);
        this.problemsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)10));
        this.problemsSection = this.singleWrapper.addContent((JComponent)((Object)this.problemsPanel), null, false);
        this.problemsSection.setVisible(false);
        this.cpuMemoryMetricsRow = new MetricsRow(false);
        this.statsSection = this.singleWrapper.addContent(this.cpuMemoryMetricsRow.getRootComponent(), null);
        this.sessionSection = this.singleWrapper.addContent(this.sessionTable.getRootComponent(), Language.get("ACTIVE_SESSIONS"));
        this.rdpSection = this.singleWrapper.addContent(this.rdpSessionTable.getRootComponent(), Language.get("RDP_SESSIONS"));
        this.alertSection = this.singleWrapper.addContent(this.alertTable.getRootComponent(), Language.get("ALERTS"), new StrippedContentPanel.StrippedContentPanelListener(){

            @Override
            public void sectionExpanded() {
                MachineDetailsPanel.this.loadAllAlerts();
            }
        }, Language.get("TOOLTIP_SHOW_ALL_ALERTS"));
        this.disksPanel = new GbPanel();
        this.disksPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)10));
        this.disksSection = this.singleWrapper.addContent((JComponent)this.disksPanel, Language.get("ACCESS_DISK_USAGE"));
        this.cpuPanel = new GbPanel();
        this.cpuPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)10));
        this.cpuSection = this.singleWrapper.addContent((JComponent)this.cpuPanel, Language.get("ACCESS_PROCESS_OFFENDERS"));
        this.networkPanel = new GbPanel();
        this.networkPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)10));
        this.networkSection = this.singleWrapper.addContent((JComponent)this.networkPanel, Language.get("ACCESS_NETWORK_IPS"));
        this.hardwareDetails.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)10));
        this.hardwareSection = this.singleWrapper.addContent((JComponent)this.hardwareDetails.getRootComponent(), Language.get("ACCESS_HARDWARE"));
        this.versionLabel = new JLabel();
        this.versionLabel.setFont(SHStyle.smallFont);
        this.versionLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.versionLabel.setHorizontalAlignment(0);
        this.versionLabel.setVerticalAlignment(3);
        this.versionLabel.setOpaque(true);
        this.versionLabel.setBorder(SHBorderFactory.createEmptyBorder((int)30, (int)0, (int)0, (int)0));
        this.contentSingle.add((Component)this.versionLabel, 0, this.contentSingle.getComponentCount(), 1, 1, 10, 1, 10, 1);
        int targetHeight = this.connect.getPreferredSize().height;
        this.alertSection.setButtonHeight(targetHeight);
        this.appTunnelUI = new AppTunnelUI(this.accessPanelListener);
        this.servicesPanel.setLayout(new GridLayout(1, 1));
        this.servicesPanel.add(this.appTunnelUI.getRootComponent());
    }

    public void updateUIWithPermissions(TechGroupPermissions permissions) {
        this.contentMultiple.initUIWithPermissions(permissions);
        this.advancedPanel.initUIWithPermissions(permissions);
        this.system.initUIWithPermissions(permissions);
        boolean canManageMonitoring = this.accessPanelListener.getTechClient().getTechUser().getPermissions().canManageMonitoring();
        this.monitorLabel.setVisible(canManageMonitoring);
        this.monitorButton.setVisible(canManageMonitoring);
        this.historyPanel.setTechClient(this.accessPanelListener.getTechClient());
        this.softwarePanel.setTechClient(this.accessPanelListener.getTechClient());
    }

    private int boundRGB(int col) {
        col = Math.max(0, col);
        return Math.min(col, 255);
    }

    private Color getColorForSeverity(double severity) {
        int grey = SHStyle.PANEL_BACKGROUND_DARKER.getRed();
        int red = grey + (int)((double)(255 - grey) * severity);
        int green = grey - (int)(60.0 * severity);
        int blue = grey - (int)(60.0 * severity);
        return new Color(this.boundRGB(red), this.boundRGB(green), this.boundRGB(blue));
    }

    private void initUIForMultipleMachines(TreeSelection<MachineGroup, Machine> selection) {
        this.selection = null;
        this.multipleSelection = (MachineSelection)selection;
        if (this.selectedFilterProcessor instanceof StopMachineFilter) {
            StopSGServiceUI ui = ((StopMachineFilter)this.selectedFilterProcessor).getUi();
            this.setCoreComponent((JPanel)ui.getRootComponent());
            ui.setSelectedMachines((Machine[])selection.getAllElements());
            return;
        }
        if (this.selectedFilterProcessor instanceof UpdateMachineFilter) {
            UpdateSGServiceUI ui = ((UpdateMachineFilter)this.selectedFilterProcessor).getUi();
            this.setCoreComponent((JPanel)ui.getRootComponent());
            ui.setSelectedMachines((Machine[])selection.getAllElements());
            return;
        }
        this.contentMultiple.initSelectedMachines(this.multipleSelection);
        if (this.accessPanelListener.getTechClient().amOverMachineLimit()) {
            BorderPanel bp = new BorderPanel();
            bp.addCenter((JComponent)((Object)this.contentMultiple));
            ProblemsPanel pp = new ProblemsPanel();
            pp.initFor(null, this.accessPanelListener.getTechClient());
            bp.addNorth((JComponent)((Object)pp));
            this.setCoreComponent((JPanel)bp);
        } else {
            this.setCoreComponent((JPanel)((Object)this.contentMultiple));
        }
        this.rootComponent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUIWithNotificationForMachines(Machine[] machines) {
        if (this.rootComponent.getComponentCount() == 0 || this.rootComponent.getComponent(0) != this.contentNotify) {
            this.rootComponent.removeAll();
            this.rootComponent.add(this.contentNotify);
        }
        this.contentNotify.removeAll();
        Object object = this.CONFIGURE_LOCK;
        synchronized (object) {
            this.notificationPanel = new MachineNotificationPanel(machines, this.accessPanelListener, this);
            this.notificationPanel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
            this.contentNotify.add((Component)this.notificationPanel.getRootComponent(), "Center");
        }
        this.accessPanelListener.setDetailsPanelScrollPaneEnabled(false);
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUIWithPreconfiguredAccessApps() {
        if (this.rootComponent.getComponentCount() == 0 || this.rootComponent.getComponent(0) != this.contentPreconfigured) {
            this.rootComponent.removeAll();
            this.rootComponent.add(this.contentPreconfigured);
        }
        this.contentPreconfigured.removeAll();
        Object object = this.CONFIGURE_LOCK;
        synchronized (object) {
            AppProfileUI ui = AppProfileUI.getAppProfileUI(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.accessPanelListener.getTechClient(), AppProfiles.PROFILE_REMOTE_ACCESS);
            this.proconfiguredAppPanel = ui.getRootComponent();
            ui.setCloseListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MachineDetailsPanel.this.proconfiguredAppPanel = null;
                    MachineDetailsPanel.this.done();
                }
            });
            this.contentPreconfigured.add((Component)this.proconfiguredAppPanel, "Center");
        }
        this.accessPanelListener.setDetailsPanelScrollPaneEnabled(false);
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUIWithConfigureForMachine(Machine machine) {
        if (this.rootComponent.getComponentCount() == 0 || this.rootComponent.getComponent(0) != this.contentConfigure) {
            this.rootComponent.removeAll();
            this.rootComponent.add(this.contentConfigure);
        }
        this.contentConfigure.removeAll();
        Object object = this.CONFIGURE_LOCK;
        synchronized (object) {
            this.configurePanel = new MachineConfigurePanel(machine, this.accessPanelListener, this);
            this.configurePanel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
            this.contentConfigure.add((Component)this.configurePanel.getRootComponent(), "Center");
        }
        this.accessPanelListener.setDetailsPanelScrollPaneEnabled(false);
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    private boolean isAlreadySelected(TreeSelection.SelectedGroup newSelection) {
        if (this.selection == null) {
            return false;
        }
        if (newSelection == null) {
            return false;
        }
        Machine current = (Machine)this.selection.getFirstMachine();
        Machine newMachine = (Machine)newSelection.getFirstMachine();
        return current.getMachineID().equals(newMachine.getMachineID());
    }

    public JComponent getChild(JPanel parent, int row, int column, int width) {
        int index = row * width + column;
        if (index >= parent.getComponentCount()) {
            return null;
        }
        return (JComponent)parent.getComponent(index);
    }

    public void initUIWithNoSelection() {
        this.selection = null;
        this.multipleSelection = null;
        this.setCoreComponent(new JPanel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUIWithSingleMachine(TreeSelection.SelectedGroup selection) {
        AbstractSGServiceUI ui;
        boolean machineAlreadySelected;
        Object object = this.CONFIGURE_LOCK;
        synchronized (object) {
            machineAlreadySelected = this.isAlreadySelected(selection);
            if (machineAlreadySelected && this.notificationPanel != null && this.notificationPanel.isConfiguring()) {
                return;
            }
            if (this.notificationPanel != null) {
                this.notificationPanel.stopConfiguring(false);
                this.notificationPanel = null;
                this.accessPanelListener.setContentsPanelVisible(true);
            }
            if (machineAlreadySelected && this.configurePanel != null && this.configurePanel.isConfiguring((Machine)selection.getFirstMachine())) {
                return;
            }
            if (this.configurePanel != null) {
                this.configurePanel.stopConfiguring(false);
                this.configurePanel = null;
                this.accessPanelListener.setContentsPanelVisible(true);
            }
            if (this.proconfiguredAppPanel != null) {
                return;
            }
        }
        this.selection = selection;
        this.multipleSelection = null;
        if (selection == null) {
            this.machine = null;
        } else {
            this.machine = (Machine)selection.getFirstMachine();
            this.parentGroup = (MachineGroup)selection.group;
            if (!machineAlreadySelected) {
                LogGatherer.setSelectedMachine(this.machine);
            }
        }
        if (this.machine == null) {
            this.setCoreComponent(new JPanel());
            return;
        }
        if (!this.containerSingle.isVisible()) {
            this.containerSingle.setVisible(true);
        }
        if (this.selectedFilterProcessor instanceof StopMachineFilter) {
            ui = ((StopMachineFilter)this.selectedFilterProcessor).getUi();
            this.setCoreComponent((JPanel)ui.getRootComponent());
            ui.setSelectedMachines(new Machine[]{(Machine)selection.getFirstMachine()});
        } else if (this.selectedFilterProcessor instanceof UpdateMachineFilter) {
            ui = ((UpdateMachineFilter)this.selectedFilterProcessor).getUi();
            this.setCoreComponent((JPanel)ui.getRootComponent());
            ui.setSelectedMachines(new Machine[]{(Machine)selection.getFirstMachine()});
        } else {
            MachineInfo info;
            block70: {
                ScaledInsets tableInsets;
                boolean showMonitoringMetrics;
                boolean showScreenshots;
                block68: {
                    this.setCoreComponent(this.containerSingle);
                    this.initButtonBarFor(this.machine);
                    if (!machineAlreadySelected) {
                        this.initFSPaneFor(this.machine);
                    }
                    this.sessionTable.setSessions(this.machine.getActiveSessions_ClientOnly());
                    this.rdpSessionTable.setSessions(this.machine, this.machine.getRDPSessions());
                    this.alertTable.setTriggeredAlerts(this.machine);
                    this.appTunnelUI.setSelectedMachine(this.machine);
                    this.runToolResultsPanel.setSelectedMachine(this.machine);
                    boolean showMonitoring = this.accessPanelListener.getTechClient().getPermissions().canViewMetrics();
                    showScreenshots = this.accessPanelListener.getTechClient().getPermissions().canViewScreenshots() && showMonitoring;
                    showMonitoringMetrics = this.accessPanelListener.getTechClient().getPermissions().canViewMetrics() && showMonitoring;
                    info = this.machine.getMachineInfo();
                    this.system.initSystemPanelWith(this.machine);
                    this.system.setVisible(true);
                    if (!machineAlreadySelected) {
                        this.loadHistoryForMachine();
                    }
                    if (Switches.SH_softwareStore && this.softwareViewButton.isSelected()) {
                        this.softwarePanel.softwareSubPanel.showMachineSoftware(this.getSelectedMachine());
                    }
                    if (this.machine.hasAnyProblem()) {
                        this.problemsSection.setVisible(true);
                        this.problemsPanel.initFor(this.machine, this.accessPanelListener.getTechClient());
                    } else {
                        this.problemsSection.setVisible(false);
                    }
                    MachineSelection sel = new MachineSelection();
                    sel.addMachines((TreeGroup)selection.group, new Machine[]{this.machine});
                    this.advancedPanel.initSelectedMachines(sel);
                    this.notesPanel.initForMachine(this.machine);
                    this.updateNotesIcon();
                    this.setLinkText(this.machine);
                    this.favouriteButton.setSelected(this.accessPanelListener.isMachineFavourite(this.machine));
                    if (this.machine.isAvailable() && this.machine.getActiveSessionCount_ClientOnly() > 0) {
                        this.sessionSection.setVisible(true);
                    } else {
                        this.sessionSection.setVisible(false);
                    }
                    this.rdpSection.setVisible(this.machine.isAvailable() && this.machine.getRDPSessionCount() > 0);
                    this.alertSection.setVisible(this.machine.isAvailable() && this.machine.getMachineInfo().getTriggeredAlertIDs().size() > 0);
                    tableInsets = new ScaledInsets(0, 0, 0, 0);
                    if (info != null && this.machine.isAvailable() && this.machine.allowMonitoring() && this.machine.isMonitored() && showMonitoringMetrics) {
                        Object labels;
                        int i;
                        int count;
                        int rowIndex;
                        int i2;
                        this.statsSection.setVisible(true);
                        this.cpuMemoryMetricsRow.setData(info.getCpu(), info.getMem(), info.getLoadAverageData());
                        Message m = info.getDetailedDisks();
                        try {
                            if (m != null) {
                                DiskRow row;
                                m.resetIndex();
                                ArrayList<DiskRow> diskRows = new ArrayList<DiskRow>();
                                for (i2 = 0; i2 < m.length(); i2 += 2) {
                                    row = new DiskRow();
                                    row.name = m.getNextString();
                                    row.val = m.getNextDouble();
                                    if (Double.isNaN(row.val) || Double.isInfinite(row.val)) continue;
                                    diskRows.add(row);
                                }
                                Collections.sort(diskRows);
                                for (rowIndex = 0; rowIndex < diskRows.size(); ++rowIndex) {
                                    row = (DiskRow)diskRows.get(rowIndex);
                                    String name = row.name;
                                    double val = row.val;
                                    DiskLabels labels2 = this.getDiskRow(rowIndex, (Insets)tableInsets);
                                    labels2.left.setText(this.df.format(val) + " %");
                                    labels2.right.setText(name);
                                    double severity = Math.min(1.0, Math.max(0.0, (val - 50.0) / 50.0));
                                    Color color = this.getColorForSeverity(severity);
                                    labels2.left.setBackground(color);
                                    labels2.icon.setBackground(color);
                                }
                                count = diskRows.size();
                                for (i = this.diskLabelList.size() - 1; i >= count; --i) {
                                    labels = this.diskLabelList.remove(i);
                                    this.disksPanel.remove((Component)((DiskLabels)labels).icon);
                                    this.disksPanel.remove((Component)((DiskLabels)labels).left);
                                    this.disksPanel.remove((Component)((DiskLabels)labels).right);
                                }
                                this.disksSection.setVisible(m.length() > 0);
                                this.disksPanel.revalidate();
                                this.disksPanel.repaint();
                            } else {
                                this.disksSection.setVisible(false);
                            }
                        }
                        catch (Throwable t) {
                            this.disksSection.setVisible(false);
                            System.out.println("[MachineDetailsPanel] Problem processing disks section");
                            System.out.println(m);
                            t.printStackTrace();
                        }
                        m = info.getDetailedProcs();
                        try {
                            if (m != null) {
                                m.resetIndex();
                                ArrayList<ProcessRow> processRows = new ArrayList<ProcessRow>();
                                for (i2 = 0; i2 < m.length(); i2 += 2) {
                                    ProcessRow row = new ProcessRow();
                                    row.name = m.getNextString();
                                    row.val = m.getNextDouble();
                                    processRows.add(row);
                                }
                                Collections.sort(processRows);
                                for (rowIndex = 0; rowIndex < processRows.size(); ++rowIndex) {
                                    ProcessRow row = (ProcessRow)processRows.get(rowIndex);
                                    labels = this.getCPURow(rowIndex, (Insets)tableInsets);
                                    ((CPULabels)labels).left.setText(this.df.format(row.val) + " %");
                                    ((CPULabels)labels).right.setText(row.name);
                                    double severity = Math.min(1.0, Math.max(0.0, (row.val - 50.0) / 50.0));
                                    Color color = this.getColorForSeverity(severity);
                                    ((CPULabels)labels).left.setBackground(color);
                                    ((CPULabels)labels).icon.setBackground(color);
                                }
                                count = processRows.size();
                                for (i = this.cpuLabelList.size() - 1; i >= count; --i) {
                                    labels = this.cpuLabelList.remove(i);
                                    this.cpuPanel.remove((Component)((CPULabels)labels).icon);
                                    this.cpuPanel.remove((Component)((CPULabels)labels).left);
                                    this.cpuPanel.remove((Component)((CPULabels)labels).right);
                                }
                                this.cpuSection.setVisible(m.length() != 0);
                                this.cpuPanel.revalidate();
                                this.cpuPanel.repaint();
                                break block68;
                            }
                            this.cpuSection.setVisible(false);
                        }
                        catch (Throwable t) {
                            this.cpuSection.setVisible(false);
                            System.out.println("[MachineDetailsPanel] Problem processing CPU section");
                            System.out.println(m);
                            t.printStackTrace();
                        }
                    } else {
                        this.cpuSection.setVisible(false);
                        this.disksSection.setVisible(false);
                        this.statsSection.setVisible(false);
                    }
                }
                if (showScreenshots && this.machine.isAvailable() && this.machine.allowMonitoring()) {
                    block69: {
                        if (info != null) {
                            if (this.previousScreenshot == null || this.previousScreenshotHashcode == 0 || this.previousScreenshotHashcode != info.getSmallScreenHash()) {
                                try {
                                    if (info.getSmallScreenJpeg() != null) {
                                        this.previousScreenshot = ImageIO.read(new ByteArrayInputStream(info.getSmallScreenJpeg()));
                                        break block69;
                                    }
                                    this.previousScreenshot = null;
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                        } else {
                            this.previousScreenshot = null;
                        }
                    }
                    this.system.setImage(this.previousScreenshot);
                } else {
                    this.system.setImage(null);
                }
                if (info != null && showMonitoringMetrics) {
                    String wip = info.getWanIP();
                    try {
                        if (wip == null) {
                            wip = "";
                        }
                        if (wip.trim().length() > 0) {
                            NetAdapter[] all;
                            int rowIndex = 0;
                            double mbit = info.getWifiMbit();
                            double signal = info.getWifiSignalPc();
                            if (mbit != -1.0) {
                                // empty if block
                            }
                            NetworkLabels labels = this.getNetworkRow(rowIndex, (Insets)tableInsets);
                            labels.icon.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/world.svg,16"));
                            labels.icon.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)1, (int)6));
                            labels.name.setText("WAN");
                            labels.ip.setText("<html><font color=#626262>IP:</font> " + wip);
                            labels.mac.setText("");
                            for (NetAdapter na : all = info.getNetAdapters()) {
                                labels = this.getNetworkRow(++rowIndex, (Insets)tableInsets);
                                labels.icon.setIcon(ImageLoader.getImageIcon((String)"images/svg/computing/network.svg,16"));
                                labels.icon.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)1, (int)6));
                                labels.name.setText("<html>" + na.name);
                                labels.ip.setText("<html><font color=#626262>IP:</font> " + na.ip);
                                labels.mac.setText("<html><font color=#626262>Mac:</font> " + na.mac);
                            }
                            ++rowIndex;
                            for (int i = this.networkLabelList.size() - 1; i >= rowIndex; --i) {
                                labels = this.networkLabelList.remove(i);
                                this.networkPanel.remove((Component)labels.icon);
                                this.networkPanel.remove((Component)labels.ip);
                                this.networkPanel.remove((Component)labels.mac);
                                this.networkPanel.remove((Component)labels.name);
                            }
                            this.networkSection.setVisible(true);
                            this.networkPanel.revalidate();
                            this.networkPanel.repaint();
                            break block70;
                        }
                        this.networkSection.setVisible(false);
                    }
                    catch (Throwable t) {
                        if (this.networkSection != null) {
                            this.networkSection.setVisible(false);
                        }
                        System.out.println("[MachineDetailsPanel] Problem processing IP/LAN section");
                        System.out.println(wip);
                        t.printStackTrace();
                    }
                } else if (this.networkSection != null) {
                    this.networkSection.setVisible(false);
                }
            }
            if (!machineAlreadySelected) {
                if (info != null && info.getHardwareDetails() != null) {
                    BasicInfo basicInfo = info.getHardwareDetails();
                    try {
                        this.hardwareDetails.initFor(basicInfo);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.hardwareSection.setVisible(true);
                } else if (this.hardwareSection != null) {
                    this.hardwareSection.setVisible(false);
                }
            }
            if (this.machine.getAccessServiceVersion() != null) {
                String version = this.machine.getAccessServiceVersion();
                boolean hasSub = VersionUtil.getMajorMinorSubFrom(version).length > 2;
                String buildHMS = Version.getBuildDateFromFullVersion(this.machine.getBuild());
                if (hasSub || buildHMS == null) {
                    this.versionLabel.setText(Language.get("SERVICE_VERSION") + " " + version);
                } else {
                    this.versionLabel.setText(Language.get("SERVICE_VERSION") + " " + version + " " + buildHMS);
                }
            } else {
                this.versionLabel.setText(" ");
            }
            this.singleWrapper.setBackgroundColours();
            this.versionLabel.setBackground(this.singleWrapper.getLastColor());
        }
        this.rootComponent.repaint();
    }

    private void updateNotesIcon() {
        String notes = this.machine.getMachineInfo().getNotes();
        String warnings = this.machine.getMachineInfo().getWarnings();
        if (!(notes != null && notes.length() != 0 || warnings != null && warnings.length() != 0)) {
            Icon notesIcon = ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16");
            this.notesViewButton.setIcon(notesIcon);
        } else {
            Icon notesIcon = ImageLoader.getImageIcon((String)"O[images/svg/general/pencil.svg,16 | images/svg/bulbs/bulb-green.svg,8]");
            this.notesViewButton.setIcon(notesIcon);
        }
    }

    private boolean canAccessFiles(Machine machine) {
        return Version.canProvideFsyncAccess(machine.getBuild());
    }

    private void initFSPaneFor(Machine machine) {
        this.fsPanel.setRemoteOS(machine.getOsBaseType());
        this.dirs.addToCache((Object)this.lastMachineID, (Object)this.fsPanel.getCurrentDir());
        if (!this.canAccessFiles(machine)) {
            this.fsPanel.initUI((RootPaneContainer)((Object)this.getRootComponent().getRootPane().getParent()), null, null, null);
            this.lastMachineID = "none selected";
        } else if (!machine.getMachineID().equals(this.lastMachineID)) {
            this.lastMachineID = machine.getMachineID();
            System.out.println("[FSPane] Initing file access for " + this.lastMachineID + " (" + this.dirs.getFromCache((Object)this.lastMachineID) + ")");
            this.fsPanel.setMonitoringOnly(this.accessPanelListener.getTechClient().isMonitoringOnly());
            FsUpgrade upgrader = new FsUpgrade(machine.getMachineID(), machine.getBuild());
            this.fsPanel.initUI((RootPaneContainer)((Object)this.getRootComponent().getRootPane().getParent()), new TechClientFS(this.accessPanelListener.getTechClient(), this.lastMachineID), (GFile)this.dirs.getFromCache((Object)this.lastMachineID), upgrader);
        }
    }

    private void initButtonBarFor(Machine machine) {
        TechGroupPermissions permissions = this.accessPanelListener.getTechClient().getPermissions();
        this.connect.setVisible(machine.isAvailable() && !machine.needsUpgrading() && !machine.isHeadless());
        this.terminalConnect.setVisible(machine.isAvailable() && !machine.needsUpgrading() && machine.isHeadless());
        boolean canViewFiles = machine.isAvailable() && machine.supportsMonitoring() && machine.allowScripting();
        boolean canAppTunnel = machine.isAvailable() && permissions.canUseAppTunnels();
        boolean viewRunToolResults = machine.isAvailable() && machine.allowScripting() && permissions.canRunTools();
        this.setViewsPanelButtons(true, canViewFiles, canAppTunnel, true, true, true, true, viewRunToolResults);
        this.upgradeButton.setVisible(machine.isAvailable() && machine.needsUpgrading() && permissions.canManagePersistentConnections());
        boolean canCopyFiles = permissions.canCopyFiles();
        this.fsPanel.setVisible(machine.isAvailable() && !machine.needsUpgrading() && canCopyFiles);
        this.wol.setVisible(!machine.isAvailable());
        boolean canManageMonitoring = permissions.canManageMonitoring();
        if (canManageMonitoring && machine.isAvailable() && machine.allowMonitoring()) {
            this.monitorButton.setVisible(true);
            this.monitorButton.setSelected(machine.isMonitored());
            this.monitorLabel.setVisible(true);
            this.monitorLabel.setIcon(null);
            this.monitorLabel.setText(Language.get("MONITOR"));
        } else {
            this.monitorButton.setVisible(false);
            if (!machine.isAvailable() || !machine.supportsMonitoring()) {
                this.monitorLabel.setVisible(false);
            } else {
                this.monitorLabel.setVisible(true);
                this.monitorLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/accessdenied.svg,16"));
                this.monitorLabel.setText(Language.get("MONITOR_DENIED"));
            }
        }
    }

    private NetworkLabels getNetworkRow(int rowIndex, Insets tableInsets) {
        if (rowIndex < this.networkLabelList.size()) {
            return this.networkLabelList.get(rowIndex);
        }
        NetworkLabels labels = new NetworkLabels();
        labels.icon = new JLabel();
        labels.name = new JWrapLabel();
        labels.ip = new JLabel();
        labels.mac = new JLabel();
        this.networkPanel.add((Component)labels.icon, 0, rowIndex, 1, 1, 0, 0, 17, 2, tableInsets);
        this.networkPanel.add((Component)labels.name, 1, rowIndex, 1, 1, 10, 1, 13, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.networkPanel.add((Component)labels.ip, 2, rowIndex, 1, 1, 3, 1, 17, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.networkPanel.add((Component)labels.mac, 3, rowIndex, 1, 1, 3, 1, 17, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.networkLabelList.add(labels);
        return labels;
    }

    private CPULabels getCPURow(int rowIndex, Insets tableInsets) {
        if (rowIndex < this.cpuLabelList.size()) {
            return this.cpuLabelList.get(rowIndex);
        }
        CPULabels labels = new CPULabels();
        labels.left = new JLabel("", 4);
        labels.right = new AlertConfigPanel.TruncatingLabel("", 2);
        labels.icon = new JLabel(ImageLoader.getImageIcon((String)"images/svg/computing/window-2.svg,16"));
        labels.left.setOpaque(true);
        labels.left.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)3));
        labels.icon.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)6));
        this.cpuPanel.add((Component)labels.icon, 0, rowIndex, 1, 1, 0, 0, 17, 2, tableInsets);
        this.cpuPanel.add((Component)labels.left, 1, rowIndex, 1, 1, 0, 1, 13, 2, tableInsets);
        this.cpuPanel.add((Component)labels.right, 2, rowIndex, 1, 1, 1000, 1, 17, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.cpuLabelList.add(labels);
        return labels;
    }

    private DiskLabels getDiskRow(int rowIndex, Insets tableInsets) {
        if (rowIndex < this.diskLabelList.size()) {
            return this.diskLabelList.get(rowIndex);
        }
        DiskLabels labels = new DiskLabels();
        labels.left = new JLabel("", 4);
        labels.right = new AlertConfigPanel.TruncatingLabel("", 2);
        labels.icon = new JLabel(ImageLoader.getImageIcon((String)"images/svg/computing/disk.svg,16"));
        labels.left.setOpaque(true);
        labels.left.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)3));
        labels.icon.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)6));
        this.disksPanel.add((Component)labels.icon, 0, rowIndex, 1, 1, 0, 0, 17, 2, tableInsets);
        this.disksPanel.add((Component)labels.left, 1, rowIndex, 1, 1, 0, 1, 13, 2, tableInsets);
        this.disksPanel.add((Component)labels.right, 2, rowIndex, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.diskLabelList.add(labels);
        return labels;
    }

    private void setCoreComponent(JPanel newComponent) {
        if (this.rootComponent.getComponentCount() == 0 || this.rootComponent.getComponent(0) != newComponent) {
            this.rootComponent.removeAll();
            this.rootComponent.add(newComponent);
            this.accessPanelListener.setDetailsPanelScrollPaneEnabled(true);
            this.rootComponent.revalidate();
        }
    }

    public Machine getSelectedMachine() {
        return this.machine;
    }

    public void setSelectedMachine(TreeSelection<MachineGroup, Machine> selection) {
        if (selection != null) {
            this.initUIWithSingleMachine(selection.getFirstSelectedGroup());
        } else {
            this.initUIWithSingleMachine(null);
        }
    }

    public void setSelectedMachines(TreeSelection<MachineGroup, Machine> selection) {
        if (selection != null) {
            this.initUIForMultipleMachines(selection);
        } else {
            this.initUIWithSingleMachine(null);
        }
    }

    public void groupsRemoved(MachineGroup parentGroup, MachineGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void groupsChanged(MachineGroup parentGroup, MachineGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void machinesChanged(MachineGroup parent, Machine[] inserted, Machine[] removed, Machine[] updated, Machine.MachineChanges updateResults) {
        if (this.selection != null) {
            Machine machine = (Machine)this.selection.getFirstMachine();
            if (machine == null) {
                return;
            }
            if (updated != null && updated.length > 0) {
                for (Machine m : updated) {
                    if (!m.equals(machine)) continue;
                    this.initUIWithSingleMachine(this.selection);
                }
            }
        }
    }

    @Override
    public void editableLabelStartEdit() {
        this.machineToRename = this.machine;
        this.parentGroupOfMachineToRename = this.parentGroup;
    }

    @Override
    public void editableLabelValueSet(String newMachineName) {
        if (this.machineToRename != null) {
            MachineName newName = new MachineName(newMachineName, this.machineToRename.getMachineName().getGroup());
            this.accessPanelListener.setElementName(this.parentGroupOfMachineToRename, this.machineToRename, newName);
        }
    }

    public void configureNotification(Machine[] machines) {
        this.showDetailsPanel = this.accessPanelListener.isDetailsPanelVisible();
        this.accessPanelListener.setDetailsPanelVisiblity(true);
        this.accessPanelListener.setContentsPanelVisible(false);
        this.initUIWithNotificationForMachines(machines);
    }

    public void showPreconfiguredAccessApps() {
        this.showDetailsPanel = this.accessPanelListener.isDetailsPanelVisible();
        this.accessPanelListener.setDetailsPanelVisiblity(true);
        this.accessPanelListener.setContentsPanelVisible(false);
        this.accessPanelListener.setHierarchyPanelVisible(false);
        this.initUIWithPreconfiguredAccessApps();
    }

    public void configureMachine(Machine machine) {
        this.showDetailsPanel = this.accessPanelListener.isDetailsPanelVisible();
        this.accessPanelListener.setDetailsPanelVisiblity(true);
        this.accessPanelListener.setContentsPanelVisible(false);
        this.initUIWithConfigureForMachine(machine);
    }

    @Override
    public void done() {
        if (this.configurePanel != null) {
            this.configurePanel.stopConfiguring(true);
        }
        this.switchToMainMachineView();
    }

    private void switchToMainMachineView() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MachineDetailsPanel.this.switchToMainMachineView();
                }
            });
            return;
        }
        this.initUIWithSingleMachine(this.selection);
        this.accessPanelListener.setDetailsPanelVisiblity(this.showDetailsPanel);
        this.accessPanelListener.setContentsPanelVisible(true);
        this.accessPanelListener.setHierarchyPanelVisible(true);
    }

    @Override
    public void cancelled() {
        if (this.configurePanel != null) {
            this.configurePanel.stopConfiguring(false);
        }
        this.switchToMainMachineView();
    }

    public void setAncestorFilterProcessor(TreeNodeFilterProcessor<MachineGroup, Machine> selectedFilterProcessor) {
        this.selectedFilterProcessor = selectedFilterProcessor;
    }

    @Override
    public void filterProcessorChanged() {
    }

    public void showBigScreenshot() {
        this.accessPanelListener.showBigScreenshot(this.machine);
    }

    public void nextScreen(boolean big) {
        this.accessPanelListener.changeMonitoredScreen(this.machine.getID(), true, big);
    }

    public void previousScreen(boolean big) {
        this.accessPanelListener.changeMonitoredScreen(this.machine.getID(), false, big);
    }

    private void loadAllAlerts() {
        String[] allAlertIDs;
        ArrayList<LocatedAlert> alerts = new ArrayList<LocatedAlert>();
        for (String id : allAlertIDs = this.accessPanelListener.getTechClient().getAllAlertIDsForMachine(this.machine)) {
            ResourceContainer alert = (ResourceContainer)this.alertModel.getElementWithID(id);
            if (!(alert instanceof LocatedAlert) || alert == null) continue;
            alerts.add((LocatedAlert)alert);
        }
        this.alertTable.setAllAlerts(alerts);
    }

    public int getSelectedScreen() {
        if (this.machine == null) {
            return 0;
        }
        return this.system.getSelectedScreen(this.machine);
    }

    private void setViewsPanelButtons(boolean info, boolean file, boolean appTunnel, boolean history, boolean software, boolean notes, boolean advanced, boolean toolResults) {
        ArrayList<JToggleButton> buttons = new ArrayList<JToggleButton>();
        ArrayList<Object> panels = new ArrayList<Object>();
        if (info) {
            buttons.add(this.infoViewButton);
            panels.add(this.scrollContent);
        }
        if (file) {
            buttons.add(this.fileViewButton);
            panels.add(this.fsPanel);
        }
        if (!GroupAccessKeyset.useTrimmedUI()) {
            if (toolResults) {
                buttons.add(this.runToolResults);
                panels.add(this.runToolResultsPanel.getRootComponent());
            }
            if (Switches.v45 && appTunnel) {
                buttons.add(this.appConnectionButton);
                panels.add(this.servicesPanel);
            }
            if (Switches.SH_subHistoryPanel && history) {
                buttons.add(this.historyViewButton);
                panels.add(this.historyPanel);
            }
            if (Switches.SH_softwareStore && software) {
                buttons.add(this.softwareViewButton);
                panels.add(this.softwarePanel);
            }
            if (notes) {
                buttons.add(this.notesViewButton);
                panels.add(this.notesPanel);
            }
            if (advanced) {
                buttons.add(this.advancedButton);
                panels.add(this.advancedContent);
            }
        }
        super.setViewButtons(buttons.toArray(new AbstractButton[0]), panels.toArray(new JComponent[0]));
    }

    public void notifyToolboxChange(ToolBoxResultWrapper toolRun) {
        this.runToolResultsPanel.updateResult(toolRun);
    }

    @Override
    protected void notifyViewChange(AbstractButton source, JComponent viewPanel) {
        if (source == this.historyViewButton) {
            this.loadHistoryForMachine();
        } else if (source == this.softwareViewButton) {
            try {
                Machine m = this.getSelectedMachine();
                System.out.println("[MachineDetailsPanel] Loading software for " + m);
                if (Switches.SH_softwareStore) {
                    this.softwarePanel.softwareSubPanel.showMachineSoftware(this.getSelectedMachine());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadHistoryForMachine() {
        if (!this.historyViewButton.isSelected()) {
            return;
        }
        try {
            Machine m = this.getSelectedMachine();
            System.out.println("[MachineDetailsPanel] Loading history for " + m);
            if (Switches.SH_subHistoryPanel) {
                if (m != null) {
                    this.historyPanel.historySubPanel.showMachineSessions(m.getMachineID());
                } else {
                    this.historyPanel.historySubPanel.clearMachineSessions();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class CPULabels {
        JLabel icon;
        JLabel left;
        JLabel right;

        CPULabels() {
        }
    }

    class DiskLabels {
        JLabel icon;
        JLabel left;
        JLabel right;

        DiskLabels() {
        }
    }

    class DiskRow
    implements Comparable<DiskRow> {
        String name;
        double val;

        DiskRow() {
        }

        @Override
        public int compareTo(DiskRow o) {
            return -Double.compare(this.val, o.val);
        }
    }

    private class FsUpgrade
    implements FsAutoUpgrade {
        String machineID;
        boolean machineSupportsMachineStreams;
        boolean amDirect = false;

        public FsUpgrade(String machineID, String build) {
            this.machineID = machineID;
            this.machineSupportsMachineStreams = Version.canProvideMachineStreams(build);
        }

        @Override
        public GenericFS upgradeIfPossible(GenericFS fs) {
            if (!Switches.SH_allowFsUpgradesToMachineStreams || !this.machineSupportsMachineStreams) {
                return fs;
            }
            if (fs instanceof RAClient) {
                return fs;
            }
            if (Switches.SH_allowFsDirect) {
                try {
                    System.out.println("[FSPane] Trying to upgrade FS to " + this.machineID + " to direct...");
                    RAClient rafs = MachineDetailsPanel.this.accessPanelListener.getTechClient().getDirectRAClient(this.machineID, Switches.SH_maxTimeoutToGetDirectRAClientFS);
                    System.out.println("[FSPane] Upgraded FS to " + this.machineID + " to direct OK");
                    if (previousRaClient != null) {
                        previousRaClient.shutdown("New direct RAClientFS established, closing old");
                    }
                    previousRaClient = rafs;
                    this.amDirect = true;
                    return rafs;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            try {
                System.out.println("[FSPane] Trying to upgrade FS to " + this.machineID + " to patched...");
                RAClient rafs = MachineDetailsPanel.this.accessPanelListener.getTechClient().getRAClient(this.machineID);
                System.out.println("[FSPane] Upgraded FS to " + this.machineID + " to patched OK");
                if (previousRaClient != null) {
                    previousRaClient.shutdown("New patched RAClientFS established, closing old");
                }
                previousRaClient = rafs;
                this.amDirect = false;
                return rafs;
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean amDirect() {
            return this.amDirect;
        }
    }

    private class MachineDetailsHistoryPanel
    extends JPanel {
        private HistorySubPanel historySubPanel;

        public MachineDetailsHistoryPanel() {
            this.historySubPanel = new HistorySubPanel(MachineDetailsPanel.this.accessPanelListener);
            this.initUI();
        }

        public void initUI() {
            JLabel titleLabel = new JLabel(Language.get("MACHINE_HISTORY_TITLE"));
            titleLabel.setFont(SHStyle.largeFont);
            JPanel titleBar = new JPanel(new BorderLayout());
            titleBar.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)5, (int)5, (int)0));
            titleBar.add((Component)titleLabel, "North");
            this.setLayout(new BorderLayout());
            this.add((Component)titleBar, "North");
            this.add((Component)this.historySubPanel.getRootComponent(), "Center");
        }

        public void setTechClient(TechClient techClient) {
            this.historySubPanel.setTechClient(techClient);
        }
    }

    private class MachineDetailsSoftwarePanel
    extends JPanel {
        private MachineSoftwarePanel softwareSubPanel;

        public MachineDetailsSoftwarePanel() {
            this.softwareSubPanel = new MachineSoftwarePanel(MachineDetailsPanel.this.accessPanelListener);
            this.initUI();
        }

        public void initUI() {
            JLabel titleLabel = new JLabel(Language.get("MACHINE_SOFTWARE_TITLE"));
            titleLabel.setFont(SHStyle.largeFont);
            JPanel titleBar = new JPanel(new BorderLayout());
            titleBar.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)5, (int)5, (int)0));
            titleBar.add((Component)titleLabel, "North");
            this.setLayout(new BorderLayout());
            this.add((Component)titleBar, "North");
            this.add((Component)this.softwareSubPanel.getRootComponent(), "Center");
        }

        public void setTechClient(TechClient techClient) {
            this.softwareSubPanel.setTechClient(techClient);
        }
    }

    class NetworkLabels {
        JLabel icon;
        JLabel name;
        JLabel ip;
        JLabel mac;

        NetworkLabels() {
        }
    }

    private class NotesPanel
    extends JPanel
    implements FocusListener {
        private final JTextArea notesArea;
        private final JTextArea warningsArea;
        private String preChangeText;
        private String preChangeWarnings;
        private boolean amEditing;
        private final JPanel titledNotesSection;
        private final JPanel titledWarningsSection;

        public NotesPanel() {
            super(new GridLayout(2, 1));
            this.notesArea = new JTextArea();
            this.warningsArea = new JTextArea();
            this.amEditing = false;
            this.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
            this.notesArea.addFocusListener(this);
            this.warningsArea.addFocusListener(this);
            JScrollPane scroller = new JScrollPane(this.notesArea);
            this.titledNotesSection = SHStrippedContentPanel.createTitledSection(scroller, Language.get("NOTES"));
            this.add(this.titledNotesSection);
            scroller = new JScrollPane(this.warningsArea);
            this.titledWarningsSection = SHStrippedContentPanel.createTitledSection(scroller, Language.get("NOTIFICATIONS"));
            this.add(this.titledWarningsSection);
            this.titledWarningsSection.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        }

        public void initForMachine(Machine m) {
            if (!this.amEditing) {
                this.notesArea.setText(m.getMachineInfo().getNotes());
                this.warningsArea.setText(m.getMachineInfo().getWarnings());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.preChangeWarnings = this.warningsArea.getText();
            this.preChangeText = this.notesArea.getText();
            this.amEditing = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            String newWarnings;
            this.amEditing = false;
            String newText = this.notesArea.getText();
            if (!newText.equals(this.preChangeText)) {
                MachineDetailsPanel.this.accessPanelListener.setNotes(MachineDetailsPanel.this.machine, newText);
                MachineDetailsPanel.this.updateNotesIcon();
            }
            if (!(newWarnings = this.warningsArea.getText()).equals(this.preChangeWarnings)) {
                MachineDetailsPanel.this.accessPanelListener.setWarnings(MachineDetailsPanel.this.machine, newWarnings);
                MachineDetailsPanel.this.updateNotesIcon();
            }
        }
    }

    class ProcessRow
    implements Comparable<ProcessRow> {
        String name;
        double val;

        ProcessRow() {
        }

        @Override
        public int compareTo(ProcessRow o) {
            return -Double.compare(this.val, o.val);
        }
    }

    private class WarningPanel
    extends GbPanel {
        public WarningPanel() {
            super.setBackground(AccessStyle.WARNING_PANEL_BACKGROUND);
        }

        public void setBackground(Color c) {
        }
    }
}

