/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechServerConfigManager;
import java.util.ArrayList;
import java.util.Iterator;
import utils.progtools.SaverUtil;

public class TechServerConfig
implements SaverUtil.SaveListener {
    public static final String SOURCE_ID_ADMIN_PANEL = "Admin";
    public static final String SOURCE_ID_PROFILE = "Profile";
    public static TechServerConfig INSTANCE;
    private LicenseSet licenseSet;
    private TechUser[] usersToAdminister;
    private TechGroup[] groupsToAdminister;
    private static final Object LOAD_LOCK;
    private String sourceID;
    private static final Object SAVE_LOCK;
    private boolean hasBeenFetched = false;
    private final TechClient client;
    private final ServerConfig cachedConfig = new ServerConfig();
    private boolean isWindows;
    private final SaverUtil saveUtil = new SaverUtil("ServerConfig", 1000, this, false);
    private ArrayList<TechServerConfigListener> listeners = new ArrayList();

    public void notifyUIOfConfigChange() {
        for (TechServerConfigListener listener : this.listeners) {
            listener.serverConfigFetched();
        }
    }

    public TechServerConfig(TechClient client) {
        this.client = client;
        INSTANCE = this;
        if (client.canAdministerServer()) {
            this.loadConfigFromServer();
        } else if (client.getTechUser().canAdministerGroup) {
            this.loadTechUserConfigs();
        }
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilLoaded() {
        Object object = LOAD_LOCK;
        synchronized (object) {
            while (!this.hasBeenFetched) {
                try {
                    LOAD_LOCK.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ServerConfig getServerConfig() {
        return this.cachedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReload() {
        Object object = LOAD_LOCK;
        synchronized (object) {
            this.hasBeenFetched = false;
        }
        this.loadConfigFromServer();
    }

    public void forceSaveNow() {
        this.performSave(true);
    }

    public boolean hasBeenFetched() {
        return this.hasBeenFetched;
    }

    public void addTechServerConfigListener(TechServerConfigListener listener) {
        this.listeners.add(listener);
    }

    private void loadConfigFromServer() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TechServerConfig.this.licenseSet = new LicenseSet();
                    TechServerConfig.this.isWindows = TechServerConfig.this.client.fetchServerConfiguration(TechServerConfig.this.cachedConfig, TechServerConfig.this.licenseSet);
                    Iterator iterator = LOAD_LOCK;
                    synchronized (iterator) {
                        TechServerConfig.this.hasBeenFetched = true;
                        LOAD_LOCK.notifyAll();
                    }
                    for (TechServerConfigListener listener : TechServerConfig.this.listeners) {
                        listener.serverConfigFetched();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    private void loadTechUserConfigs() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TechClient.AdministrationDetails administrationDetails = TechServerConfig.this.client.getTechUsersToAdminister();
                    TechServerConfig.access$702(TechServerConfig.this, administrationDetails.adminUsers);
                    TechServerConfig.access$802(TechServerConfig.this, administrationDetails.groups);
                    Iterator iterator = LOAD_LOCK;
                    synchronized (iterator) {
                        TechServerConfig.this.hasBeenFetched = true;
                        LOAD_LOCK.notifyAll();
                    }
                    for (TechServerConfigListener listener : TechServerConfig.this.listeners) {
                        listener.serverConfigFetched();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public void requestSave(String sourceID) {
        this.saveUtil.queueSave();
        this.sourceID = sourceID;
    }

    @Override
    public void performSave() {
        this.performSave(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performSave(boolean overwrite) {
        try {
            System.out.println("[TechServerConfig] Save is queued: " + TechServerConfigManager.INSTANCE.isSaveQueued());
            if (!TechServerConfigManager.INSTANCE.isSaveQueued()) {
                return;
            }
            boolean worked = this.client.storeServerConfiguration(this.cachedConfig, overwrite);
            if (!worked) {
                if (!TechServerConfigManager.INSTANCE.isSaveQueued()) {
                    return;
                }
                System.out.println("[TechServerConfig] The server rejected the save attempt as the server's configuration has changed.");
                ServerConfigMismatchHandler mismatchHandler = this.checkIfOverwrite("Server rejected save attempt");
                if (mismatchHandler.overwrite()) {
                    try {
                        System.out.println("[TechServerConfig] User has requested to force the save");
                        this.client.storeServerConfiguration(this.cachedConfig, true);
                    }
                    finally {
                        this.configMismatchHandled();
                    }
                }
                if (mismatchHandler.revert()) {
                    try {
                        System.out.println("[TechServerConfig] User has requested to revert");
                        TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
                        this.loadConfigFromServer();
                    }
                    finally {
                        this.configMismatchHandled();
                    }
                    return;
                }
                return;
            }
            System.out.println("[TechServerConfig] Save complete");
            TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
            for (TechServerConfigListener listener : this.listeners) {
                listener.localServerConfigChanged(this.sourceID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ServerConfigMismatchHandler checkIfOverwrite(String reason) {
        for (TechServerConfigListener listener : this.listeners) {
            ServerConfigMismatchHandler handler = listener.configMismatch(reason);
            if (!handler.overwrite() && !handler.revert()) continue;
            return handler;
        }
        return new ServerConfigMismatchHandler(false, false);
    }

    private void configMismatchHandled() {
        for (TechServerConfigListener listener : this.listeners) {
            listener.configMismatchHandled();
        }
    }

    public Object getLock() {
        return SAVE_LOCK;
    }

    public TechUser[] getUsersToAdminister() {
        return this.usersToAdminister;
    }

    public TechGroup[] getGroupsToAdminister() {
        return this.groupsToAdminister;
    }

    static /* synthetic */ TechUser[] access$702(TechServerConfig x0, TechUser[] x1) {
        x0.usersToAdminister = x1;
        return x1;
    }

    static /* synthetic */ TechGroup[] access$802(TechServerConfig x0, TechGroup[] x1) {
        x0.groupsToAdminister = x1;
        return x1;
    }

    static {
        LOAD_LOCK = new Object();
        SAVE_LOCK = new Object();
    }

    public static class ServerConfigMismatchHandler {
        private boolean overwrite;
        private boolean revert;

        public ServerConfigMismatchHandler(boolean overwrite, boolean revert) {
            this.overwrite = overwrite;
            this.revert = revert;
        }

        public boolean overwrite() {
            return this.overwrite;
        }

        public boolean revert() {
            return this.revert;
        }
    }

    public static interface TechServerConfigListener {
        public void loadedNewConfig(ServerConfig var1);

        public void serverConfigFetched();

        public void localServerConfigChanged(String var1);

        public ServerConfigMismatchHandler configMismatch(String var1);

        public void configMismatchHandled();

        public void failedToBind(String[] var1);
    }
}

