/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.techclient;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import bcutil.SingleStringKeyHashProvider;
import com.aem.BuildDateUtil;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.utils.ProxyUtil;
import com.aem.nodelink.utils.SafeClock;
import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.ProfileType;
import com.aem.sdemo.AttendeeInfo;
import com.aem.sdesktop.SessionPerformance;
import com.aem.sdesktop.common.OpusConfig;
import com.aem.sgateway.SGHttpsUtil;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.shelp.common.ClientEncryption;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.common.Invitation;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.PC;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.history.AlertSearchConfig;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.properties.AbstractProperties;
import com.aem.shelp.common.properties.ServerProperties;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.properties.WindowBoundsUtil;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.mdupload.fs.FSMirror;
import com.aem.shelp.mdupload.fs.FSProgress;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.DemoInfo;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.MiniClient;
import com.aem.shelp.proxy.SessionLimitExceededException;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.authentication.TOTPAuthenticator;
import com.aem.shelp.proxy.common.HistoryElement;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.config.TransientTechGroup;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.logging.SimpleHelpEventRepository;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.techclient.APIToken;
import com.aem.shelp.proxy.techclient.ClientFeatures;
import com.aem.shelp.proxy.techclient.MachineResponseListener;
import com.aem.shelp.proxy.techclient.RAClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.techclient.TechClientIPCHandler;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.techclient.TechTwoTierKeyManager;
import com.aem.shelp.proxy.techclient.TwoTierKey;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.NetAdapter;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.proxy.types.apptunnel.AppTunnelSpecification;
import com.aem.shelp.tech.ClientNotificationUtil;
import com.aem.shelp.tech.TechHelpUIArguments;
import com.aem.shelp.tech.TechHelpUi;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.TechServerConfigManager;
import com.aem.shelp.tech.admin.BrandingSettings;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.tech.admin.subsections.simulation.Simulation;
import com.aem.shelp.tech.alerts.alerts.AlertHistoryListener;
import com.aem.shelp.tech.alerts.alerts.contents.table.AlertLiveInfoProvider;
import com.aem.shelp.tech.appprofile.AppProfileUtils;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.tech.history.HistoryListener;
import com.aem.shelp.tech.invitations.InvitationConfiguration;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.tech.reporting.ReportResult;
import com.aem.shelp.tech.video.TechVideoRepository;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.ChainedLinkStatusListener;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.GenericSync;
import com.aem.shelp.util.KeytoolUtil;
import com.aem.shelp.util.MachineStream;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.P2PSock;
import com.aem.shelp.util.PropertiesToMessage;
import com.aem.shelp.util.SHMemoryPolicy;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.shelp.util.WebTransactionToken;
import com.aem.shelp.util.WebTransactor;
import com.aem.shelp.util.WindowsFirewallUtil;
import com.aem.tests.Testing;
import com.aem.utils.StreamUtils;
import com.aem.utils.authentication.LDAPAuthenticator;
import com.aem.utils.authentication.LDAPProperties;
import com.aem.utils.multiplex.MultiplexerInputStream;
import com.aem.utils.multiplex.MultiplexerOutputStream;
import com.aem.utils.os.SystemInfo;
import com.aem.utils.zip.GZIPer;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import jwrapper.failover.FailoverMonitor;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.ddebug.DDLog;
import utils.files.FileUtil;
import utils.loggingframework.events.LogEvent;
import utils.message.BasicMTTransactionClient;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.multiplex.FastMxInputStream;
import utils.multiplex.FastMxOutputStream;
import utils.progtools.BestCaseCompressor;
import utils.progtools.Cleanable;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeoutMap;
import utils.progtools.time.Time;
import utils.site.transact.TrialUtil;
import utils.software.OSSoftwareUtil;
import utils.software.types.software.Software;
import utils.ssl.KeyStoreUtility;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;
import utils.udp.WakeOnLan;

public class TechClient
implements PC,
AbstractProperties.PropertiesSaver,
AlertLiveInfoProvider {
    public static final byte[] NULL_SESSION_ID = null;
    public static boolean USE_FAKE_MAGIC = false;
    private static final long MT_TRANS_RESPONSE_TIMEOUT = 300000L;
    private BasicMTTransactionClient client;
    private MultiplexerOutputStream mxout;
    private MultiplexerInputStream mxin;
    private final boolean threadsLive = true;
    private Notifier notifier;
    private Poller poller;
    private Processor processor;
    private TechClientListener listener;
    private TransientTechUser techUser;
    private String host;
    private int port;
    private String techNetID;
    private String custNetID;
    private boolean overMachineLimit;
    private NodeLink sock;
    private String langfilename;
    private ResourceBundle lang;
    private String virtualHostname;
    private ArrayList<Message> prefetchedIDToMessageResultsList = null;
    private final Object PREFETCH_CACHE_LOCK = new Object();
    private final ArrayList<HistoryListener> historyListeners = new ArrayList();
    private final ArrayList<AlertHistoryListener> alertHistoryListeners = new ArrayList();
    private final ArrayList<TechServerConfig.TechServerConfigListener> newServerConfigListeners = new ArrayList();
    private long oldestHistoricalSession;
    private int serverLicenseMode;
    private LicenseSet serverLicenseSet;
    private TechCredentials credentials;
    private int sessionLimit;
    private HashMap<String, Integer> alertTargetCounts = new HashMap();
    public static TechClient LAST_INSTANCE;
    private boolean doSgUpdatingNotifications = false;
    private String pubKeyHashFromConnect;
    private boolean showBackupWarning = false;
    private final OnDemandThreadPool edtPool = new OnDemandThreadPool("TechSubscriptions-" + this.getTechUser(), 1, 20, 5);
    Object trans_LOCK = new Object();
    private BCUtil trans_BCU;
    private final HashMap<String, HashedThumb> screensMap = new HashMap();
    private final Object bs_LOCK = new Object();
    private Message subscribeMessage = new Message(13200);
    private final Object SUBSCRIBE_LOCK = new Object();
    private boolean ignoreSubscribes = false;
    private final Object minis_LOCK = new Object();
    private final HashMap<String, Object> minis = new HashMap();
    private String previousCustomerOrMachineID;
    private Message bufferedWols;
    private int cachedRemoteMachinesLimit = -1;
    private int cachedAttendeeLimit = -1;
    private static final Object sessionWindows_LOCK;
    private static final ArrayList<TechClientIPCHandler> sessionWindows;
    private final Object respListeners_LOCK = new Object();
    private final HashMap<Long, MachineResponseListener> respListeners = new HashMap();
    private long machineResponseListenerID = BCUtil.getSecureRandom().nextLong();
    private final boolean isTestOrDebug = false;
    Object crossTransfers_LOCK = new Object();
    TimeoutMap<Long, FSProgress> crossTransfers;

    public int getSessionLimit() {
        return this.sessionLimit;
    }

    public void debug_addAlertTargetCount(String id, Integer count) {
        this.alertTargetCounts.put(id, count);
    }

    @Override
    public int getTargetCountForAlert(String id) {
        try {
            return this.alertTargetCounts.get(id);
        }
        catch (Exception x) {
            return 0;
        }
    }

    public LicenseSet getServerLicenses() {
        return this.serverLicenseSet;
    }

    public int getServerLicenseMode() {
        return this.serverLicenseMode;
    }

    public boolean allowsProvider() {
        if (TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_BIZ)) {
            return true;
        }
        if (this.serverLicenseSet != null) {
            return this.serverLicenseSet.allowsProvider();
        }
        return false;
    }

    public boolean allowsAlerts() {
        if (TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_BIZ)) {
            return true;
        }
        if (this.serverLicenseSet != null) {
            return this.serverLicenseSet.allowsAlerts();
        }
        return false;
    }

    public boolean allowsMassNotify() {
        if (TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_BIZ)) {
            return true;
        }
        if (this.serverLicenseSet != null) {
            return this.serverLicenseSet.allowsMassNotify();
        }
        return false;
    }

    public boolean allowsMassToolbox() {
        if (TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_BIZ)) {
            return true;
        }
        if (this.serverLicenseSet != null) {
            return this.serverLicenseSet.allowsMassToolbox();
        }
        return false;
    }

    public boolean isMonitoringOnly() {
        return false;
    }

    public TechGroupPermissions getPermissions() {
        return this.techUser.getPermissions();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPubKeyHashFromConnect() {
        return this.pubKeyHashFromConnect;
    }

    public boolean isSimpleHelpAdminUser() {
        return this.credentials.isSimpleHelpAdminUser();
    }

    public boolean canAdministerServer() {
        return this.credentials.isSimpleHelpAdminUser() || this.getPermissions().canAdminServer();
    }

    public String getLoginUsername() {
        return this.credentials.getUsername();
    }

    public void addNewServerConfigListener(TechServerConfig.TechServerConfigListener listener) {
        this.newServerConfigListeners.add(listener);
    }

    private void notifyServerConfigListeners(ServerConfig newConfig) {
        for (TechServerConfig.TechServerConfigListener listener : this.newServerConfigListeners) {
            listener.loadedNewConfig(newConfig);
        }
    }

    private void notifyFailedBindings(String[] failedBindings) {
        for (TechServerConfig.TechServerConfigListener listener : this.newServerConfigListeners) {
            listener.failedToBind(failedBindings);
        }
    }

    private TechServerConfig.ServerConfigMismatchHandler notifyConfigServerMismatch() {
        for (TechServerConfig.TechServerConfigListener listener : this.newServerConfigListeners) {
            TechServerConfig.ServerConfigMismatchHandler handler = listener.configMismatch("Server rejected save as config has changed");
            if (!handler.overwrite() && !handler.revert()) continue;
            return handler;
        }
        return new TechServerConfig.ServerConfigMismatchHandler(false, false);
    }

    private void notifyConfigServerMismatchHandled() {
        for (TechServerConfig.TechServerConfigListener listener : this.newServerConfigListeners) {
            listener.configMismatchHandled();
        }
    }

    public TechClient(TechClient forkFrom, boolean inSession, TechClientListener listener) throws Exception {
        this(forkFrom, inSession, listener, null);
    }

    private TechClient(TechClient forkFrom, boolean inSession, TechClientListener listener, NodeLinkStatusListener status) throws Exception {
        this(forkFrom.langfilename, forkFrom.lang, forkFrom.host, forkFrom.port, forkFrom.credentials, inSession, listener, status);
    }

    public static TechClient createQuickClient(String username, String password) throws Exception {
        URL url = new URL(JWSystem.getUpdateURL());
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return new TechClient("en", null, host, port, new TechCredentials(username, password, NULL_SESSION_ID), false, null);
    }

    public TechClient(String langfilename, ResourceBundle lang, String host, int port, TechCredentials credentials, boolean inSession, boolean acceptAnyPkhash) throws Exception {
        this.createTechClient(langfilename, lang, host, port, credentials, inSession, new TechClientAdapter(), null, null, acceptAnyPkhash);
    }

    public TechClient(String langfilename, ResourceBundle lang, String host, int port, TechCredentials credentials, boolean inSession, TechClientListener listener) throws Exception {
        this(langfilename, lang, host, port, credentials, inSession, listener, null);
    }

    public TechClient(String langfilename, ResourceBundle lang, TechCredentials credentials, boolean inSession, TechClientListener listener, NodeLinkStatusListener status) throws Exception {
        this(langfilename, lang, null, -9999, credentials, inSession, listener, status);
    }

    public TechClient(String langfilename, ResourceBundle lang, String host, int port, TechCredentials credentials, boolean inSession, TechClientListener listener, NodeLinkStatusListener status) throws Exception {
        this(langfilename, lang, host, port, credentials, inSession, listener, status, null);
    }

    public TechClient(String langfilename, ResourceBundle lang, String host, int port, TechCredentials credentials, boolean inSession, TechClientListener listener, NodeLinkStatusListener status, int[] messageIDsToPrefetch) throws Exception {
        this.createTechClient(langfilename, lang, host, port, credentials, inSession, listener, status, messageIDsToPrefetch, false);
    }

    private void createTechClient(String langfilename, ResourceBundle lang, String host, int port, TechCredentials credentials, boolean inSession, TechClientListener listener, NodeLinkStatusListener status, int[] messageIDsToPrefetch, boolean acceptAnyPkhash) throws Exception {
        Message message;
        String pkhash;
        LAST_INSTANCE = this;
        this.langfilename = langfilename;
        this.lang = lang;
        this.host = host;
        this.port = port;
        this.listener = listener;
        this.credentials = credentials;
        if (host == null && port == -9999) {
            System.out.println("[TechClient] Connecting to local server");
            this.sock = SHelpNodelinkConnector.getLocalProxyServerConnection(status);
        } else {
            System.out.println("[TechClient] Connecting to " + host + ":" + port);
            this.sock = SHelpNodelinkConnector.getConnection(host, port, status);
        }
        this.sock.setFriendlyName("TechClient");
        System.out.println("[TechClient] Connection OK (took " + Time.time() + ") sending protocol version");
        if (USE_FAKE_MAGIC) {
            URL url = new URL("http://" + host + ":" + port + "/version");
            InputStream in2 = url.openStream();
            String[] sb = StreamUtils.readAllAsStringUTF8(in2).split("-");
            try {
                in2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("[TESTING] Faking build number to match server");
            String build = sb[3] + sb[4];
            long YMDHMS = Long.parseLong(build);
            StreamUtils.writeLong(this.sock.getOutputStream(), BuildDateUtil.getFakeTechMagicBuildDate(YMDHMS));
            this.sock.getOutputStream().flush();
        } else {
            StreamUtils.writeLong(this.sock.getOutputStream(), BuildDateUtil.getTechMagicBuildDate());
            this.sock.getOutputStream().flush();
        }
        InputStream in = this.sock.getInputStream();
        try {
            long in2 = StreamUtils.readLong(in);
        }
        catch (Exception e) {
            throw new IOException("Server does not appear to be a SimpleHelp server or is an incompatible version");
        }
        System.out.println("[TechClient] Protocol version OK, setting up encryption");
        System.out.println("[TechClient] Setting up encryption (BCU)");
        if (JWTesting.amTesting()) {
            pkhash = null;
        } else if (!JWLaunchProperties.isJWrapperSetup()) {
            pkhash = null;
        } else if (acceptAnyPkhash) {
            pkhash = null;
        } else {
            pkhash = JWLaunchProperties.getProperty((String)"shpkhash");
            if (pkhash != null && pkhash.length() == 0) {
                pkhash = null;
            }
        }
        System.out.println("[SDesktopServerController] Expected server pkhash: " + pkhash);
        BCUtil bcu = new BCUtil();
        if (pkhash == null) {
            bcu.setValidHashRequired(false);
        } else {
            bcu.setClientRsaKeyPairHashNoRecovery((BCUtil.PublicKeyHashProvider)new SingleStringKeyHashProvider(pkhash));
        }
        if (pkhash == null && !JWLaunchProperties.isJWrapperSetup()) {
            bcu.setValidHashRequired(false);
        }
        bcu.handshake(this.sock.getInputStream(), this.sock.getOutputStream(), true, null);
        this.pubKeyHashFromConnect = bcu.getSavedPublicKeyAuthHash();
        if (Testing.queryTestingBoolean("TEST_QUIT_TECHUI_BEFORE_LOGIN_ATTEMPT")) {
            JWTesting.reportSuccess((String)"TechUI Launch");
            System.out.println("[TESTING] TechClient has established a connection but will not send credentials, exiting!");
            System.exit(0);
        }
        System.out.println("[TechClient] Sending credentials (session token provided is " + credentials.hasSessionToken() + ")");
        Message m = new Message();
        m.append(credentials.getUsername());
        m.append(credentials.getPassword());
        m.append(credentials.getSessionToken());
        String existingKey = null;
        if (JWLaunchProperties.isJWrapperSetup()) {
            existingKey = TechTwoTierKeyManager.getKeyFor(credentials.getUsername(), host + ":" + port);
        }
        m.append(existingKey);
        if (AppProfileUtils.usingAppProfile()) {
            m.append(AppProfileUtils.getAppProfileIDorNull());
        } else {
            m.append("");
        }
        if (credentials.hasOverrideToken()) {
            m.append(credentials.getOverrideToken());
        }
        BCUtilMessenger.writeMsg(bcu, this.sock.getOutputStream(), m);
        this.sock.getOutputStream().flush();
        int success = StreamUtils.readInt(this.sock.getInputStream());
        boolean readRememberKey = false;
        while (success == 160) {
            Message messageWrapper = BCUtilMessenger.readMsg(bcu, this.sock.getInputStream());
            String message2 = messageWrapper.getNextString();
            if (message2 != null && message2.length() > 0 && Language.exists(message2) && (message2 = Language.get(message2)).trim().length() > 0) {
                listener.updateAuthenticationStatusMessage(message2);
            }
            success = StreamUtils.readInt(this.sock.getInputStream());
        }
        int originalSuccessCode = success;
        if (success == 100 || success == 150) {
            boolean first = true;
            boolean rerequest = false;
            while (success == 100 || success == 150) {
                TechClientListener.TwoTierResponse responseCode;
                Message etmp = BCUtilMessenger.readMsg(bcu, this.sock.getInputStream());
                if (success == 100) {
                    String emailAddress = etmp.getNextString();
                    boolean allowRemember = etmp.getNextBoolean();
                    responseCode = listener.requestTwoTierCode(!first && !rerequest, emailAddress, allowRemember);
                } else {
                    String replyMessage = etmp.getNextString();
                    responseCode = listener.processAuthenticationChallenge(!first && !rerequest, replyMessage);
                }
                Message response = new Message();
                if (responseCode == null || responseCode.enteredCode == null) {
                    response.setType(110);
                    rerequest = true;
                } else {
                    rerequest = false;
                    response.append(responseCode.enteredCode);
                    if (success == 100) {
                        response.append(responseCode.rememberMachine);
                        response.append(this.getMachineHostname());
                    }
                }
                BCUtilMessenger.writeMsg(bcu, this.sock.getOutputStream(), response);
                this.sock.getOutputStream().flush();
                InputStream inputStream = this.sock.getInputStream();
                success = StreamUtils.readInt(inputStream);
                boolean bl = readRememberKey = responseCode != null && responseCode.rememberMachine;
                if (originalSuccessCode == success) {
                    first = false;
                    continue;
                }
                originalSuccessCode = success;
                first = true;
            }
        }
        InputStream inputStream = this.sock.getInputStream();
        if (success == 140) {
            Message readMessage = BCUtilMessenger.readMsg(bcu, this.sock.getInputStream());
            String totpKey = readMessage.getNextString();
            String totpUsername = readMessage.getNextString();
            String hostname = readMessage.getNextString();
            int length = readMessage.getNextInt();
            int maxTries = 10;
            while (success == 140) {
                if (--maxTries == 0) {
                    throw new IOException("Quitting after 10 app setup attempts");
                }
                long testCode = listener.requestAppAuthenticationSetup(totpKey, totpUsername, hostname, length);
                if (testCode == -1L) {
                    throw new QuitLoginException();
                }
                Message response = new Message();
                response.append(testCode);
                BCUtilMessenger.writeMsg(bcu, this.sock.getOutputStream(), response);
                this.sock.getOutputStream().flush();
                success = StreamUtils.readInt(inputStream);
            }
            listener.closeAppAuthenticationSetup();
        }
        boolean first = true;
        while (success == 120) {
            message = BCUtilMessenger.readMsg(bcu, this.sock.getInputStream());
            boolean allowRemember = message.getNextBoolean();
            TechClientListener.TwoTierResponse responseCode = listener.requestTwoTierCode(!first, null, allowRemember);
            Message response = new Message();
            response.append(responseCode.enteredCode);
            response.append(responseCode.rememberMachine);
            response.append(this.getMachineHostname());
            BCUtilMessenger.writeMsg(bcu, this.sock.getOutputStream(), response);
            this.sock.getOutputStream().flush();
            success = StreamUtils.readInt(inputStream);
            readRememberKey = responseCode.rememberMachine;
            first = false;
        }
        if (success != 1) {
            String reason = StreamUtils.readNStringUTF8(this.sock.getInputStream(), 1024);
            throw new WrongPasswordException("Login failed - incorrect technician login password", reason);
        }
        if (readRememberKey) {
            message = BCUtilMessenger.readMsg(bcu, this.sock.getInputStream());
            TechTwoTierKeyManager.setKeyFor(credentials.getUsername(), host + ":" + port, message.getNextString());
        }
        System.out.println("[TechClient] Technician authenticated.");
        Message additionalMessage = BCUtilMessenger.readMsg(bcu, this.sock.getInputStream());
        credentials.setSessionToken(additionalMessage.getNextByteArray());
        this.techUser = TransientTechUser.fromMessage(additionalMessage.getNextMessage());
        this.virtualHostname = additionalMessage.getNextString();
        this.oldestHistoricalSession = additionalMessage.getNextLong();
        this.serverLicenseMode = additionalMessage.getNextInt();
        Message licenseSetMessage = additionalMessage.getNextMessage();
        this.serverLicenseSet = licenseSetMessage == null || licenseSetMessage.length() == 0 ? null : LicenseSet.fromMessage(licenseSetMessage);
        Message trials = additionalMessage.getNextMessage();
        this.storeTrialMarkers(trials);
        boolean applyFailoverUrl = additionalMessage.getNextBoolean();
        String failoverUrl = additionalMessage.getNextString();
        if (additionalMessage.hasNext()) {
            long centralTime = additionalMessage.getNextLong();
            OneClock.print(centralTime);
        }
        if (!ServerManagement.isServerJVM()) {
            System.out.println("[HAF] Apply failover URL override: " + applyFailoverUrl);
            System.out.println("[HAF] Failover URL override: " + failoverUrl);
            if (applyFailoverUrl) {
                FailoverMonitor.overrideFailoverURL((String)failoverUrl);
                try {
                    if (Switches.SH_failoverCheckAfterOverride) {
                        FailoverMonitor.checkSetup((boolean)true);
                    }
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
            }
        }
        this.addNewServerConfigListener(new TechServerConfig.TechServerConfigListener(){

            @Override
            public void loadedNewConfig(ServerConfig config) {
                if (config != null) {
                    TechClient.this.virtualHostname = config.getHostname(null);
                }
            }

            @Override
            public void serverConfigFetched() {
            }

            @Override
            public void localServerConfigChanged(String sourceID) {
            }

            @Override
            public TechServerConfig.ServerConfigMismatchHandler configMismatch(String reason) {
                return new TechServerConfig.ServerConfigMismatchHandler(false, false);
            }

            @Override
            public void configMismatchHandled() {
            }

            @Override
            public void failedToBind(String[] failedAddresses) {
            }
        });
        System.out.println("[TechClient] Setting up proxy demultiplexer");
        this.mxout = new MultiplexerOutputStream(this.sock.getOutputStream());
        this.mxin = new MultiplexerInputStream(this.sock.getInputStream(), "TechClient-ProxyDemultiplexer");
        this.mxin.showBufferMaxouts(true);
        this.trans_BCU = bcu;
        this.client = new BasicMTTransactionClient(this.mxin.getInputStream((short)0, "Tech Server Plane"), this.mxout.getOutputStream((short)0));
        this.client.setResponseTimeout(300000L);
        if (this.notifier != null) {
            this.notifier.die();
        }
        if (this.processor != null) {
            this.processor.die();
        }
        this.processor = new Processor();
        this.processor.start();
        this.notifier = new Notifier(bcu, this.mxin.getInputStream((short)1, "Tech Notify Plane"));
        this.notifier.start();
        if (this.poller == null) {
            this.poller = new Poller();
            this.poller.start();
        }
        if (messageIDsToPrefetch == null) {
            messageIDsToPrefetch = new int[]{100000, 16000, 68002, 68007};
        }
        System.out.println("[TechClient] Prefetching common requests");
        this.prefetchAndCacheSimpleRequests(messageIDsToPrefetch);
        try {
            System.out.println("[TechClient] Fetching technician properties and settings.");
            this.fetchProperties(inSession);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            System.out.println("[TechClient] Fetching server configuration.");
            this.fetchKeyServerSwitches();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            System.out.println("[TechClient] Fetching last backup time.");
            this.showBackupWarning = this.getLastBackup() == -1L;
            System.out.println("[TechClient] Show backup warning? " + this.showBackupWarning);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            System.out.println("[TechClient] Fetching encryption keys");
            this.fetchEncryptionKeys();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (status != null) {
            this.setLinkStatusListener(status);
        }
    }

    private void storeTrialMarkers(Message trials) {
        if (ServerManagement.isServerJVM()) {
            return;
        }
        try {
            TrialUtil tu = TrialUtils.getTU();
            System.out.println("[Trial] Clearing");
            tu.clearAllTrials();
            while (trials.hasNext()) {
                String feature = trials.getNextString();
                byte[] marker = trials.getNextByteArray();
                System.out.println("[Trial] Storing " + feature);
                tu.setRawLocalTrialMarker(feature, marker);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void requestComparativeStateDump(String machineID) throws Exception {
        Message m = new Message(170002);
        m.append(machineID);
        this.doTransact(m);
    }

    private String getMachineHostname() {
        return JWGenericOS.getInstance().getHostname();
    }

    public ToolBox fetchToolBox() throws Exception {
        Message m = new Message(34200);
        m = this.doTransact(m);
        ToolBox toolBox = new ToolBox();
        toolBox.fromMessage(m, false);
        return toolBox;
    }

    public void saveToolBox(ToolBox box) throws Exception {
        System.out.println("[TechClient] Saving ToolBox with " + box.getAllItems().size() + " items");
        Message m = box.toMessage(null);
        m.setType(34100);
        m = this.doTransact(m);
        box.updateFromMessage(m);
        System.out.println("[TechClient] Updated ToolBox to " + box.getAllItems().size() + " items");
    }

    public ArrayList<Simulation> getAllSimulations() throws Exception {
        Message m = new Message(200002);
        m = this.doTransact(m);
        ArrayList<Simulation> list = new ArrayList<Simulation>();
        System.out.println("[Simulations] Loaded " + list.size() + " simulations");
        while (m.hasNext()) {
            list.add(Simulation.fromMessage(m.getNextMessage()));
        }
        return list;
    }

    public void saveSimulation(Simulation sim) throws Exception {
        Message m = new Message(200001);
        m.append(sim.toMessage());
        this.doTransact(m);
    }

    public boolean shouldShowBackupWarning() {
        return this.showBackupWarning;
    }

    public String getVirtualServerHostname() {
        return this.virtualHostname;
    }

    public void setTechnicianDisplayName(String name) {
        if (name != null && name.trim().length() >= 0) {
            this.techUser.displayName = name;
        }
    }

    public void setLinkStatusListener(NodeLinkStatusListener status) {
        this.sock.addLinkStatusListener(status);
        this.sock.addOutOfBandListener(new ChainedLinkStatusListener(status, Language.get("CUSTOMER_LINK_DOWN")));
    }

    public void addLinkStatusListener(NodeLinkStatusListener status) {
        this.sock.addLinkStatusListener(status);
        this.sock.addOutOfBandListener(new ChainedLinkStatusListener(status, Language.get("CUSTOMER_LINK_DOWN")));
    }

    private void doAsyncSubscriptionJob(Message m) {
        this.edtPool.runAsync((Runnable)new SendOnlyJob(m));
    }

    private Message doTransact(Message m) throws Exception {
        return this.doTransactionInternal(m, true);
    }

    private void doSend(Message m) throws Exception {
        this.doTransactionInternal(m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doTransactionInternal(Message m, boolean requiresResponse) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!requiresResponse) {
                this.doAsyncSubscriptionJob(m);
                return null;
            }
            new Exception("***WARNING*** TC used on EDT").printStackTrace(System.out);
        }
        Message orig = m;
        Object object = this.PREFETCH_CACHE_LOCK;
        synchronized (object) {
            try {
                if (this.prefetchedIDToMessageResultsList != null) {
                    Message result = null;
                    for (int i = 0; i < this.prefetchedIDToMessageResultsList.size(); ++i) {
                        Message cachedMessage = this.prefetchedIDToMessageResultsList.get(i);
                        if (cachedMessage.getType() == m.getType()) {
                            result = this.prefetchedIDToMessageResultsList.remove(i);
                            break;
                        }
                        if (this.prefetchedIDToMessageResultsList.size() != 0) continue;
                        this.prefetchedIDToMessageResultsList = null;
                        break;
                    }
                    if (result != null) {
                        return result;
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[TechClient] Cached result for message (" + m.getType() + ") could not be retrieved: " + t.getMessage());
            }
        }
        Object unencrypted_streamed = null;
        Message tmp = new Message();
        if (Switches.SH_compressTechTransactions) {
            tmp.append(this.trans_BCU.wrap(BestCaseCompressor.compress((byte[])MessageUtils.messageToBytes((Message)m))));
        } else {
            tmp.append(this.trans_BCU.wrap(MessageUtils.messageToBytes((Message)m)));
        }
        Message enc = this.client.doTransaction(tmp);
        byte[] tmpdat = (byte[])enc.get(0);
        m = Switches.SH_compressTechTransactions ? MessageUtils.bytesToMessage((byte[])BestCaseCompressor.decompress((byte[])this.trans_BCU.unwrap(tmpdat))) : MessageUtils.bytesToMessage((byte[])this.trans_BCU.unwrap(tmpdat));
        if (unencrypted_streamed != null) {
            System.out.println("Appending " + unencrypted_streamed.length() + " streamed messages...");
            m.appendAll(unencrypted_streamed);
            unencrypted_streamed = null;
        }
        if (m.getType() == -1) {
            String msg = "Error processing this request";
            if (m.length() > 0 && m.get(0) instanceof String) {
                String key = (String)m.get(0);
                try {
                    String value;
                    msg = value = this.lang.getString(key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.out.println("[TechClient] ERROR in transaction " + m + " returned for " + orig);
            throw new Exception(msg);
        }
        if (m.getType() == -2) {
            throw new Exception("Unimplemented request");
        }
        if (m.getType() == -3) {
            throw new SessionLimitExceededException((String)m.get(0));
        }
        if (m.getType() != 1 && m.getType() != 2) {
            throw new Exception("Unknown transaction failure " + m.getType());
        }
        if (m.getType() == 2) {
            m = MessageUtils.bytesToMessage((byte[])GZIPer.s_decompress((byte[])m.get(0)));
        }
        return m;
    }

    public Message doMiniClientTransaction(Message mcmsg, String miniSessionID) throws Exception {
        Message m = new Message(29000);
        m.append(miniSessionID);
        m.append(mcmsg);
        m = this.doTransact(m);
        m = (Message)m.get(0);
        if (m.getType() == -1) {
            String msg = "Error processing this request";
            if (m.length() > 0 && m.get(0) instanceof String) {
                String key = (String)m.get(0);
                try {
                    String value;
                    msg = value = this.lang.getString(key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.out.println("[TechClient-MiniClient]: ERROR " + m + " returned for MC transaction " + mcmsg);
            throw new Exception(msg);
        }
        if (m.getType() == -2) {
            throw new Exception("Unimplemented request");
        }
        if (m.getType() == -3) {
            throw new Exception((String)m.get(0));
        }
        return m;
    }

    public void precacheThumbnailsFor(String[] machines) throws Exception {
        HashedThumb ht;
        Message m = new Message(110004);
        for (String machine : machines) {
            m.append(machine);
            ht = this.screensMap.get(machine);
            if (ht != null) {
                m.append(ht.hash);
                continue;
            }
            m.append(0);
        }
        m = this.doTransact(m);
        while (m.hasNext()) {
            Message sub = m.getNextMessage();
            if (sub.length() <= 0) continue;
            String id = sub.getNextString();
            int hash = sub.getNextInt();
            byte[] dat = sub.getNextByteArray();
            ht = new HashedThumb(id, hash, ImageIO.read(new ByteArrayInputStream(dat)));
            this.screensMap.put(id, ht);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getBigScreen(String machineID) throws Exception {
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(machineID, "Asked to fetch big screenshot for " + machineID);
        }
        Object object = this.bs_LOCK;
        synchronized (object) {
            Message m = new Message(110006);
            m.append(machineID);
            this.doTransact(m);
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "Requested big screenshot, waiting for arrival...");
            }
            this.bs_LOCK.wait(60000L);
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(machineID, "big screenshot ready");
            }
        }
        Message m = new Message(110005);
        m.append(machineID);
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(machineID, "fetching big screenshot");
        }
        m = this.doTransact(m);
        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
            DDLog.log(machineID, "got big screenshot " + m);
        }
        if (m.length() > 0) {
            byte[] jpeg = m.getNextByteArray();
            return ImageIO.read(new ByteArrayInputStream(jpeg));
        }
        return null;
    }

    public String getServerStackdump() throws Exception {
        Message m = new Message(160001);
        m = this.doTransact(m);
        return m.getNextString();
    }

    public void setUploadDetails(String machineID) throws Exception {
        Message m = new Message(110002);
        m.append(machineID);
        this.doSend(m);
    }

    public void switchMonitoring(boolean on, List<String> ids) throws Exception {
        Message m = new Message(110001);
        m.append(on);
        for (String id : ids) {
            m.append(id);
        }
        this.doSend(m);
    }

    public void switchMonitoredScreen(String machineID, boolean next, boolean big) {
        Message m = new Message(110007);
        m.append(machineID);
        m.append(next);
        m.append(big);
        try {
            this.doSend(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMachinesToSubscribeList(Collection<Machine> machines) {
        Object object = this.SUBSCRIBE_LOCK;
        synchronized (object) {
            for (Machine machine : machines) {
                this.subscribeMessage.append(machine.getMachineID());
            }
            if (this.subscribeMessage.length() > 1000) {
                this.sendSubscribeList();
            }
        }
    }

    public void ignoreSubscribeSends(boolean ignore) {
        this.ignoreSubscribes = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscribeList() {
        Object object = this.SUBSCRIBE_LOCK;
        synchronized (object) {
            if (this.subscribeMessage.length() == 0 || this.ignoreSubscribes) {
                return;
            }
            System.out.println("[TechClient] Sending subscribe list (size is " + this.subscribeMessage.length() + ")");
            this.doAsyncSubscriptionJob(this.subscribeMessage);
            this.subscribeMessage = new Message(13200);
        }
    }

    public void subscribeToMachinesExpensive(Collection<Machine> machines, Machine extra) {
        Message m = new Message(13201);
        for (Machine machine : machines) {
            m.append(machine.getMachineID());
        }
        if (extra != null) {
            m.append(extra.getMachineID());
        }
        this.doAsyncSubscriptionJob(m);
    }

    public void clearMachineSubscriptions() {
        Message m = new Message(13300);
        this.doAsyncSubscriptionJob(m);
    }

    public void renameMachine(String id, MachineName name) {
        Message m = new Message(13400);
        m.append(id);
        name.toMessage(m);
        try {
            this.doSend(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void removeOfflineMachine(Machine[] machines) throws Exception {
        Message m = new Message(13600);
        for (Machine machine : machines) {
            m.append(machine.getMachineID());
        }
        this.doSend(m);
    }

    public void moveMachines(Machine[] machines, String[] groupPath) {
        Message m = new Message(13500);
        m.append(machines.length);
        for (Machine machine : machines) {
            m.append(machine.getMachineID());
        }
        if (groupPath == null) {
            m.append(0);
        } else {
            m.append(groupPath.length);
            for (String group : groupPath) {
                m.append(group);
            }
        }
        try {
            this.doSend(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void getTemplateEmailsForEvents(LogEvent[] logEvents) throws Exception {
        Message m = new Message(57000);
        m.append(logEvents.length);
        for (LogEvent logEvent : logEvents) {
            m.append(((SimpleHelpLogEvent)logEvent).getEmailTemplateFile().toString());
        }
        m = this.doTransact(m);
        for (int i = 0; i < logEvents.length; ++i) {
            String subject = m.getAsString(i * 2);
            String content = m.getAsString(i * 2 + 1);
            SimpleHelpEventRepository.INSTANCE.putEmailTemplate(logEvents[i], subject, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniClient startMiniSession(String machineID) throws Exception {
        Object x;
        Object object;
        Object LOCK;
        Message m = new Message(28000);
        m.append(machineID);
        m.append(System.currentTimeMillis());
        m = this.doTransact(m);
        String activity = m.getAsString(0);
        Object object2 = LOCK = new Object();
        synchronized (object2) {
            object = this.minis_LOCK;
            synchronized (object) {
                this.minis.put(activity, LOCK);
            }
            LOCK.wait(45000L);
        }
        object = this.minis_LOCK;
        synchronized (object) {
            x = this.minis.get(activity);
        }
        if (x instanceof Message) {
            m = (Message)x;
            String miniSessionID = (String)m.get(0);
            String sgServiceVersion = (String)m.get(1);
            return new MiniClient(this, miniSessionID, sgServiceVersion);
        }
        throw new Exception("Mini session failed");
    }

    public boolean testEmail(String host2, String port2, boolean tls, boolean ssl, String username2, String password2, String fromEmail, String emailAddy, boolean auth) throws Exception {
        Message m = new Message(32000);
        m.append(host2);
        m.append(port2);
        m.append(tls);
        m.append(ssl);
        m.append(auth);
        m.append(username2);
        m.append(password2);
        m.append(fromEmail);
        m.append(emailAddy);
        m = this.doTransact(m);
        boolean success = (Boolean)m.get(0);
        if (!success) {
            String message = (String)m.get(1);
            throw new Exception(message);
        }
        return true;
    }

    public String[] getCurrentlyConfiguredDetails() throws Exception {
        Message m = new Message(108000);
        m = this.doTransact(m);
        String[] result = new String[m.length()];
        for (int i = 0; i < m.length(); ++i) {
            result[i] = m.getAsString(i);
        }
        return result;
    }

    public ArrayList<Object> testLDAPSearch(LDAPProperties ldapProperties) throws Exception {
        Message m = new Message(34000);
        m.append(ldapProperties.baseDN);
        m.append(ldapProperties.filter);
        m = this.doTransact(m);
        ArrayList<Object> result = new ArrayList<Object>();
        boolean success = (Boolean)m.get(0);
        if (!success) {
            String message = "Unknown";
            if (m.length() > 1) {
                message = (String)m.get(1);
            }
            throw new Exception(message);
        }
        int count = (Integer)m.get(1);
        for (int i = 0; i < count; ++i) {
            result.add(m.get(i + 2));
        }
        return result;
    }

    public boolean testLDAPLogin(String username, String password, LDAPProperties ldapProperties) throws Exception {
        Message m = new Message(35000);
        m.append(ldapProperties.baseDN);
        m.append(ldapProperties.filter);
        m.append(username);
        m.append(password);
        m.append(ldapProperties.groups);
        m.append(ldapProperties.isSimple());
        m = this.doTransact(m);
        boolean success = (Boolean)m.get(0);
        if (!success) {
            String message = "Authentication Failed.";
            if (m.length() > 1) {
                message = (String)m.get(1);
            }
            throw new Exception(message);
        }
        return true;
    }

    public boolean testLDAPConnectSoServer(String ldapHost, String ldapPort, String authentication, boolean ssl, String ldapUsername, String ldapPassword) throws Exception {
        Message m = new Message(33000);
        m.append(ldapHost);
        m.append(ldapPort);
        m.append(authentication);
        m.append(ssl);
        m.append(ldapUsername);
        m.append(ldapPassword);
        m = this.doTransact(m);
        boolean success = (Boolean)m.get(0);
        if (!success) {
            String message = "Unknown";
            if (m.length() > 1) {
                message = (String)m.get(1);
            }
            throw new Exception(message);
        }
        return true;
    }

    private void fetchEncryptionKeys() throws Exception {
        Message m = new Message(68007);
        m = this.doTransact(m);
        int count = m.getNextInt();
        for (int i = 0; i < count; ++i) {
            String base64Key = m.getNextString();
            ClientEncryption.INSTANCE.addDataListEncryptionKey(base64Key);
        }
    }

    private void fetchKeyServerSwitches() throws Exception {
        Message m = new Message(100000);
        CentralDebugging.VERY_LARGE_SCALE_SG = (m = this.doTransact(m)).getNextBoolean();
        if (CentralDebugging.VERY_LARGE_SCALE_SG) {
            System.out.println("Operating for Very Large Scale SG Deployments");
        }
        ClientFeatures.showPerformanceMetricsInAccessTab = m.getNextBoolean();
        SimpleHelpEventRepository.getRepository().setShowPerformanceEvent(ClientFeatures.showPerformanceMetricsInAccessTab);
        OpusConfig.bitRate = m.getNextInt();
        System.out.println("[TechClient] Default bitrate is " + OpusConfig.bitRate);
        ClientFeatures.multiLicense = m.getNextBoolean();
    }

    private void fetchProperties(boolean inSession) throws Exception {
        Message m = new Message(16000);
        if ((m = this.doTransact(m)).length() > 0) {
            byte[] techui = (byte[])m.get(0);
            byte[] session = (byte[])m.get(1);
            byte[] server = (byte[])m.get(2);
            if (inSession) {
                if (session != null && session.length > 0) {
                    SessionProperties.INSTANCE.reinitFrom(session);
                }
                if (techui != null && techui.length > 0) {
                    TechProperties.INSTANCE.reinitFrom(techui);
                }
                if (server != null && server.length > 0) {
                    ServerProperties.INSTANCE.reinitFrom(server);
                }
                SessionProperties.INSTANCE.setRemoteStore(this);
            } else {
                if (session != null && session.length > 0) {
                    SessionProperties.INSTANCE.reinitFrom(session);
                }
                if (techui != null && techui.length > 0) {
                    TechProperties.INSTANCE.reinitFrom(techui);
                }
                TechProperties.INSTANCE.setRemoteStore(this);
            }
        }
    }

    public void deletePeerConfig(PeerConfig config) throws Exception {
        Message m = new Message(192004);
        m.append(config.toMessage());
        this.doTransact(m);
    }

    public String getServerPeerName() throws Exception {
        Message m = new Message(192002);
        m = this.doTransact(m);
        return m.getNextString();
    }

    public void setServerPeerName(String name) throws Exception {
        Message m = new Message(192003);
        m.append(name);
        this.doTransact(m);
    }

    public ArrayList<PeerConfig> getPeerConfigs() throws Exception {
        Message m = new Message(192000);
        m = this.doTransact(m);
        ArrayList<PeerConfig> list = new ArrayList<PeerConfig>();
        while (m.hasNext()) {
            PeerConfig peerConfig = PeerConfig.fromMessage(m.getNextMessage());
            System.out.println("[TechClient] Received peer config: " + peerConfig);
            list.add(peerConfig);
        }
        return list;
    }

    public void savePeerConfig(PeerConfig config, boolean reloadPeersOnServer) throws Exception {
        Message m = new Message(192001);
        m.append(reloadPeersOnServer);
        m.append(config.toMessage());
        this.doTransact(m);
    }

    public void saveAllPeerConfigs(ArrayList<PeerConfig> configs, boolean reloadPeersOnServer) throws Exception {
        Message m = new Message(192001);
        m.append(reloadPeersOnServer);
        for (PeerConfig config : configs) {
            m.append(config.toMessage());
        }
        this.doTransact(m);
    }

    public void setServerTrialMarker(String feature, byte[] dat) throws Exception {
        Message m = new Message(18002);
        m.append(feature);
        m.append(dat);
        this.doTransact(m);
    }

    public LicenseSet getLicenseFromServer() throws Exception {
        Message m = new Message(18001);
        m = this.doTransact(m);
        Message license = (Message)m.get(0);
        LicenseSet set = new LicenseSet();
        LicenseConfig.fromMessage(license, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchServerConfiguration(ServerConfig serverConfig, LicenseSet licenseSet) throws Exception {
        boolean ret;
        boolean notify = false;
        Message m = new Message(17000);
        m = this.doTransact(m);
        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object) {
            if (m.length() > 0) {
                Message server = (Message)m.get(0);
                Message license = (Message)m.get(1);
                Message defaultEmailContents = (Message)m.get(2);
                boolean isWindows = m.getAsBoolean(3);
                if (serverConfig != null) {
                    TechServerConfigManager.INSTANCE.setServerConfigInstanceID(server.getNextLong());
                    serverConfig.fromMessage(server.getNextMessage(), false);
                    notify = true;
                }
                licenseSet.loadFrom(license.getNextMessage());
                Templates.twoTierActivationSubject = defaultEmailContents.getAsString(0);
                Templates.twoTierActivationContent = defaultEmailContents.getAsString(1);
                Templates.adminTwoTierActivationSubject = defaultEmailContents.getAsString(2);
                Templates.adminTwoTierActivationContent = defaultEmailContents.getAsString(3);
                ret = isWindows;
            } else {
                ret = false;
            }
        }
        if (notify) {
            this.notifyServerConfigListeners(serverConfig);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeServerConfiguration(ServerConfig serverConfig, boolean override) throws Exception {
        TechServerConfig.ServerConfigMismatchHandler handler;
        boolean failedBecauseOfBindings;
        Long requestSaveID;
        Message m = new Message(19000);
        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object) {
            requestSaveID = TechServerConfigManager.INSTANCE.getRequestedSaveConfigInstanceID();
            if (requestSaveID == null) {
                return true;
            }
            Message config = new Message();
            serverConfig.saveToMessage(null, config, false);
            System.out.println("[TechClient] Requesting save with ID " + requestSaveID);
            m.append(requestSaveID);
            m.append(override);
            m.append(config);
        }
        m = this.doTransact(m);
        boolean success = m.getNextBoolean();
        boolean bl = failedBecauseOfBindings = m.length() > 1;
        if (override || success) {
            System.out.println("[TechClient] Save successful with ID " + requestSaveID);
            TechServerConfigManager.INSTANCE.setServerConfigInstanceID(m.getNextLong());
            TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
            this.notifyServerConfigListeners(serverConfig);
            return true;
        }
        if (failedBecauseOfBindings) {
            Object[] failedBindings = m.getNextStringArray();
            System.out.println("[TechClient] Saving of server config failed because the following bindings failed: " + Arrays.toString(failedBindings));
            this.notifyFailedBindings((String[])failedBindings);
            TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
            TechServerConfig.INSTANCE.forceReload();
            return false;
        }
        System.out.println("[TechClient] Save failed with ID " + requestSaveID);
        Object object2 = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object2) {
            handler = this.notifyConfigServerMismatch();
        }
        if (handler.overwrite()) {
            System.out.println("[TechClient] User chose to overwrite");
            try {
                boolean bl2 = this.storeServerConfiguration(serverConfig, true);
                return bl2;
            }
            finally {
                this.notifyConfigServerMismatchHandled();
            }
        }
        if (handler.revert()) {
            System.out.println("[TechClient] User chose to revert");
            try {
                TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
                TechServerConfig.INSTANCE.forceReload();
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.notifyConfigServerMismatchHandled();
            }
        }
        return true;
    }

    @Override
    public void mergeTechProperties(String prefix, byte[] data) throws Exception {
        Message m = new Message(19200);
        m.append(prefix);
        m.append(data);
        this.doSend(m);
    }

    @Override
    public void setTechProperties(String prefix, byte[] data) throws Exception {
        Message m = new Message(19100);
        m.append(prefix);
        m.append(data);
        this.doSend(m);
    }

    public boolean putServerLicense(String licenseData) throws Exception {
        this.cachedAttendeeLimit = -1;
        this.cachedRemoteMachinesLimit = -1;
        Message m = new Message(18000);
        m.append(licenseData);
        m = this.doTransact(m);
        return m.getType() == 1;
    }

    public boolean removeServerLicense(long licenseID) throws Exception {
        this.cachedAttendeeLimit = -1;
        this.cachedRemoteMachinesLimit = -1;
        Message m = new Message(18003);
        m.append(licenseID);
        m = this.doTransact(m);
        return m.getType() == 1;
    }

    public BrandingSettings fetchBrandingSettings() throws Exception {
        Message m = new Message(31600);
        m = this.doTransact(m);
        Message msg = m.getNextMessage();
        return BrandingSettings.fromMessage(msg);
    }

    public void saveBrandingSettings(BrandingSettings savedSettings) throws Exception {
        Message m = new Message(31601);
        m.append(savedSettings.toMessage());
        this.doSend(m);
    }

    public ServerLogDetails getLoggingDetails() throws Exception {
        Message m = new Message(20000);
        m = this.doTransact(m);
        ServerLogDetails details = new ServerLogDetails();
        details.serverStartTime = m.getNextLong();
        details.totalLogsSizeBytes = m.getNextLong();
        return details;
    }

    public void requestServerLog(long start, long end, boolean fullLog) throws Exception {
        Message m = new Message(20000);
        m.append(start);
        m.append(end);
        m.append(fullLog);
        this.doTransact(m);
    }

    public Message getNextServerLogChunk() throws Exception {
        Message m = new Message(20010);
        return this.doTransact(m);
    }

    public KeytoolUtil.KeyStoreResult requestLetsEncryptCertificate(String domain, String email) throws Exception {
        Message m = new Message(38002);
        m.append(domain);
        m.append(email);
        m = this.doTransact(m);
        KeytoolUtil.KeyStoreResult result = new KeytoolUtil.KeyStoreResult();
        result.success = m.getNextInt();
        result.keystorePath = m.getNextString();
        result.errorMessage = m.getNextString();
        result.expiryDate = m.getNextLong();
        return result;
    }

    public KeytoolUtil.KeyStoreResult uploadKeystoreWithCertificate(File file, String storepass, String keypass) throws Exception {
        Message m = new Message(37000);
        m.append(FileUtil.readFile((File)file));
        m.append(storepass);
        m.append(keypass);
        m = this.doTransact(m);
        KeytoolUtil.KeyStoreResult result = new KeytoolUtil.KeyStoreResult();
        result.success = m.getNextInt();
        result.keystorePath = m.getNextString();
        result.errorMessage = m.getNextString();
        result.expiryDate = m.getNextLong();
        return result;
    }

    public KeytoolUtil.KeyStoreResult requestSelfSignedCertificate(String domain, String organisation) throws Exception {
        Message m = new Message(36000);
        m.append(domain);
        m.append(organisation);
        m = this.doTransact(m);
        KeytoolUtil.KeyStoreResult result = new KeytoolUtil.KeyStoreResult();
        result.success = m.getNextInt();
        result.keystorePath = m.getNextString();
        result.errorMessage = m.getNextString();
        result.expiryDate = m.getNextLong();
        return result;
    }

    public void updateServerManagement() throws Exception {
        Message m = new Message(7000);
        m = this.doTransact(m);
        int N = 0;
        try {
            ServerManagement.SIMPLEHELP = (Boolean)m.get(N++);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ServerManagement.SIMPLEGATEWAY = (Boolean)m.get(N++);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ServerManagement.SIMPLEDEMO = (Boolean)m.get(N++);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getMachinesLastModified() throws Exception {
        Message m = new Message(13100);
        m = this.doTransact(m);
        return (Long)m.get(0);
    }

    private Message[] batchFetchSimpleRequests(int[] messageIDs) throws Exception {
        Message m = new Message(67000);
        for (int messageID : messageIDs) {
            m.append(messageID);
        }
        System.out.println("[TechClient] Requesting batch simple requests");
        long start = System.currentTimeMillis();
        m = this.doTransact(m);
        System.out.println("[TechClient] Received batch simple requests (took " + (System.currentTimeMillis() - start) + "ms)");
        int responseCount = m.length();
        Message[] responses = new Message[responseCount];
        for (int i = 0; i < responseCount; ++i) {
            responses[i] = (Message)m.get(i);
        }
        return responses;
    }

    private Message[] batchFetchComplexRequests(Message[] messages) throws Exception {
        Message m = new Message(67500);
        for (Message message : messages) {
            m.append(message);
        }
        m = this.doTransact(m);
        int responseCount = m.length();
        Message[] responses = new Message[responseCount];
        for (int i = 0; i < responseCount; ++i) {
            responses[i] = (Message)m.get(i);
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchAndCacheSimpleRequests(int[] messageIDs) throws Exception {
        Message[] results = this.batchFetchSimpleRequests(messageIDs);
        Object object = this.PREFETCH_CACHE_LOCK;
        synchronized (object) {
            if (this.prefetchedIDToMessageResultsList == null) {
                this.prefetchedIDToMessageResultsList = new ArrayList();
            }
            this.prefetchedIDToMessageResultsList.addAll(Arrays.asList(results).subList(0, messageIDs.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchAndCacheComplexRequests(Message[] messages) throws Exception {
        Message[] results = this.batchFetchComplexRequests(messages);
        Object object = this.PREFETCH_CACHE_LOCK;
        synchronized (object) {
            if (this.prefetchedIDToMessageResultsList == null) {
                this.prefetchedIDToMessageResultsList = new ArrayList();
            }
            this.prefetchedIDToMessageResultsList.addAll(Arrays.asList(results).subList(0, messages.length));
        }
    }

    public Customer[] getAdvancedCustomerList() throws Exception {
        return this.getCustomerWaitingList();
    }

    public WebTransactor createWebTransactor() throws Exception {
        WebTransactionToken wtok = new WebTransactionToken(this.trans_BCU);
        Message m = new Message(130001);
        m.append(wtok.toMessage());
        this.doTransact(m);
        return new WebTransactor(wtok, this.getHost(), this.getPort());
    }

    public Message getProxyEntireMachineGroupList() throws Exception {
        Message m = new Message(13010);
        m = this.doTransact(m);
        return m;
    }

    public String[][] getEntireMachineGroupList() throws Exception {
        Message m = new Message(13010);
        m = this.doTransact(m);
        int length = m.length();
        String[][] result = new String[length][];
        for (int i = 0; i < length; ++i) {
            result[i] = m.getNextStringArray();
        }
        return result;
    }

    public Machine[] getEntireMachineList_Expensive() throws Exception {
        return this.getMachinesList();
    }

    public AccessSession[] getRemoteAccessSessions_Expensive() throws Exception {
        return this.getMachineSessionList();
    }

    public SupportSession[] getAdvancedConnectedList() throws Exception {
        return this.getCustomerSessionList();
    }

    private Customer[] getCustomerWaitingList() throws Exception {
        Message m = new Message(12000);
        m = this.doTransact(m);
        Customer[] info = new Customer[m.length()];
        for (int i = 0; i < info.length; ++i) {
            Message gi = (Message)m.get(i);
            info[i] = new Customer(gi);
        }
        return info;
    }

    private SupportSession[] getCustomerSessionList() throws Exception {
        Message m = new Message(14000);
        m = this.doTransact(m);
        SupportSession[] info = new SupportSession[m.length()];
        for (int i = 0; i < info.length; ++i) {
            Message gi = (Message)m.get(i);
            info[i] = (SupportSession)AbstractSession.fromMessage(gi);
        }
        return info;
    }

    private Machine[] getMachinesList() throws Exception {
        Message m = new Message(13000);
        m = this.doTransact(m);
        Machine[] info = new Machine[m.length()];
        for (int i = 0; i < info.length; ++i) {
            Message gi = (Message)m.get(i);
            info[i] = new Machine(gi);
        }
        return info;
    }

    private AccessSession[] getMachineSessionList() throws Exception {
        Message m = new Message(15000);
        m = this.doTransact(m);
        AccessSession[] info = new AccessSession[m.length()];
        for (int i = 0; i < info.length; ++i) {
            Message gi = (Message)m.get(i);
            info[i] = (AccessSession)AbstractSession.fromMessage(gi);
        }
        return info;
    }

    public void updateMachines(String[] s) throws Exception {
        System.out.println("[TechClient] Requesting update of machines:");
        Message m = new Message(23000);
        for (String value : s) {
            m.append(value);
            System.out.println("  " + value);
        }
        this.doSend(m);
        System.out.println("[TechClient] Requested updates of machines");
    }

    public void stopAndDisableV3Machine(String[] s) throws Exception {
        System.out.println("[TechClient] Requesting stop and disable of " + s.length + " machines.");
        Message m = new Message(24000);
        for (String value : s) {
            m.append(value);
        }
        this.doSend(m);
        System.out.println("[TechClient] Requested stop and disable of machines");
    }

    public void setStopOnNextRegister(String[] machineIDs, boolean stop) throws Exception {
        if (stop) {
            System.out.println("[TechClient] Requesting a future stop of offline machines (" + machineIDs.length + ")");
        } else {
            System.out.println("[TechClient] Cancelling a future stop of offline machines (" + machineIDs.length + ")");
        }
        Message m = new Message(31050);
        m.append(stop);
        m.append(machineIDs);
        this.doSend(m);
    }

    public void repairMachine(String[] s) throws Exception {
        System.out.println("[TechClient] Requesting repair of machines");
        Message m = new Message(65000);
        for (String value : s) {
            m.append(value);
            System.out.println("  " + value);
        }
        this.doSend(m);
        System.out.println("[TechClient] Requested repair of machines");
    }

    private String prepareMachineForConnect(String id, boolean isMachine, boolean retry, boolean requestAccess, long requestAccessTimeout, String requestedWindowsSessionID, int initialSessionMode) throws Exception {
        System.out.println("[TechClient] Requesting prepare connection to " + id);
        System.out.println("[TechClient] Shortened connection request to " + id);
        Message m = new Message(8100);
        if (!isMachine) {
            return null;
        }
        m.append(id);
        m.append(retry);
        m.append(requestAccess);
        m.append(requestAccessTimeout);
        m.append(requestedWindowsSessionID);
        m.append(initialSessionMode);
        Message ret = this.doTransact(m);
        System.out.println("[TechClient] Requested prepare connection to machine " + id);
        return (String)ret.get(0);
    }

    public BCUtil connect(long initialisationTime, ProxyConnectSettings settings) throws Exception {
        return this.connect("", initialisationTime, settings);
    }

    public String getPreviouslyConnectedCustomerOrMachineID() {
        return this.previousCustomerOrMachineID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BCUtil connect(String existingSessionID, long initialisationTime, ProxyConnectSettings settings) throws Exception {
        try {
            this.doSgUpdatingNotifications = true;
            if (existingSessionID == null) {
                existingSessionID = "";
            }
            System.out.println("[TechClient] Requesting connection to " + settings.customerOrMachineID);
            this.previousCustomerOrMachineID = settings.customerOrMachineID;
            Message m = new Message(2000);
            if (settings.isMachine) {
                m = new Message(8000);
            }
            m.append(settings.customerOrMachineID);
            m.append(settings.retry);
            m.append(existingSessionID);
            m.append(initialisationTime);
            m.append(settings.requestAccess);
            m.append(settings.requestAccessTimeout);
            m.append(settings.initialMode);
            m.append(settings.requestedWindowsSessionID);
            m.append(settings.isMobile);
            m.append(settings.appTunnelHostname);
            m.append(settings.appTunnelPort);
            System.out.println("[TechClient] " + m.toString());
            try {
                if (JWLaunchProperties.isJWrapperSetup()) {
                    m.append(JWLaunchProperties.getProperty((String)"fover_so_mustwait").equalsIgnoreCase("yes"));
                    JWLaunchProperties.deleteProperty((String)"fover_so_mustwait");
                } else {
                    m.append(false);
                }
            }
            catch (Exception x) {
                m.append(false);
            }
            Message response = this.doTransact(m);
            ConnectedTarget.TARGET = AbstractSession.fromMessage(response.getNextMessage());
            BCUtil sessionBCU = new BCUtil();
            sessionBCU.readFromBytes(response.getNextByteArray());
            this.custNetID = response.getNextString();
            this.techNetID = response.getNextString();
            if (settings.isMachine) {
                this.techUser.permissions = TechGroupPermissions.fromMessage(response.getNextMessage());
            }
            BCUtil bCUtil = sessionBCU;
            return bCUtil;
        }
        finally {
            this.doSgUpdatingNotifications = false;
        }
    }

    public String getTechNetID() {
        return this.techNetID;
    }

    public String getCustNetID() {
        return this.custNetID;
    }

    public void disconnect(String reason) {
        try {
            if (this.notifier != null) {
                this.notifier.die();
            }
            if (this.processor != null) {
                this.processor.die();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sock.isAlive() && !this.sock.isDown()) {
                this.sock.stop(reason);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public NodeLink getConnectedSocketAndInvalidateTC() {
        return this.sock;
    }

    public OutputStream getConnectedOutputStream() {
        return this.mxout.getOutputStream((short)2);
    }

    public InputStream getConnectedInputStream() {
        return this.mxin.getInputStream((short)2, "User Connect Plane");
    }

    public void kickUser(Customer customer) throws Exception {
        Message m = new Message(3000);
        m.append(customer.getCustomerID());
        this.doSend(m);
        System.out.println("[TechClient] Requested kick customer " + customer);
    }

    public void killSession(AbstractSession session) throws Exception {
        Message m = session instanceof SupportSession ? new Message(5000) : new Message(10000);
        m.append(session.getSessionID());
        this.doSend(m);
        System.out.println("[TechClient] Requested kill connection " + session);
    }

    public void deletePresentation(String demoName) throws Exception {
        Message m = new Message(41000);
        m.append(demoName);
        this.doSend(m);
    }

    public void requestPortMapping() throws Exception {
        Message m = new Message(74000);
        this.doSend(m);
    }

    public boolean isPortMapped() throws Exception {
        Message m = new Message(76000);
        m = this.doTransact(m);
        return m.getAsBoolean(0);
    }

    public void removePortMapping() throws Exception {
        Message m = new Message(75000);
        this.doSend(m);
    }

    public void bufferWolRequest(Machine from, NetAdapter[] to) {
        if (this.bufferedWols == null) {
            this.bufferedWols = new Message(77000);
        }
        Message m = new Message();
        m.append(from.getMachineID());
        Message sub = new Message(1589706769);
        m.append(sub);
        for (NetAdapter aTo : to) {
            try {
                sub.append(WakeOnLan.getAddrBytes(aTo.ip));
                sub.append(WakeOnLan.getMacBytes(aTo.mac));
                System.out.println("[TechClient] Will request WOL from " + from.getMachineName() + " for " + aTo.ip + " / " + aTo.mac);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bufferedWols.append(m);
    }

    public void doRemoteMachineNotifications(ArrayList<String> machineIDs, String heading, String message) throws Exception {
        Message m = new Message(180000);
        System.out.println("[TechClient] Requesting popup notification on " + machineIDs.size() + " machines");
        m.append(heading);
        m.append(message);
        m.append(machineIDs.size());
        for (String id : machineIDs) {
            m.append(id);
        }
        this.doSend(m);
    }

    public void doBufferedWolsNow() throws Exception {
        this.doSend(this.bufferedWols);
        this.bufferedWols = null;
    }

    public boolean presentationHasStarted(String demoName) throws Exception {
        Message m = new Message(42000);
        m.append(demoName);
        m = this.doTransact(m);
        return (Boolean)m.get(0);
    }

    public Invitation requestNewInvitation(Invitation invitationResult) throws Exception {
        Message m = new Message(50000);
        m.append(invitationResult.toMessage());
        m = this.doTransact(m);
        Message result = (Message)m.get(0);
        return Invitation.fromMessage(result);
    }

    public void sendInvitationEmail(Invitation selectedInvitation, String address, String url, boolean standalone) throws Exception {
        Message m = new Message(55000);
        m.append(selectedInvitation.toMessage());
        m.append(address);
        m.append(url);
        m.append(standalone);
        this.doSend(m);
    }

    public void sendInvitationQuickEmail(String name, String address, String url) throws Exception {
        Message m = new Message(56000);
        m.append(name);
        m.append(address);
        m.append(url);
        this.doSend(m);
    }

    public InvitationConfiguration getInvitationConfiguration() throws Exception {
        Message m = new Message(54000);
        m = this.doTransact(m);
        InvitationConfiguration config = new InvitationConfiguration();
        config.emailText = m.getAsString(0);
        config.detailsXML = m.getAsString(1);
        return config;
    }

    public void updateInvitation(Invitation invitation) throws Exception {
        Message m = new Message(52000);
        m.append(invitation.toMessage());
        this.doSend(m);
    }

    public EditableInvitationWrapper[] getAllInvitations() throws Exception {
        Message m = new Message(53000);
        m = this.doTransact(m);
        EditableInvitationWrapper[] invitations = new EditableInvitationWrapper[m.getAsInt(0)];
        for (int i = 0; i < invitations.length * 2; i += 2) {
            boolean canEdit = m.getAsBoolean(i + 1);
            Invitation invitation = Invitation.fromMessage((Message)m.get(i + 2));
            invitations[i / 2] = new EditableInvitationWrapper(invitation, canEdit);
        }
        return invitations;
    }

    public void deleteInvitations(ArrayList<Invitation> removedInvitations) throws Exception {
        Message m = new Message(51000);
        m.append(removedInvitations.size());
        for (Invitation invitation : removedInvitations) {
            m.append(invitation.toMessage());
        }
        this.doSend(m);
    }

    public boolean registerPresentation(String demoName, String demoDesc, String demoPass, boolean isSecure, boolean acceptDetails, boolean isPrivate) throws Exception {
        Message m = new Message(39000);
        m.append(demoName);
        m.append(demoDesc);
        m.append(demoPass);
        m.append(isSecure);
        m.append(acceptDetails);
        m.append(isPrivate);
        m = this.doTransact(m);
        return (Boolean)m.get(0);
    }

    public long getLastBackup() throws Exception {
        Message m = new Message(68002);
        if ((m = this.doTransact(m)).length() == 0) {
            return -1L;
        }
        return m.getNextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadBackupRestoreFileAndRestart(File localConfig) {
        TechClientFS techFS = new TechClientFS(this, "SG_Server");
        File remoteFile = new File("configuration", "restoredconfig.zip");
        try {
            System.out.println("[TechClient] Fetching last save: " + remoteFile);
            LocalFS localFS = new LocalFS();
            GFile localFSGFile = LocalFS.getFile(localConfig);
            System.out.println("[TechClient] Source GFile is " + localFSGFile.path() + " - " + localFSGFile.name);
            GFile remoteGFile = new GFile(remoteFile.getPath(), remoteFile.getName(), remoteFile.lastModified(), remoteFile.length(), remoteFile.isDirectory(), remoteFile.isHidden());
            techFS.deleteFiles(new GFile[]{remoteGFile});
            System.out.println("[TechClient] Target GFile is " + remoteGFile.path() + " - " + remoteGFile.name);
            new FSMirror().mirror(localFS, localFSGFile, techFS, remoteGFile);
            System.out.println("[TechClient] Restore file uploaded");
            Message m = new Message(68006);
            m.append(true);
            System.out.println("[TechClient] Calculating hash for restore zip");
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(localConfig));){
                m.append(BCUtil.getSha256of((InputStream)in));
            }
            System.out.println("[TechClient] Requesting server restart");
            Message ret = this.doTransact(m);
            if (ret.getType() == -4) {
                System.out.println("[TechClient] Server unexpectedly claimed we do not have permissions");
            } else if (ret.getType() == 1) {
                System.out.println("[TechClient] Server will restart");
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    public void restartServer() throws Exception {
        Message m = new Message(68006);
        m.append(false);
        m.append(new byte[0]);
        this.doTransact(m);
    }

    public void requestConfigBackupZip() throws Exception {
        Message m = new Message(68001);
        this.doTransact(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfigBackupZipTo(File saveFile, FSMirror.ProgressListener listener) throws Exception {
        if (saveFile.exists()) {
            saveFile.delete();
        }
        TechClientFS techFS = new TechClientFS(this, "SG_Server");
        File remoteFile = new File("configuration", "lastbackup.dat");
        try {
            System.out.println("[TechClient] Fetching last save: " + remoteFile);
            try (BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(saveFile));){
                LocalFS localFS = new LocalFS();
                GFile localFSGFile = LocalFS.getFile(saveFile);
                System.out.println("[SessionDownloader] Source GFile is " + localFSGFile.path() + " - " + localFSGFile.name);
                GFile remoteGFile = new GFile(remoteFile.getPath(), remoteFile.getName(), remoteFile.lastModified(), remoteFile.length(), remoteFile.isDirectory(), remoteFile.isHidden());
                System.out.println("[SessionDownloader] Target GFile is " + remoteGFile.path() + " - " + remoteGFile.name);
                new FSMirror(listener).mirror(techFS, remoteGFile, localFS, localFSGFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            saveFile.delete();
            throw ex;
        }
    }

    public String webserviceGetLatestVersion() throws Exception {
        Message m = new Message(70000);
        m = this.doTransact(m);
        return m.getAsString(0);
    }

    public boolean webserviceIsPublic() throws Exception {
        Message m = new Message(71000);
        m = this.doTransact(m);
        return m.getAsBoolean(0);
    }

    public String webserviceGetPublicIP() throws Exception {
        Message m = new Message(72000);
        m = this.doTransact(m);
        return m.getAsString(0);
    }

    public WindowsFirewallUtil.FirewallStatus getFirewallStatus() throws Exception {
        Message m = new Message(73000);
        m = this.doTransact(m);
        return WindowsFirewallUtil.FirewallStatus.fromMessage(m);
    }

    public int getAttendeeLimit() {
        try {
            if (this.cachedAttendeeLimit != -1) {
                return this.cachedAttendeeLimit;
            }
            Message m = new Message(45000);
            m = this.doTransact(m);
            this.cachedAttendeeLimit = (Integer)m.get(0);
            return this.cachedAttendeeLimit;
        }
        catch (Exception x) {
            return 0;
        }
    }

    public void requestServerToFetchServiceLog(long sessionID, String machineID) throws Exception {
        Message m = new Message(105000);
        m.append(sessionID);
        m.append(machineID);
        if (FixedByteBuffer.INSTANCE != null) {
            m.append(SystemInfo.getFullInfo() + "\n" + FixedByteBuffer.INSTANCE.getContents());
        } else {
            m.append(SystemInfo.getFullInfo() + "\n--");
        }
        this.doTransact(m);
    }

    public void setAvatarImage(String login, byte[] imageBytes) throws Exception {
        Message m = new Message(103000);
        m.append(login);
        m.append(imageBytes);
        this.doSend(m);
    }

    public void batchLoadAvatarDebuggingAndToolBox(String login) throws Exception {
        Message av = new Message(104000);
        av.append(login);
        Message debug = new Message(107000);
        Message toolBox = new Message(34200);
        this.prefetchAndCacheComplexRequests(new Message[]{av, debug, toolBox});
    }

    public byte[] getAvatarImage(String login) throws Exception {
        Message m = new Message(104000);
        m.append(login);
        m = this.doTransact(m);
        return (byte[])m.get(0);
    }

    public void loadCentralisedDebuggingProperties() throws Exception {
        Message m = new Message(107000);
        m = this.doTransact(m);
        Properties p = PropertiesToMessage.toProperties(m);
        CentralDebugging.loadCentralisedSwitchesFromProperties(p);
    }

    public DemoInfo[] getPresentationList() throws Exception {
        Message m = new Message(40000);
        m = this.doTransact(m);
        DemoInfo[] infos = new DemoInfo[m.length()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new DemoInfo();
            infos[i].fromMessage((Message)m.get(i));
        }
        return infos;
    }

    public AttendeeInfo[] getAttendeeInfoForPresentation(String demoName) throws Exception {
        Message m = new Message(44000);
        m.append(demoName);
        m = this.doTransact(m);
        int length = m.getAsInt(0);
        AttendeeInfo[] infos = new AttendeeInfo[length];
        for (int i = 0; i < length; ++i) {
            infos[i] = new AttendeeInfo();
            infos[i].fromMessage((Message)m.get(i + 1));
        }
        return infos;
    }

    public boolean setTechnicianPassword(String newPassword) throws Exception {
        Message m = new Message(66000);
        m.append(newPassword);
        this.doSend(m);
        return true;
    }

    public Message doProxiedClientControllerTransaction(String demoName, Message m) throws Exception {
        Message mt = new Message(43000);
        mt.append(demoName);
        mt.append(m);
        mt = this.doTransact(mt);
        return (Message)mt.get(0);
    }

    public void startClient(String id, boolean isMachine, boolean retry, int initialSessionMode, boolean requestAccess, long requestTimeout, boolean viewOnly, WindowBoundsUtil.DesiredWindowBounds windowBounds, String requestedWindowsSessionID, PortForwardRequest portForwardRequest) throws Exception {
        this.startClient(id, isMachine, retry, initialSessionMode, requestAccess, requestTimeout, viewOnly, windowBounds, requestedWindowsSessionID, portForwardRequest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClient(String id, boolean isMachine, boolean retry, int initialSessionMode, boolean requestAccess, long requestTimeout, boolean viewOnly, WindowBoundsUtil.DesiredWindowBounds windowBounds, String requestedWindowsSessionID, PortForwardRequest portForwardRequest, Properties customProps) throws Exception {
        String safetechname;
        String[] proxyInfo = null;
        try {
            proxyInfo = ProxyUtil.detectProxy(new URL(SGHttpsUtil.getRequiredHttpProtocol() + "://" + this.host + ":" + this.port + "/"));
            System.out.println("Proxy Host: " + proxyInfo[0]);
            System.out.println("Proxy Port: " + proxyInfo[1]);
        }
        catch (NullPointerException t) {
            System.out.println("No proxy detected");
        }
        catch (Throwable t) {
            System.out.println("Failed to detect proxy: " + t);
            t.printStackTrace();
        }
        String langfile = JWSystem.getAllAppVersionsSharedFolder() + File.separator + this.langfilename + ".txt";
        String safeuname = this.techUser.username;
        if (this.techUser.isServerAdmin()) {
            safeuname = null;
        }
        if (safeuname != null && safeuname.trim().length() == 0) {
            safeuname = null;
        }
        if ((safetechname = this.techUser.displayName) != null && safetechname.trim().length() == 0) {
            safetechname = null;
        }
        TechHelpUIArguments args = new TechHelpUIArguments();
        args.setLanguage(langfile);
        args.setIsMachine(isMachine);
        args.setHost(this.host);
        args.setPort(this.port);
        args.setUsername(safeuname);
        args.setPassword(this.credentials.getPassword());
        args.setConnectCustomerOrMachineByID(id);
        args.setTechName(safetechname);
        args.setSHRetry(retry);
        args.setInitialSessionType(initialSessionMode);
        args.setRequestAccess(requestAccess);
        args.setRequestTimeout(requestTimeout);
        args.setViewOnly(viewOnly);
        args.setTTSessionID(this.getSessionID());
        args.setWindowBounds(windowBounds);
        args.setRequestedWindowsSessionID(requestedWindowsSessionID);
        if (portForwardRequest != null && portForwardRequest.portForwardHostname != null && portForwardRequest.portForwardPort > 0) {
            System.out.println("[TechClient] Requesting port forwarding (" + portForwardRequest.portForwardHostname + ":" + portForwardRequest.portForwardPort);
            args.setPortForwardSettings(portForwardRequest.portForwardHostname, portForwardRequest.portForwardPort);
        }
        System.out.println("[TechClient] Saving window bounds as " + windowBounds);
        if (proxyInfo != null) {
            args.setProxyHost(proxyInfo[0]);
            args.setProxyPort(proxyInfo[1]);
        }
        if (Switches.SH_tabbedSessions && Switches.SH_sessionsInTechUiProcess && TechClient.getSessionWindows().size() > 0) {
            Properties populatedProperties = args.getPopulatedProperties();
            SHMemoryPolicy.applyTechnicianSessionPolicy(populatedProperties);
            ThreadGroup sessionTG = new ThreadGroup("Session " + id + " " + new Date());
            Properties mergedProperties = JWSystem.buildInheritedLaunchProperties((Properties)populatedProperties, (String)"SessionUI");
            System.out.println("[TechClient] Our properties n=" + JWLaunchProperties.getAsProperties().size());
            System.out.println("[TechClient] Custom properties n=" + populatedProperties.size());
            System.out.println("[TechClient] Merged properties n=" + mergedProperties.size());
            JWLaunchProperties.setPropertyMapFor((ThreadGroup)sessionTG, (Properties)mergedProperties);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Tech UI] Launching tabbed tech session process now");
            }
            final TechHelpUIArguments fargs = args;
            new Thread(sessionTG, "SessionLaunchThread"){

                @Override
                public void run() {
                    try {
                        ProxyConnectSettings proxyConnectSettings = ProxyConnectSettings.getProxyConnectSettingsForTechHelpUI(fargs);
                        TechHelpUi.launchAdditionalSession((ProxyConnectSettings)proxyConnectSettings);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }.start();
        } else if (Switches.SH_tabbedSessions && TechClient.getSessionWindows().size() > 0) {
            TechClientIPCHandler window = TechClient.getSessionWindows().get(0);
            window.launchSession(args);
        } else {
            if (isMachine) {
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Tech UI] Asking server to prepare machine for connection");
                }
                System.out.println("[TechClient] Preparing machine for connection");
                try {
                    String ID = this.prepareMachineForConnect(id, isMachine, retry, requestAccess, requestTimeout, requestedWindowsSessionID, initialSessionMode);
                    args.setPreConnectedID(ID);
                    if (portForwardRequest != null && portForwardRequest.messageListener != null) {
                        portForwardRequest.messageListener.setSessionID(ID);
                    }
                }
                catch (Throwable t) {
                    System.out.println("[TechClient] Warning: preparing machine for connection failed. (" + t.getClass().getName() + ": " + t.getMessage() + "");
                }
            }
            Properties populatedProperties = args.getPopulatedProperties();
            if (JWTesting.amTesting()) {
                populatedProperties.setProperty(JWTesting.JWA_REPORT_PORT, JWLaunchProperties.getProperty((String)JWTesting.JWA_REPORT_PORT));
                if (Testing.queryTestingBoolean("TEST_TECHUI_LAUNCH_ONE_ACCESS_SESSION_QUIT")) {
                    System.out.println("[Testing] Setting up session to quit randomly");
                    populatedProperties.setProperty("exit_timebomb", "" + Testing.getFrontWeightedRandom(15000, 90000));
                }
            }
            SHMemoryPolicy.applyTechnicianSessionPolicy(populatedProperties);
            try {
                if (customProps != null) {
                    Object[] keys;
                    for (Object object : keys = customProps.keySet().toArray()) {
                        String key = (String)object;
                        String value = customProps.getProperty(key);
                        populatedProperties.setProperty(key, value);
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            JWSockIPC.setupForIPC((Properties)populatedProperties, (boolean)true);
            if (Switches.SH_expose_as_a_service_dev_code && initialSessionMode == 5) {
                JWSystem.forkVirtualApp((String)"HeadlessSessionUI", (Properties)populatedProperties, null);
            } else {
                Properties populatedPropertiesForPrelaunch = args.getPopulatedPropertiesForPrelaunch();
                populatedProperties.setProperty("xmx_override", "512");
                populatedPropertiesForPrelaunch.setProperty("xmx_override", "512");
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Tech UI] Launching tech session process now");
                }
                if (Switches.SH_sessionsInTechUiProcess) {
                    System.out.println("[TechClient] Launching session inside TechUI process");
                    ThreadGroup sessionTG = new ThreadGroup("Session " + id + " " + new Date());
                    Properties mergedProperties = JWSystem.buildInheritedLaunchProperties((Properties)populatedProperties, (String)"SessionUI");
                    System.out.println("[TechClient] Our properties n=" + JWLaunchProperties.getAsProperties().size());
                    System.out.println("[TechClient] Custom properties n=" + populatedProperties.size());
                    System.out.println("[TechClient] Merged properties n=" + mergedProperties.size());
                    JWLaunchProperties.setPropertyMapFor((ThreadGroup)sessionTG, (Properties)mergedProperties);
                    Thread thread = new Thread(sessionTG, "SessionLaunch " + new Date()){

                        @Override
                        public void run() {
                            try {
                                TechHelpUi.launchSessionUI();
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                        }
                    };
                    thread.start();
                } else {
                    JWSystem.forkVirtualApp((String)"SessionUI", (Properties)populatedProperties, null);
                    if (Switches.SH_tcStripPopulatedPropsForPreLaunch) {
                        JWSystem.prepareForkVirtualApp((String)"SessionUI", (Properties)populatedPropertiesForPrelaunch, null);
                    } else {
                        JWSystem.prepareForkVirtualApp((String)"SessionUI", (Properties)populatedProperties, null);
                    }
                }
            }
            TechClientIPCHandler handler = new TechClientIPCHandler(this, populatedProperties, portForwardRequest);
            Object object = sessionWindows_LOCK;
            synchronized (object) {
                sessionWindows.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<TechClientIPCHandler> getSessionWindows() {
        Object object = sessionWindows_LOCK;
        synchronized (object) {
            ArrayList<TechClientIPCHandler> list = new ArrayList<TechClientIPCHandler>();
            for (int i = 0; i < sessionWindows.size(); ++i) {
                TechClientIPCHandler handler = sessionWindows.get(i);
                if (handler.isConnected()) {
                    list.add(handler);
                    continue;
                }
                sessionWindows.remove(i--);
            }
            return list;
        }
    }

    public boolean amOverMachineLimit() {
        return this.overMachineLimit;
    }

    public TransientTechUser getTechUser() {
        return this.techUser;
    }

    public void overwriteSessionID(byte[] newID) {
        this.credentials.setSessionToken(newID);
    }

    public byte[] getSessionID() {
        return this.credentials.getSessionToken();
    }

    public long getOldestHistoricalSession() {
        return this.oldestHistoricalSession;
    }

    public void requestNewHistorySearch(SearchConfig query) throws Exception {
        Message m = new Message(109000);
        m.append(query.toMessage());
        this.doTransact(m);
    }

    public void requestNewAlertHistorySearch(AlertSearchConfig query) throws Exception {
        Message m = new Message(109050);
        m.append(query.toMessage());
        this.doTransact(m);
    }

    public void requestMoreAlertHistoryData(int maxResults) throws Exception {
        Message m = new Message(109051);
        m.append(maxResults);
        this.doSend(m);
    }

    public void requestMoreHistoryData(int maxResults) throws Exception {
        Message m = new Message(109001);
        m.append(maxResults);
        this.doSend(m);
    }

    public Software requestMachineSoftware(String machineID) throws Exception {
        Message m = new Message(109010);
        m.append(machineID);
        m = this.doTransact(m);
        return OSSoftwareUtil.fromMessage(m.getNextMessage());
    }

    public void setVideoPassword(long sessionStartTime, String id, String password) throws Exception {
        Message m = new Message(109006);
        m.append(sessionStartTime);
        m.append(id);
        m.append(password);
        this.doSend(m);
    }

    public void notifyServerOfUploadedVideo(long sessionStartTime, String id) throws Exception {
        Message m = new Message(109002);
        m.append(sessionStartTime);
        m.append(id);
        this.doSend(m);
    }

    public VideoDetails getVideoDetailsForSession(AbstractSession selectedSession) throws Exception {
        Message m = new Message(109003);
        m.append(selectedSession.getStartTime());
        m.append(selectedSession.getSessionID());
        m = this.doTransact(m);
        VideoDetails details = new VideoDetails();
        details.existsOnServer = m.getNextBoolean();
        if (details.existsOnServer) {
            details.lengthInBytes = m.getNextLong();
            details.parts = m.getNextInt();
            details.duration = m.getNextLong();
        }
        details.htmlExistsOnServer = m.getNextBoolean();
        details.videoID = m.getNextString();
        if (m.getNextBoolean()) {
            details.passwordUTF8 = m.getNextByteArray();
        }
        return details;
    }

    public void deleteVideo(AbstractSession selectedSession) throws Exception {
        Message m = new Message(109004);
        m.append(selectedSession.getStartTime());
        m.append(selectedSession.getSessionID());
        this.doSend(m);
    }

    public void setAutoUpdateServices(Machine[] machines, boolean autoUpdate) throws Exception {
        Message m = new Message(66500);
        m.append(autoUpdate);
        for (Machine machine1 : machines) {
            m.append(machine1.getMachineID());
        }
        this.doTransact(m);
        for (Machine machine : machines) {
            machine.setAutoUpdating(autoUpdate);
        }
    }

    public SimpleGatewayConfig getServiceConfigViaSecMsg(String machineID, String password) throws Exception {
        Message m = new Message(1589706760);
        m.append(password);
        Message wrapper = new Message(1589706768);
        wrapper.append(machineID);
        wrapper.append(m);
        m = this.doTransact(wrapper);
        boolean requiresPassword = m.getNextBoolean();
        if (requiresPassword) {
            throw new PasswordRequiredException();
        }
        byte[] config = m.getNextByteArray();
        return new SimpleGatewayConfig(config);
    }

    public void rebootComputerViaSecMsg(String machineID) throws Exception {
        Message m = new Message(1589706804);
        Message wrapper = new Message(1589706768);
        wrapper.append(machineID);
        wrapper.append(m);
        this.doSend(wrapper);
    }

    public void restartServiceViaSecMsg(String machineID) throws Exception {
        Message m = new Message(1589706803);
        Message wrapper = new Message(1589706768);
        wrapper.append(machineID);
        wrapper.append(m);
        this.doSend(wrapper);
    }

    public byte[] getLogsViaSecMsg(String machineID, String password) throws Exception {
        Message m = new Message(1589706772);
        m.append(password);
        Message wrapper = new Message(1589706768);
        wrapper.append(machineID);
        wrapper.append(m);
        m = this.doTransact(wrapper);
        boolean requiresPassword = m.getNextBoolean();
        if (requiresPassword) {
            throw new PasswordRequiredException();
        }
        return m.getNextByteArray();
    }

    public void storeServiceConfigViaSecMsg(String machineID, String password, SimpleGatewayConfig config) throws Exception {
        Message m = new Message(1589706761);
        m.append(password);
        m.append(config.save(true));
        Message wrapper = new Message(1589706768);
        wrapper.append(machineID);
        wrapper.append(m);
        m = this.doTransact(wrapper);
        boolean requiresPassword = m.getNextBoolean();
        if (requiresPassword) {
            throw new PasswordRequiredException();
        }
    }

    public void requestRefusedUpdateRetry(String machineID) throws Exception {
        Message m = new Message(1589706802);
        Message wrapper = new Message(1589706768);
        wrapper.append(machineID);
        wrapper.append(m);
        this.doTransact(wrapper);
    }

    public void setNotes(Machine machine, String newText) throws Exception {
        Message m = new Message(13700);
        m.append(machine.getMachineID());
        m.append(newText);
        this.doSend(m);
    }

    public void setWarnings(Machine machine, String newText) throws Exception {
        Message m = new Message(13701);
        m.append(machine.getMachineID());
        m.append(newText);
        this.doSend(m);
    }

    public void reconnect(boolean inSession, NodeLinkStatusListener status) throws Exception {
        this.createTechClient(this.langfilename, this.lang, this.host, this.port, this.credentials, inSession, this.listener, status, null, false);
    }

    public String getLicenseSource() throws Exception {
        Message m = new Message(13800);
        m = this.doTransact(m);
        return m.getNextString();
    }

    public void doSyncSend(String machineID, Message send) throws Exception {
        Message m = new Message(47000);
        m.append(machineID);
        m.append(send);
        this.doSend(m);
    }

    public Message doSyncTransaction(String machineID, Message send) throws Exception {
        Message m = new Message(48000);
        m.append(machineID);
        m.append(send);
        Message ret = this.doTransact(m);
        return ret.getAsMessage(0);
    }

    public void addBlockedMachines(Machine[] machines) throws Exception {
        Message m = new Message(13900);
        m.append(machines.length);
        for (Machine machine : machines) {
            m.append(machine.getMachineID());
        }
        this.doSend(m);
    }

    public void setRunToolWhenNextOnline(Machine[] machines, boolean enable, ToolBoxItem itemToRun, int maxSessionsToUse) throws Exception {
        Message m = new Message(31052);
        m.append(enable);
        if (itemToRun != null) {
            m.append(itemToRun.toMessage());
        } else {
            m.append((Message)null);
        }
        m.append(machines.length);
        for (Machine machine : machines) {
            m.append(machine.getMachineID());
        }
        this.doSend(m);
    }

    public void setMigrateWhenNextOnline(Machine[] offlineMachines, boolean enable, String add, String remove) throws Exception {
        if (add == null) {
            add = "";
        }
        if (remove == null) {
            remove = "";
        }
        Message m = new Message(31051);
        m.append(enable);
        m.append(add);
        m.append(remove);
        m.append(this.trans_BCU.getSavedPublicKeyAuthHash());
        m.append(offlineMachines.length);
        for (Machine machines : offlineMachines) {
            m.append(machines.getMachineID());
        }
        this.doSend(m);
    }

    public void migrateServices(Machine[] availableMachines, String add, String remove) {
        if (add == null) {
            add = "";
        }
        if (remove == null) {
            remove = "";
        }
        for (Machine availableMachine : availableMachines) {
            Message m = new Message(1589706776);
            Message madd = new Message();
            madd.append(add);
            if (add.length() > 0) {
                madd.append(this.trans_BCU.getSavedPublicKeyAuthHash());
            }
            Message mremove = new Message();
            mremove.append(remove);
            m.append(madd);
            m.append(mremove);
            Message wrapper = new Message(1589706768);
            wrapper.append(availableMachine.getMachineID());
            wrapper.append(m);
            try {
                this.doTransact(wrapper);
                System.out.println("[TechClient] Migration of " + availableMachine.getMachineID() + " was accepted.");
            }
            catch (Throwable t) {
                System.out.println("[TechClient] Migration of " + availableMachine.getMachineID() + " failed for some reason.");
                t.printStackTrace();
            }
        }
    }

    public String getConnectionIDUsingFilter(String directCustomerByFilter, boolean isMachine) {
        try {
            Message m = new Message(14100);
            m.append(directCustomerByFilter);
            m.append(isMachine);
            m = this.doTransact(m);
            return m.getAsString(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public ArrayList<String> getAllMachinesForAlert(LocatedAlert alert) {
        Message m = new Message(14900);
        m.append(alert.getID());
        try {
            m = this.doTransact(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ArrayList<String> machines = new ArrayList<String>();
        while (m.hasNext()) {
            machines.add(m.getNextString());
        }
        return machines;
    }

    public String[] getAllAlertIDsForMachine(Machine machine) {
        Message m = new Message(14904);
        m.append(machine.getID());
        try {
            m = this.doTransact(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ArrayList<String> alertIDs = new ArrayList<String>();
        while (m.hasNext()) {
            alertIDs.add(m.getNextString());
        }
        return alertIDs.toArray(new String[0]);
    }

    public void newAlert(ResourceContainer alert) {
        if (LocalSwitches.DEV_acculogAlertPropagation) {
            Acculog.log("[Alert Propagation] TechClient reporting creation of new alert " + alert.getName());
        }
        Message m = new Message(14500);
        m.append(alert.toMessage());
        try {
            this.doTransact(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void updateAlerts(ResourceContainer[] alerts) {
        Message m = new Message(14600);
        for (ResourceContainer alert : alerts) {
            if (LocalSwitches.DEV_acculogAlertPropagation) {
                Acculog.log("[Alert Propagation] TechClient reporting update of new alert " + alert.getName());
            }
            m.append(alert.toMessage());
        }
        try {
            this.doTransact(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void deleteAlerts(ResourceContainer[] alerts) {
        Message m = new Message(14700);
        m.append(alerts.length);
        for (ResourceContainer alert : alerts) {
            m.append(alert.toMessage());
        }
        try {
            this.doTransact(m);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public ResourceContainer[] getEntireAlertList_Expensive() throws Exception {
        System.out.println("[Alerts] Requesting all alerts");
        Message m = new Message(14200);
        m = this.doTransact(m);
        ResourceContainer[] info = new ResourceContainer[m.length()];
        System.out.println("[Alerts] Got " + info.length + " alerts");
        for (int i = 0; i < info.length; ++i) {
            Message gi = (Message)m.get(i);
            info[i] = ResourceSerialiser.resourceContainerFromMessage(gi);
        }
        return info;
    }

    public long fetchKeystoreExpiryDate() throws Exception {
        Message m = new Message(38003);
        m = this.doTransact(m);
        return m.getNextLong();
    }

    public void renewLECertificate() throws Exception {
        Message m = new Message(38004);
        this.doTransact(m);
    }

    public KeyStoreUtility.KeystoreValidationResult fetchKeystoreDetails() throws Exception {
        Message m = new Message(38001);
        m = this.doTransact(m);
        KeyStoreUtility.KeystoreValidationResult result = new KeyStoreUtility.KeystoreValidationResult();
        result.loadFrom(m.getNextMessage());
        return result;
    }

    public boolean testRadiusLogin(String username, String password) throws Exception {
        Message m = new Message(33200);
        m.append(username);
        m.append(password);
        m = this.doTransact(m);
        boolean success = (Boolean)m.get(0);
        if (!success) {
            String message = "Authentication Failed.";
            if (m.length() > 1) {
                message = (String)m.get(1);
            }
            throw new Exception(message);
        }
        return true;
    }

    public boolean testRadiusConnectSoServer(String hostname, int port, String authentication, String secret) throws Exception {
        Message m = new Message(33100);
        m.append(hostname);
        m.append(port);
        m.append(authentication);
        m.append(secret);
        m = this.doTransact(m);
        boolean success = (Boolean)m.get(0);
        if (!success) {
            String message = "Unknown";
            if (m.length() > 1) {
                message = (String)m.get(1);
            }
            throw new Exception(message);
        }
        return true;
    }

    public void clearResource(ToolBoxItem item, ToolBoxResource resource) throws Exception {
        String itemID = item.getID();
        Message m = new Message(34500);
        m.append(itemID);
        m.append(resource.toMessage());
        this.doSend(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addResponseListener(MachineResponseListener listener) {
        Object object = this.respListeners_LOCK;
        synchronized (object) {
            ++this.machineResponseListenerID;
            this.respListeners.put(this.machineResponseListenerID, listener);
            return this.machineResponseListenerID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResponseListener(long id, Message response, String machineID) {
        Object object = this.respListeners_LOCK;
        synchronized (object) {
            MachineResponseListener listener = this.respListeners.get(id);
            if (listener != null) {
                listener.machineResponse(machineID, response);
            }
        }
    }

    public void cancelToolboxRun(Machine[] machines, long runID, int maximumSessionsToUse) throws Exception {
        Message m = new Message(1589727273);
        m.append(runID);
        this.proxyToAll(machines, m, null, maximumSessionsToUse);
    }

    public long runToolboxItem(Machine[] machines, ToolBoxItem item, MachineResponseListener listener, int maximumSessionsToUse) throws Exception {
        Message mproxy = new Message(1589727253);
        mproxy.append(item.toMessage());
        return this.proxyToAll(machines, mproxy, listener, maximumSessionsToUse);
    }

    private long proxyToAll(Machine[] machines, Message toProxy, MachineResponseListener listener, int maximumSessionsToUse) throws Exception {
        Message m = new Message(1589706779);
        double desiredRatePerMin = -1.0;
        m.append(maximumSessionsToUse);
        m.append(desiredRatePerMin);
        long responseID = -1L;
        if (listener != null) {
            responseID = this.addResponseListener(listener);
        }
        m.append(responseID);
        m.append(toProxy);
        Message mlist = new Message();
        for (Machine machine : machines) {
            mlist.append(machine.getMachineID());
        }
        m.append(mlist);
        this.doSend(m);
        return responseID;
    }

    public TechCredentials getTechCredentials() {
        return this.credentials;
    }

    public ToolBoxGroup[] getSharedToolBoxes() throws Exception {
        System.out.println("[TechClient] Fetching all shared toolboxes");
        Message m = new Message(34600);
        m = this.doTransact(m);
        ToolBoxGroup[] result = new ToolBoxGroup[m.getNextInt()];
        System.out.println("[TechClient] Got " + result.length + " results");
        for (int i = 0; i < result.length; ++i) {
            ToolBoxGroup group = new ToolBoxGroup(0L);
            group.fromMessage(m.getNextMessage());
            result[i] = group;
        }
        return result;
    }

    public void removeTwoTierKey(int techID, String hostname) throws Exception {
        Message m = new Message(34701);
        m.append(techID);
        m.append(hostname);
        this.doSend(m);
    }

    public void setAPIToken(APIToken apiToken) throws Exception {
        Message m = apiToken.toMessage();
        m.setType(34708);
        this.doTransact(m);
    }

    public APIToken[] getAPITokens() throws Exception {
        Message m = new Message(34705);
        m = this.doTransact(m);
        int size = m.getNextInt();
        APIToken[] tokens = new APIToken[size];
        for (int i = 0; i < size; ++i) {
            tokens[i] = new APIToken(m.getNextMessage());
        }
        return tokens;
    }

    public void deleteAPIToken(APIToken token) throws Exception {
        Message m = new Message(34706);
        m.append(token.token);
        this.doTransact(m);
    }

    public APIToken createAPIToken() throws Exception {
        Message m = new Message(34707);
        m = this.doTransact(m);
        return new APIToken(m);
    }

    public TwoTierKey[] getTwoTierKeys() throws Exception {
        Message m = new Message(34700);
        m = this.doTransact(m);
        int size = m.getNextInt();
        TwoTierKey[] keys = new TwoTierKey[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = new TwoTierKey();
            keys[i].techID = m.getNextInt();
            keys[i].techUsername = m.getNextString();
            keys[i].hostname = m.getNextString();
        }
        return keys;
    }

    public void clearAllNotifications() throws Exception {
        Message m = new Message(80000);
        this.doSend(m);
    }

    public void markNotificationRead(Notification notification) throws Exception {
        Message m = notification.toMessage();
        m.setType(81000);
        this.doTransact(m);
    }

    public Notification[] loadAllNotifications() throws Exception {
        Message m = new Message(82000);
        m = this.doTransact(m);
        Notification[] result = new Notification[m.getNextInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Notification.fromMessage(m.getNextMessage());
        }
        return result;
    }

    public void switchTechnicianPreferencesToUse(int sessionType, int groupID) throws Exception {
        Message m = new Message(66100);
        m.append(sessionType);
        m.append(groupID);
        this.doTransact(m);
    }

    public TransientTechUser[] getVisibleTechnicians() throws Exception {
        Message m = new Message(69000);
        m = this.doTransact(m);
        TransientTechUser[] result = new TransientTechUser[m.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TransientTechUser.fromMessage(m.getNextMessage());
        }
        return result;
    }

    public TransientTechGroup[] getVisibleGroups() throws Exception {
        Message m = new Message(69001);
        m = this.doTransact(m);
        TransientTechGroup[] result = new TransientTechGroup[m.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TransientTechGroup.fromMessage(m.getNextMessage());
        }
        return result;
    }

    public AppProfile[] getAllAppProfilesByType(ProfileType type) throws Exception {
        Message m = new Message(69050);
        m.append(type.getID());
        m = this.doTransact(m);
        int count = m.getNextInt();
        AppProfile[] result = new AppProfile[count];
        for (int i = 0; i < count; ++i) {
            result[i] = AppProfile.fromMessage(m.getNextMessage());
        }
        return result;
    }

    public AppProfile createAppProfile(ProfileType type, String name) throws Exception {
        Message m = new Message(69053);
        m.append(type.getID());
        m.append(name);
        m = this.doTransact(m);
        return AppProfile.fromMessage(m.getNextMessage());
    }

    public void saveAppProfiles(AppProfile[] profiles) throws Exception {
        Message m = new Message(69051);
        m.append(profiles.length);
        for (AppProfile profile : profiles) {
            m.append(profile.toMessage());
        }
        this.doTransact(m);
    }

    public void deleteAppProfile(AppProfile profile) throws Exception {
        Message m = new Message(69052);
        m.append(profile.toMessage());
        this.doTransact(m);
    }

    public String getLEAgreementURL() throws Exception {
        Message m = new Message(72500);
        m = this.doTransact(m);
        return m.getNextString();
    }

    public boolean validateTOTPCode(long codeToValidate) throws Exception {
        Message m = new Message(72600);
        m.append(codeToValidate);
        m = this.doTransact(m);
        return m.getNextBoolean();
    }

    public boolean validateTOTPCode(long codeToValidate, String key) throws Exception {
        Message m = new Message(72600);
        m.append(codeToValidate);
        m.append(key);
        m = this.doTransact(m);
        return m.getNextBoolean();
    }

    public LDAPAuthenticator.LDAPSearchResult[] getLDAPGroups(String baseDN) throws Exception {
        Message m = new Message(78000);
        m.append(baseDN);
        m = this.doTransact(m);
        int ret = m.getNextInt();
        LDAPAuthenticator.LDAPSearchResult[] result = new LDAPAuthenticator.LDAPSearchResult[ret];
        for (int i = 0; i < ret; ++i) {
            result[i] = new LDAPAuthenticator.LDAPSearchResult();
            result[i].CN = m.getNextString();
            result[i].DN = m.getNextString();
        }
        return result;
    }

    public String[] getLDAPBases() throws Exception {
        Message m = new Message(78100);
        m = this.doTransact(m);
        return m.getNextStringArray();
    }

    public void setServerLanguage(String serverLanguage) throws Exception {
        Message m = new Message(79000);
        m.append(serverLanguage);
        this.doTransact(m);
    }

    public SessionPerformance[] getPerformanceStatsFor(String[] allIDS) throws Exception {
        if (allIDS == null) {
            return null;
        }
        Message m = new Message(109100);
        m.append(allIDS);
        m = this.doTransact(m);
        SessionPerformance[] results = new SessionPerformance[allIDS.length];
        for (int i = 0; i < allIDS.length; ++i) {
            results[i] = m.getNextBoolean() ? new SessionPerformance(m.getNextMessage()) : null;
        }
        return results;
    }

    public String getVideoFileName(long startTime, String id, String videoExtension) throws Exception {
        Message m = new Message(109007);
        m.append(startTime);
        m.append(id);
        m.append(videoExtension);
        m = this.doTransact(m);
        return m.getNextString();
    }

    public ReportResult requestReport(ReportRequest config) throws Exception {
        Message m = config.toMessage();
        m.setType(109200);
        m = this.doTransact(m);
        return ReportResult.fromMessage(m);
    }

    public ReportResult fetchReport(String filename, long creationTime) throws Exception {
        Message m = new Message(109201);
        m.append(filename);
        m.append(creationTime);
        m = this.doTransact(m);
        return ReportResult.fromMessage(m);
    }

    public TOTPAuthenticator.TOTPRequest requestNewTOTPKey() throws Exception {
        Message m = new Message(190000);
        m = this.doTransact(m);
        TOTPAuthenticator.TOTPRequest result = new TOTPAuthenticator.TOTPRequest();
        result.key = m.getNextString();
        result.username = m.getNextString();
        result.hostname = m.getNextString();
        result.issuer = m.getNextString();
        result.digits = m.getNextInt();
        return result;
    }

    public void deleteSessionHistories(AbstractSession[] sessions) throws Exception {
        Message m = new Message(109009);
        m.append(sessions.length);
        for (AbstractSession session : sessions) {
            m.append(session.toMessage());
        }
        this.doTransact(m);
    }

    public void pinSpecificationToMachine(String machineID, AppTunnelSpecification spec) throws Exception {
        Message m = new Message(191001);
        m.append(machineID);
        m.append(spec.toMessage());
        this.doTransact(m);
    }

    public void unpinSpecificationToMachine(String machineID, AppTunnelSpecification spec) throws Exception {
        Message m = new Message(191002);
        m.append(machineID);
        m.append(spec.toMessage());
        this.doTransact(m);
    }

    public AppTunnelSpecification[] getPinnedSpecificationsFor(String machineID) throws Exception {
        Message m = new Message(191000);
        m.append(machineID);
        m = this.doTransact(m);
        int count = m.getNextInt();
        AppTunnelSpecification[] result = new AppTunnelSpecification[count];
        for (int i = 0; i < count; ++i) {
            result[i] = AppTunnelSpecification.fromMessage(m.getNextMessage());
        }
        return result;
    }

    public X509CertificateDescription[] getSSLCertificates() throws Exception {
        Message m = new Message(78500);
        m = this.doTransact(m);
        ArrayList<X509CertificateDescription> results = new ArrayList<X509CertificateDescription>();
        while (m.hasNext()) {
            X509CertificateDescription desc = new X509CertificateDescription();
            desc.dn = m.getNextString();
            desc.commonName = m.getNextString();
            desc.serial = m.getNextString();
            desc.expiry = m.getNextLong();
            results.add(desc);
        }
        return results.toArray(new X509CertificateDescription[0]);
    }

    public void removeSSLCertificate(String serial) throws Exception {
        Message m = new Message(78502);
        m.append(serial);
        this.doTransact(m);
    }

    public X509CertificateDescription addSSLCertificate(X509Certificate cert) throws Exception {
        Message m = new Message(78501);
        m.append(cert.getEncoded());
        m = this.doTransact(m);
        X509CertificateDescription desc = new X509CertificateDescription();
        desc.dn = m.getNextString();
        desc.commonName = m.getNextString();
        desc.serial = m.getNextString();
        desc.expiry = m.getNextLong();
        return desc;
    }

    public void convertToAuxiliaryServer(String hostname, int port, String authToken, byte[] serverkeys) throws Exception {
        Message m = new Message(193001);
        m.append(hostname);
        m.append(port);
        m.append(authToken);
        m.append(serverkeys);
        this.doTransact(m);
    }

    public AdministrationDetails getTechUsersToAdminister() throws Exception {
        Message m = new Message(17050);
        m = this.doTransact(m);
        String xml = m.getNextString();
        AdministrationDetails result = new AdministrationDetails();
        ArrayList<TechGroup> groups = new ArrayList<TechGroup>();
        while (m.hasNext()) {
            TransientTechGroup ttg = TransientTechGroup.fromMessage(m.getNextMessage());
            groups.add(new TechGroup(ttg.uniqueID, ttg.name));
        }
        result.groups = groups.toArray(new TechGroup[0]);
        result.adminUsers = ServerConfig.loadTechnicianXMLOnly(xml, groups);
        return result;
    }

    public RAClient getDirectRAClient(String machineID, long maxMs) throws Exception {
        String salt = BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID();
        String secret = BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID();
        P2PSock p2p = new P2PSock();
        int PORT = P2PSock.PORT_TC_P2P;
        try {
            PORT = p2p.listenOn(PORT, PORT + P2PSock.SCAN_LIMIT);
            System.out.println("[P2PSock] Listening on " + PORT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Message m = new Message(194000);
        m.append(machineID);
        m.append(P2PSock.getMyHostsList());
        m.append(PORT);
        m.append(salt);
        m.append(secret);
        m = this.doTransact(m);
        Message hosts = m.getNextMessage();
        int remotePort = m.getNextInt();
        System.out.println("[P2PSock] Accepting connections to " + PORT + ", connecting to " + remotePort);
        long T = SafeClock.currentTimeMillis();
        p2p.connect(hosts, remotePort, maxMs);
        T = SafeClock.currentTimeMillis() - T;
        System.out.println("[TechClient] Took " + T + "ms to get direct connection to " + machineID + ": " + p2p);
        BCUtil bcu = new BCUtil();
        bcu.initFromSecret(salt, secret, 1);
        if (Switches.SHFTP_noEncryptionOnLocalTransfers) {
            System.out.println("[P2PSock] Switching to parallel encrypted NL for direct MachineStream");
            boolean local = p2p.isLocal();
            System.out.println("[P2PSock] Local: " + local);
            OutputStream out = p2p.getRawSocket().getOutputStream();
            StreamUtils.writeBoolean(out, local);
            out.flush();
            if (local) {
                System.out.println("[P2PSock] Type: Multiplexed Socket");
                p2p.multiplexSock();
                MachineStream ms = new MachineStream(p2p.getRawSocket(), p2p.getSecureXin(), p2p.getSecureXout());
                RAClient client = new RAClient(ms);
                client.setSecure(false);
                return client;
            }
            System.out.println("[P2PSock] Type: Parallel Secure NL");
            BCUtil.removeCpuBounding();
            p2p.switchToSecureParallelNL(bcu);
            MachineStream ms = new MachineStream(p2p.getRawNL(), p2p.getSecureXin(), p2p.getSecureXout());
            return new RAClient(ms);
        }
        p2p.switchToSecureNL(bcu);
        p2p.getRawNL().setFriendlyName("Direct MachineStream");
        MachineStream ms = new MachineStream(p2p.getRawNL(), p2p.getSecureXin(), p2p.getSecureXout());
        return new RAClient(ms);
    }

    public RAClient getRAClient(String machineID) throws Exception {
        String salt = BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID();
        String secret = BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID() + "" + BCUtil.getNextAbsID();
        Message m = new Message(194001);
        m.append(machineID);
        int patchID = (int)BCUtil.getNextAbsID();
        m.append(patchID);
        m.append(salt);
        m.append(secret);
        this.doTransact(m);
        System.out.println("[MachineStream] Getting connection");
        SHelpNodelinkPatcher patcher = SHelpNodelinkPatcher.establishConnection(this.host, this.port);
        System.out.println("[MachineStream] Patching");
        NodeLink direct = patcher.finishPatch(true, patchID, null, new MachineSync(patchID, machineID), new Node(), true);
        direct.setFriendlyName("PatchedMachineStream");
        System.out.println("[MachineStream] Got patched connection, creating MachineStream");
        BCUtil bcu = new BCUtil();
        bcu.initFromSecret(salt, secret, 1);
        BCUtilOutputStream bcout = new BCUtilOutputStream(direct.getOutputStream(), bcu);
        BCUtilInputStream bcin = new BCUtilInputStream(direct.getInputStream(), bcu);
        FastMxInputStream xin = new FastMxInputStream((InputStream)bcin, "TechClientMachineStream");
        FastMxOutputStream xout = new FastMxOutputStream((OutputStream)bcout);
        direct.setFriendlyName("Patched MachineStream");
        MachineStream ms = new MachineStream(direct, xin, xout);
        return new RAClient(ms);
    }

    public void addHistoryListener(HistoryListener listener) {
        if (!this.historyListeners.contains(listener)) {
            this.historyListeners.add(listener);
        }
    }

    public void addAlertHistoryListener(AlertHistoryListener listener) {
        if (!this.alertHistoryListeners.contains(listener)) {
            this.alertHistoryListeners.add(listener);
        }
    }

    public void runDiskCleanupNow(int monthsOld) throws Exception {
        Message m = new Message(79300);
        m.append(monthsOld);
        this.doTransact(m);
    }

    public MemoryUsage getServerMemoryUsage() throws Exception {
        Message m = new Message(79100);
        m = this.doTransact(m);
        MemoryUsage usage = new MemoryUsage();
        usage.maxAllocatable = m.getNextLong();
        usage.maxUsedPercentageEver = m.getNextDouble();
        usage.currentPercentage = m.getNextDouble();
        usage.loadAverage1 = m.getNextByte();
        usage.loadAverage5 = m.getNextByte();
        usage.loadAverage15 = m.getNextByte();
        usage.totalServerMemory = m.getNextLong();
        usage.jre64bit = m.getNextBoolean();
        return usage;
    }

    public void setServerMemoryLimit(long bytesValue) throws Exception {
        Message m = new Message(79200);
        m.append(bytesValue);
        this.doTransact(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crossMachineTransfer(String sgID, String targetSgID, String shHost, int shPort, String username, byte[] sessionToken, ArrayList<String> srcPaths, String destFolderPath, FSProgress progress) throws Exception {
        long transferID = BCUtil.getNextAbsID();
        Object object = this.crossTransfers_LOCK;
        synchronized (object) {
            if (this.crossTransfers == null) {
                this.crossTransfers = new TimeoutMap();
            }
            this.crossTransfers.put(transferID, progress, 90000L);
        }
        Message m = new Message(196000);
        m.append(transferID);
        m.append(sgID);
        m.append(targetSgID);
        m.append(shHost);
        m.append(shPort);
        m.append(username);
        m.append(sessionToken);
        Message sub = new Message();
        for (String path : srcPaths) {
            sub.append(path);
        }
        m.append(sub);
        m.append(destFolderPath);
        this.doTransact(m);
    }

    public void sendCrossTransferProgress(long transferID, long progress) throws Exception {
        Message m = new Message(196001);
        m.append(transferID);
        m.append(progress);
        this.doSend(m);
    }

    static {
        sessionWindows_LOCK = new Object();
        sessionWindows = new ArrayList();
    }

    public class AdministrationDetails {
        public TechUser[] adminUsers;
        public TechGroup[] groups;
    }

    public static class EditableInvitationWrapper {
        public final Invitation invitation;
        public final boolean canBeEdited;

        public EditableInvitationWrapper(Invitation invtiation, boolean canBeEdited) {
            this.invitation = invtiation;
            this.canBeEdited = canBeEdited;
        }

        public String toString() {
            return this.invitation.toString();
        }

        public String getName() {
            return this.invitation.getName();
        }

        public String getFormattedCreationTime() {
            return this.invitation.getFormattedCreationTime();
        }

        public String getCreatedByDisplayName() {
            return this.invitation.getCreatedByDisplayName();
        }
    }

    class HashedThumb {
        final int hash;
        final String machineID;
        final Image jpeg;

        HashedThumb(String machineID, int hash, Image jpeg) {
            this.machineID = machineID;
            this.hash = hash;
            this.jpeg = jpeg;
        }

        public String toString() {
            return this.machineID + "$" + this.hash;
        }
    }

    public static interface HeadlessMessageListener {
        public void setSessionID(String var1);

        public void newMessage(String var1);

        public void sessionClosed();

        public void sessionConnected();

        public void setLocalPort(int var1);

        public void registerIPCHandler(TechClientIPCHandler var1);

        public String getMachinePassword();
    }

    private final class MachineSync
    implements GenericSync {
        final int patchID;
        final String machineID;

        MachineSync(int patchID, String machineID) {
            this.patchID = patchID;
            this.machineID = machineID;
        }

        @Override
        public void syncWithRemoteNow() {
            try {
                Message m = new Message(194002);
                m.append(this.machineID);
                m.append(this.patchID);
                System.out.println("[MachineStream] Attempting remote sync for " + this.patchID + " to " + this.machineID);
                TechClient.this.doTransact(m);
                System.out.println("[MachineStream] Sync done for " + this.patchID + " to " + this.machineID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class MemoryUsage {
        public long maxAllocatable;
        double maxUsedPercentageEver;
        public double currentPercentage;
        public double loadAverage1;
        public double loadAverage5;
        public double loadAverage15;
        public long totalServerMemory;
        public boolean jre64bit;
    }

    class Notifier
    extends Thread {
        final BCUtil bcu;
        final InputStream in;
        boolean die;

        Notifier(BCUtil bcu, InputStream in) {
            super("TechClientNotifier");
            this.die = false;
            this.bcu = bcu;
            this.in = in;
        }

        void die() {
            this.die = true;
        }

        @Override
        public void run() {
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.aliasMaster("Tech Client", this.in);
            }
            try {
                while (!this.die) {
                    Message m = BCUtilMessenger.readMsg(this.bcu, this.in);
                    TechClient.this.processor.addNotification(m);
                }
            }
            catch (Exception e) {
                if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                    Throwable ee = e;
                    while (ee.getCause() != null) {
                        ee = ee.getCause();
                    }
                    ee.printStackTrace();
                }
                System.out.println("[Notifier] " + e);
            }
        }
    }

    public static class PasswordRequiredException
    extends Exception {
    }

    class Poller
    extends Thread {
        Poller() {
            super("TechClientPoller");
        }

        @Override
        public void run() {
            while (TechClient.this.notifier.isAlive()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TechClient.this.listener.customerListChanged();
                TechClient.this.listener.customerLiveListChanged();
                TechClient.this.listener.demoListChanged();
            }
        }
    }

    public static class PortForwardRequest {
        final String portForwardHostname;
        final int portForwardPort;
        final HeadlessMessageListener messageListener;

        public PortForwardRequest(String remoteHost, int remotePort, HeadlessMessageListener messageListener) {
            this.portForwardHostname = remoteHost;
            this.portForwardPort = remotePort;
            this.messageListener = messageListener;
        }
    }

    class Processor
    extends Thread
    implements Cleanable {
        boolean die;
        final int MAX_NOTIFICATIONS = 50000;
        final Object notifications_WAIT;
        final Object notifications_LOCK;
        ArrayList<Message> notifications;

        Processor() {
            super("TechClientProcessor");
            this.die = false;
            this.MAX_NOTIFICATIONS = 50000;
            this.notifications_WAIT = new Object();
            this.notifications_LOCK = new Object();
            this.notifications = new ArrayList();
        }

        void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void insertNotifications(ArrayList<Message> batched) {
            Object object = this.notifications_LOCK;
            synchronized (object) {
                batched.addAll(this.notifications);
                this.notifications = batched;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addNotification(Message m) {
            Object object = this.notifications_LOCK;
            synchronized (object) {
                if (this.notifications.size() > 50000) {
                    System.out.println("***WARNING*** Unable to sustain notification processing, " + this.notifications.size());
                } else {
                    this.notifications.add(m);
                }
            }
            object = this.notifications_WAIT;
            synchronized (object) {
                this.notifications_WAIT.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.die) {
                    ArrayList<Message> list;
                    boolean skip = false;
                    Object object = this.notifications_LOCK;
                    synchronized (object) {
                        if (this.notifications.size() > 0) {
                            skip = true;
                        }
                    }
                    if (!skip) {
                        object = this.notifications_WAIT;
                        synchronized (object) {
                            this.notifications_WAIT.wait(1000L);
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Object object2 = this.notifications_LOCK;
                    synchronized (object2) {
                        if (this.notifications.size() == 0) {
                            continue;
                        }
                        list = this.notifications;
                        this.notifications = new ArrayList();
                    }
                    ArrayList<Machine> added = null;
                    ArrayList<Machine> removed = null;
                    if (CentralDebugging.TECH_UI_MACHINE_NOTIFICATIONS) {
                        System.out.println("[TechClientProcessor] TechUI processing " + list.size() + " notifications");
                    }
                    for (Message m : list) {
                        if (Switches.SH_batchNotificationsOnTechSide) {
                            if (m.getType() == 10007000) {
                                if (added == null) {
                                    added = new ArrayList<Machine>();
                                }
                                added.add(new Machine(m.getNextMessage()));
                                continue;
                            }
                            if (m.getType() == 10010000) {
                                if (removed == null) {
                                    removed = new ArrayList<Machine>();
                                }
                                removed.add(new Machine(m.getNextMessage()));
                                continue;
                            }
                            this.processBatch(added, true, false);
                            this.processBatch(removed, false, true);
                            if (added != null) {
                                added.clear();
                            }
                            if (removed != null) {
                                removed.clear();
                            }
                        }
                        this.processNotify(m);
                    }
                    this.processBatch(added, true, false);
                    this.processBatch(removed, false, true);
                }
            }
            catch (Exception e) {
                if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                    Throwable ee = e;
                    while (ee.getCause() != null) {
                        ee = ee.getCause();
                    }
                    ee.printStackTrace();
                }
                System.out.println("[TechClientProcessor] " + e);
            }
        }

        private void processBatch(ArrayList<Machine> machines, boolean added, boolean removed) {
            try {
                if (machines != null && machines.size() > 0) {
                    Machine[] tmp = machines.toArray(new Machine[0]);
                    if (added) {
                        long T = System.currentTimeMillis();
                        TechClient.this.listener.machinesAdded(tmp);
                        T = System.currentTimeMillis() - T;
                        if (T > 50L) {
                            System.out.println("[Notifications] Processed " + tmp.length + " machine adds in " + T + "ms");
                        }
                    } else {
                        long T = System.currentTimeMillis();
                        TechClient.this.listener.machinesRemoved(tmp);
                        T = System.currentTimeMillis() - T;
                        if (T > 50L) {
                            System.out.println("[Notifications] Processed " + tmp.length + " machine removes in " + T + "ms");
                        }
                    }
                }
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNotify(Message m) {
            long Tnotify;
            block93: {
                Tnotify = SafeClock.currentTimeMillis();
                try {
                    int type = m.getType();
                    if (type == -2147483647) {
                        m = MessageUtils.decompress((Message)m);
                        this.addNotification(m);
                        break block93;
                    }
                    if (type == 10028000) {
                        int count = m.getNextInt();
                        byte[] dat = m.getNextByteArray();
                        if (dat.length > 1024) {
                            System.out.println("[TechClient] Notification batch size is " + dat.length / 1024 + "k");
                        }
                        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
                        GZIPInputStream gzin = new GZIPInputStream(bin);
                        ArrayList<Message> list = new ArrayList<Message>();
                        try {
                            for (int i = 0; i < count; ++i) {
                                Message toProcess = MessageUtils.readMessage((InputStream)gzin);
                                list.add(toProcess);
                            }
                        }
                        catch (EOFException i) {
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                        this.insertNotifications(list);
                        break block93;
                    }
                    if (type == 10026000) {
                        System.out.println("[TechClient] Batch notify x" + m.length());
                        for (int i = 0; i < m.length(); ++i) {
                            Message toProcess = m.getAsMessage(i);
                            this.addNotification(toProcess);
                        }
                        break block93;
                    }
                    if (type == 10022000) {
                        Notification newNotification = Notification.fromMessage(m);
                        ClientNotificationUtil.localiseNotification(newNotification);
                        TechClient.this.listener.newNotificationReceived(newNotification);
                        break block93;
                    }
                    if (type == 10005500) {
                        try {
                            byte id = m.getNextByte();
                            HistoryMetrics metrics = HistoryMetrics.fromMessage(m.getNextMessage());
                            for (HistoryListener historyListener : TechClient.this.historyListeners) {
                                if (historyListener.getHistoryID() != id) continue;
                                historyListener.metricResults(metrics);
                            }
                            break block93;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        break block93;
                    }
                    if (type == 10005200) {
                        try {
                            byte id = m.getNextByte();
                            boolean isFinished = m.getNextBoolean();
                            int resultSize = m.getNextInt();
                            ArrayList<HistoryElement> results = new ArrayList<HistoryElement>();
                            for (int i = 0; i < resultSize; ++i) {
                                results.add(HistoryElement.fromMessage(m.getNextMessage()));
                            }
                            Collections.sort(results, new Comparator<HistoryElement>(){

                                @Override
                                public int compare(HistoryElement o1, HistoryElement o2) {
                                    return -1 * Long.compare(o1.getTime(), o2.getTime());
                                }
                            });
                            for (AlertHistoryListener historyListener : TechClient.this.alertHistoryListeners) {
                                if (historyListener.getHistoryID() != id) continue;
                                historyListener.searchResults(results, isFinished);
                            }
                            break block93;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        break block93;
                    }
                    if (type == 10005000) {
                        try {
                            byte id = m.getNextByte();
                            boolean isFinished = m.getNextBoolean();
                            int resultSize = m.getNextInt();
                            ArrayList<AbstractSession> results = new ArrayList<AbstractSession>();
                            for (int i = 0; i < resultSize; ++i) {
                                results.add(AbstractSession.fromMessage(m.getNextMessage()));
                            }
                            Collections.sort(results, new Comparator<AbstractSession>(){

                                @Override
                                public int compare(AbstractSession o1, AbstractSession o2) {
                                    return -1 * Long.compare(o1.getStartTime(), o2.getStartTime());
                                }
                            });
                            for (AbstractSession session : results) {
                                if (!TechVideoRepository.getVideoFileFor(session).exists()) continue;
                                session.setHasSessionRecording(true);
                            }
                            for (HistoryListener historyListener : TechClient.this.historyListeners) {
                                if (historyListener.getHistoryID() != id) continue;
                                historyListener.searchResults(results, isFinished);
                            }
                            break block93;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        break block93;
                    }
                    if (type == 10025000) {
                        if (TechClient.this.doSgUpdatingNotifications) {
                            System.out.println("[TechClient] Notified by server that waiting for remote user to accept connection");
                            TechClient.this.listener.waitingForRemoteUserToAccept();
                        }
                        break block93;
                    }
                    if (type == 10024000) {
                        if (TechClient.this.doSgUpdatingNotifications) {
                            System.out.println("[TechClient] Notified by server that currently connecting SG session is updating on remote side");
                            TechClient.this.listener.sgUpdatingDuringConnect();
                        }
                        break block93;
                    }
                    if (type == 10029000) {
                        long serverConfigInstanceID = m.getNextLong();
                        System.out.println("[TechClient] Notified by server of a config change");
                        TechClient.this.listener.configChangedOnServer(serverConfigInstanceID);
                        break block93;
                    }
                    if (type == 10001000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that machine list has changed");
                        }
                        TechClient.this.listener.customerListChanged();
                        break block93;
                    }
                    if (type == 10002000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            System.out.println("Notified of a warning message " + m);
                        }
                        TechClient.this.listener.setWarningMessage((String)m.get(0));
                        break block93;
                    }
                    if (type == 10003000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            System.out.println("Notified that the customer live list has changed");
                        }
                        TechClient.this.listener.customerLiveListChanged();
                        break block93;
                    }
                    if (type == 10006000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            System.out.println("Notified that a big screenshot is ready");
                        }
                        Object serverConfigInstanceID = TechClient.this.bs_LOCK;
                        synchronized (serverConfigInstanceID) {
                            TechClient.this.bs_LOCK.notifyAll();
                            break block93;
                        }
                    }
                    if (type == 10017000) {
                        TechClient.this.serverLicenseMode = m.getNextInt();
                        TechClient.this.storeTrialMarkers(m.getNextMessage());
                        Message licenseSetMessage = m.getNextMessage();
                        if (licenseSetMessage == null || licenseSetMessage.length() == 0) {
                            TechClient.this.serverLicenseSet = null;
                        } else {
                            TechClient.this.serverLicenseSet = LicenseSet.fromMessage(licenseSetMessage);
                        }
                        System.out.println("[TechClient] Notified of server license state change: " + TechClient.this.serverLicenseMode);
                        if (TechClient.this.listener != null) {
                            TechClient.this.listener.licenseChanged();
                        }
                        break block93;
                    }
                    if (type == 0x98FFF8) {
                        TechClient.this.listener.peersChanged();
                        break block93;
                    }
                    if (type == 10023000) {
                        OneClock.print(m.getNextLong());
                        break block93;
                    }
                    if (type == 10004000) {
                        int machineLimit;
                        boolean isJoinedSessionCounts = m.getNextBoolean();
                        boolean isEvaluation = m.getNextBoolean();
                        boolean isPlan2 = m.getNextBoolean();
                        int allSessions = m.getNextInt();
                        int maxSHSessions = m.getNextInt();
                        int maxSGSessions = m.getNextInt();
                        int alertedMachines = m.getNextInt();
                        int alertLimit = m.getNextInt();
                        int registeredMachines = m.getNextInt();
                        if (registeredMachines > (machineLimit = m.getNextInt())) {
                            if (TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_ENT)) {
                                TechClient.this.overMachineLimit = false;
                            } else if (TrialUtils.getTU().amTrialling(TrialUtil.FEATURE_BIZ)) {
                                TechClient.this.overMachineLimit = registeredMachines > 5000;
                            } else {
                                TechClient.this.overMachineLimit = true;
                            }
                        } else {
                            TechClient.this.overMachineLimit = false;
                        }
                        TechClient.this.sessionLimit = maxSHSessions;
                        TechClient.this.listener.updateSessionCounts(isJoinedSessionCounts, isEvaluation, isPlan2, allSessions, maxSHSessions, maxSGSessions, alertedMachines, alertLimit, registeredMachines, machineLimit);
                        break block93;
                    }
                    if (type == 0x98E888) {
                        HashMap<String, Integer> targetCounts = new HashMap<String, Integer>();
                        while (m.hasNext()) {
                            String ID = m.getNextString();
                            int count = m.getNextInt();
                            targetCounts.put(ID, count);
                        }
                        TechClient.this.alertTargetCounts = targetCounts;
                        break block93;
                    }
                    if (type == 10018000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that alert added " + m);
                        }
                        ResourceContainer rc = ResourceSerialiser.resourceContainerFromMessage(m.getNextMessage());
                        TechClient.this.listener.alertAdded(rc);
                        break block93;
                    }
                    if (type == 10019000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that alert removed " + m);
                        }
                        ResourceContainer rc = ResourceSerialiser.resourceContainerFromMessage(m.getNextMessage());
                        TechClient.this.listener.alertRemoved(rc);
                        break block93;
                    }
                    if (type == 10020000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that alert updated " + m);
                        }
                        while (m.hasNext()) {
                            ResourceContainer rc = ResourceSerialiser.resourceContainerFromMessage(m.getNextMessage());
                            TechClient.this.listener.alertChanged(rc);
                        }
                        break block93;
                    }
                    if (type == 10007000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that machine added " + m);
                        }
                        Machine machine = new Machine(m.getNextMessage());
                        TechClient.this.listener.machineAdded(machine);
                        break block93;
                    }
                    if (type == 10010000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that machine removed " + m);
                        }
                        Machine machine = new Machine(m.getNextMessage());
                        TechClient.this.listener.machineRemoved(machine);
                        break block93;
                    }
                    if (type == 10008000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that machine online " + m);
                        }
                        Machine machine = new Machine(m.getNextMessage());
                        TechClient.this.listener.machineOnline(machine);
                        break block93;
                    }
                    if (type == 10009000) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that machine offline " + m);
                        }
                        Machine machine = new Machine(m.getNextMessage());
                        TechClient.this.listener.machineOffline(machine);
                        break block93;
                    }
                    if (type == 10012000) {
                        Machine machine = new Machine(m.getNextMessage());
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that machine data changed " + machine.toComparisonString());
                        }
                        TechClient.this.listener.machineDataChanged(machine);
                        break block93;
                    }
                    if (type == 10011000) {
                        Machine machine = new Machine(m.getNextMessage());
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that filterable machine info changed " + machine.toComparisonString());
                        }
                        TechClient.this.listener.machineFilterableInfoChanged(machine);
                        break block93;
                    }
                    if (type == 10013000) {
                        AccessSession session = new AccessSession();
                        session.loadFrom(m.getNextMessage());
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that session has been added " + session);
                        }
                        TechClient.this.listener.sessionAdded(session);
                        break block93;
                    }
                    if (type == 10014000) {
                        AccessSession session = new AccessSession();
                        session.loadFrom(m.getNextMessage());
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LIST_UPDATES) {
                            System.out.println("Notified that session has been removed " + session);
                        }
                        TechClient.this.listener.sessionRemoved(session);
                        break block93;
                    }
                    if (type == 10015000) {
                        Object LOCK;
                        String activity = m.getAsString(0);
                        Object count = TechClient.this.minis_LOCK;
                        synchronized (count) {
                            LOCK = TechClient.this.minis.get(activity);
                            TechClient.this.minis.put(activity, m);
                        }
                        count = LOCK;
                        synchronized (count) {
                            LOCK.notifyAll();
                            break block93;
                        }
                    }
                    if (type == 1589706781) {
                        Message response = m.getNextMessage();
                        long listenerID = m.getNextLong();
                        String machineID = m.getNextString();
                        TechClient.this.notifyResponseListener(listenerID, response, machineID);
                    } else if (type == 0x990BB0) {
                        long transferID = m.getNextLong();
                        long progress = m.getNextLong();
                        FSProgress fsProgress = TechClient.this.crossTransfers.get(transferID, 90000L);
                        fsProgress.transferredBytes(progress);
                    }
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
            }
            Tnotify -= SafeClock.currentTimeMillis();
            if (CentralDebugging.TECH_CLIENT_SHOW_ALL_NOTIFICATIONS) {
                System.out.println("[TechClient] Dealt with notification (" + Tnotify + "ms): " + m.toString(2, false, PC.REFS));
            }
            if (Tnotify > 100L) {
                System.out.println("[TechClient] Took " + Tnotify + "ms to process " + m);
            }
        }

        public void cleanupNow() {
            this.die();
        }
    }

    public static class QuitLoginException
    extends Exception {
    }

    class SendOnlyJob
    implements Runnable {
        final Message m;

        SendOnlyJob(Message m) {
            this.m = m;
        }

        @Override
        public void run() {
            try {
                TechClient.this.doSend(this.m);
            }
            catch (Throwable t) {
                System.out.println("***WARNING*** TC UI missed exception " + t);
                t.printStackTrace();
            }
        }
    }

    public static class ServerLogDetails {
        public long serverStartTime;
        long totalLogsSizeBytes;
    }

    public static class VideoDetails {
        public boolean existsOnServer = false;
        public long lengthInBytes = 0L;
        public long duration = 0L;
        public boolean htmlExistsOnServer = false;
        public String videoID;
        public byte[] passwordUTF8;
        public int parts;

        public boolean hasPassword() {
            return this.passwordUTF8 != null && this.passwordUTF8.length > 0;
        }

        public String getPassword() {
            return new String(this.passwordUTF8, StandardCharsets.UTF_8);
        }
    }

    public static class WrongPasswordException
    extends Exception {
        public final String reason;

        public WrongPasswordException(String message) {
            this(message, (String)null);
        }

        WrongPasswordException(String message, String reason) {
            super(message);
            if (reason == null) {
                System.out.println("[TechClient] Wrong password exception (reason:<<null>>)");
            } else {
                System.out.println("[TechClient] Wrong password exception (reason:" + reason + ")");
            }
            this.reason = reason;
        }
    }

    public static class X509CertificateDescription {
        public String dn;
        public String commonName;
        public String serial;
        public long expiry;
    }
}

