/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.targets.notifytech;

import com.aem.shelp.common.Language;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import utils.loggingframework.events.LogEvent;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanelWrapper;

public abstract class VariablePanel
implements ActionListener,
FocusListener {
    public JPanel rootComponent = new ColorPropagatingPanel();
    private JLabel variablesLabel = new JLabel();
    private JComboBox variablesBox = new SHComboBox();
    private JButton insertButton = new JButton();
    private JTextComponent[] content;
    boolean contentWasLastFocused = true;
    JTextComponent lastFocusedContent = null;

    public VariablePanel(JTextComponent[] content) {
        this.content = content;
        for (JTextComponent c : content) {
            c.addFocusListener(this);
        }
        this.initUI();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.variablesBox.setEnabled(true);
        this.insertButton.setEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        boolean isContent = false;
        this.lastFocusedContent = null;
        for (JTextComponent c : this.content) {
            if (e.getSource() != c) continue;
            this.lastFocusedContent = c;
            isContent = true;
            break;
        }
        this.contentWasLastFocused = isContent;
    }

    public void initUI() {
        this.variablesLabel.setText(Language.get("TARGET_UI_EMAIL_VARIABLES"));
        this.insertButton.setText(Language.get("TARGET_UI_EMAIL_INSERT"));
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.rootComponent, (Insets)new ScaledInsets(3, 3, 3, 3));
        wrapper.add((Component)this.variablesLabel, 0, 0, 1, 1, 1, 1, 13, 0);
        wrapper.add((Component)this.variablesBox, 1, 0, 1, 1, 1, 1, 17, 0);
        wrapper.add((Component)this.insertButton, 2, 0, 1, 1, 0, 1, 17, 0);
        this.insertButton.addActionListener(this);
        this.variablesBox.setEnabled(false);
        this.insertButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.insertButton) {
            String selectedVariable = "${" + this.variablesBox.getSelectedItem() + "}";
            if (this.contentWasLastFocused) {
                if (this.lastFocusedContent instanceof JTextArea) {
                    ((JTextArea)this.lastFocusedContent).insert(selectedVariable, this.lastFocusedContent.getCaretPosition());
                    this.lastFocusedContent.requestFocusInWindow();
                } else if (this.lastFocusedContent instanceof JTextField) {
                    int pos = this.lastFocusedContent.getCaretPosition();
                    this.lastFocusedContent.setText(this.lastFocusedContent.getText().substring(0, pos) + selectedVariable + this.lastFocusedContent.getText().substring(pos));
                    this.lastFocusedContent.setCaretPosition(pos + selectedVariable.length());
                }
                this.notifyChange();
            }
        }
    }

    protected abstract void notifyChange();

    public void setVariables(LogEvent.LogEventVariable[] commonVariables) {
        this.variablesBox.setModel(new DefaultComboBoxModel<LogEvent.LogEventVariable>(commonVariables));
        if (commonVariables.length > 0) {
            this.variablesBox.setSelectedIndex(0);
        }
    }
}

