/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.alerts;

import com.aem.shelp.proxy.alerts.AlertNotifyState;
import com.aem.shelp.proxy.common.alerts.AlertReason;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class LocatedAlertLogEvent
extends SimpleHelpLogEvent {
    public static String ID = "LocatedAlertLogEvent";
    public AlertReason reason;
    public LocatedAlert alert;
    public Machine remoteMachine;
    public boolean isTrigger = true;
    public AlertNotifyState notifyState;

    public LocatedAlertLogEvent(LocatedAlert alert, Machine machine, boolean isTrigger, AlertReason reason) {
        this.isTrigger = isTrigger;
        this.alert = alert;
        this.remoteMachine = machine;
        this.reason = reason;
    }

    @Override
    public File getEmailTemplateFile() {
        if (this.isTrigger) {
            return new File("templates/alert/alert_trigger");
        }
        return new File("templates/alert/alert_reset");
    }

    @Override
    protected String getEventID() {
        return this.getID();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return ID;
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public String getLogText() {
        StringBuilder buffer = new StringBuilder();
        if (this.isTrigger) {
            buffer.append("[AlertTriggerEvent] ");
        } else {
            buffer.append("[AlertResetEvent] ");
        }
        buffer.append("Alert '").append(this.alert.getName().getName()).append("'");
        if (this.isTrigger) {
            buffer.append(" triggered");
        } else {
            buffer.append(" reset");
        }
        buffer.append(" on ").append(this.remoteMachine.getMachineName());
        if (this.reason != null) {
            buffer.append(" (");
            buffer.append(this.reason);
            buffer.append(" )");
        }
        return buffer.toString();
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<");
        if (this.isTrigger) {
            buffer.append("AlertTriggerEvent");
        } else {
            buffer.append("AlertResetEvent");
        }
        buffer.append(">\n");
        super.addToXML(buffer, indent + 1);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"alert", (String)this.alert.getName().toString());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"alertName", (String)this.alert.getName().getName());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"alertGroups", (String)this.alert.getName().getGroupString());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"remoteMachine", (String)this.remoteMachine.getMachineName().toString());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineName", (String)this.remoteMachine.getMachineName().getName());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineGroups", (String)this.remoteMachine.getMachineName().getGroupString());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineID", (String)this.remoteMachine.getMachineID());
        if (this.reason != null && this.reason.reason != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"reason", (String)this.reason.reason);
        }
        if (this.reason != null && this.reason.contextDump != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"context", (String)this.reason.contextDump);
        }
        buffer.append(XML14Util.getIndent((int)indent)).append("</");
        if (this.isTrigger) {
            buffer.append("AlertTriggerEvent");
        } else {
            buffer.append("AlertResetEvent");
        }
        buffer.append(">\n");
    }

    public LocatedAlert getLocatedAlert() {
        return this.alert;
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        if (this.remoteMachine != null) {
            variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, this.remoteMachine));
            variableList.add(new LogEvent.LogEventVariable("remoteMachineID", null, this.remoteMachine.getID()));
            String hostname = ServerConfig.get().hostname;
            String url = "https://" + hostname;
            url = url + "/mobile?mach=" + this.remoteMachine.getID();
            variableList.add(new LogEvent.LogEventVariable("remoteMachineMobileLink", null, url));
            variableList.add(new LogEvent.LogEventVariable("machineName", null, this.remoteMachine.getMachineName().getName()));
            variableList.add(new LogEvent.LogEventVariable("machineGroups", null, this.remoteMachine.getMachineName().getGroupString()));
        } else {
            variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, ""));
            variableList.add(new LogEvent.LogEventVariable("remoteMachineID", null, ""));
            variableList.add(new LogEvent.LogEventVariable("remoteMachineMobileLink", null, ""));
            variableList.add(new LogEvent.LogEventVariable("machineName", null, ""));
            variableList.add(new LogEvent.LogEventVariable("machineGroups", null, ""));
        }
        variableList.add(new LogEvent.LogEventVariable("isTrigger", null, Boolean.toString(this.isTrigger)));
        if (this.alert != null && this.alert.getName() != null) {
            variableList.add(new LogEvent.LogEventVariable("alert", null, this.alert.getName().toString()));
            variableList.add(new LogEvent.LogEventVariable("alertName", null, this.alert.getName().getName()));
            variableList.add(new LogEvent.LogEventVariable("alertGroup", null, this.alert.getName().getGroupString()));
        } else {
            variableList.add(new LogEvent.LogEventVariable("alert", null, ""));
            variableList.add(new LogEvent.LogEventVariable("alertName", null, ""));
            variableList.add(new LogEvent.LogEventVariable("alertGroup", null, ""));
        }
        if (this.reason != null) {
            if (this.reason.reason != null) {
                variableList.add(new LogEvent.LogEventVariable("reason", null, this.reason.reason));
            }
            if (this.reason.contextDump != null) {
                variableList.add(new LogEvent.LogEventVariable("context", null, this.reason.contextDump));
            }
        } else {
            variableList.add(new LogEvent.LogEventVariable("reason", null, ""));
            variableList.add(new LogEvent.LogEventVariable("context", null, ""));
        }
    }

    @Override
    protected void toProperties(Properties properties) {
        MachineName name;
        super.toProperties(properties);
        if (this.remoteMachine != null) {
            this.safePut(properties, "remoteMachine", this.remoteMachine);
            if (this.remoteMachine.getName() != null) {
                this.safePut(properties, "machineName", this.remoteMachine.getName().getName());
                this.safePut(properties, "machineGroups", this.remoteMachine.getName().getGroupString());
            }
        }
        properties.put("isTrigger", Boolean.toString(this.isTrigger));
        if (this.reason != null) {
            this.safePut(properties, "reason", this.reason.reason);
            this.safePut(properties, "context", this.reason.contextDump);
        }
        if (this.alert != null && (name = this.alert.getName()) != null) {
            this.safePut(properties, "alert", name.toString());
            this.safePut(properties, "alertName", this.alert.getName().getName());
            this.safePut(properties, "alertGroup", this.alert.getName().getGroupString());
        }
    }
}

