/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.AbstractSession;
import java.io.IOException;
import utils.message.Message;

public class TransientTechUser {
    public int uniqueID = -1;
    public int[] loggedInGroupIDs;
    public String[] loggedInGroupNames;
    public boolean canAdministerGroup = false;
    public boolean canAdministerServer = false;
    public String displayName = "";
    public String username = "";
    public String emailAddress = "";
    public String groupList = "";
    public boolean isAnonymousLogin = false;
    public transient byte[] avatarBytes = null;
    public TechGroupPermissions permissions = new TechGroupPermissions();
    public int loginType;
    public String defaultSGMachineName;
    public long maxFileTransferSize = -1L;
    public int sessionSpeedLimitKbps = -1;
    public long fpsDelay = -1L;
    public long inactivityTimeout = 0L;
    public long requestConnectionTimeout = 0L;

    public String toString() {
        if (this.displayName == null || this.displayName.length() == 0) {
            return this.username;
        }
        return this.displayName;
    }

    public static TransientTechUser fromMessage(Message m) throws IOException {
        TransientTechUser user = new TransientTechUser();
        user.uniqueID = m.getNextInt();
        user.loggedInGroupIDs = m.getNextIntArray();
        user.loggedInGroupNames = m.getNextStringArray();
        user.displayName = m.getNextString();
        user.username = m.getNextString();
        user.emailAddress = m.getNextString();
        user.groupList = m.getNextString();
        user.isAnonymousLogin = m.getNextBoolean();
        user.loginType = m.getNextInt();
        user.permissions = TechGroupPermissions.fromMessage(m.getNextMessage());
        user.defaultSGMachineName = m.getNextString();
        user.maxFileTransferSize = m.getNextLong();
        user.sessionSpeedLimitKbps = m.getNextInt();
        user.fpsDelay = m.getNextLong();
        user.requestConnectionTimeout = m.getNextLong();
        user.canAdministerGroup = m.getNextBoolean();
        user.canAdministerServer = m.getNextBoolean();
        user.inactivityTimeout = m.getNextLong();
        return user;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.uniqueID);
        m.append(this.loggedInGroupIDs);
        m.append(this.loggedInGroupNames);
        m.append(this.displayName);
        m.append(this.username);
        m.append(this.emailAddress);
        m.append(this.groupList);
        m.append(this.isAnonymousLogin);
        m.append(this.loginType);
        m.append(this.permissions.toMessage());
        m.append(this.defaultSGMachineName);
        m.append(this.maxFileTransferSize);
        m.append(this.sessionSpeedLimitKbps);
        m.append(this.fpsDelay);
        m.append(this.requestConnectionTimeout);
        m.append(this.canAdministerGroup);
        m.append(this.canAdministerServer);
        m.append(this.inactivityTimeout);
        return m;
    }

    public boolean isFPSLimited() {
        return this.fpsDelay != -1L;
    }

    public long getFPSDelay() {
        return this.fpsDelay;
    }

    public boolean isSessionSpeedLimited() {
        return this.sessionSpeedLimitKbps != -1;
    }

    public int getSessionSpeedLimitKBps() {
        return this.sessionSpeedLimitKbps;
    }

    public boolean isMaxFileTransferSizeLimited() {
        return this.maxFileTransferSize != -1L;
    }

    public boolean hasInactivityTimeout() {
        return this.inactivityTimeout > 0L;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public boolean techUserCanChangePassword() {
        return !this.isServerAdmin() && !this.isAnonymousLogin && this.loginType == 1;
    }

    public boolean isServerAdmin() {
        return this.uniqueID == 0;
    }

    public String getDisplayName() {
        if (this.displayName != null && this.displayName.length() > 0) {
            return this.displayName;
        }
        if (this.isServerAdmin()) {
            return OemBranding.OEM_ADMIN_USERNAME;
        }
        return this.username;
    }

    public TechGroupPermissions getPermissions() {
        return this.permissions;
    }

    public String getUsername() {
        return this.username;
    }

    public String setSubstitutedSGName() {
        String temp = this.defaultSGMachineName;
        if (temp == null) {
            return null;
        }
        temp = temp.replaceAll("\\$\\{TechnicianName\\}", this.displayName).trim();
        if (this.loggedInGroupNames != null && this.loggedInGroupNames.length > 0) {
            temp = temp.replaceAll("\\$\\{TechnicianGroup\\}", this.loggedInGroupNames[0]).trim();
        }
        return temp;
    }

    public boolean canTerminateSession(AbstractSession session) {
        TechGroupPermissions permissions = this.getPermissions();
        if (permissions == null) {
            return true;
        }
        if (permissions.canTerminateOtherUsersSessions()) {
            return true;
        }
        try {
            if (session != null && this.getUsername().equals(session.getTechnicianUsername())) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }
}

