/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.config;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.ServerProperties;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxGroupRef;
import com.aem.shelp.common.toolbox.ToolBoxRegistryAPI;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.DefaultConfiguration;
import com.aem.shelp.proxy.MasterLog;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.alerts.AlertRegistryAPI;
import com.aem.shelp.proxy.authentication.TOTPConfig;
import com.aem.shelp.proxy.common.ProxyServerAPI;
import com.aem.shelp.proxy.common.TechPrefsFileUtil;
import com.aem.shelp.proxy.config.LazyEncryptedPassword;
import com.aem.shelp.proxy.config.LazyHashPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.EmailTemplateLoader;
import com.aem.shelp.proxy.logging.SimpleHelpEventRepository;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import com.aem.shelp.proxy.logging.access.TechJoinAccessSessionEvent;
import com.aem.shelp.proxy.logging.access.TechLeaveAccessSessionEvent;
import com.aem.shelp.proxy.logging.server.TechLoginEvent;
import com.aem.shelp.proxy.logging.server.TechLogoutEvent;
import com.aem.shelp.proxy.logging.support.TechJoinSupportSessionEvent;
import com.aem.shelp.proxy.logging.support.TechLeaveSupportSessionEvent;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.proxy.types.filters.CombinedMachineFilter;
import com.aem.shelp.proxy.types.filters.CustomerFilter;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.admin.multiserver.MultiServerPanel;
import com.aem.shelp.util.PatternWrapper;
import com.aem.utils.Debugger;
import com.aem.utils.FileCopyUtil;
import com.aem.utils.StreamUtils;
import com.aem.utils.authentication.LDAPAuthenticator;
import com.aem.utils.authentication.LDAPProperties;
import com.aem.utils.blowfish.Blowfish;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import utils.email.CommonEmailer;
import utils.email.HtmlEmailer;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.logmapping.LogMappingImpl;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.email.EmailTarget;
import utils.loggingframework.targets.email.EventEmailTemplate;
import utils.loggingframework.targets.file.FileTarget;
import utils.message.Message;
import utils.message.TypedMap;
import utils.progtools.Sizes;
import utils.string.Base64;
import utils.string.HexData;
import utils.string.SimpleRegex;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.CUIFieldRepository;
import utils.swing.cui.types.fields.TextField;
import utils.switches.Switches;
import utils.xml.XML14Util;

public class ServerConfig
implements LDAPAuthenticator.LDAPAttributeMappingProvider {
    public static boolean TEST_LOAD = false;
    public static String LEGACY_FILENAME = "serverconfig.xml";
    public static final String DEFAULT_FILENAME = "configuration/serverconfig.xml";
    public static final String DEFAULT_EXTENSION = "configuration/ProxyServerExtension.cfg";
    private final Object LOCK = new Object();
    private static final Object SAVE_FILE_LOCK = new Object();
    private long loadTime = 0L;
    private static ServerConfig CURRENT_INSTANCE = new ServerConfig();
    public boolean enabledRemoteSupport = true;
    public boolean enabledRemoteAccess = true;
    public boolean enabledPresentation = true;
    public boolean enabledMobileAccess = true;
    public boolean enabledMobileSshAccess = true;
    public boolean enabledServiceRecovery = true;
    private final ArrayList<LDAPAuthenticator.LDAPAttributeMapping> ldapMappings = new ArrayList();
    private String comment = null;
    private boolean logInfo = false;
    public boolean statusPage = false;
    public boolean statusPageIncludeMachines = false;
    public boolean statusPageIncludeSessions = false;
    public boolean statusPageIncludePerformance = false;
    public PatternWrapper[] statusPageRestrictions = new PatternWrapper[0];
    public boolean emailSettingsEnabled = false;
    public boolean smtpTLS;
    public boolean smtpSSL;
    public boolean smtpSendAsTechnicians;
    public String smtpHost;
    public int smtpPort;
    public String smtpUser;
    public LazyEncryptedPassword smtpPassword = new LazyEncryptedPassword(null);
    public String smtpFromEmail;
    public String smtpFromName;
    public boolean smtpAuthentication = false;
    private String dateFormat = null;
    public Properties emailProperties = null;
    public boolean remoteMachinesTechPresence;
    public boolean remoteCustomersTechPresence;
    public boolean ldapEnable;
    public boolean ldapEnableSSL;
    public String ldapHostname;
    public int ldapPort;
    public String ldapUsername;
    public LazyEncryptedPassword ldapPassword = new LazyEncryptedPassword(null);
    public String ldapAuthentication;
    public boolean ldapFollowLinks = true;
    public boolean ldapIsAD;
    public String ldapUserClass;
    private String ldapGroupClass;
    private String ldapLoginAttribute;
    private String ldapMemberAttribute;
    private int totpLength = 6;
    private int totpWindowSize = 10;
    private HashMap<String, LazyEncryptedPassword> deprecated_anonymousUserIDToTOTPKey = new HashMap();
    public boolean sessionSummaryTechComment;
    public boolean sessionSummaryAllowSkip;
    public boolean sessionSummaryCustEmail;
    public String sessionSummaryEmailCustDetail;
    private final ArrayList<TechUser> technicians = new ArrayList();
    private final ArrayList<TechUser> anonymousTechnicians = new ArrayList();
    private final ArrayList<TechGroup> groups = new ArrayList();
    private boolean simplehelp;
    private boolean simplegateway;
    private boolean simplesuite;
    public PatternWrapper[] techRestrictions;
    public PatternWrapper[] apiRestrictions;
    public int[] portList;
    public String[] ipList;
    public String[] ipPortPairsList;
    public int sshdPort;
    public LazyHashPassword serverHashPassword = new LazyHashPassword(null);
    public String disclaimer;
    private final Object detailFieldsLock = new Object();
    private CUIField[] detailFields;
    private String detailFieldsXML;
    public boolean enabledQueuePassword;
    public String queuePassword;
    public long appearWaitMS;
    public long connectWaitMS;
    public boolean stopButDontRemoveServices = false;
    public LazyEncryptedPassword keystoreStorePassword = new LazyEncryptedPassword(null);
    public LazyEncryptedPassword keystoreKeyPassword = new LazyEncryptedPassword(null);
    public String keystoreType = "SelfSigned";
    public static final String KEYSTORE_SELF_SIGNED = "SelfSigned";
    public static final String KEYSTORE_LETS_ENCRYPT = "LetsEncrypt";
    public static final String KEYSTORE_UPLOADED = "Uploaded";
    public static final boolean deprecated_forceSslForSessions = false;
    private boolean uPnPPortForwardingEnabled = true;
    public int defaultMachineTimeoutMS = 30000;
    public int secureMessengerRouteMapSize = ServerConfig.getDefaultSecureMessengerRouteMapSize();
    public String hostname = null;
    public boolean forwardToHTTPS = false;
    public String failoverCheckURL = null;
    public String condenserForURL = null;
    private LazyEncryptedPassword condenserToken = new LazyEncryptedPassword(null);
    private long debugDelay = 0L;
    public List<BlockedRemoteMachine> blockedRemoteAccessMachines = null;
    public List<HTTPHeader> httpHeaders = null;
    public List<String> blockedURLs = null;
    public List<Pattern> blockedURLPatterns = null;
    public boolean autoForgetEnabled;
    public long autoForgetTimeoutMS = 600000L;
    public boolean diskCleanupEnabled = false;
    public int diskCleanupTimeoutMonths = 12;
    public boolean archiveLogs = true;
    public boolean compressLogs = true;
    public long maxLogsFileSize = 0x40000000L;
    private boolean encryptLogs = true;
    public int logsToKeep = 3;
    private boolean deprecated_logTechToFile = false;
    private boolean deprecated_logFilePerTech = false;
    private boolean deprecated_logTechEmail = false;
    private String deprecated_logTechEmailAddress = null;
    private boolean deprecated_logTechLogins = false;
    private boolean deprecated_logTechLogouts = false;
    private boolean deprecated_logTechJoins = false;
    private boolean deprecated_logTechLeaves = false;
    private boolean deprecated_logTechRemoteJoins = false;
    private boolean deprecated_logTechRemoteLeaves = false;
    private boolean deprecated_logCustToFile = false;
    private boolean deprecated_logFilePerCust = false;
    private boolean deprecated_logCustEmail = false;
    private String deprecated_logCustEmailAddress = null;
    private boolean deprecated_logCustJoinQueue = false;
    private boolean deprecated_logCustLeaveQueue = false;
    private boolean deprecated_logCustJoins = false;
    private boolean deprecated_logCustLeaves = false;
    private LogMapping[] deprecated_logMappings = null;
    public final TechUser serverAdmin = new TechUser(0, OemBranding.OEM_ADMIN_USERNAME, OemBranding.OEM_ADMIN_USERNAME, null, null, false, true, true);
    public final TechGroup serverAdminGroup = new TechGroup(2000001, OemBranding.OEM_ADMIN_USERNAME + "Group");
    public boolean redirectDefaultToWelcomePage = true;
    private String serverLanguage = null;
    public String endOfSessionOption = null;
    public String endOfSessionURL = null;
    public boolean endOfSessionURLAccess = true;
    public boolean endOfSessionURLSupport = true;
    public boolean elevateSupportSessions = true;
    public int defaultMaxAudioBitrate = 0;
    public boolean radiusEnable = false;
    public RadiusConfig[] radiusConfigs = null;
    public int radiusAttempts = 3;
    public long radiusTimeout = 10000L;
    public int radiusStrategy = 1;
    public int radiusStaggeredTimeout = 2000;
    public boolean feature_showPerformanceMetricsTechConsole = false;
    public boolean feature_multiLicense = false;
    private static final Random random = new Random();

    public static ServerConfig get() {
        return CURRENT_INSTANCE;
    }

    public static void set(ServerConfig newVersion) {
        CURRENT_INSTANCE = newVersion;
    }

    private static int getDefaultSecureMessengerRouteMapSize() {
        if (Switches.SH_adaptableRoutemapSize) {
            if (Runtime.getRuntime().maxMemory() > 4L * Sizes.ONE_GIGABYTE) {
                return 150000;
            }
            if (Runtime.getRuntime().maxMemory() > 2L * Sizes.ONE_GIGABYTE) {
                return 100000;
            }
            if (Runtime.getRuntime().maxMemory() > Sizes.ONE_GIGABYTE) {
                return 25000;
            }
            return 10000;
        }
        return 10000;
    }

    public void setAdminPasswordTo(String originalNonHashedPassword) {
        if (this.serverHashPassword == null) {
            this.serverHashPassword = LazyHashPassword.createWithNewPassword(originalNonHashedPassword);
        } else {
            this.serverHashPassword.setOriginalPassword(originalNonHashedPassword);
        }
    }

    public ServerConfig() {
        this.serverAdmin.setGroups(new TechGroup[]{this.serverAdminGroup});
    }

    private static boolean getElementContentsAsBoolean(Element parentElement, String childTagName, boolean defaultValue) {
        Element endOfSessionElement = XML14Util.getChildByName((Element)parentElement, (String)childTagName);
        if (endOfSessionElement != null) {
            String value = XML14Util.getTextContent((Node)endOfSessionElement);
            return (value = value.toLowerCase().trim()).equals("yes") || value.equals("on") || value.equals("true");
        }
        return defaultValue;
    }

    private static int getElementContentsAsInteger(Element parentElement, String childTagName, int defaultValue) {
        Element endOfSessionElement = XML14Util.getChildByName((Element)parentElement, (String)childTagName);
        if (endOfSessionElement != null) {
            String value = XML14Util.getTextContent((Node)endOfSessionElement);
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static long getElementContentsAsLong(Element parentElement, String childTagName, long defaultValue) {
        Element endOfSessionElement = XML14Util.getChildByName((Element)parentElement, (String)childTagName);
        if (endOfSessionElement != null) {
            String value = XML14Util.getTextContent((Node)endOfSessionElement);
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static String getElementContentsAsString(Element parentElement, String childTagName) {
        Element endOfSessionElement = XML14Util.getChildByName((Element)parentElement, (String)childTagName);
        if (endOfSessionElement != null) {
            return XML14Util.getTextContent((Node)endOfSessionElement);
        }
        return null;
    }

    public static void main(String[] args) throws DOMException, IOException, ParserConfigurationException, SAXException, ServerStartFailureException {
        ServerConfig c = new ServerConfig();
        c.loadConfig(FileUtil.readFileAsStringUTF8((String)"SimpleHelp/configuration/serverconfig.xml"));
    }

    static String decryptPass_legacy(String pword) {
        if (pword == null) {
            return null;
        }
        Blowfish bfish = new Blowfish();
        bfish.init("ADSijlsd709)&*))(*()(*)7ds8a9jkdlasjoa897*())(&*((((((((ujdjksakldnadj, nn   Jhjodsay8ads;''");
        byte[] dat = HexData.hexStringToByteArray((String)pword);
        dat = bfish.decryptSecure(dat, 0, false);
        try {
            return new String(dat, "UnicodeBig");
        }
        catch (Exception x) {
            return new String(dat);
        }
    }

    private static String getEncryptedPasswordOrNull(LazyEncryptedPassword lazyEncryptedPassword) {
        if (lazyEncryptedPassword == null) {
            return null;
        }
        return lazyEncryptedPassword.getEncryptedPassword();
    }

    public static String getDecryptedPasswordOrNull(LazyEncryptedPassword lazyEncryptedPassword) {
        if (lazyEncryptedPassword == null) {
            return null;
        }
        return lazyEncryptedPassword.getDecryptedPassword();
    }

    static String decryptPassv2(String pword) throws IOException {
        if (pword == null) {
            return null;
        }
        return BCUtil.decryptPassword((String)pword, (String)"!jfjaASJj32jjls00a0alaj1@JaAasjkjkdkVMNa..,kjsdn2lja02jlj2744'';'/Jhjodsay8ads;''");
    }

    static String encryptPassv2(String pword) {
        if (pword == null) {
            return null;
        }
        try {
            return BCUtil.encryptedPassword((String)pword, (String)"!jfjaASJj32jjls00a0alaj1@JaAasjkjkdkVMNa..,kjsdn2lja02jlj2744'';'/Jhjodsay8ads;''");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static LazyHashPassword getHashedPassword(Element root, String plainTagName) {
        String hashKey = "Hash" + plainTagName;
        String saltedHashPassword = XML14Util.getChildText((Element)root, (String)hashKey, null);
        if (saltedHashPassword != null) {
            return new LazyHashPassword(saltedHashPassword);
        }
        LazyEncryptedPassword encryptedPassword = ServerConfig.getPassword(root, plainTagName, "Secure" + plainTagName, "Secure" + plainTagName + "v2");
        if (encryptedPassword.isNull()) {
            return null;
        }
        String originalPassword = encryptedPassword.getDecryptedPassword();
        return LazyHashPassword.createWithNewPassword(originalPassword);
    }

    private LazyEncryptedPassword getPlaintextOrEncryptedPassword(Element root, String plainTagName) {
        return ServerConfig.getPassword(root, plainTagName, "Secure" + plainTagName, "Secure" + plainTagName + "v2");
    }

    private static LazyEncryptedPassword getPassword(Element root, String plainTagName, String legacyTagName, String encryptedTagName) {
        try {
            String password;
            if (plainTagName != null && (password = XML14Util.getChildText((Element)root, (String)plainTagName, null)) != null) {
                return new LazyEncryptedPassword(password);
            }
            if (legacyTagName != null && (password = XML14Util.getChildText((Element)root, (String)legacyTagName, null)) != null) {
                return new LazyEncryptedPassword(password, true);
            }
            if (encryptedTagName != null && (password = XML14Util.getChildText((Element)root, (String)encryptedTagName, null)) != null) {
                return new LazyEncryptedPassword(password, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LazyEncryptedPassword(null);
    }

    private String getComment(String source, String startTagName) {
        int startIndex = source.indexOf(startTagName);
        if (startIndex == -1) {
            return null;
        }
        return source.substring(0, startIndex).trim();
    }

    public void loadConfig(File file) throws IOException, ParserConfigurationException, SAXException, DOMException, ServerStartFailureException {
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
        String allData = new String(StreamUtils.readAll(fin), StandardCharsets.UTF_8);
        ((InputStream)fin).close();
        this.loadConfig(allData, true);
        this.disclaimer = ServerConfig.loadDisclaimer();
        try {
            File serverDirectory = new File("DEPLOY");
            if (!serverDirectory.exists()) {
                serverDirectory = new File("lib");
            }
            if (this.serverLanguage != null) {
                Language.loadTranslationsFrom(serverDirectory, this.serverLanguage);
            } else {
                Language.loadTranslationsFrom(serverDirectory, "en");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setServerLanguage(String language) {
        this.serverLanguage = language;
    }

    public String getServerLanguage() {
        if (this.serverLanguage == null) {
            return "en";
        }
        return this.serverLanguage;
    }

    private EventEmailTemplate getDefaultEmailTemplate(SimpleHelpLogEvent event) {
        File emailFile = event.getEmailTemplateFile();
        EventEmailTemplate template = new EventEmailTemplate(event);
        if (emailFile != null && emailFile.exists()) {
            String[] result = EmailTemplateLoader.processTemplateFile(emailFile);
            template.setContent(result[0], result[1]);
        }
        return template;
    }

    public void migrateSettings(AlertRegistryAPI alertRegistry, ToolBoxRegistryAPI toolBoxRegistryAPI) throws IOException {
        Class<? extends LogEvent> c;
        String eventID;
        String[] stringArray;
        ArrayList<EventEmailTemplate> templates;
        AbstractTarget target;
        Iterator<TechUser> eventIDs;
        ArrayList<LogMappingImpl> newLogMappings = new ArrayList<LogMappingImpl>();
        boolean migratedSettings = false;
        if (this.deprecated_logTechToFile || this.deprecated_logFilePerTech || this.deprecated_logTechEmail && this.deprecated_logTechEmailAddress != null && this.deprecated_logTechEmailAddress.length() > 0) {
            migratedSettings = true;
            eventIDs = new ArrayList<String>();
            if (this.deprecated_logTechLogins) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLoginEvent.class)));
            }
            if (this.deprecated_logTechLogouts) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLogoutEvent.class)));
            }
            if (this.deprecated_logTechJoins) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechJoinSupportSessionEvent.class)));
            }
            if (this.deprecated_logTechLeaves) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLeaveSupportSessionEvent.class)));
            }
            if (this.deprecated_logTechRemoteJoins) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechJoinAccessSessionEvent.class)));
            }
            if (this.deprecated_logTechRemoteLeaves) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLeaveAccessSessionEvent.class)));
            }
            if (this.deprecated_logTechToFile) {
                target = new FileTarget();
                target.logFileName = "TechnicianActivity.log";
                target.logFileLocation = "./";
                target.timestamp = true;
                newLogMappings.add(new LogMappingImpl("Technician Activity Log", ((ArrayList)((Object)eventIDs)).toArray(new String[0]), new AbstractTarget[]{target}));
            }
            if (this.deprecated_logTechEmail && this.deprecated_logTechEmailAddress != null && this.deprecated_logTechEmailAddress.length() > 0) {
                target = new EmailTarget();
                ((EmailTarget)target).toEmailAddresses = new String[]{this.deprecated_logTechEmailAddress};
                try {
                    templates = new ArrayList<EventEmailTemplate>();
                    stringArray = ((ArrayList)((Object)eventIDs)).iterator();
                    while (stringArray.hasNext()) {
                        eventID = (String)stringArray.next();
                        c = SimpleHelpEventRepository.INSTANCE.getEventClass(eventID);
                        templates.add(this.getDefaultEmailTemplate((SimpleHelpLogEvent)c.newInstance()));
                    }
                    ((EmailTarget)target).storedEmailTemplates = new EventEmailTemplate[templates.size()];
                    templates.toArray(((EmailTarget)target).storedEmailTemplates);
                }
                catch (Throwable t) {
                    System.out.println("[ServerConfig] Unable to succesfully migrate email logging. Please verify new settings in the Logging tab of the Administration console.");
                    t.printStackTrace();
                }
                newLogMappings.add(new LogMappingImpl("Technician Activity Email", ((ArrayList)((Object)eventIDs)).toArray(new String[0]), new AbstractTarget[]{target}));
            }
        }
        if (this.deprecated_logCustToFile || this.deprecated_logFilePerCust || this.deprecated_logCustEmail && this.deprecated_logCustEmailAddress != null && this.deprecated_logCustEmailAddress.length() > 0) {
            migratedSettings = true;
            eventIDs = new ArrayList();
            if (this.deprecated_logCustJoinQueue) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLoginEvent.class)));
            }
            if (this.deprecated_logCustLeaveQueue) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLogoutEvent.class)));
            }
            if (this.deprecated_logCustJoins) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechJoinSupportSessionEvent.class)));
            }
            if (this.deprecated_logCustLeaves) {
                ((ArrayList)((Object)eventIDs)).add((TechUser)((Object)SimpleHelpEventRepository.INSTANCE.getEventIDForClass(TechLeaveSupportSessionEvent.class)));
            }
            if (this.deprecated_logCustToFile) {
                target = new FileTarget();
                target.logFileName = "CustomerActivity.log";
                target.logFileLocation = "./";
                target.timestamp = true;
                newLogMappings.add(new LogMappingImpl("Customer Activity Log", ((ArrayList)((Object)eventIDs)).toArray(new String[0]), new AbstractTarget[]{target}));
            }
            if (this.deprecated_logCustEmail && this.deprecated_logCustEmailAddress != null && this.deprecated_logCustEmailAddress.length() > 0) {
                target = new EmailTarget();
                ((EmailTarget)target).toEmailAddresses = new String[]{this.deprecated_logCustEmailAddress};
                try {
                    templates = new ArrayList();
                    stringArray = ((ArrayList)((Object)eventIDs)).iterator();
                    while (stringArray.hasNext()) {
                        eventID = (String)stringArray.next();
                        c = SimpleHelpEventRepository.INSTANCE.getEventClass(eventID);
                        templates.add(this.getDefaultEmailTemplate((SimpleHelpLogEvent)c.newInstance()));
                    }
                    ((EmailTarget)target).storedEmailTemplates = new EventEmailTemplate[templates.size()];
                    templates.toArray(((EmailTarget)target).storedEmailTemplates);
                }
                catch (Throwable t) {
                    System.out.println("[ServerConfig] Unable to succesfully migrate email logging. Please verify new settings in the Logging tab of the Administration console.");
                    t.printStackTrace();
                }
                newLogMappings.add(new LogMappingImpl("Customer Activity Email", ((ArrayList)((Object)eventIDs)).toArray(new String[0]), new AbstractTarget[]{target}));
            }
        }
        this.migrateFile("templates/technician/tech_leave_customer", "configuration/templates/support/technician_leave");
        this.migrateFile("templates/technician/tech_joins_customer", "configuration/templates/support/technician_join");
        this.migrateFile("templates/customer/customer_leave_tech", "configuration/templates/support/customer_leave");
        this.migrateFile("templates/customer/customer_join_tech", "configuration/templates/support/customer_join");
        this.migrateFile("templates/customer/customer_logout", "configuration/templates/support/customer_logout");
        this.migrateFile("templates/customer/customer_login", "configuration/templates/support/customer_login");
        this.migrateFile("templates/technician/tech_logout", "configuration/templates/technician/logout");
        this.migrateFile("templates/technician/tech_login", "configuration/templates/technician/login");
        this.migrateFile("templates/technician/tech_join_remote", "configuration/templates/access/technician_join");
        this.migrateFile("templates/technician/tech_leave_remote", "configuration/templates/access/technician_leave");
        this.migrateFile("templates/session/customer", "configuration/templates/support/session_summary");
        this.migrateFile("templates/session/remoteaccess", "configuration/templates/access/session_summary");
        for (TechGroup group : this.groups) {
            if (group.getGroupID() != -1) continue;
            group.setGroupID(this.getTechnicianGroupID());
            migratedSettings = true;
        }
        for (TechUser technician : this.technicians) {
            if (technician.getUserID() != -1) continue;
            technician.setUserID(this.getTechnicianID());
            migratedSettings = true;
        }
        for (TechUser technician : this.anonymousTechnicians) {
            if (technician.getUserID() != -1) continue;
            technician.setUserID(this.getTechnicianID());
            migratedSettings = true;
        }
        File oldLicense = new File("shlicense.txt");
        File newLicense = new File("configuration/shlicense.txt");
        if (oldLicense.exists() && !newLicense.exists() && !oldLicense.renameTo(newLicense)) {
            FileUtil.copy((File)oldLicense, (File)newLicense);
        }
        if (this.detailFields == null) {
            migratedSettings = true;
            String oldDetails = ServerConfig.loadDeprecatedDetails();
            if (oldDetails == null) {
                oldDetails = "Name\nCompany";
            }
            System.out.println("[ServerConfig] Detected old style details.txt file. Migrating settings.");
            String[] oldDetailsSplit = oldDetails.split("\\n");
            ArrayList<TextField> newFieldList = new ArrayList<TextField>();
            for (String anOldDetailsSplit : oldDetailsSplit) {
                String oldDetail = anOldDetailsSplit.trim();
                if (oldDetail == null || oldDetail.length() <= 0) continue;
                newFieldList.add(new TextField(oldDetail, null));
            }
            this.detailFields = new CUIField[newFieldList.size()];
            newFieldList.toArray(this.detailFields);
        }
        if (migratedSettings) {
            if (this.deprecated_logMappings == null) {
                this.deprecated_logMappings = new LogMappingImpl[0];
            }
            LogMapping[] newMappingsArray = new LogMapping[newLogMappings.size() + this.deprecated_logMappings.length];
            System.arraycopy(this.deprecated_logMappings, 0, newMappingsArray, 0, this.deprecated_logMappings.length);
            for (int i = 0; i < newLogMappings.size(); ++i) {
                newMappingsArray[i + this.deprecated_logMappings.length] = (LogMappingImpl)newLogMappings.get(i);
            }
            this.deprecated_logMappings = newMappingsArray;
            this.saveToConfig(new File(DEFAULT_FILENAME));
            ServerConfig.deleteDeprecatedDetails();
        }
        try {
            if (this.deprecated_logMappings != null && this.deprecated_logMappings.length > 0) {
                for (LogMapping logMappingImpl : this.deprecated_logMappings) {
                    ServerEvent newEvent = new ServerEvent();
                    newEvent.setName(logMappingImpl.getLogMappingDescription());
                    newEvent.setTargets(logMappingImpl.getTargets());
                    newEvent.setLogEventIDs(logMappingImpl.getLogEventIDs());
                    newEvent.setFilters(logMappingImpl.getFilters());
                    newEvent.setActive(true);
                    alertRegistry.add(newEvent);
                }
                alertRegistry.scheduleSaveInTenSeconds();
                this.saveToConfig(new File(DEFAULT_FILENAME));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.deprecated_migrateToolBoxes(toolBoxRegistryAPI);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechGroup[] getAllTechGroups() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.groups.toArray(new TechGroup[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deprecated_migrateToolBoxes(ToolBoxRegistryAPI toolBoxRegistryAPI) throws Exception {
        boolean save = false;
        for (TechUser user : this.getTechnicians(true)) {
            File loadFile = TechPrefsFileUtil.getPrefsFileV2(user, "toolbox");
            if (!loadFile.exists()) continue;
            AtomicFileOutputStream.prepareForReading((File)loadFile);
            byte[] dat = FileUtil.readFile((File)loadFile);
            try {
                save = true;
                ToolBox toolBox = ToolBox.loadFromXML(new String(dat, StandardCharsets.UTF_8));
                toolBoxRegistryAPI.setToolBoxFor(user, toolBox);
                toolBoxRegistryAPI.registerToolBoxResources(toolBox);
                if (!CentralDebugging.PX_TOOLBOX) continue;
                System.out.println("[ProxyServer] Deprecated Loaded toolbox: ");
                System.out.println(toolBox.toXML());
            }
            finally {
                loadFile.delete();
            }
        }
        if (save) {
            toolBoxRegistryAPI.saveImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDefaultFile() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.saveToConfig(new File(DEFAULT_FILENAME));
        }
    }

    private void migrateFile(String oldFile, String newFile) {
        File oldFileHandle = new File(oldFile);
        if (!oldFileHandle.exists()) {
            return;
        }
        File newFileHandle = new File(newFile);
        try {
            FileCopyUtil.fastCopyFile(oldFileHandle, newFileHandle);
            oldFileHandle.delete();
        }
        catch (IOException e) {
            Debugger.warning("[ServerConfig] Unable to migrate old configuration file: " + oldFile);
        }
    }

    public static String getHostFromIpAndPort(String ipport) {
        int split = ipport.indexOf(58);
        return ipport.substring(0, split);
    }

    public static int getPortFromIpAndPort(String ipport) {
        int split = ipport.indexOf(58);
        return Integer.parseInt(ipport.substring(split + 1));
    }

    public void recreateIpAndPortLists() {
        if (this.ipPortPairsList != null) {
            int i;
            ArrayList<String> ipsOnly = new ArrayList<String>();
            ArrayList<String> portsOnly = new ArrayList<String>();
            for (i = 0; i < this.ipPortPairsList.length; ++i) {
                try {
                    String port;
                    String ip;
                    int split = this.ipPortPairsList[i].indexOf(58);
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Listening on specific IP:Port combo " + i + ": " + this.ipPortPairsList[i]);
                    }
                    if (!ipsOnly.contains(ip = this.ipPortPairsList[i].substring(0, split))) {
                        ipsOnly.add(ip);
                    }
                    if (portsOnly.contains(port = this.ipPortPairsList[i].substring(split + 1))) continue;
                    portsOnly.add(port);
                    continue;
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Invalid IpPort bind spec: " + this.ipPortPairsList[i]);
                    return;
                }
            }
            this.ipList = new String[ipsOnly.size()];
            ipsOnly.toArray(this.ipList);
            this.portList = new int[portsOnly.size()];
            for (i = 0; i < this.portList.length; ++i) {
                this.portList[i] = Integer.parseInt((String)portsOnly.get(i));
            }
        } else {
            this.ipList = null;
        }
    }

    public void loadConfig(String xmlData) throws IOException, ParserConfigurationException, SAXException, DOMException, ServerStartFailureException {
        this.loadConfig(xmlData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(String xmlData, boolean diskAccess) throws IOException, ParserConfigurationException, SAXException, DOMException, ServerStartFailureException {
        Element messengerRouteMapElement;
        Element node;
        int i;
        int i2;
        Element child4;
        Element root;
        block306: {
            Element childchild;
            Element child2;
            Element settings;
            ArrayList email;
            Object key;
            block304: {
                Element settings2;
                ArrayList users;
                Object httpHeader;
                Object nextHostname;
                Object child3;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document dom = builder.parse(new InputSource(new StringReader(xmlData)));
                root = dom.getDocumentElement();
                this.loadTime = System.currentTimeMillis();
                this.serverAdminGroup.setMultiTierRememberMachine(false);
                this.simplehelp = false;
                this.simplegateway = false;
                this.simplesuite = false;
                if (root.getTagName().trim().equalsIgnoreCase("SimpleHelp")) {
                    this.simplehelp = true;
                }
                if (root.getTagName().trim().equalsIgnoreCase("SimpleGateway")) {
                    this.simplegateway = true;
                }
                if (root.getTagName().trim().equalsIgnoreCase("SimpleSuite")) {
                    this.simplesuite = true;
                }
                if (this.simplehelp) {
                    ServerManagement.SIMPLEGATEWAY = false;
                    ServerManagement.SIMPLEHELP = true;
                } else if (this.simplegateway) {
                    ServerManagement.SIMPLEGATEWAY = true;
                    ServerManagement.SIMPLEHELP = false;
                }
                if (this.simplesuite) {
                    ServerManagement.SIMPLEGATEWAY = true;
                    ServerManagement.SIMPLEHELP = true;
                }
                this.comment = this.simplehelp ? this.getComment(xmlData, "<SimpleHelp>") : (this.simplegateway ? this.getComment(xmlData, "<SimpleGateway>") : this.getComment(xmlData, "<SimpleSuite>"));
                this.enabledRemoteSupport = ServerManagement.SIMPLEHELP;
                this.enabledRemoteAccess = ServerManagement.SIMPLEGATEWAY;
                this.enabledPresentation = ServerManagement.SIMPLEDEMO;
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"ServerFeatures");
                    if (child3 != null) {
                        Element remoteAccess = XML14Util.getChildByName((Element)child3, (String)"RemoteAccess");
                        Element remoteSupport = XML14Util.getChildByName((Element)child3, (String)"RemoteSupport");
                        Element presentation = XML14Util.getChildByName((Element)child3, (String)"Presentation");
                        Element mobileAccess = XML14Util.getChildByName((Element)child3, (String)"MobileAccess");
                        Element serviceRecovery = XML14Util.getChildByName((Element)child3, (String)"ServiceRecovery");
                        if (remoteAccess != null) {
                            this.enabledRemoteAccess = XML14Util.getTextContent((Node)remoteAccess).equalsIgnoreCase("on");
                        }
                        if (remoteSupport != null) {
                            this.enabledRemoteSupport = XML14Util.getTextContent((Node)remoteSupport).equalsIgnoreCase("on");
                        }
                        if (presentation != null) {
                            this.enabledPresentation = XML14Util.getTextContent((Node)presentation).equalsIgnoreCase("on");
                        }
                        if (mobileAccess != null) {
                            this.enabledMobileAccess = XML14Util.getTextContent((Node)mobileAccess).equalsIgnoreCase("on");
                        }
                        if (serviceRecovery != null) {
                            this.enabledServiceRecovery = XML14Util.getTextContent((Node)serviceRecovery).equalsIgnoreCase("on");
                        }
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Debugger.error("[Server Config] Unable to process server features.");
                }
                ServerManagement.SIMPLEHELP = this.enabledRemoteSupport;
                ServerManagement.SIMPLEGATEWAY = this.enabledRemoteAccess;
                ServerManagement.SIMPLEDEMO = this.enabledPresentation;
                try {
                    LazyHashPassword newPassword = ServerConfig.getHashedPassword(root, "Password");
                    if (newPassword == null || newPassword.isNull()) {
                        throw new NullPointerException("");
                    }
                    this.serverHashPassword = newPassword;
                }
                catch (Exception x) {
                    Debugger.error("[Server Config] Invalid <Password> entry: the master <Password> tag is required, even when using LDAP authentication, please also note you should not set this password to blank.");
                }
                try {
                    this.detailFields = null;
                    Element parentElement = XML14Util.getChildByName((Element)root, (String)"DetailsList");
                    if (parentElement != null) {
                        this.detailFields = CUIFieldRepository.loadChildrenOfElement((Element)parentElement, null);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Debugger.error("[Server Config] Unable to load customer detail fields configuration.");
                }
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"Hostname");
                    if (child3 != null) {
                        nextHostname = XML14Util.getTextContent((Node)child3);
                        if ((this.hostname == null || nextHostname == null || !this.hostname.equals(nextHostname)) && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Set hostname of the server to " + this.hostname);
                        }
                        this.hostname = nextHostname;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    child3 = XML14Util.getChildren((Element)root, (String)"3");
                    if (child3 != null) {
                        this.httpHeaders = new ArrayList<HTTPHeader>();
                        nextHostname = ((ArrayList)child3).iterator();
                        while (nextHostname.hasNext()) {
                            httpHeader = (Element)nextHostname.next();
                            String name = httpHeader.getAttribute("name");
                            String value = httpHeader.getAttribute("value");
                            this.httpHeaders.add(new HTTPHeader(name, value));
                            if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                            System.out.println("[Server Config] Loaded custom HTTP header " + name + "=" + value);
                        }
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                this.autoForgetEnabled = ServerConfig.getElementContentsAsBoolean(root, "AutoForget", false);
                this.autoForgetTimeoutMS = Long.parseLong(XML14Util.getChildText((Element)root, (String)"AutoForgetTimeoutMS", (String)"600000"));
                this.diskCleanupEnabled = ServerConfig.getElementContentsAsBoolean(root, "DiskCleanup", false);
                this.diskCleanupTimeoutMonths = Integer.parseInt(XML14Util.getChildText((Element)root, (String)"DiskCleanupTimeoutMonths", (String)"12"));
                Element loggingParent = XML14Util.getChild((Element)root, (String)"Logging");
                if (loggingParent != null) {
                    this.archiveLogs = ServerConfig.getElementContentsAsBoolean(loggingParent, "Archive", true);
                    this.compressLogs = ServerConfig.getElementContentsAsBoolean(loggingParent, "Compress", true);
                    this.maxLogsFileSize = ServerConfig.getElementContentsAsLong(loggingParent, "MaxPartSize", 0x40000000L);
                    this.logsToKeep = ServerConfig.getElementContentsAsInteger(loggingParent, "LogsToKeep", 3);
                    this.encryptLogs = ServerConfig.getElementContentsAsBoolean(loggingParent, "Encrypt", true);
                }
                try {
                    child3 = XML14Util.getChildren((Element)root, (String)"BlockedURL");
                    if (child3 != null) {
                        this.blockedURLs = new ArrayList<String>();
                        this.blockedURLPatterns = new ArrayList<Pattern>();
                        int total = 0;
                        httpHeader = ((ArrayList)child3).iterator();
                        while (httpHeader.hasNext()) {
                            Element blockedURL = (Element)httpHeader.next();
                            String url = XML14Util.getTextContent((Node)blockedURL);
                            try {
                                Pattern p = SimpleRegex.simpleToPattern(url, false);
                                this.blockedURLs.add(url);
                                this.blockedURLPatterns.add(p);
                                ++total;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (total > 0 && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Loaded " + total + " blocked URLs");
                        }
                    } else {
                        this.blockedURLs = null;
                        this.blockedURLPatterns = null;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"MachineAppearTimeoutMS");
                    if (child3 != null) {
                        long appearWaitMS = Long.parseLong(XML14Util.getTextContent((Node)child3));
                        if (appearWaitMS != this.appearWaitMS && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Machine appear wait specified " + appearWaitMS + "ms");
                        }
                        this.appearWaitMS = appearWaitMS;
                    } else {
                        this.appearWaitMS = 0L;
                    }
                }
                catch (NumberFormatException x) {
                    Debugger.error("[Server Config] Invalid <MachineAppearTimeoutMS> entry: not a valid number");
                    this.appearWaitMS = 0L;
                }
                catch (Exception x) {
                    this.appearWaitMS = 0L;
                }
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"MachineConnectTimeoutMS");
                    if (child3 != null) {
                        long connectWaitMS = Long.parseLong(XML14Util.getTextContent((Node)child3));
                        if (connectWaitMS != this.connectWaitMS && CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Machine connect wait specified " + connectWaitMS + "ms");
                        }
                        this.connectWaitMS = connectWaitMS;
                    } else {
                        this.connectWaitMS = 0L;
                    }
                }
                catch (NumberFormatException x) {
                    Debugger.error("[Server Config] Invalid <MachineConnectTimeoutMS> entry: not a valid number");
                    this.connectWaitMS = 0L;
                }
                catch (Exception x) {
                    this.connectWaitMS = 0L;
                }
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"SslKeystore");
                    if (child3 != null) {
                        this.keystoreStorePassword = this.getPlaintextOrEncryptedPassword((Element)child3, "KeystoreStorePassword");
                        this.keystoreKeyPassword = this.getPlaintextOrEncryptedPassword((Element)child3, "KeystoreKeyPassword");
                        this.keystoreType = XML14Util.getChildText((Element)child3, (String)"StoreType", null);
                        if (this.keystoreType == null) {
                            this.keystoreType = SslToTcp.KEYSTORE == null || SslToTcp.KEYSTORE.isSelfSigned() ? KEYSTORE_SELF_SIGNED : KEYSTORE_UPLOADED;
                        }
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] SSL Keystore specified.");
                        }
                    } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] No SSL keystore specified");
                    }
                }
                catch (Exception x) {
                    Debugger.error("[Server Config] Invalid <SslKeystore> entry, the child tags <KeystorePath>, <[Secure]KeystoreStorePassword> and <[Secure]KeystoreKeyPassword> must be specified and valid");
                }
                try {
                    String text;
                    child3 = XML14Util.getChildByName((Element)root, (String)"RedirectDefaultUrlToWelcomePage");
                    this.redirectDefaultToWelcomePage = child3 != null ? (text = XML14Util.getTextContent((Node)child3)) == null || !text.equalsIgnoreCase("no") : true;
                }
                catch (Exception x) {
                    this.redirectDefaultToWelcomePage = false;
                }
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"ServerLanguage");
                    this.serverLanguage = child3 != null ? XML14Util.getTextContent((Node)child3) : "en";
                }
                catch (Exception x) {
                    this.serverLanguage = "en";
                }
                try {
                    child3 = XML14Util.getChildByName((Element)root, (String)"StopRemoteServicesOnly");
                    if (child3 != null) {
                        this.stopButDontRemoveServices = true;
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Remote services are stopped but not removed.");
                        }
                    } else {
                        this.stopButDontRemoveServices = false;
                    }
                }
                catch (Exception x) {
                    this.stopButDontRemoveServices = false;
                }
                Element appChild = XML14Util.getChildByName((Element)root, (String)"AdminAppAuthentication");
                this.serverAdminGroup.setMultiTierApp(appChild != null);
                if (appChild != null) {
                    LazyEncryptedPassword adminAppAuthenticationKey = ServerConfig.getPassword(appChild, null, "Key", "Keyv2");
                    this.serverAdmin.setTOTPKey(adminAppAuthenticationKey);
                }
                appChild = XML14Util.getChildByName((Element)root, (String)"AdminAuthenticationRememberMachine");
                this.serverAdminGroup.setMultiTierRememberMachine(this.serverAdminGroup.getMultiTierRememberMachine() || appChild != null);
                Element twoTierChild = XML14Util.getChildByName((Element)root, (String)"AdminTwoTier");
                if (twoTierChild != null) {
                    Element bodyElement;
                    Element emailElement;
                    this.serverAdminGroup.setMultiTierEmail(true);
                    Element codeLengthElement = XML14Util.getChildByName((Element)twoTierChild, (String)"CodeLength");
                    if (codeLengthElement != null) {
                        String codeLength = XML14Util.getTextContent((Node)codeLengthElement);
                        try {
                            this.serverAdminGroup.setTwoTierCodeLength(Integer.parseInt(codeLength));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            this.serverAdminGroup.setMultiTierEmail(false);
                        }
                    }
                    if ((emailElement = XML14Util.getChildByName((Element)twoTierChild, (String)"EmailAddress")) != null) {
                        this.serverAdmin.setEmail(XML14Util.getTextContent((Node)emailElement));
                    }
                    String subject = null;
                    String body = null;
                    Element subjectElement = XML14Util.getChildByName((Element)twoTierChild, (String)"EmailSubject");
                    if (subjectElement != null) {
                        subject = XML14Util.getTextContent((Node)subjectElement);
                    }
                    if ((bodyElement = XML14Util.getChildByName((Element)twoTierChild, (String)"EmailBody")) != null) {
                        body = new String(HexData.hexStringToByteArray((String)XML14Util.getTextContent((Node)bodyElement)), StandardCharsets.UTF_8);
                    }
                    this.serverAdminGroup.setTwoTierEmail(subject, body);
                    Element rememberElement = XML14Util.getChildByName((Element)twoTierChild, (String)"RememberMachine");
                    this.serverAdminGroup.setMultiTierRememberMachine(this.serverAdminGroup.getMultiTierRememberMachine() || rememberElement != null);
                } else {
                    this.serverAdminGroup.setMultiTierEmail(false);
                }
                try {
                    this.groups.clear();
                    ArrayList allGroups = XML14Util.getChildrenByName((Element)root, (String)"TechnicianGroup");
                    for (Object groupElement : allGroups) {
                        Element filter;
                        Element filter2;
                        int k;
                        Object ldapChild;
                        String appProfileId;
                        Element appProfileIdElement;
                        String machineFiltersAttribute = groupElement.getAttribute("machineFilters");
                        String name = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)groupElement, (String)"Name"));
                        int id = -1;
                        try {
                            id = Integer.parseInt(XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)groupElement, (String)"ID")));
                        }
                        catch (Throwable t) {
                            id = -1;
                        }
                        TechGroup group = new TechGroup(id, name);
                        LazyHashPassword password = ServerConfig.getHashedPassword((Element)groupElement, "Password");
                        if (password != null && !password.isNull()) {
                            group.setPassword(true);
                            group.setPassword(password);
                        }
                        if (Switches.SH_appProfiles && (appProfileIdElement = XML14Util.getChildByName((Element)groupElement, (String)"AssociatedAppProfileID")) != null && (appProfileId = XML14Util.getTextContent((Node)appProfileIdElement)) != null) {
                            group.setAssociatedAppProfileID(appProfileId);
                        }
                        group.setHostname(XML14Util.getChildText((Element)groupElement, (String)"GroupHostname", null));
                        group.setDefaultSGServiceName(XML14Util.getChildText((Element)groupElement, (String)"DefaultSimpleGatewayName", null));
                        group.setDefaultVideoPassword(XML14Util.getChildText((Element)groupElement, (String)"DefaultRecordingPassword", null));
                        group.setRequestAccessTimeout(ServerConfig.getElementContentsAsLong((Element)groupElement, "RequestAccessTimeoutMS", 0L));
                        group.setInactivityTimeout(ServerConfig.getElementContentsAsLong((Element)groupElement, "InactivityTimeoutMS", 0L));
                        group.setAllowAnonymousLogins(ServerConfig.getElementContentsAsBoolean((Element)groupElement, "AnonymousLogins", true));
                        group.getPermissions().setCanInstallPersistentConnection(ServerConfig.getElementContentsAsBoolean((Element)groupElement, "InstallServices", true));
                        group.getPermissions().setCanManagePersistentConnections(ServerConfig.getElementContentsAsBoolean((Element)groupElement, "ManageServices", true));
                        group.getPermissions().setCanRemoteSupport(ServerConfig.getElementContentsAsBoolean((Element)groupElement, "RemoteSupport", true));
                        group.getPermissions().setCanRemoteAccess(ServerConfig.getElementContentsAsBoolean((Element)groupElement, "RemoteAccess", true));
                        Element techGroupPermissionsChild = XML14Util.getChildByName((Element)groupElement, (String)"TechGroupPermissions");
                        if (techGroupPermissionsChild != null) {
                            TechGroupPermissions.parseXML(group.getPermissions(), techGroupPermissionsChild);
                        }
                        group.setMaxShGroupConcurrency(ServerConfig.getElementContentsAsInteger((Element)groupElement, "MaxShSessionsGroup", -1));
                        group.setMaxShUserConcurrency(ServerConfig.getElementContentsAsInteger((Element)groupElement, "MaxShSessionsUser", -1));
                        group.setMaxSgGroupConcurrency(ServerConfig.getElementContentsAsInteger((Element)groupElement, "MaxSgSessionsGroup", -1));
                        group.setMaxSgUserConcurrency(ServerConfig.getElementContentsAsInteger((Element)groupElement, "MaxSgSessionsUser", -1));
                        group.setMaxFileTransferSize(ServerConfig.getElementContentsAsLong((Element)groupElement, "MaxFileSize", -1L));
                        group.setFPSDelay(ServerConfig.getElementContentsAsInteger((Element)groupElement, "FPSDelay", -1));
                        group.setFPSLimited(group.getFPSDelay() != -1L);
                        group.setSessionLimitKbps(ServerConfig.getElementContentsAsInteger((Element)groupElement, "SessionSpeedLimit", -1));
                        group.setSessionLimited(group.getSessionLimitKbps() != -1);
                        group.setRadius(XML14Util.getChildByName((Element)groupElement, (String)"RADIUS") != null);
                        group.setMultiTierApp(XML14Util.getChildByName((Element)groupElement, (String)"AppAuthentication") != null);
                        group.setMultiTierRememberMachine(XML14Util.getChildByName((Element)groupElement, (String)"MultiTierRememberMachine") != null);
                        Element twoTierChild2 = XML14Util.getChildByName((Element)groupElement, (String)"TwoTier");
                        if (twoTierChild2 != null) {
                            Element bodyElement;
                            group.setMultiTierEmail(true);
                            Element codeLengthElement = XML14Util.getChildByName((Element)twoTierChild2, (String)"CodeLength");
                            if (codeLengthElement != null) {
                                String codeLength = XML14Util.getTextContent((Node)codeLengthElement);
                                try {
                                    group.setTwoTierCodeLength(Integer.parseInt(codeLength));
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    group.setMultiTierEmail(false);
                                }
                            }
                            String emailBody = null;
                            String emailSubject = null;
                            Element subjectElement = XML14Util.getChildByName((Element)twoTierChild2, (String)"EmailSubject");
                            if (subjectElement != null) {
                                emailSubject = XML14Util.getTextContent((Node)subjectElement);
                            }
                            if ((bodyElement = XML14Util.getChildByName((Element)twoTierChild2, (String)"EmailBody")) != null) {
                                emailBody = new String(HexData.hexStringToByteArray((String)XML14Util.getTextContent((Node)bodyElement)), StandardCharsets.UTF_8);
                            }
                            group.setTwoTierEmail(emailSubject, emailBody);
                        }
                        if ((ldapChild = XML14Util.getChildByName((Element)groupElement, (String)"LDAP")) != null) {
                            LDAPProperties ldapProperties = new LDAPProperties();
                            group.setLDAP(true);
                            ldapProperties.filter = XML14Util.getChildText((Element)ldapChild, (String)"SearchFilter", null);
                            ldapProperties.baseDN = XML14Util.getChildText((Element)ldapChild, (String)"BaseDN", null);
                            Element groups = XML14Util.getChildByName((Element)ldapChild, (String)"Groups");
                            if (groups == null) {
                                ldapProperties.groups = null;
                            } else {
                                ArrayList groupList = XML14Util.getChildrenByName((Element)groups, (String)"Group");
                                ldapProperties.groups = new String[groupList.size()];
                                for (int i3 = 0; i3 < groupList.size(); ++i3) {
                                    Element e = (Element)groupList.get(i3);
                                    ldapProperties.groups[i3] = XML14Util.getTextContent((Node)e);
                                }
                            }
                            if (XML14Util.getChildByName((Element)ldapChild, (String)"Advanced") != null) {
                                ldapProperties.setAdvanced();
                            } else if (ldapProperties.filter == null || ldapProperties.filter.length() == 0) {
                                ldapProperties.setSimple();
                            } else {
                                ldapProperties.setAdvanced();
                            }
                            group.setLdapProperties(ldapProperties);
                        }
                        group.setFilterByAllowedGroups(ServerConfig.getElementContentsAsBoolean((Element)groupElement, "FilterByMachineGroup", false));
                        Element allowedGroupsChild = XML14Util.getChildByName((Element)groupElement, (String)"AllowedMachineGroups");
                        if (allowedGroupsChild != null) {
                            ArrayList allowedGroupChildren = XML14Util.getChildrenByName((Element)allowedGroupsChild, (String)"AllowedMachineGroup");
                            ArrayList<ArrayList<String>> allowedGroups = new ArrayList<ArrayList<String>>();
                            for (Element allowedGroupChild : allowedGroupChildren) {
                                ArrayList<String> groupPath = new ArrayList<String>();
                                ArrayList allowedGroupPaths = XML14Util.getChildrenByName((Element)allowedGroupChild, (String)"Path");
                                for (Element allowedPath : allowedGroupPaths) {
                                    groupPath.add(XML14Util.getTextContent((Node)allowedPath));
                                }
                                allowedGroups.add(groupPath);
                            }
                            group.setRemoteAccessGroupRestrictions(allowedGroups);
                        }
                        String[] deprecated_shows = null;
                        String[] deprecated_hides = null;
                        String[] deprecated_machineShows = null;
                        String[] deprecated_machineHides = null;
                        ArrayList filters = XML14Util.getChildrenByName((Element)groupElement, (String)"ShowMatching");
                        deprecated_shows = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = (Element)filters.get(k);
                            deprecated_shows[k] = XML14Util.getTextContent((Node)filter2).trim();
                        }
                        filters = XML14Util.getChildrenByName((Element)groupElement, (String)"HideMatching");
                        deprecated_hides = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = (Element)filters.get(k);
                            deprecated_hides[k] = XML14Util.getTextContent((Node)filter2).trim();
                        }
                        filters = XML14Util.getChildrenByName((Element)groupElement, (String)"ShowMatchingMachines");
                        deprecated_machineShows = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = (Element)filters.get(k);
                            deprecated_machineShows[k] = XML14Util.getTextContent((Node)filter2).trim();
                        }
                        filters = XML14Util.getChildrenByName((Element)groupElement, (String)"HideMatchingMachines");
                        deprecated_machineHides = new String[filters.size()];
                        for (k = 0; k < filters.size(); ++k) {
                            filter2 = (Element)filters.get(k);
                            deprecated_machineHides[k] = XML14Util.getTextContent((Node)filter2).trim();
                        }
                        if (deprecated_shows.length == 0 && deprecated_hides.length == 0) {
                            filters = XML14Util.getChildrenByName((Element)groupElement, (String)"CustomerFilter");
                            CustomerFilter[] customerFilters = new CustomerFilter[filters.size()];
                            for (int k2 = 0; k2 < filters.size(); ++k2) {
                                filter = (Element)filters.get(k2);
                                CustomerFilter customerFilter = new CustomerFilter();
                                customerFilter.loadFromXML(filter);
                                customerFilters[k2] = customerFilter;
                            }
                            group.setCustomerFilters(customerFilters);
                        } else {
                            group.setCustomerFilters(ServerConfig.migrateDeprecatedCustomerFilters(deprecated_shows, deprecated_hides));
                        }
                        if (deprecated_machineShows.length == 0 && deprecated_machineHides.length == 0) {
                            filters = XML14Util.getChildrenByName((Element)groupElement, (String)"MachineFilter");
                            Filter[] machineFilters = new MachineFilter[filters.size()];
                            for (int k3 = 0; k3 < filters.size(); ++k3) {
                                filter = (Element)filters.get(k3);
                                MachineFilter machineFilter = new MachineFilter();
                                machineFilter.loadFromXML(filter);
                                machineFilters[k3] = machineFilter;
                            }
                            SimpleMachineFilter simpleMachineFilter = null;
                            filter = XML14Util.getChildByName((Element)groupElement, (String)"SimpleMachineFilter");
                            if (filter != null) {
                                simpleMachineFilter = new SimpleMachineFilter();
                                simpleMachineFilter.loadFromXML(filter);
                            }
                            int filterType = 0;
                            if (machineFiltersAttribute != null && machineFiltersAttribute.length() > 0) {
                                if (machineFiltersAttribute.equals("advanced")) {
                                    filterType = 2;
                                } else if (machineFiltersAttribute.equals("simple")) {
                                    filterType = 1;
                                }
                            } else if (machineFilters.length > 0) {
                                filterType = 2;
                            }
                            CombinedMachineFilter combinedMachineFilter = group.getMachineFilters();
                            combinedMachineFilter.setAdvancedFilters(machineFilters);
                            combinedMachineFilter.setSimpleMachineFilter(simpleMachineFilter);
                            combinedMachineFilter.setType(filterType);
                        } else {
                            CombinedMachineFilter combinedMachineFilter = group.getMachineFilters();
                            combinedMachineFilter.setAdvancedFilters(ServerConfig.migrateDeprecatedMachineFilters(deprecated_machineShows, deprecated_machineHides));
                            combinedMachineFilter.setType(2);
                        }
                        this.groups.add(group);
                    }
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <TechnicianGroup> entries");
                    e.printStackTrace();
                }
                try {
                    users = XML14Util.getChildrenByName((Element)root, (String)"Technician");
                    ServerConfig.loadTechnicianXML(users, false, this.technicians, this.groups);
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <Technician> entries");
                }
                try {
                    users = XML14Util.getChildrenByName((Element)root, (String)"AnonTechnician");
                    ServerConfig.loadTechnicianXML(users, true, this.anonymousTechnicians, this.groups);
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <AnonTechnician> entries");
                }
                this.deprecated_anonymousUserIDToTOTPKey.clear();
                Element allKeys = XML14Util.getChild((Element)root, (String)"AnonymousTOTPKeys");
                if (allKeys != null) {
                    ArrayList allEntries = XML14Util.getChildren((Element)allKeys, (String)"KeyEntry");
                    for (Element child4 : allEntries) {
                        String user = XML14Util.getChildText((Element)child4, (String)"User", null);
                        String keyEncrypted = XML14Util.getChildText((Element)child4, (String)"TOTPKey", null);
                        if (user == null || keyEncrypted == null) {
                            System.out.println("[ServerConfig] Expected an anonymous TOTP key, but a field was empty (user: " + user + ", key: " + keyEncrypted + ")");
                            continue;
                        }
                        this.deprecated_anonymousUserIDToTOTPKey.put(user, new LazyEncryptedPassword(keyEncrypted, false));
                    }
                }
                this.remoteCustomersTechPresence = false;
                this.remoteMachinesTechPresence = false;
                String error = "";
                try {
                    ArrayList pres = XML14Util.getChildrenByName((Element)root, (String)"TechnicianPresenceDialog");
                    if (pres.size() > 1) {
                        Debugger.error("[Server Config] Error reading <TechnicianPresenceDialog> entry - only one <TechnicianPresenceDialog> entry allowed");
                    } else if (pres.size() == 1) {
                        settings2 = (Element)pres.get(0);
                        ArrayList custChildren = XML14Util.getChildrenByName((Element)settings2, (String)"RemoteCustomers");
                        if (custChildren.size() > 1) {
                            Debugger.error("[Server Config] Error reading <RemoteCustomers> entry - only one <RemoteCustomers> entry allowed");
                        } else if (custChildren.size() == 1) {
                            error = " (invalid <RemoteCustomers> tag)";
                            String rcust = XML14Util.getTextContent((Node)((Node)custChildren.get(0)));
                            this.remoteCustomersTechPresence = rcust.equalsIgnoreCase("on");
                        }
                        ArrayList techChildren = XML14Util.getChildrenByName((Element)settings2, (String)"RemoteMachines");
                        if (techChildren.size() > 1) {
                            Debugger.error("[Server Config] Error reading <RemoteMachines> entry - only one <RemoteMachines> entry allowed");
                        } else if (techChildren.size() == 1) {
                            error = " (invalid <RemoteMachines> tag)";
                            String rmach = XML14Util.getTextContent((Node)((Node)techChildren.get(0)));
                            this.remoteMachinesTechPresence = rmach.equalsIgnoreCase("on");
                        }
                    }
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <TechnicianPresenceDialog> entry" + error);
                }
                error = "";
                try {
                    ArrayList email2 = XML14Util.getChildrenByName((Element)root, (String)"EmailSettings");
                    if (email2.size() > 1) {
                        Debugger.error("[Server Config] Error reading <EmailSettings> entry - only one <EmailSettings> entry allowed");
                        break block304;
                    }
                    if (email2.size() != 1) break block304;
                    this.emailSettingsEnabled = true;
                    settings2 = (Element)email2.get(0);
                    try {
                        this.dateFormat = XML14Util.getTextContent((Node)((Node)XML14Util.getChildrenByName((Element)settings2, (String)"DateFormat").get(0)));
                        try {
                            String example = MasterLog.setDateFormat(this.dateFormat);
                            if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                                System.out.println("[Server Config] Email log date format: (sample) " + example);
                            }
                        }
                        catch (Exception e) {
                            Debugger.error("[Server Config] Email log date format invalid: " + this.dateFormat + " (" + e.getMessage() + ")");
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    error = " (invalid or missing <SmtpHost> tag)";
                    this.smtpHost = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpHost"));
                    error = " (invalid or missing <SmtpPort> tag)";
                    String porty = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpPort"));
                    this.smtpPort = Integer.parseInt(porty);
                    this.smtpUser = "";
                    this.smtpPassword = new LazyEncryptedPassword(null);
                    this.smtpAuthentication = false;
                    if (XML14Util.getChildByName((Element)settings2, (String)"SmtpUser") != null) {
                        this.smtpAuthentication = true;
                        error = " (invalid or missing <SmtpUser> tag)";
                        this.smtpUser = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpUser"));
                        error = " (invalid or missing <SmtpPass> tag)";
                        this.smtpPassword = this.getPlaintextOrEncryptedPassword(settings2, "SmtpPass");
                    }
                    error = " (invalid or missing <SmtpFromEmail> tag)";
                    this.smtpFromEmail = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpFromEmail"));
                    error = " (invalid or missing <SmtpFromName> tag)";
                    this.smtpFromName = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpFromName"));
                    error = " (invalid or missing <SmtpTLS> tag)";
                    this.smtpTLS = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpTLS")).equalsIgnoreCase("on");
                    error = " (invalid or missing <SmtpSSL> tag)";
                    this.smtpSSL = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpSSL")).equalsIgnoreCase("on");
                    this.smtpSendAsTechnicians = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)settings2, (String)"SmtpSendAsTechnicians")).equalsIgnoreCase("on");
                    this.emailProperties = new Properties();
                    ArrayList emailPropertiesList = XML14Util.getChildrenByName((Element)settings2, (String)"EmailProperty");
                    if (emailPropertiesList != null) {
                        for (Element element : emailPropertiesList) {
                            key = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)element, (String)"Key"));
                            String value = XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)element, (String)"Value"));
                            if (key == null || value == null) continue;
                            this.emailProperties.put(key, value);
                        }
                    }
                    error = "";
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Email Settings: " + this.smtpHost + ":" + this.smtpPort + " (" + (this.smtpAuthentication ? "authenticated" : "not authenticated") + ") (" + (this.smtpSSL ? "SSL" : "no SSL") + ") (" + (this.smtpTLS ? "TLS" : "no TLS") + ")");
                    }
                }
                catch (Exception e) {
                    Debugger.error("[Server Config] Error reading <EmailSettings> entry" + error);
                }
            }
            try {
                Templates.loadTemplates();
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading Email Templates " + e);
            }
            try {
                email = XML14Util.getChildrenByName((Element)root, (String)"TechnicianActivityLog");
                if (email.size() > 1) {
                    Debugger.error("[Server Config] Error reading <TechnicianActivityLog> entry - only one <TechnicianActivityLog> entry allowed");
                } else if (email.size() == 0) {
                    this.deprecated_logTechEmail = false;
                    this.deprecated_logTechEmailAddress = null;
                    this.deprecated_logFilePerTech = false;
                    this.deprecated_logTechToFile = false;
                    this.deprecated_logTechLogins = false;
                    this.deprecated_logTechLogouts = false;
                    this.deprecated_logTechJoins = false;
                    this.deprecated_logTechLeaves = false;
                    this.deprecated_logTechRemoteJoins = false;
                    this.deprecated_logTechRemoteLeaves = false;
                } else if (email.size() == 1) {
                    settings = (Element)email.get(0);
                    child2 = XML14Util.getChildByName((Element)settings, (String)"LogToFile");
                    this.deprecated_logTechToFile = child2 != null && XML14Util.getTextContent((Node)child2).equalsIgnoreCase("on");
                    child2 = XML14Util.getChildByName((Element)settings, (String)"LogToFilePerTechnician");
                    this.deprecated_logFilePerTech = child2 != null && XML14Util.getTextContent((Node)child2).equalsIgnoreCase("on");
                    child2 = XML14Util.getChildByName((Element)settings, (String)"LogToEmail");
                    if (child2 != null) {
                        this.deprecated_logTechEmail = true;
                        this.deprecated_logTechEmailAddress = XML14Util.getTextContent((Node)child2);
                    } else {
                        this.deprecated_logTechEmail = false;
                        this.deprecated_logTechEmailAddress = "";
                    }
                    child2 = XML14Util.getChildByName((Element)settings, (String)"WhatToLog");
                    if (child2 != null) {
                        childchild = XML14Util.getChildByName((Element)child2, (String)"Logins");
                        this.deprecated_logTechLogins = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"Logouts");
                        this.deprecated_logTechLogouts = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"JoinCustomer");
                        this.deprecated_logTechJoins = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"LeaveCustomer");
                        this.deprecated_logTechLeaves = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"JoinRemote");
                        this.deprecated_logTechRemoteJoins = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"LeaveRemote");
                        this.deprecated_logTechRemoteLeaves = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                    } else {
                        this.deprecated_logTechLogins = true;
                        this.deprecated_logTechLogouts = true;
                        this.deprecated_logTechJoins = true;
                        this.deprecated_logTechLeaves = true;
                        this.deprecated_logTechRemoteJoins = true;
                        this.deprecated_logTechRemoteLeaves = true;
                    }
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <TechnicianActivityLog> entry");
            }
            try {
                email = XML14Util.getChildrenByName((Element)root, (String)"CustomerActivityLog");
                if (email.size() > 1) {
                    Debugger.error("[Server Config] Error reading <CustomerActivityLog> entry - only one <CustomerActivityLog> entry allowed");
                } else if (email.size() == 0) {
                    this.deprecated_logCustEmail = false;
                    this.deprecated_logCustEmailAddress = null;
                    this.deprecated_logFilePerCust = false;
                    this.deprecated_logCustToFile = false;
                    this.deprecated_logCustJoinQueue = false;
                    this.deprecated_logCustLeaveQueue = false;
                    this.deprecated_logCustJoins = false;
                    this.deprecated_logCustLeaves = false;
                } else if (email.size() == 1) {
                    settings = (Element)email.get(0);
                    child2 = XML14Util.getChildByName((Element)settings, (String)"LogToFile");
                    this.deprecated_logCustToFile = child2 != null && XML14Util.getTextContent((Node)child2).equalsIgnoreCase("on");
                    child2 = XML14Util.getChildByName((Element)settings, (String)"LogToFilePerTechnician");
                    this.deprecated_logFilePerCust = child2 != null && XML14Util.getTextContent((Node)child2).equalsIgnoreCase("on");
                    child2 = XML14Util.getChildByName((Element)settings, (String)"LogToEmail");
                    if (child2 != null) {
                        this.deprecated_logCustEmail = true;
                        this.deprecated_logCustEmailAddress = XML14Util.getTextContent((Node)child2);
                    } else {
                        this.deprecated_logCustEmail = false;
                    }
                    child2 = XML14Util.getChildByName((Element)settings, (String)"WhatToLog");
                    if (child2 != null) {
                        childchild = XML14Util.getChildByName((Element)child2, (String)"JoinQueue");
                        this.deprecated_logCustJoinQueue = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"LeaveQueue");
                        this.deprecated_logCustLeaveQueue = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"JoinTechnician");
                        this.deprecated_logCustJoins = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                        childchild = XML14Util.getChildByName((Element)child2, (String)"LeaveTechnician");
                        this.deprecated_logCustLeaves = childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on");
                    } else {
                        this.deprecated_logCustJoinQueue = false;
                        this.deprecated_logCustLeaveQueue = false;
                        this.deprecated_logCustJoins = false;
                        this.deprecated_logCustLeaves = false;
                    }
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <CustomerActivityLog> entry");
            }
            try {
                ArrayList status = XML14Util.getChildrenByName((Element)root, (String)"StatusPage");
                if (status.size() > 1) {
                    Debugger.error("[Server Config] Error reading <StatusPage> entry - only one <StatusPage> entry allowed");
                } else if (status.size() == 1) {
                    settings = (Element)status.get(0);
                    this.statusPage = true;
                    this.statusPageIncludeMachines = ServerConfig.getElementContentsAsBoolean(settings, "IncludeMachines", true);
                    this.statusPageIncludeSessions = ServerConfig.getElementContentsAsBoolean(settings, "IncludeSessions", false);
                    this.statusPageIncludePerformance = ServerConfig.getElementContentsAsBoolean(settings, "IncludePerformance", false);
                    ArrayList restrictions = XML14Util.getChildrenByName((Element)settings, (String)"StatusPageRestriction");
                    this.statusPageRestrictions = new PatternWrapper[restrictions.size()];
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < restrictions.size(); ++k) {
                        Element restrict = (Element)restrictions.get(k);
                        try {
                            this.statusPageRestrictions[k] = new PatternWrapper(XML14Util.getTextContent((Node)restrict).trim(), false);
                            sb.append("\t(Allowed Network) ").append(XML14Util.getTextContent((Node)restrict).trim()).append("\n");
                            continue;
                        }
                        catch (Exception e) {
                            throw new ServerStartFailureException("Invalid StatusPageRestriction: " + XML14Util.getTextContent((Node)restrict), e);
                        }
                    }
                    if (this.statusPageRestrictions.length == 0) {
                        this.statusPageRestrictions = null;
                    } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Status Page Restrictions:\n" + sb);
                    }
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <StatusPage> entry");
            }
            Element radiusSettings = XML14Util.getChild((Element)root, (String)"RadiusSettings");
            try {
                if (radiusSettings == null) {
                    this.radiusAttempts = 3;
                    this.radiusTimeout = 10000L;
                    this.radiusStrategy = 1;
                } else {
                    this.radiusAttempts = Integer.parseInt(XML14Util.getChildText((Element)radiusSettings, (String)"Attempts", (String)"3"));
                    this.radiusTimeout = Integer.parseInt(XML14Util.getChildText((Element)radiusSettings, (String)"TimeoutMS", (String)"10000"));
                    this.radiusStrategy = Integer.parseInt(XML14Util.getChildText((Element)radiusSettings, (String)"Strategy", (String)Integer.toString(1)));
                    this.radiusStaggeredTimeout = Integer.parseInt(XML14Util.getChildText((Element)radiusSettings, (String)"StaggeredTimeoutMS", (String)Integer.toString(2000)));
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <RadiusAuthentication> entry");
            }
            try {
                this.radiusEnable = false;
                ArrayList radius = XML14Util.getChildrenByName((Element)root, (String)"RadiusAuthentication");
                ArrayList<RadiusConfig> result = new ArrayList<RadiusConfig>();
                for (Element radiusParent : radius) {
                    this.radiusEnable = true;
                    RadiusConfig config = new RadiusConfig();
                    try {
                        config.index = Integer.parseInt(radiusParent.getAttribute("id"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    config.radiusHostname = XML14Util.getChildText((Element)radiusParent, (String)"RadiusHostname", null);
                    config.radiusAuthProtocol = XML14Util.getChildText((Element)radiusParent, (String)"RadiusAuthenticationProtocol", null);
                    try {
                        config.radiusPort = Integer.parseInt(XML14Util.getChildText((Element)radiusParent, (String)"RadiusPort", null));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    config.radiusSecret = XML14Util.getChildText((Element)radiusParent, (String)"RadiusSecret", null);
                    result.add(config);
                }
                this.radiusConfigs = result.toArray(new RadiusConfig[0]);
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <RadiusAuthentication> entry");
            }
            try {
                ArrayList ldap = XML14Util.getChildrenByName((Element)root, (String)"LDAPAuthentication");
                if (ldap.size() > 1) {
                    Debugger.error("[Server Config] Error reading <LDAPAuthentication> entry - only one <LDAPAuthentication> entry allowed");
                    break block306;
                }
                if (ldap.size() != 1) break block306;
                settings = (Element)ldap.get(0);
                this.ldapEnable = true;
                ArrayList hostname = XML14Util.getChildrenByName((Element)settings, (String)"LDAPHostname");
                ArrayList port = XML14Util.getChildrenByName((Element)settings, (String)"LDAPPort");
                ArrayList authenticationMechanism = XML14Util.getChildrenByName((Element)settings, (String)"AuthenticationMechanism");
                ArrayList useSSL = XML14Util.getChildrenByName((Element)settings, (String)"UseSSL");
                ArrayList trustStore = XML14Util.getChildrenByName((Element)settings, (String)"TrustKeyStore");
                this.ldapIsAD = XML14Util.getChildByName((Element)settings, (String)"IsAD") != null;
                this.ldapUserClass = XML14Util.getChildText((Element)settings, (String)"UserClass", null);
                this.ldapGroupClass = XML14Util.getChildText((Element)settings, (String)"GroupClass", null);
                this.ldapLoginAttribute = XML14Util.getChildText((Element)settings, (String)"LoginAttribute", null);
                this.ldapMemberAttribute = XML14Util.getChildText((Element)settings, (String)"MemberAttribute", null);
                this.ldapFollowLinks = ServerConfig.getElementContentsAsBoolean(settings, "FollowReferrals", true);
                key = this.LOCK;
                synchronized (key) {
                    this.ldapMappings.clear();
                    Element ldapMappingsParent = XML14Util.getChildByName((Element)settings, (String)"LDAPAttributeMappings");
                    if (ldapMappingsParent != null) {
                        ArrayList ldapMappingChildren = XML14Util.getChildrenByName((Element)ldapMappingsParent, (String)"LDAPMapping");
                        for (Element element : ldapMappingChildren) {
                            String shProperty = element.getAttribute("techProperty");
                            ArrayList<String> mappings = new ArrayList<String>();
                            ArrayList ldapAttributes = XML14Util.getChildrenByName((Element)element, (String)"LDAPAttribute");
                            for (Element ldapAttribute : ldapAttributes) {
                                mappings.add(XML14Util.getTextContent((Node)ldapAttribute));
                            }
                            this.ldapMappings.add(new LDAPAuthenticator.LDAPAttributeMapping(shProperty, mappings.toArray(new String[0])));
                        }
                    }
                }
                Element childchild2 = XML14Util.getChildByName((Element)settings, (String)"LDAPUsername");
                if (childchild2 != null) {
                    this.ldapUsername = XML14Util.getTextContent((Node)childchild2);
                }
                this.ldapPassword = this.getPlaintextOrEncryptedPassword(settings, "LDAPPassword");
                if (hostname.size() == 0) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: <LDAPHostname> cannot be empty");
                } else if (hostname.size() > 1) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: only one <LDAPHostname> entry allowed");
                } else {
                    this.ldapHostname = XML14Util.getTextContent((Node)((Node)hostname.get(0)));
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] LDAP Authentication Server = " + this.ldapHostname);
                    }
                }
                if (port.size() == 0) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: <LDAPPort> cannot be empty");
                } else if (port.size() > 1) {
                    Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: only one <LDAPPort> entry allowed");
                } else {
                    String portString = XML14Util.getTextContent((Node)((Node)port.get(0)));
                    try {
                        this.ldapPort = Integer.parseInt(portString);
                    }
                    catch (Throwable t) {
                        Debugger.error("[Server Config] Invalid <LDAPAuthentication> entry: <LDAPPort> must be a valid integer");
                    }
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] LDAP Authentication Port = " + this.ldapPort);
                    }
                }
                if (authenticationMechanism.size() > 0) {
                    this.ldapAuthentication = XML14Util.getTextContent((Node)((Node)authenticationMechanism.get(0)));
                    if (this.ldapAuthentication != null) {
                        this.ldapAuthentication = this.ldapAuthentication.trim();
                    }
                }
                if (useSSL.size() > 0) {
                    this.ldapEnableSSL = true;
                }
                if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                    System.out.println("[Server Config] LDAP Server Configured: " + (this.ldapAuthentication != null ? "'" + this.ldapAuthentication + "' " : "") + "LDAP Authentication on " + this.ldapHostname + ":" + this.ldapPort + (this.ldapEnableSSL ? " using SSL" : ""));
                }
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Error reading <LDAPAuthentication> entry");
            }
        }
        ArrayList children = XML14Util.getChildrenByName((Element)root, (String)"IP");
        Object[] oldIPs = new String[children.size()];
        for (i2 = 0; i2 < children.size(); ++i2) {
            child4 = (Element)children.get(i2);
            oldIPs[i2] = XML14Util.getTextContent((Node)child4).trim();
        }
        if (oldIPs.length == 0) {
            oldIPs = null;
        }
        children = XML14Util.getChildrenByName((Element)root, (String)"IpPort");
        this.ipPortPairsList = new String[children.size()];
        for (i2 = 0; i2 < children.size(); ++i2) {
            child4 = (Element)children.get(i2);
            this.ipPortPairsList[i2] = XML14Util.getTextContent((Node)child4).trim();
        }
        if (this.ipPortPairsList.length == 0) {
            this.ipPortPairsList = null;
        }
        if ((children = XML14Util.getChildrenByName((Element)root, (String)"SshdPort")).size() > 0) {
            Element child5 = (Element)children.get(0);
            try {
                this.sshdPort = Integer.parseInt(XML14Util.getTextContent((Node)child5).trim());
            }
            catch (Exception x) {
                Debugger.error("[Server Config] Invalid Server SSHD port: " + XML14Util.getTextContent((Node)child5));
            }
        }
        children = XML14Util.getChildrenByName((Element)root, (String)"Port");
        this.portList = new int[children.size()];
        for (int i4 = 0; i4 < children.size(); ++i4) {
            child4 = (Element)children.get(i4);
            try {
                if (XML14Util.getTextContent((Node)child4).trim().equalsIgnoreCase("Auto")) {
                    this.portList = null;
                    break;
                }
                this.portList[i4] = Integer.parseInt(XML14Util.getTextContent((Node)child4).trim());
                continue;
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Invalid Server port: " + XML14Util.getTextContent((Node)child4));
            }
        }
        if (oldIPs != null) {
            ArrayList<String> list = new ArrayList<String>();
            Arrays.sort(oldIPs);
            Arrays.sort(this.portList);
            if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                System.out.println("[Server Config] Found tags, converting...");
            }
            for (Object oldIP : oldIPs) {
                for (Object aPortList : (ArrayList)this.portList) {
                    String ipPort = (String)oldIP + ":" + (int)aPortList;
                    list.add(ipPort);
                    if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                    System.out.println("[Server Config] \tConversion added " + ipPort);
                }
            }
            this.ipPortPairsList = new String[list.size()];
            list.toArray(this.ipPortPairsList);
            this.ipList = null;
        }
        this.recreateIpAndPortLists();
        if (this.ipList == null) {
            if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                System.out.println("[Server Config] No specific IP:Port combinations used, will bind to all IPs");
            }
        } else {
            for (int i5 = 0; i5 < this.ipList.length; ++i5) {
                if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                System.out.println("[Server Config] IP Used " + (1 + i5) + "/" + this.ipList.length + " = " + this.ipList[i5]);
            }
        }
        if (this.portList != null) {
            for (int i6 = 0; i6 < this.portList.length; ++i6) {
                if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                System.out.println("[Server Config] Port Used " + (1 + i6) + "/" + this.portList.length + " = " + this.portList[i6]);
            }
        }
        try {
            ArrayList sessionSummaryChildren = XML14Util.getChildrenByName((Element)root, (String)"SessionSummary");
            if (sessionSummaryChildren.size() > 1) {
                Debugger.error("[Server Config] Error reading <SessionSummary> entry - only one <SessionSummary> entry allowed");
            } else if (sessionSummaryChildren.size() == 1) {
                ArrayList emailList;
                boolean deprecated_sessionSummaryCustomer;
                boolean deprecated_sessionSummaryChat;
                Element settings = (Element)sessionSummaryChildren.get(0);
                boolean deprecated_sessionSummaryEnabled = true;
                Element childchild = XML14Util.getChildByName((Element)settings, (String)"IncludeTechComments");
                if (childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on")) {
                    this.sessionSummaryTechComment = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Technician Comments Enabled");
                    }
                } else {
                    this.sessionSummaryTechComment = false;
                }
                if ((childchild = XML14Util.getChildByName((Element)settings, (String)"SkipAllowed")) != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on")) {
                    this.sessionSummaryAllowSkip = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Session Summary Skip Allowed");
                    }
                } else {
                    this.sessionSummaryAllowSkip = false;
                }
                if ((childchild = XML14Util.getChildByName((Element)settings, (String)"IncludeChat")) != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on")) {
                    deprecated_sessionSummaryChat = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Session Chat Summary Enabled");
                    }
                } else {
                    deprecated_sessionSummaryChat = false;
                }
                if ((childchild = XML14Util.getChildByName((Element)settings, (String)"IncludeCustomerDetails")) != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on")) {
                    deprecated_sessionSummaryCustomer = true;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[Server Config] Session Customer Details Summary Enabled");
                    }
                } else {
                    deprecated_sessionSummaryCustomer = false;
                }
                if ((emailList = XML14Util.getChildrenByName((Element)settings, (String)"EmailSummary")).size() > 0) {
                    boolean deprecated_sessionSummaryEmailTech;
                    boolean deprecated_sessionSummaryArbEmail;
                    Element email = (Element)emailList.get(0);
                    boolean deprecated_sessionSummaryEmailEnabled = true;
                    childchild = XML14Util.getChildByName((Element)email, (String)"Email");
                    if (childchild != null) {
                        deprecated_sessionSummaryArbEmail = true;
                        String deprecated_sessionSummaryArbEmailAddress = XML14Util.getTextContent((Node)childchild);
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Session Summary Email Enabled: '" + deprecated_sessionSummaryArbEmailAddress + "'");
                        }
                    } else {
                        deprecated_sessionSummaryArbEmail = false;
                    }
                    childchild = XML14Util.getChildByName((Element)email, (String)"TechnicianEmail");
                    if (childchild != null && XML14Util.getTextContent((Node)childchild).equalsIgnoreCase("on")) {
                        deprecated_sessionSummaryEmailTech = true;
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Session Technician Email Enabled.");
                        }
                    } else {
                        deprecated_sessionSummaryEmailTech = false;
                    }
                    if ((childchild = XML14Util.getChildByName((Element)email, (String)"CustomerEmailDetail")) != null) {
                        this.sessionSummaryCustEmail = true;
                        this.sessionSummaryEmailCustDetail = XML14Util.getTextContent((Node)childchild);
                        if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                            System.out.println("[Server Config] Session Customer Email Enabled: Detail '" + this.sessionSummaryEmailCustDetail + "'");
                        }
                    } else {
                        this.sessionSummaryCustEmail = false;
                    }
                } else {
                    boolean bl = false;
                }
            } else {
                boolean deprecated_sessionSummaryEnabled = false;
            }
        }
        catch (Exception e) {
            Debugger.error("[Server Config] Invalid SessionSummary Entry");
        }
        this.endOfSessionOption = ServerConfig.getElementContentsAsString(root, "EndOfSessionOption");
        this.endOfSessionURL = ServerConfig.getElementContentsAsString(root, "EndOfSessionURL");
        this.endOfSessionURLSupport = ServerConfig.getElementContentsAsBoolean(root, "EndOfSessionURLSupport", true);
        this.endOfSessionURLAccess = ServerConfig.getElementContentsAsBoolean(root, "EndOfSessionURLAccess", true);
        this.elevateSupportSessions = ServerConfig.getElementContentsAsBoolean(root, "WindowsElevation", true);
        StringBuilder sb = new StringBuilder();
        ArrayList children2 = XML14Util.getChildrenByName((Element)root, (String)"APIRestriction");
        this.apiRestrictions = new PatternWrapper[children2.size()];
        for (i = 0; i < children2.size(); ++i) {
            Element child6 = (Element)children2.get(i);
            try {
                this.apiRestrictions[i] = new PatternWrapper(XML14Util.getTextContent((Node)child6).trim(), false);
                sb.append("\t(Allowed Network) ").append(XML14Util.getTextContent((Node)child6).trim()).append("\n");
                continue;
            }
            catch (Exception e) {
                throw new ServerStartFailureException("Invalid APIRestriction: " + XML14Util.getTextContent((Node)child6), e);
            }
        }
        if (this.apiRestrictions.length == 0) {
            this.apiRestrictions = null;
        } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
            System.out.println("[Server Config] API Network Restrictions:\n" + sb);
        }
        sb = new StringBuilder();
        children2 = XML14Util.getChildrenByName((Element)root, (String)"TechRestriction");
        this.techRestrictions = new PatternWrapper[children2.size()];
        for (i = 0; i < children2.size(); ++i) {
            Element child7 = (Element)children2.get(i);
            try {
                this.techRestrictions[i] = new PatternWrapper(XML14Util.getTextContent((Node)child7).trim(), false);
                sb.append("\t(Allowed Network) ").append(XML14Util.getTextContent((Node)child7).trim()).append("\n");
                continue;
            }
            catch (Exception e) {
                throw new ServerStartFailureException("Invalid TechRestriction: " + XML14Util.getTextContent((Node)child7), e);
            }
        }
        if (this.techRestrictions.length == 0) {
            this.techRestrictions = null;
        } else if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
            System.out.println("[Server Config] Technician Client Network Restrictions:\n" + sb);
        }
        children = XML14Util.getChildrenByName((Element)root, (String)"LogInfo");
        if (children.size() > 0) {
            node = (Element)children.get(0);
            if (XML14Util.getTextContent((Node)node).trim().equalsIgnoreCase("on")) {
                this.logInfo = true;
            } else {
                if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                    System.out.println("[Server Config] INFO level logging disabled");
                }
                Debugger.PRINT_INFO = false;
                this.logInfo = false;
            }
        }
        if ((children = XML14Util.getChildrenByName((Element)root, (String)"CustomerAuthentication")).size() > 0) {
            node = (Element)children.get(0);
            if ((children = XML14Util.getChildrenByName((Element)node, (String)"CustomerPassword")).size() > 0) {
                Element passwordNode = (Element)children.get(0);
                String password = XML14Util.getTextContent((Node)passwordNode).trim();
                if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                    System.out.println("[Server Config] Customer authentication password enabled");
                }
                this.enabledQueuePassword = true;
                this.queuePassword = password;
            } else {
                this.enabledQueuePassword = false;
            }
        } else {
            this.enabledQueuePassword = false;
        }
        this.blockedRemoteAccessMachines = new ArrayList<BlockedRemoteMachine>();
        children = XML14Util.getChildrenByName((Element)root, (String)"BlockedRemoteMachine");
        if (children.size() > 0) {
            int count = 0;
            for (Element e : children) {
                ++count;
                BlockedRemoteMachine blockedMachine = new BlockedRemoteMachine();
                blockedMachine.machineID = ServerConfig.getElementContentsAsString(e, "ID");
                blockedMachine.name = MachineName.extractFromNameWithGroup(ServerConfig.getElementContentsAsString(e, "Name"));
                this.blockedRemoteAccessMachines.add(blockedMachine);
            }
            if (count > 0) {
                System.out.println("[ServerConfig] " + count + " machines are blocked.");
            }
        }
        if ((messengerRouteMapElement = XML14Util.getChildByName((Element)root, (String)"SecureMessengerRouteMapSize")) != null) {
            String textContent = XML14Util.getTextContent((Node)messengerRouteMapElement);
            try {
                this.secureMessengerRouteMapSize = Integer.parseInt(textContent);
            }
            catch (Throwable t) {
                System.out.println("[ServerConfig] Unable to parse SecureMessengerRouteMapSize from " + textContent);
            }
        }
        this.feature_showPerformanceMetricsTechConsole = XML14Util.childExists((Element)root, (String)"FeaturePerformanceMetrics");
        this.feature_multiLicense = XML14Util.childExists((Element)root, (String)"FeatureMultiLicense");
        this.defaultMaxAudioBitrate = ServerConfig.getElementContentsAsInteger(root, "MaxAudioBitrate", 0);
        this.defaultMachineTimeoutMS = ServerConfig.getElementContentsAsInteger(root, "MachineTimeoutMS", this.defaultMachineTimeoutMS);
        this.debugDelay = ServerConfig.getElementContentsAsLong(root, "DebugSimulateDelay", this.debugDelay);
        if (ServerManagement.isServerJVM() && this.debugDelay > 0L) {
            try {
                Thread.sleep(this.debugDelay);
                System.out.println("[ServerConfig] [DEBUG] Read delaying for " + this.debugDelay);
                new Exception("Sleeping...").printStackTrace();
            }
            catch (Throwable textContent) {
                // empty catch block
            }
        }
        this.totpLength = ServerConfig.getElementContentsAsInteger(root, "TOTPLength", 6);
        this.totpWindowSize = ServerConfig.getElementContentsAsInteger(root, "TOTPWindowSize", 10);
        this.forwardToHTTPS = ServerConfig.getElementContentsAsBoolean(root, "ForwardHTTPtoHTTPS", false);
        this.failoverCheckURL = XML14Util.getChildTextAllowEmptyStr((Element)root, (String)"FailOverCheckURL", null);
        this.condenserForURL = XML14Util.getChildText((Element)root, (String)"CentralServerURL", null);
        this.condenserToken = this.getPlaintextOrEncryptedPassword(root, "CentralServerToken");
        this.uPnPPortForwardingEnabled = ServerConfig.getElementContentsAsBoolean(root, "UPnPPortForwarding", false);
        Element loggingConfigParent = XML14Util.getChildByName((Element)root, (String)"LoggingConfiguration");
        if (loggingConfigParent != null) {
            ArrayList loggingChildren = XML14Util.getChildrenByName((Element)loggingConfigParent, (String)"LogMapping");
            ArrayList<LogMappingImpl> mappings = new ArrayList<LogMappingImpl>();
            for (Element child8 : loggingChildren) {
                try {
                    LogMappingImpl logMapping = LogMappingImpl.deprecated_loadFromXML(child8, (ResourceBundle)Language.DEFLANG);
                    mappings.add(logMapping);
                }
                catch (Throwable t) {
                    Debugger.error("[ServerConfig] Unable to load log mapping.");
                    t.printStackTrace();
                }
            }
            this.deprecated_logMappings = mappings.toArray(new LogMapping[0]);
        }
        if (this.feature_multiLicense) {
            this.migrateMultiLicense();
        }
    }

    private void migrateMultiLicense() {
        File licensesFolder = new File("configuration/licenses");
        if (licensesFolder.exists()) {
            return;
        }
        licensesFolder.mkdirs();
        try {
            FileUtil.copy((File)new File("configuration/shlicense.txt"), (File)new File(licensesFolder, "shlicense.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void loadTechnicianXML(ArrayList<Element> users, boolean isAnonymous, ArrayList<TechUser> technicians, ArrayList<TechGroup> allGroups) {
        technicians.clear();
        for (Element user : users) {
            try {
                Element filter;
                int k;
                String value;
                Element appProfilesElement;
                String value2;
                Element accountEnabledElement;
                String value3;
                int id;
                String machineFiltersAttribute = user.getAttribute("machineFilters");
                try {
                    id = Integer.parseInt(XML14Util.getTextContent((Node)XML14Util.getChildByName((Element)user, (String)"ID")));
                }
                catch (Throwable t) {
                    id = -1;
                }
                LazyEncryptedPassword login = ServerConfig.getPassword(user, "Login", null, "Loginv2");
                LazyEncryptedPassword email = ServerConfig.getPassword(user, "Email", null, "Emailv2");
                LazyEncryptedPassword name = ServerConfig.getPassword(user, "Name", null, "Namev2");
                LazyHashPassword hashedPassword = null;
                boolean allowLocalLogins = true;
                boolean accountEnabled = true;
                boolean appProfilesOnly = false;
                LazyEncryptedPassword totpKey = new LazyEncryptedPassword(null);
                try {
                    totpKey = ServerConfig.getPassword(user, null, "TOTPKey", "TOTPKeyv2");
                }
                catch (Throwable t) {
                    System.out.println("[ServerConfig] WARNING. Unable to decrypt TOTP secure key for user " + login);
                }
                Element allowLocalLogin = XML14Util.getChildByName((Element)user, (String)"AllowLocallyAuthenticatedLogin");
                if (allowLocalLogin != null && (value3 = XML14Util.getTextContent((Node)allowLocalLogin)) != null) {
                    if (value3.equalsIgnoreCase("on")) {
                        allowLocalLogins = true;
                    } else if (value3.equalsIgnoreCase("off")) {
                        allowLocalLogins = false;
                    }
                }
                if ((hashedPassword = ServerConfig.getHashedPassword(user, "Password")) == null || hashedPassword.isNull()) {
                    allowLocalLogins = false;
                    if (CentralDebugging.PX_VERBOSE_SERVER_CONFIG) {
                        System.out.println("[ServerConfig] Technician " + login + " has no password specific. Local logins have been disabled.");
                    }
                }
                if ((accountEnabledElement = XML14Util.getChildByName((Element)user, (String)"Enabled")) != null && (value2 = XML14Util.getTextContent((Node)accountEnabledElement)) != null) {
                    if (value2.equalsIgnoreCase("on")) {
                        accountEnabled = true;
                    } else if (value2.equalsIgnoreCase("off")) {
                        accountEnabled = false;
                    }
                }
                if (Switches.SH_appProfiles && (appProfilesElement = XML14Util.getChildByName((Element)user, (String)"AppProfilesOnly")) != null && (value = XML14Util.getTextContent((Node)appProfilesElement)) != null) {
                    if (value.equalsIgnoreCase("on")) {
                        appProfilesOnly = true;
                    } else if (value.equalsIgnoreCase("off")) {
                        appProfilesOnly = false;
                    }
                }
                if (login.isNull()) {
                    Debugger.error("[Server Config] Invalid <Technician> entry: <Login> cannot be empty");
                }
                if (name.isNull()) {
                    name = login;
                }
                TechUser techuser = new TechUser(id, name, login, hashedPassword, email, isAnonymous, allowLocalLogins, accountEnabled);
                techuser.setEnabledUntilTime(ServerConfig.getElementContentsAsLong(user, "EnabledUntilTime", 0L));
                if (!totpKey.isNull()) {
                    techuser.setTOTPKey(totpKey);
                }
                if (Switches.SH_appProfiles) {
                    techuser.setIsForAppProfilesOnly(appProfilesOnly);
                }
                ArrayList<TechGroup> tempList = new ArrayList<TechGroup>();
                ArrayList<TechGroup> groupAdminList = new ArrayList<TechGroup>();
                ArrayList groupList = XML14Util.getChildrenByName((Element)user, (String)"GroupMemberOf");
                for (Element filter2 : groupList) {
                    String groupName = XML14Util.getTextContent((Node)filter2).trim();
                    TechGroup group = null;
                    for (Object allGroup : allGroups) {
                        if (!((TechGroup)allGroup).getName().equals(groupName)) continue;
                        group = allGroup;
                        break;
                    }
                    if (group == null || tempList.contains(group)) continue;
                    tempList.add(group);
                }
                groupList = XML14Util.getChildrenByName((Element)user, (String)"GroupIDMemberOf");
                for (Element filter2 : groupList) {
                    String groupID = XML14Util.getTextContent((Node)filter2).trim();
                    try {
                        Object allGroup;
                        int intID = Integer.parseInt(groupID);
                        TechGroup group = null;
                        allGroup = allGroups.iterator();
                        while (allGroup.hasNext()) {
                            TechGroup allGroup2 = (TechGroup)allGroup.next();
                            if (allGroup2.getGroupID() != intID) continue;
                            group = allGroup2;
                            break;
                        }
                        if (group == null) continue;
                        String memberOverride = filter2.getAttribute("member");
                        String adminAttribute = filter2.getAttribute("admin");
                        if (!(memberOverride != null && memberOverride.equals("no") || tempList.contains(group))) {
                            tempList.add(group);
                        }
                        if (adminAttribute == null || !adminAttribute.equals("yes") || groupAdminList.contains(group)) continue;
                        groupAdminList.add(group);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                techuser.setGroups(tempList.toArray(new TechGroup[0]));
                techuser.setGroupsToAdmin(groupAdminList.toArray(new TechGroup[0]));
                String[] deprecated_shows = null;
                String[] deprecated_hides = null;
                String[] deprecated_machineShows = null;
                String[] deprecated_machineHides = null;
                ArrayList filters = XML14Util.getChildrenByName((Element)user, (String)"ShowMatching");
                deprecated_shows = new String[filters.size()];
                for (k = 0; k < filters.size(); ++k) {
                    Element filter3 = (Element)filters.get(k);
                    deprecated_shows[k] = XML14Util.getTextContent((Node)filter3).trim();
                }
                filters = XML14Util.getChildrenByName((Element)user, (String)"HideMatching");
                deprecated_hides = new String[filters.size()];
                for (k = 0; k < filters.size(); ++k) {
                    Element filter4 = (Element)filters.get(k);
                    deprecated_hides[k] = XML14Util.getTextContent((Node)filter4).trim();
                }
                filters = XML14Util.getChildrenByName((Element)user, (String)"ShowMatchingMachines");
                deprecated_machineShows = new String[filters.size()];
                for (k = 0; k < filters.size(); ++k) {
                    Element filter5 = (Element)filters.get(k);
                    deprecated_machineShows[k] = XML14Util.getTextContent((Node)filter5).trim();
                }
                filters = XML14Util.getChildrenByName((Element)user, (String)"HideMatchingMachines");
                deprecated_machineHides = new String[filters.size()];
                for (k = 0; k < filters.size(); ++k) {
                    Element filter6 = (Element)filters.get(k);
                    deprecated_machineHides[k] = XML14Util.getTextContent((Node)filter6).trim();
                }
                if (deprecated_shows.length == 0 && deprecated_hides.length == 0) {
                    filters = XML14Util.getChildrenByName((Element)user, (String)"CustomerFilter");
                    CustomerFilter[] customerFilters = new CustomerFilter[filters.size()];
                    for (int k2 = 0; k2 < filters.size(); ++k2) {
                        filter = (Element)filters.get(k2);
                        CustomerFilter customerFilter = new CustomerFilter();
                        customerFilter.loadFromXML(filter);
                        customerFilters[k2] = customerFilter;
                    }
                    techuser.setCustomerFilters(customerFilters);
                } else {
                    techuser.setCustomerFilters(ServerConfig.migrateDeprecatedCustomerFilters(deprecated_shows, deprecated_hides));
                }
                if (deprecated_machineShows.length == 0 && deprecated_machineHides.length == 0) {
                    filters = XML14Util.getChildrenByName((Element)user, (String)"MachineFilter");
                    Filter[] machineFilters = new MachineFilter[filters.size()];
                    for (int k3 = 0; k3 < filters.size(); ++k3) {
                        filter = (Element)filters.get(k3);
                        MachineFilter machineFilter = new MachineFilter();
                        machineFilter.loadFromXML(filter);
                        machineFilters[k3] = machineFilter;
                    }
                    SimpleMachineFilter simpleMachineFilter = null;
                    filter = XML14Util.getChildByName((Element)user, (String)"SimpleMachineFilter");
                    if (filter != null) {
                        simpleMachineFilter = new SimpleMachineFilter();
                        simpleMachineFilter.loadFromXML(filter);
                    }
                    int filterType = 0;
                    if (machineFiltersAttribute != null && machineFiltersAttribute.length() > 0) {
                        if (machineFiltersAttribute.equals("advanced")) {
                            filterType = 2;
                        } else if (machineFiltersAttribute.equals("simple")) {
                            filterType = 1;
                        }
                    } else if (machineFilters.length > 0) {
                        filterType = 2;
                    }
                    CombinedMachineFilter combinedMachineFilter = techuser.getMachineFilters();
                    combinedMachineFilter.setAdvancedFilters(machineFilters);
                    combinedMachineFilter.setSimpleMachineFilter(simpleMachineFilter);
                    combinedMachineFilter.setType(filterType);
                } else {
                    CombinedMachineFilter combinedMachineFilter = techuser.getMachineFilters();
                    combinedMachineFilter.setAdvancedFilters(ServerConfig.migrateDeprecatedMachineFilters(deprecated_machineShows, deprecated_machineHides));
                    combinedMachineFilter.setType(2);
                }
                technicians.add(techuser);
                if (!CentralDebugging.PX_VERBOSE_SERVER_CONFIG) continue;
                System.out.println("[Server Config] Technician User: \"" + techuser.getDefaultName() + "\" (" + techuser.getLogin() + ")");
            }
            catch (Exception e) {
                Debugger.error("[Server Config] Invalid <Technician> entry: " + user.toString());
            }
        }
    }

    private static MachineFilter[] migrateDeprecatedMachineFilters(String[] deprecated_machineShows, String[] deprecated_machineHides) {
        MachineFilter[] filters = new MachineFilter[deprecated_machineShows.length + deprecated_machineHides.length];
        int index = 0;
        for (String filter : deprecated_machineHides) {
            filter = filter.replace("*", "");
            filters[index++] = new MachineFilter(false, "Filter_Details", 2, filter);
        }
        for (String filter : deprecated_machineShows) {
            filter = filter.replace("*", "");
            filters[index++] = new MachineFilter(true, "Filter_Details", 2, filter);
        }
        return filters;
    }

    private static CustomerFilter[] migrateDeprecatedCustomerFilters(String[] deprecated_shows, String[] deprecated_hides) {
        CustomerFilter[] filters = new CustomerFilter[deprecated_shows.length + deprecated_hides.length];
        int index = 0;
        for (String filter : deprecated_hides) {
            filter = filter.replace("*", "");
            filters[index++] = new CustomerFilter(false, "Filter_Details", 2, filter);
        }
        for (String filter : deprecated_shows) {
            filter = filter.replace("*", "");
            filters[index++] = new CustomerFilter(true, "Filter_Details", 2, filter);
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToConfig(File file) throws IOException {
        String config;
        Object object = this.LOCK;
        synchronized (object) {
            config = this.printConfig(true);
        }
        object = SAVE_FILE_LOCK;
        synchronized (object) {
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
            try {
                bout.write(config.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                bout.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLForTechniciansIn(TechGroup[] groups) {
        Object object = this.LOCK;
        synchronized (object) {
            StringBuffer result = new StringBuffer();
            result.append("<Technicians>\n");
            block3: for (TechUser user : this.technicians) {
                for (TechGroup group : groups) {
                    if (!user.isInGroup(group)) continue;
                    this.saveTechnicianXML(result, user, "Technician");
                    continue block3;
                }
            }
            block5: for (TechUser user : this.anonymousTechnicians) {
                for (TechGroup group : groups) {
                    if (!user.isInGroup(group)) continue;
                    this.saveTechnicianXML(result, user, "AnonTechnician");
                    continue block5;
                }
            }
            result.append("</Technicians>\n");
            return result.toString();
        }
    }

    public static TechUser[] loadTechnicianXMLOnly(String techXML, ArrayList<TechGroup> groups) throws ParserConfigurationException, IOException, SAXException {
        ArrayList users;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.parse(new InputSource(new StringReader(techXML)));
        Element root = dom.getDocumentElement();
        ArrayList<TechUser> technicians = new ArrayList<TechUser>();
        ArrayList<TechUser> anonymousTechnicians = new ArrayList<TechUser>();
        try {
            users = XML14Util.getChildrenByName((Element)root, (String)"Technician");
            ServerConfig.loadTechnicianXML(users, false, technicians, groups);
        }
        catch (Exception e) {
            Debugger.error("[Server Config] Error reading <Technician> entries");
        }
        try {
            users = XML14Util.getChildrenByName((Element)root, (String)"AnonTechnician");
            ServerConfig.loadTechnicianXML(users, true, anonymousTechnicians, groups);
        }
        catch (Exception e) {
            Debugger.error("[Server Config] Error reading <AnonTechnician> entries");
        }
        ArrayList<TechUser> results = new ArrayList<TechUser>();
        results.addAll(technicians);
        results.addAll(anonymousTechnicians);
        return results.toArray(new TechUser[0]);
    }

    private void appendXmlTag(StringBuffer sb, String tag, String contents) {
        this.appendXmlTag(sb, tag, contents, 1);
    }

    private void appendXmlTag(StringBuffer sb, String tag, String contents, int tabs) {
        this.appendXmlTag(sb, tag, contents, tabs, null, null);
    }

    private void appendXmlTag(StringBuffer sb, String tag, String contents, int tabs, String[] attNames, String[] attValues) {
        int i;
        if (contents == null) {
            return;
        }
        for (i = 0; i < tabs; ++i) {
            sb.append('\t');
        }
        sb.append("<").append(tag);
        if (attNames != null) {
            for (i = 0; i < attNames.length; ++i) {
                String attName = attNames[i];
                String attValue = attValues[i];
                if (attValue != null) {
                    sb.append(" ").append(attName).append("=\"").append(attValue).append("\"");
                    continue;
                }
                sb.append(" ").append(attName);
            }
        }
        if (contents.length() == 0) {
            sb.append("/>\n");
            return;
        }
        sb.append(">");
        char[] cs = contents.toCharArray();
        for (int i2 = 0; i2 < cs.length; ++i2) {
            char c = cs[i2];
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        sb.append("</").append(tag).append(">\n");
    }

    public String printConfig() {
        return this.printConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String printConfig(boolean diskAccess) {
        boolean atLeastOneUserHasATOTPKey = false;
        StringBuffer buffer = new StringBuffer();
        if (this.comment != null) {
            buffer.append(this.comment).append("\n");
        }
        if (this.simplehelp) {
            buffer.append("<SimpleHelp>\n");
        } else if (this.simplegateway) {
            buffer.append("<SimpleGateway>\n");
        } else {
            buffer.append("<SimpleSuite>\n");
        }
        buffer.append("\t<ServerFeatures>\n");
        if (this.enabledRemoteAccess) {
            this.appendXmlTag(buffer, "RemoteAccess", "on", 2);
        } else {
            this.appendXmlTag(buffer, "RemoteAccess", "off", 2);
        }
        if (this.enabledRemoteSupport) {
            this.appendXmlTag(buffer, "RemoteSupport", "on", 2);
        } else {
            this.appendXmlTag(buffer, "RemoteSupport", "off", 2);
        }
        if (this.enabledPresentation) {
            this.appendXmlTag(buffer, "Presentation", "on", 2);
        } else {
            this.appendXmlTag(buffer, "Presentation", "off", 2);
        }
        if (this.enabledMobileAccess) {
            this.appendXmlTag(buffer, "MobileAccess", "on", 2);
        } else {
            this.appendXmlTag(buffer, "MobileAccess", "off", 2);
        }
        if (this.enabledServiceRecovery) {
            this.appendXmlTag(buffer, "ServiceRecovery", "on", 2);
        } else {
            this.appendXmlTag(buffer, "ServiceRecovery", "off", 2);
        }
        buffer.append("\t</ServerFeatures>\n");
        if (this.detailFields != null) {
            buffer.append(CUIFieldRepository.fieldsToXML((CUIField[])this.detailFields, (int)1));
        }
        if (this.logInfo) {
            this.appendXmlTag(buffer, "LogInfo", "On");
        }
        if (this.serverHashPassword != null && !this.serverHashPassword.isNull()) {
            this.appendXmlTag(buffer, "HashPassword", this.serverHashPassword.getHashedPassword());
        }
        if (this.keystoreStorePassword != null && this.keystoreKeyPassword != null) {
            buffer.append("\t<SslKeystore>\n");
            this.appendXmlTag(buffer, "SecureKeystoreStorePasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.keystoreStorePassword), 2);
            this.appendXmlTag(buffer, "SecureKeystoreKeyPasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.keystoreKeyPassword), 2);
            this.appendXmlTag(buffer, "StoreType", this.keystoreType, 2);
            buffer.append("\t</SslKeystore>\n");
        }
        if (this.portList != null) {
            for (int aPortList : this.portList) {
                this.appendXmlTag(buffer, "Port", "" + aPortList);
            }
        }
        if (this.ipPortPairsList != null) {
            for (int anIpPortPairsList : (Object)this.ipPortPairsList) {
                this.appendXmlTag(buffer, "IpPort", "" + (String)anIpPortPairsList);
            }
        }
        if (this.sshdPort != 0) {
            this.appendXmlTag(buffer, "SshdPort", "" + this.sshdPort);
        }
        if (this.hostname != null) {
            this.appendXmlTag(buffer, "Hostname", this.hostname);
        }
        if (this.appearWaitMS != 0L) {
            this.appendXmlTag(buffer, "MachineAppearTimeoutMS", "" + this.appearWaitMS);
        }
        if (this.httpHeaders != null) {
            Object object = this.httpHeaders.iterator();
            while (object.hasNext()) {
                HTTPHeader hTTPHeader = (HTTPHeader)object.next();
                this.appendXmlTag(buffer, "HTTPHeader", "", 1, new String[]{"name", "value"}, new String[]{hTTPHeader.name, hTTPHeader.value});
            }
        }
        if (this.blockedURLs != null) {
            for (String string : this.blockedURLs) {
                this.appendXmlTag(buffer, "BlockedURL", string);
            }
        }
        this.appendXmlTag(buffer, "AutoForget", Boolean.toString(this.autoForgetEnabled));
        this.appendXmlTag(buffer, "AutoForgetTimeoutMS", Long.toString(this.autoForgetTimeoutMS));
        this.appendXmlTag(buffer, "DiskCleanup", Boolean.toString(this.diskCleanupEnabled));
        this.appendXmlTag(buffer, "DiskCleanupTimeoutMonths", Long.toString(this.diskCleanupTimeoutMonths));
        buffer.append("\t<Logging>\n");
        this.appendXmlTag(buffer, "Archive", this.archiveLogs ? "on" : "off", 2);
        this.appendXmlTag(buffer, "Compress", this.compressLogs ? "on" : "off", 2);
        this.appendXmlTag(buffer, "MaxPartSize", Long.toString(this.maxLogsFileSize), 2);
        this.appendXmlTag(buffer, "Encrypt", this.encryptLogs ? "on" : "off", 2);
        this.appendXmlTag(buffer, "LogsToKeep", Integer.toString(this.logsToKeep), 2);
        buffer.append("\t</Logging>\n");
        if (this.connectWaitMS != 0L) {
            this.appendXmlTag(buffer, "MachineConnectTimeoutMS", "" + this.connectWaitMS);
        }
        if (this.stopButDontRemoveServices) {
            buffer.append("\t<StopRemoteServicesOnly/>\n");
        }
        if (this.redirectDefaultToWelcomePage) {
            buffer.append("\t<RedirectDefaultUrlToWelcomePage>yes</RedirectDefaultUrlToWelcomePage>\n");
        } else {
            buffer.append("\t<RedirectDefaultUrlToWelcomePage>no</RedirectDefaultUrlToWelcomePage>\n");
        }
        if (this.serverLanguage != null) {
            buffer.append("\t<ServerLanguage>").append(this.serverLanguage).append("</ServerLanguage>\n");
        }
        for (TechGroup techGroup : this.groups) {
            SimpleMachineFilter simpleMachineFilter;
            Filter[] filterArray;
            buffer.append("\t<TechnicianGroup machineFilters=\"");
            if (techGroup.getMachineFilters().useSimpleFilter()) {
                buffer.append("simple");
            } else if (techGroup.getMachineFilters().useAdvancedFilter()) {
                buffer.append("advanced");
            } else {
                buffer.append("all");
            }
            buffer.append("\">\n");
            this.appendXmlTag(buffer, "ID", "" + techGroup.getGroupID(), 2);
            this.appendXmlTag(buffer, "Name", techGroup.getName(), 2);
            if (techGroup.getHostname() != null && techGroup.getHostname().length() > 0) {
                this.appendXmlTag(buffer, "GroupHostname", techGroup.getHostname(), 2);
            }
            if (techGroup.getDefaultSGServiceName() != null && techGroup.getDefaultSGServiceName().length() > 0) {
                this.appendXmlTag(buffer, "DefaultSimpleGatewayName", techGroup.getDefaultSGServiceName(), 2);
            }
            if (techGroup.getDefaultVideoPassword() != null && techGroup.getDefaultVideoPassword().length() > 0) {
                this.appendXmlTag(buffer, "DefaultRecordingPassword", techGroup.getDefaultVideoPassword(), 2);
            }
            this.appendXmlTag(buffer, "RequestAccessTimeoutMS", Long.toString(techGroup.getRequestAccessTimeout()), 2);
            this.appendXmlTag(buffer, "InactivityTimeoutMS", Long.toString(techGroup.getInactivityTimeout()), 2);
            if (techGroup.allowAnonymousLogins()) {
                this.appendXmlTag(buffer, "AnonymousLogins", "on", 2);
            } else {
                this.appendXmlTag(buffer, "AnonymousLogins", "off", 2);
            }
            if (Switches.SH_appProfiles && techGroup.getAssociatedAppProfileID() != null) {
                this.appendXmlTag(buffer, "AssociatedAppProfileID", techGroup.getAssociatedAppProfileID(), 2);
            }
            buffer.append(techGroup.getPermissions().toXML(2));
            if (techGroup.isMaxFileTransferSizeLimited()) {
                this.appendXmlTag(buffer, "MaxFileSize", "" + techGroup.getMaxFileTransferSize(), 2);
            }
            if (techGroup.isShConcurrencyLimited()) {
                this.appendXmlTag(buffer, "MaxShSessionsGroup", "" + techGroup.getMaxShGroupConcurrency(), 2);
                this.appendXmlTag(buffer, "MaxShSessionsUser", "" + techGroup.getMaxShUserConcurrency(), 2);
            }
            if (techGroup.isSgConcurrencyLimited()) {
                this.appendXmlTag(buffer, "MaxSgSessionsGroup", "" + techGroup.getMaxSgGroupConcurrency(), 2);
                this.appendXmlTag(buffer, "MaxSgSessionsUser", "" + techGroup.getMaxSgUserConcurrency(), 2);
            }
            if (techGroup.isFPSLimited()) {
                this.appendXmlTag(buffer, "FPSDelay", "" + techGroup.getFPSDelay(), 2);
            }
            if (techGroup.isSessionLimited()) {
                this.appendXmlTag(buffer, "SessionSpeedLimit", "" + techGroup.getSessionLimitKbps(), 2);
            }
            if (techGroup.isPassword()) {
                LazyHashPassword groupPassword = techGroup.getPassword();
                if (groupPassword.getHashedPassword() == null) {
                    Object anIpPortPairsList = this.LOCK;
                    synchronized (anIpPortPairsList) {
                        byte[] byArray = new byte[40];
                        random.nextBytes(byArray);
                        groupPassword = LazyHashPassword.createWithNewPassword(Base64.byteArrayToBase64((byte[])byArray));
                    }
                }
                this.appendXmlTag(buffer, "HashPassword", groupPassword.getHashedPassword(), 2);
            }
            if (techGroup.isMultiTierApp()) {
                buffer.append("\t\t<AppAuthentication/>\n");
            }
            if (techGroup.getMultiTierRememberMachine()) {
                buffer.append("\t\t<MultiTierRememberMachine/>\n");
            }
            if (techGroup.isMultiTierEmail()) {
                buffer.append("\t\t<TwoTier>\n");
                this.appendXmlTag(buffer, "CodeLength", Integer.toString(techGroup.getTwoTierCodeLength()), 3);
                if (techGroup.getTwoTierSubject() != null) {
                    this.appendXmlTag(buffer, "EmailSubject", techGroup.getTwoTierSubject(), 3);
                }
                if (techGroup.getTwoTierBody() != null) {
                    this.appendXmlTag(buffer, "EmailBody", HexData.byteArrayToHexString((byte[])techGroup.getTwoTierBody().getBytes(StandardCharsets.UTF_8)), 3);
                }
                buffer.append("\t\t</TwoTier>\n");
            }
            if (techGroup.isLDAP()) {
                buffer.append("\t\t<LDAP>\n");
                if (techGroup.getLDAPProperties() != null) {
                    LDAPProperties props = techGroup.getLDAPProperties();
                    if (props.baseDN != null) {
                        this.appendXmlTag(buffer, "BaseDN", props.baseDN, 3);
                    }
                    if (props.filter != null) {
                        this.appendXmlTag(buffer, "SearchFilter", props.filter, 3);
                    }
                    if (props.groups != null) {
                        buffer.append("\t\t\t<Groups>\n");
                        for (int i = 0; i < props.groups.length; ++i) {
                            this.appendXmlTag(buffer, "Group", props.groups[i], 4);
                        }
                        buffer.append("\t\t\t</Groups>\n");
                    }
                    if (!props.isSimple()) {
                        this.appendXmlTag(buffer, "Advanced", "", 3);
                    }
                }
                buffer.append("\t\t</LDAP>\n");
            }
            if (techGroup.isRadius()) {
                buffer.append("\t\t<RADIUS>yes</RADIUS>\n");
            }
            if (techGroup.getFilterByAllowedGroups()) {
                this.appendXmlTag(buffer, "FilterByMachineGroup", "on", 2);
            } else {
                this.appendXmlTag(buffer, "FilterByMachineGroup", "off", 2);
            }
            ArrayList<ArrayList<String>> allowedGroups = techGroup.getRemoteAccessGroupRestrictions();
            buffer.append("\t\t<AllowedMachineGroups>\n");
            for (ArrayList<String> arrayList : allowedGroups) {
                buffer.append("\t\t\t<AllowedMachineGroup>\n");
                for (String string : arrayList) {
                    this.appendXmlTag(buffer, "Path", string, 4);
                }
                buffer.append("\t\t\t</AllowedMachineGroup>\n");
            }
            buffer.append("\t\t</AllowedMachineGroups>\n");
            CustomerFilter[] customerFilters = techGroup.getCustomerFilters();
            if (customerFilters != null) {
                void var10_54;
                CustomerFilter[] customerFilterArray = customerFilters;
                int n = customerFilterArray.length;
                boolean bl = false;
                while (var10_54 < n) {
                    CustomerFilter filter = customerFilterArray[var10_54];
                    filter.saveToXML(buffer, 2);
                    ++var10_54;
                }
            }
            if ((filterArray = techGroup.getMachineFilters().getAdvancedFilters()) != null) {
                for (Filter filter : filterArray) {
                    filter.saveToXML(buffer, 2);
                }
            }
            if ((simpleMachineFilter = techGroup.getMachineFilters().getSimpleMachineFilter()) != null) {
                simpleMachineFilter.saveToXML(buffer, 2);
            }
            buffer.append("\t</TechnicianGroup>\n");
        }
        for (TechUser techUser : this.technicians) {
            this.saveTechnicianXML(buffer, techUser, "Technician");
            if (techUser.getTOTPKey() == null || techUser.getTOTPKey().isNull()) continue;
            atLeastOneUserHasATOTPKey = true;
        }
        for (TechUser techUser : this.anonymousTechnicians) {
            this.saveTechnicianXML(buffer, techUser, "AnonTechnician");
            if (techUser.getTOTPKey() == null || techUser.getTOTPKey().isNull()) continue;
            atLeastOneUserHasATOTPKey = true;
        }
        this.appendXmlTag(buffer, "EndOfSessionOption", this.endOfSessionOption, 1);
        this.appendXmlTag(buffer, "EndOfSessionURL", this.endOfSessionURL, 1);
        this.appendXmlTag(buffer, "EndOfSessionURLSupport", this.endOfSessionURLSupport ? "true" : "false", 1);
        this.appendXmlTag(buffer, "EndOfSessionURLAccess", this.endOfSessionURLAccess ? "true" : "false", 1);
        if (this.elevateSupportSessions) {
            this.appendXmlTag(buffer, "WindowsElevation", "true", 1);
        } else {
            this.appendXmlTag(buffer, "WindowsElevation", "false", 1);
        }
        if (this.techRestrictions != null && this.techRestrictions.length > 0) {
            buffer.append("\n");
            for (PatternWrapper techRestriction : this.techRestrictions) {
                this.appendXmlTag(buffer, "TechRestriction", techRestriction.getRegularExpression());
            }
        }
        if (this.apiRestrictions != null && this.apiRestrictions.length > 0) {
            buffer.append("\n");
            for (PatternWrapper apiRestriction : this.apiRestrictions) {
                this.appendXmlTag(buffer, "APIRestriction", apiRestriction.getRegularExpression());
            }
        }
        if (this.statusPage) {
            buffer.append("\n\t<StatusPage>\n");
            if (this.statusPageIncludeMachines) {
                this.appendXmlTag(buffer, "IncludeMachines", "on", 2);
            } else {
                this.appendXmlTag(buffer, "IncludeMachines", "off", 2);
            }
            if (this.statusPageIncludeSessions) {
                this.appendXmlTag(buffer, "IncludeSessions", "on", 2);
            } else {
                this.appendXmlTag(buffer, "IncludeSessions", "off", 2);
            }
            if (this.statusPageIncludePerformance) {
                this.appendXmlTag(buffer, "IncludePerformance", "on", 2);
            } else {
                this.appendXmlTag(buffer, "IncludePerformance", "off", 2);
            }
            if (this.statusPageRestrictions != null) {
                for (PatternWrapper statusPageRestriction : this.statusPageRestrictions) {
                    this.appendXmlTag(buffer, "StatusPageRestriction", "" + statusPageRestriction, 2);
                }
            }
            buffer.append("\t</StatusPage>\n");
        }
        if (this.serverAdminGroup.getMultiTierRememberMachine()) {
            buffer.append("\n\t<AdminAuthenticationRememberMachine/>\n");
        }
        if (this.serverAdminGroup.isMultiTierApp()) {
            LazyEncryptedPassword adminAppAuthenticationKey = this.serverAdmin.getTOTPKey();
            if (adminAppAuthenticationKey == null || adminAppAuthenticationKey.isNull()) {
                buffer.append("\n\t<AdminAppAuthentication/>\n");
            } else {
                buffer.append("\n\t<AdminAppAuthentication>\n");
                this.appendXmlTag(buffer, "Keyv2", ServerConfig.getEncryptedPasswordOrNull(adminAppAuthenticationKey), 2);
                buffer.append("\t</AdminAppAuthentication>\n");
                atLeastOneUserHasATOTPKey = true;
            }
        }
        if (this.serverAdminGroup.isMultiTierEmail()) {
            buffer.append("\n\t<AdminTwoTier>\n");
            this.appendXmlTag(buffer, "CodeLength", Integer.toString(this.serverAdminGroup.getTwoTierCodeLength()), 2);
            if (this.serverAdmin.getEmail() != null) {
                this.appendXmlTag(buffer, "EmailAddress", this.serverAdmin.getEmail(), 2);
            }
            if (this.serverAdminGroup.getTwoTierSubject() != null) {
                this.appendXmlTag(buffer, "EmailSubject", this.serverAdminGroup.getTwoTierSubject(), 2);
            }
            if (this.serverAdminGroup.getTwoTierBody() != null) {
                this.appendXmlTag(buffer, "EmailBody", HexData.byteArrayToHexString((byte[])this.serverAdminGroup.getTwoTierBody().getBytes(StandardCharsets.UTF_8)), 2);
            }
            buffer.append("\t</AdminTwoTier>\n");
        }
        if (this.emailSettingsEnabled) {
            buffer.append("\n\t<EmailSettings>\n");
            this.appendXmlTag(buffer, "SmtpHost", this.smtpHost, 2);
            this.appendXmlTag(buffer, "SmtpPort", "" + this.smtpPort, 2);
            if (this.smtpUser != null && this.smtpUser.trim().length() != 0) {
                this.appendXmlTag(buffer, "SmtpUser", this.smtpUser, 2);
                this.appendXmlTag(buffer, "SecureSmtpPassv2", ServerConfig.getEncryptedPasswordOrNull(this.smtpPassword), 2);
            }
            this.appendXmlTag(buffer, "SmtpFromEmail", this.smtpFromEmail, 2);
            this.appendXmlTag(buffer, "SmtpFromName", this.smtpFromName, 2);
            if (this.smtpSSL) {
                this.appendXmlTag(buffer, "SmtpSSL", "On", 2);
            } else {
                this.appendXmlTag(buffer, "SmtpSSL", "Off", 2);
            }
            if (this.smtpTLS) {
                this.appendXmlTag(buffer, "SmtpTLS", "On", 2);
            } else {
                this.appendXmlTag(buffer, "SmtpTLS", "Off", 2);
            }
            if (this.smtpSendAsTechnicians) {
                this.appendXmlTag(buffer, "SmtpSendAsTechnicians", "On", 2);
            } else {
                this.appendXmlTag(buffer, "SmtpSendAsTechnicians", "Off", 2);
            }
            if (this.dateFormat != null) {
                this.appendXmlTag(buffer, "DateFormat", this.dateFormat, 2);
            }
            if (this.emailProperties != null) {
                for (Object e : this.emailProperties.keySet()) {
                    String value;
                    String key = (String)e;
                    if (key == null || (value = this.emailProperties.getProperty(key)) == null) continue;
                    buffer.append("\t\t<EmailProperty>\n");
                    this.appendXmlTag(buffer, "Key", key, 3);
                    this.appendXmlTag(buffer, "Value", value, 3);
                    buffer.append("\t\t</EmailProperty>\n");
                }
            }
            buffer.append("\t</EmailSettings>\n");
        }
        if (this.deprecated_anonymousUserIDToTOTPKey.size() > 0) {
            buffer.append("\t<AnonymousTOTPKeys>\n");
            for (String string : this.deprecated_anonymousUserIDToTOTPKey.keySet()) {
                LazyEncryptedPassword decryptedKey = this.deprecated_anonymousUserIDToTOTPKey.get(string);
                String encryptedKey = ServerConfig.getEncryptedPasswordOrNull(decryptedKey);
                buffer.append("\t\t<KeyEntry>\n");
                XML14Util.appendTextNode((StringBuffer)buffer, (int)3, (String)"User", (String)string);
                XML14Util.appendTextNode((StringBuffer)buffer, (int)3, (String)"TOTPKey", (String)encryptedKey);
                buffer.append("\t\t</KeyEntry>\n");
            }
            buffer.append("\t</AnonymousTOTPKeys>\n");
        }
        if (this.remoteCustomersTechPresence || this.remoteMachinesTechPresence) {
            buffer.append("\n\t<TechnicianPresenceDialog>\n");
            if (this.remoteCustomersTechPresence) {
                this.appendXmlTag(buffer, "RemoteCustomers", "On", 2);
            }
            if (this.remoteMachinesTechPresence) {
                this.appendXmlTag(buffer, "RemoteMachines", "On", 2);
            }
            buffer.append("\t</TechnicianPresenceDialog>\n");
        }
        if (this.radiusEnable) {
            buffer.append("\n");
            buffer.append("\t<RadiusSettings>\n");
            this.appendXmlTag(buffer, "Attempts", String.valueOf(this.radiusAttempts), 2);
            this.appendXmlTag(buffer, "TimeoutMS", String.valueOf(this.radiusTimeout), 2);
            this.appendXmlTag(buffer, "Strategy", String.valueOf(this.radiusStrategy), 2);
            this.appendXmlTag(buffer, "StaggeredTimeoutMS", String.valueOf(this.radiusStaggeredTimeout), 2);
            buffer.append("\t</RadiusSettings>\n");
            if (this.radiusConfigs != null) {
                for (RadiusConfig config : this.radiusConfigs) {
                    buffer.append("\t<RadiusAuthentication id=\"").append(config.index).append("\">\n");
                    this.appendXmlTag(buffer, "RadiusHostname", config.radiusHostname, 2);
                    this.appendXmlTag(buffer, "RadiusSecret", config.radiusSecret, 2);
                    this.appendXmlTag(buffer, "RadiusPort", Integer.toString(config.radiusPort), 2);
                    this.appendXmlTag(buffer, "RadiusAuthenticationProtocol", config.radiusAuthProtocol, 2);
                    buffer.append("\t</RadiusAuthentication>\n");
                }
            }
        }
        if (this.ldapEnable) {
            buffer.append("\n");
            buffer.append("\t<LDAPAuthentication>\n");
            this.appendXmlTag(buffer, "LDAPHostname", this.ldapHostname, 2);
            this.appendXmlTag(buffer, "LDAPPort", "" + this.ldapPort, 2);
            if (this.ldapUsername != null) {
                this.appendXmlTag(buffer, "LDAPUsername", this.ldapUsername, 2);
            }
            if (this.ldapPassword != null) {
                this.appendXmlTag(buffer, "SecureLDAPPasswordv2", ServerConfig.getEncryptedPasswordOrNull(this.ldapPassword), 2);
            }
            if (this.ldapAuthentication != null) {
                this.appendXmlTag(buffer, "AuthenticationMechanism", this.ldapAuthentication, 2);
            }
            if (this.ldapEnableSSL) {
                this.appendXmlTag(buffer, "UseSSL", "", 2);
            }
            if (this.ldapIsAD) {
                this.appendXmlTag(buffer, "IsAD", "", 2);
            }
            this.appendXmlTag(buffer, "UserClass", this.ldapUserClass, 2);
            this.appendXmlTag(buffer, "GroupClass", this.ldapGroupClass, 2);
            this.appendXmlTag(buffer, "LoginAttribute", this.ldapLoginAttribute, 2);
            this.appendXmlTag(buffer, "MemberAttribute", this.ldapMemberAttribute, 2);
            this.appendXmlTag(buffer, "FollowReferrals", Boolean.toString(this.ldapFollowLinks), 2);
            if (this.ldapMappings.size() > 0) {
                buffer.append("\t\t<LDAPAttributeMappings>\n");
                for (LDAPAuthenticator.LDAPAttributeMapping lDAPAttributeMapping : this.ldapMappings) {
                    buffer.append("\t\t\t<LDAPMapping techProperty=\"" + XML14Util.escape((String)lDAPAttributeMapping.shAttribute) + "\">\n");
                    for (String ldapAttribute : lDAPAttributeMapping.ldapAttributes) {
                        if (ldapAttribute == null) continue;
                        buffer.append("\t\t\t\t<LDAPAttribute>").append(XML14Util.escape((String)ldapAttribute)).append("</LDAPAttribute>\n");
                    }
                    buffer.append("\t\t\t</LDAPMapping>\n");
                }
                buffer.append("\t\t</LDAPAttributeMappings>\n");
            }
            buffer.append("\t</LDAPAuthentication>\n");
        }
        buffer.append("\n");
        buffer.append("\t<SessionSummary>\n");
        if (this.sessionSummaryTechComment) {
            this.appendXmlTag(buffer, "IncludeTechComments", "On", 2);
        }
        if (this.sessionSummaryAllowSkip) {
            this.appendXmlTag(buffer, "SkipAllowed", "On", 2);
        }
        buffer.append("\t\t<EmailSummary>\n");
        if (this.sessionSummaryCustEmail && this.sessionSummaryEmailCustDetail != null) {
            this.appendXmlTag(buffer, "CustomerEmailDetail", this.sessionSummaryEmailCustDetail, 3);
        }
        buffer.append("\t\t</EmailSummary>\n");
        buffer.append("\t</SessionSummary>\n");
        buffer.append("\t<CustomerAuthentication>\n");
        if (this.enabledQueuePassword) {
            buffer.append("\t\t<CustomerPassword>").append(this.queuePassword).append("</CustomerPassword>\n");
        }
        buffer.append("\t</CustomerAuthentication>\n");
        if (this.uPnPPortForwardingEnabled) {
            this.appendXmlTag(buffer, "UPnPPortForwarding", "On", 1);
        }
        if (this.forwardToHTTPS) {
            this.appendXmlTag(buffer, "ForwardHTTPtoHTTPS", "On");
        }
        this.appendXmlTag(buffer, "FailOverCheckURL", this.failoverCheckURL);
        this.appendXmlTag(buffer, "CentralServerURL", this.condenserForURL);
        this.appendXmlTag(buffer, "SecureCentralServerTokenv2", ServerConfig.getEncryptedPasswordOrNull(this.condenserToken));
        if (this.debugDelay > 0L) {
            this.appendXmlTag(buffer, "DebugSimulateDelay", Long.toString(this.debugDelay));
            if (ServerManagement.isServerJVM() && diskAccess) {
                try {
                    Thread.sleep(this.debugDelay);
                    System.out.println("[ServerConfig] [DEBUG] Write delaying for " + this.debugDelay);
                    new Exception().printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.appendXmlTag(buffer, "MachineTimeoutMS", Integer.toString(this.defaultMachineTimeoutMS));
        this.appendXmlTag(buffer, "SecureMessengerRouteMapSize", Integer.toString(this.secureMessengerRouteMapSize));
        if (atLeastOneUserHasATOTPKey) {
            this.appendXmlTag(buffer, "TOTPLength", Integer.toString(this.totpLength));
            this.appendXmlTag(buffer, "TOTPWindowSize", Integer.toString(this.totpWindowSize));
        }
        if (this.feature_showPerformanceMetricsTechConsole) {
            this.appendXmlTag(buffer, "FeaturePerformanceMetrics", "");
        }
        if (this.feature_multiLicense) {
            this.appendXmlTag(buffer, "FeatureMultiLicense", "");
        }
        if (this.defaultMaxAudioBitrate > 0) {
            this.appendXmlTag(buffer, "MaxAudioBitrate", Integer.toString(this.defaultMaxAudioBitrate));
        }
        if (this.blockedRemoteAccessMachines != null) {
            for (BlockedRemoteMachine blockedRemoteMachine : this.blockedRemoteAccessMachines) {
                buffer.append("\t<BlockedRemoteMachine>\n");
                this.appendXmlTag(buffer, "ID", blockedRemoteMachine.machineID, 2);
                this.appendXmlTag(buffer, "Name", blockedRemoteMachine.name.toString(), 2);
                buffer.append("\t</BlockedRemoteMachine>\n");
            }
        }
        if (this.simplehelp) {
            buffer.append("</SimpleHelp>\n");
        } else if (this.simplegateway) {
            buffer.append("</SimpleGateway>\n");
        } else {
            buffer.append("</SimpleSuite>\n");
        }
        return buffer.toString();
    }

    private void saveTechnicianXML(StringBuffer buffer, TechUser tech, String tag) {
        Filter[] machineFilters = tech.getMachineFilters().getAdvancedFilters();
        SimpleMachineFilter simpleFilter = tech.getMachineFilters().getSimpleMachineFilter();
        buffer.append("\t<").append(tag).append(" machineFilters=\"");
        if (tech.getMachineFilters().useSimpleFilter()) {
            buffer.append("simple");
        } else if (tech.getMachineFilters().useAdvancedFilter()) {
            buffer.append("advanced");
        } else {
            buffer.append("all");
        }
        buffer.append("\">\n");
        this.appendXmlTag(buffer, "ID", "" + tech.getUserID(), 2);
        this.appendXmlTag(buffer, "Namev2", ServerConfig.getEncryptedPasswordOrNull(tech.getDefaultNameEncrypted()), 2);
        this.appendXmlTag(buffer, "Loginv2", ServerConfig.getEncryptedPasswordOrNull(tech.getLoginEncrypted()), 2);
        this.appendXmlTag(buffer, "Emailv2", ServerConfig.getEncryptedPasswordOrNull(tech.getEmailEncrypted()), 2);
        if (tech.getPassword() != null && !tech.getPassword().isNull()) {
            this.appendXmlTag(buffer, "HashPassword", tech.getPassword().getHashedPassword(), 2);
        }
        this.appendXmlTag(buffer, "TOTPKeyv2", ServerConfig.getEncryptedPasswordOrNull(tech.getTOTPKey()), 2);
        if (Switches.SH_appProfiles) {
            if (tech.isForAppProfilesOnly()) {
                this.appendXmlTag(buffer, "AppProfilesOnly", "on", 2);
            } else {
                this.appendXmlTag(buffer, "AppProfilesOnly", "off", 2);
            }
        }
        if (tech.allowLocallyAuthenticatedLogins()) {
            this.appendXmlTag(buffer, "AllowLocallyAuthenticatedLogin", "on", 2);
        } else {
            this.appendXmlTag(buffer, "AllowLocallyAuthenticatedLogin", "off", 2);
        }
        if (tech.isAccountEnabled()) {
            this.appendXmlTag(buffer, "Enabled", "on", 2);
        } else {
            this.appendXmlTag(buffer, "Enabled", "off", 2);
        }
        this.appendXmlTag(buffer, "EnabledUntilTime", Long.toString(tech.getEnabledUntilTime()));
        CustomerFilter[] customerFilters = tech.getCustomerFilters();
        if (customerFilters != null) {
            for (Filter filter : customerFilters) {
                filter.saveToXML(buffer, 2);
            }
        }
        if (machineFilters != null) {
            for (Filter filter : machineFilters) {
                filter.saveToXML(buffer, 2);
            }
        }
        if (simpleFilter != null) {
            simpleFilter.saveToXML(buffer, 2);
        }
        HashSet mergedGroups = new HashSet();
        Collections.addAll(mergedGroups, tech.groups);
        Collections.addAll(mergedGroups, tech.groupsUserCanAdmin);
        for (TechGroup group : mergedGroups) {
            boolean bl = tech.isGroupAdminFor(group);
            boolean isMember = tech.isInGroup(group);
            if (isMember && bl) {
                this.appendXmlTag(buffer, "GroupIDMemberOf", Integer.toString(group.getGroupID()), 2, new String[]{"admin"}, new String[]{"yes"});
                continue;
            }
            if (bl) {
                this.appendXmlTag(buffer, "GroupIDMemberOf", Integer.toString(group.getGroupID()), 2, new String[]{"member", "admin"}, new String[]{"no", "yes"});
                continue;
            }
            if (!isMember) continue;
            this.appendXmlTag(buffer, "GroupIDMemberOf", Integer.toString(group.getGroupID()), 2);
        }
        buffer.append("\t</" + tag + ">\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToMessage(ProxyServerAPI proxyApi, Message ret, boolean readConfigFiles) {
        Object object = this.LOCK;
        synchronized (object) {
            this.pruneUnusedProfileGroups(proxyApi);
            ret.append(this.printConfig(false));
            if (readConfigFiles) {
                ret.append(ServerConfig.loadDisclaimer());
            } else {
                ret.append(this.disclaimer);
            }
            if (ServerManagement.isServerJVM()) {
                TypedMap profileNames = new TypedMap();
                TypedMap profileTypeNames = new TypedMap();
                for (TechGroup group : this.groups) {
                    AppProfile profile;
                    String profileID = group.getAssociatedAppProfileID();
                    if (profileID == null || (profile = proxyApi.getAppProfile(profileID)) == null) continue;
                    profileNames.setString(profileID, profile.getName());
                    profileTypeNames.setString(profileID, profile.getType().getName());
                }
                Message m = profileNames.toCompressedMessage();
                m.setType(9900001);
                ret.append(m);
                m = profileTypeNames.toCompressedMessage();
                m.setType(9900002);
                ret.append(m);
            } else {
                ret.append(new Message(9900001));
                ret.append(new Message(9900002));
            }
        }
    }

    private void pruneUnusedProfileGroups(ProxyServerAPI proxyApi) {
        if (ServerManagement.isServerJVM()) {
            ArrayList<TechGroup> groupsToRemove = new ArrayList<TechGroup>();
            for (TechGroup group : this.groups) {
                AppProfile profile;
                String profileID = group.getAssociatedAppProfileID();
                if (profileID == null || (profile = proxyApi.getAppProfile(profileID)) != null) continue;
                groupsToRemove.add(group);
            }
            this.groups.removeAll(groupsToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromMessage(Message m, boolean saveConfigFiles) throws DOMException, IOException, ParserConfigurationException, SAXException, ServerStartFailureException {
        String profileID;
        String configuration = (String)m.get(0);
        this.loadConfig(configuration, false);
        TypedMap profileNames = null;
        TypedMap profileTypeNames = null;
        for (int i = 0; i < m.length(); ++i) {
            if (m.getType(i) != 4) continue;
            Message tmp = m.getAsMessage(i);
            boolean mustpop = true;
            if (tmp.getType() == 9900001) {
                if (tmp.length() > 0) {
                    profileNames = TypedMap.fromCompressedMessage((Message)tmp);
                }
            } else if (tmp.getType() == 9900002) {
                if (tmp.length() > 0) {
                    profileTypeNames = TypedMap.fromCompressedMessage((Message)tmp);
                }
            } else {
                mustpop = false;
            }
            if (!mustpop) continue;
            m.remove(i--);
        }
        if (profileNames != null) {
            Object object = this.LOCK;
            synchronized (object) {
                for (TechGroup group : this.groups) {
                    profileID = group.getAssociatedAppProfileID();
                    if (profileID == null) continue;
                    String profileName = profileNames.getString(profileID);
                    group.setTransientAppProfileName(profileName);
                }
            }
        }
        if (profileTypeNames != null) {
            Object object = this.LOCK;
            synchronized (object) {
                for (TechGroup group : this.groups) {
                    profileID = group.getAssociatedAppProfileID();
                    if (profileID == null) continue;
                    String profileTypeName = profileTypeNames.getString(profileID);
                    group.setTransientAppProfileTypeName(profileTypeName);
                }
            }
        }
        if (m.length() > 1) {
            this.disclaimer = (String)m.get(1);
        }
        if (saveConfigFiles) {
            ServerConfig.saveDisclaimer(this.disclaimer);
        }
    }

    private static String loadDisclaimer() {
        try {
            File file = new File("configuration/simplehelpdisclaimer.txt");
            File oldFile = new File("DEPLOY/simplehelpdisclaimer.txt");
            if (oldFile.exists() && !file.exists()) {
                System.out.println("[ServerConfig] Found legacy disclaimer in DEPLOY. Moving to configuration folder.");
                oldFile.renameTo(file);
            }
            if (!file.exists()) {
                if (!TEST_LOAD) {
                    FileOutputStream fout = new FileOutputStream(file);
                    fout.write(DefaultConfiguration.DEFAULT_DISCLAIMER.getBytes(StandardCharsets.UTF_8));
                    fout.close();
                }
                return DefaultConfiguration.DEFAULT_DISCLAIMER;
            }
            FileInputStream fin = new FileInputStream(file);
            String result = StreamUtils.readAllAsStringUTF8(fin);
            fin.close();
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "";
        }
    }

    private static String loadDeprecatedDetails() {
        try {
            File file = new File("configuration/simplehelpdetails.txt");
            File oldFile = new File("DEPLOY/simplehelpdetails.txt");
            if (oldFile.exists() && !file.exists()) {
                System.out.println("[ServerConfig] Found legacy details in DEPLOY. Moving to configuration folder.");
                oldFile.renameTo(file);
            }
            if (file.exists()) {
                FileInputStream fin = new FileInputStream(file);
                String result = StreamUtils.readAllAsStringUTF8(fin);
                fin.close();
                result = "Name\n" + result;
                return result;
            }
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void deleteDeprecatedDetails() {
        try {
            File file = new File("configuration/simplehelpdetails.txt");
            if (file.exists()) {
                file.delete();
            }
        }
        finally {
            File oldFile = new File("DEPLOY/simplehelpdetails.txt");
            if (oldFile.exists()) {
                oldFile.delete();
            }
        }
    }

    private static void saveDisclaimer(String disclaimer2) {
        try {
            File file = new File("configuration/simplehelpdisclaimer.txt");
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(disclaimer2.getBytes(StandardCharsets.UTF_8));
            fout.flush();
            fout.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public byte[] getCommonTechnicianProps() throws IOException {
        Properties props = new Properties();
        boolean isAdvancedSessionSummaryRequired = this.sessionSummaryTechComment;
        props.put("simplesuite_" + ServerProperties.PROP_SS_ENABLE, isAdvancedSessionSummaryRequired ? "true" : "false");
        props.put("simplesuite_" + ServerProperties.PROP_SS_TECH_COMMENT, this.sessionSummaryTechComment ? "true" : "false");
        props.put("simplesuite_" + ServerProperties.PROP_SS_ALLOW_SKIP, this.sessionSummaryAllowSkip ? "true" : "false");
        props.put("simplesuite_" + ServerProperties.PROP_SS_CUSTOM_EMAIL, this.sessionSummaryCustEmail ? "true" : "false");
        if (this.sessionSummaryEmailCustDetail != null) {
            props.put("simplesuite_" + ServerProperties.PROP_SS_CUSTOM_EMAIL_DETAIL, this.sessionSummaryEmailCustDetail);
        } else {
            props.put("simplesuite_" + ServerProperties.PROP_SS_CUSTOM_EMAIL_DETAIL, "");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gout = new GZIPOutputStream(bout);
        props.store(gout, "SimpleSuite Properties");
        gout.finish();
        gout.close();
        return bout.toByteArray();
    }

    public boolean isDefaultPassword() {
        return ServerConfig.isDefaultPassword(this.serverHashPassword);
    }

    public static boolean isDefaultPassword(LazyHashPassword password) {
        if (password == null || password.isNull()) {
            return true;
        }
        return password.matches("password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechGroup getGroupByName(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (TechGroup group : this.groups) {
                if (!group.getName().equals(name)) continue;
                return group;
            }
        }
        if (this.serverAdminGroup.getName().equals(name)) {
            return this.serverAdminGroup;
        }
        return null;
    }

    public int getRelevantGroupCount() {
        String groups = this.getGroupListAsString();
        if (groups == null || groups.length() == 0) {
            return 0;
        }
        groups = groups.replaceAll("\\\\,", "");
        return groups.split(",").length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupListAsString() {
        boolean include = false;
        StringBuilder buffer = new StringBuilder();
        Object object = this.LOCK;
        synchronized (object) {
            for (TechGroup group1 : this.groups) {
                if (group1.getAssociatedAppProfileID() != null) continue;
                for (TechUser tech : this.technicians) {
                    if (!tech.isInGroup(group1) || tech.getGroups().length < 2) continue;
                    include = true;
                    break;
                }
                if (include || !group1.allowAnonymousLogins() || !group1.isLDAP() && !group1.isPassword()) continue;
                include = true;
            }
            if (include) {
                for (TechGroup group : this.groups) {
                    if (group.getAssociatedAppProfileID() != null) continue;
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append(group.getName().replaceAll(",", "\\,"));
                }
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechUser getTechnicianByID(int techUserID) {
        if (techUserID == 0) {
            return ServerConfig.get().serverAdmin;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (TechUser technician : this.technicians) {
                if (technician.getUserID() != techUserID) continue;
                return technician;
            }
            for (TechUser technician : this.anonymousTechnicians) {
                if (technician.getUserID() != techUserID) continue;
                return technician;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechUser getTechUserByUsername(String username) {
        if (username == null || username.equals(OemBranding.OEM_ADMIN_USERNAME)) {
            return this.serverAdmin;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (TechUser technician : this.technicians) {
                if (!technician.getLogin().equals(username)) continue;
                return technician;
            }
            for (TechUser technician : this.anonymousTechnicians) {
                if (!technician.getLogin().equals(username)) continue;
                return technician;
            }
        }
        return null;
    }

    public int getTechnicianID() {
        return this.getUniqueID(1, 1000000);
    }

    public int getTechnicianGroupID() {
        return this.getUniqueID(1000001, 2000000);
    }

    public static boolean isTechnicianID(int id) {
        return id >= 0 && id <= 1000000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUniqueID(int min, int max) {
        Object object = this.LOCK;
        synchronized (object) {
            int next = -1;
            block3: while (next == -1) {
                next = Math.abs(random.nextInt(max - min)) + min;
                for (TechUser user : this.technicians) {
                    if (user.getUserID() != next) continue;
                    next = -1;
                    break;
                }
                if (next == -1) continue;
                for (TechUser user : this.anonymousTechnicians) {
                    if (user.getUserID() != next) continue;
                    next = -1;
                    break;
                }
                if (next == -1) continue;
                for (TechGroup group : this.groups) {
                    if (group.getGroupID() != next) continue;
                    next = -1;
                    continue block3;
                }
            }
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechGroup getGroupByID(int id) {
        Object object = this.LOCK;
        synchronized (object) {
            for (TechGroup group : this.groups) {
                if (group.getGroupID() != id) continue;
                return group;
            }
        }
        return null;
    }

    public String getHostname(MergedTechGroup loggedInContext) {
        if (loggedInContext == null) {
            return this.hostname;
        }
        if (loggedInContext.getHostname() == null || loggedInContext.getHostname().length() == 0) {
            return this.hostname;
        }
        return loggedInContext.getHostname();
    }

    public CommonEmailer getCommonEmailerUsingSettings(String fromAddress) {
        if (!this.smtpSendAsTechnicians) {
            fromAddress = "\"" + this.smtpFromName + "\" <" + this.smtpFromEmail + ">";
        }
        CommonEmailer.Settings settings = new CommonEmailer.Settings(this.smtpHost, "" + this.smtpPort, this.smtpAuthentication, this.smtpTLS, this.smtpSSL, this.emailProperties);
        return new HtmlEmailer(settings, this.smtpUser, this.smtpPassword.getDecryptedPassword(), fromAddress, "UTF-8");
    }

    public CommonEmailer getCommonEmailerUsingSettings() {
        return this.getCommonEmailerUsingSettings("\"" + this.smtpFromName + "\" <" + this.smtpFromEmail + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUIField[] getDetails() {
        Object object = this.detailFieldsLock;
        synchronized (object) {
            return this.detailFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(CUIField[] fields) {
        Object object = this.detailFieldsLock;
        synchronized (object) {
            this.detailFields = fields;
            this.detailFieldsXML = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetailsAsXML() {
        Object object = this.detailFieldsLock;
        synchronized (object) {
            if (this.detailFieldsXML == null) {
                this.detailFieldsXML = CUIFieldRepository.fieldsToXML((CUIField[])this.detailFields, (int)0);
            }
            return this.detailFieldsXML;
        }
    }

    public boolean isAPINetworkAllowed(String incomingIp) {
        return ServerConfig.checkIP(this.apiRestrictions, incomingIp);
    }

    public boolean isTechAllowed(String incomingIp) {
        return ServerConfig.checkIP(this.techRestrictions, incomingIp);
    }

    private static boolean checkIP(PatternWrapper[] wrappers, String incomingIp) {
        if (wrappers == null || wrappers.length == 0) {
            return true;
        }
        for (PatternWrapper techIp : wrappers) {
            if (!techIp.getPattern().matcher(incomingIp).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockedMachine(Machine machine) {
        Object object = this.LOCK;
        synchronized (object) {
            String id = machine.getMachineID();
            BlockedRemoteMachine newBlockedMachine = new BlockedRemoteMachine();
            newBlockedMachine.machineID = id;
            newBlockedMachine.name = machine.getMachineName();
            if (this.blockedRemoteAccessMachines == null) {
                this.blockedRemoteAccessMachines = new ArrayList<BlockedRemoteMachine>();
                this.blockedRemoteAccessMachines.add(newBlockedMachine);
            } else {
                for (int i = 0; i < this.blockedRemoteAccessMachines.size(); ++i) {
                    BlockedRemoteMachine existing = this.blockedRemoteAccessMachines.get(i);
                    if (existing.machineID.compareTo(id) == 0) {
                        return;
                    }
                    if (existing.machineID.compareTo(id) <= 0) continue;
                    this.blockedRemoteAccessMachines.add(i, newBlockedMachine);
                    return;
                }
                this.blockedRemoteAccessMachines.add(newBlockedMachine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMachineBlocked(String machineID) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.blockedRemoteAccessMachines == null || machineID == null) {
                return false;
            }
            for (BlockedRemoteMachine blockedMachine : this.blockedRemoteAccessMachines) {
                if (blockedMachine.machineID == null || !blockedMachine.machineID.equals(machineID)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isValidTwoTierAdminConfiguration() {
        return this.serverAdminGroup.isValidTwoTierConfiguration() && this.serverAdmin.getEmail() != null && this.serverAdmin.getEmail().length() > 0;
    }

    public boolean isValidTechID(int intValue) {
        TechUser user = this.getTechnicianByID(intValue);
        return user != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechUser[] getUsersInGroup(int groupID) {
        ArrayList<TechUser> users = new ArrayList<TechUser>();
        TechGroup group = this.getGroupByID(groupID);
        Object object = this.LOCK;
        synchronized (object) {
            for (TechUser tech : this.technicians) {
                if (!tech.isInGroup(group.getGroupID())) continue;
                users.add(tech);
            }
        }
        return users.toArray(new TechUser[0]);
    }

    public ToolBoxGroup getToolBoxGroupFor(ToolBoxGroupRef groupRef, ToolBoxRegistryAPI toolBoxRegistryAPI) {
        TechUser user = this.getTechnicianByID(groupRef.techUserID);
        if (user == null) {
            return null;
        }
        ToolBox toolBoxFor = toolBoxRegistryAPI.getToolBoxFor(user);
        if (toolBoxFor != null) {
            ToolBoxGroup group = toolBoxFor.getGroupByID(groupRef.groupID);
            if (group != null) {
                group.setSharedToolboxOwnerID(user.getDefaultName(), user.getUserID());
                return group;
            }
            System.out.println("[ServerConfig] Cannot find toolbox group " + groupRef.groupID);
        }
        return null;
    }

    public boolean isListeningOnPort(int port) {
        for (int p : this.portList) {
            if (p != port) continue;
            return true;
        }
        return false;
    }

    public TOTPConfig getTOTPConfig() {
        return new TOTPConfig(this.totpLength, this.totpWindowSize);
    }

    public LazyEncryptedPassword removeAnonymousUserTOTPKey(TechUser user, int groupID) {
        return this.deprecated_anonymousUserIDToTOTPKey.get(this.getAnonymousUserTOTPKeyID(user, groupID));
    }

    private String getAnonymousUserTOTPKeyID(TechUser user, int groupID) {
        if (user == null) {
            return null;
        }
        return user.getLogin() + " - " + groupID;
    }

    public String getLDAPMemberAttribute() {
        if (this.ldapIsAD) {
            return "memberof";
        }
        if (this.ldapMemberAttribute == null || this.ldapMemberAttribute.length() == 0) {
            return "memberof";
        }
        return this.ldapMemberAttribute;
    }

    public String getLDAPUserClass() {
        if (this.ldapIsAD) {
            return "user";
        }
        if (this.ldapUserClass == null || this.ldapUserClass.length() == 0) {
            return "user";
        }
        return this.ldapUserClass;
    }

    public String getLDAPGroupClass() {
        if (this.ldapIsAD) {
            return "group";
        }
        if (this.ldapGroupClass == null || this.ldapGroupClass.length() == 0) {
            return "group";
        }
        return this.ldapGroupClass;
    }

    public String getLDAPLogin() {
        if (this.ldapIsAD) {
            return "sAMAccountName";
        }
        if (this.ldapLoginAttribute == null || this.ldapLoginAttribute.length() == 0) {
            return "uid";
        }
        return this.ldapLoginAttribute;
    }

    public void setLDAPMemberAttribute(String LDAPMemberAttribute) {
        this.ldapMemberAttribute = LDAPMemberAttribute;
    }

    public void setLDAPLoginAttribute(String LDAPLoginAttribute) {
        this.ldapLoginAttribute = LDAPLoginAttribute;
    }

    public void setLDAPGroupClass(String LDAPGroupClass) {
        this.ldapGroupClass = LDAPGroupClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechUser registerAnonymousTechnician(ProxyServerAPI proxyServer, TechUser techUser) {
        TechGroup newGroup = techUser.getFirstGroup();
        if (newGroup == null) {
            System.out.println("[ServerConfig] [Warning] Unable to create an anonymous technician if no login group is specified.");
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (TechUser user : this.anonymousTechnicians) {
                if (!user.getLogin().equals(techUser.getLogin())) continue;
                TechGroup existingGroup = user.getFirstGroup();
                if (existingGroup == null) {
                    System.out.println("[ServerConfig] [Warning] An anonymous technician account exists with no associated group (" + user.getLogin() + ")");
                    continue;
                }
                if (!newGroup.equals(existingGroup)) continue;
                return user;
            }
            System.out.println("[ServerConfig] Registering technician login for " + techUser.getLogin() + " / " + techUser.getGroupsAsString());
            techUser.setUserID(-1);
            this.anonymousTechnicians.add(techUser);
            techUser.setUserID(this.getTechnicianID());
        }
        techUser.setTOTPKey(ServerConfig.get().removeAnonymousUserTOTPKey(techUser, techUser.getGroups()[0].getGroupID()));
        try {
            proxyServer.saveConfigToDisk();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return techUser;
    }

    public long getLastLoadTime() {
        return this.loadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfig getTrimmedConfig(TechGroup[] groupsUserCanAdmin) {
        ServerConfig newConfig = new ServerConfig();
        ArrayList<TechUser> techniciansToAdminister = new ArrayList<TechUser>();
        Object object = this.LOCK;
        synchronized (object) {
            block3: for (TechUser technician : this.technicians) {
                for (TechGroup adminGroup : groupsUserCanAdmin) {
                    if (!technician.isInGroup(adminGroup)) continue;
                    techniciansToAdminister.add(technician);
                    continue block3;
                }
            }
            block5: for (TechUser technician : this.anonymousTechnicians) {
                for (TechGroup adminGroup : groupsUserCanAdmin) {
                    if (!technician.isInGroup(adminGroup)) continue;
                    techniciansToAdminister.add(technician);
                    continue block5;
                }
            }
        }
        newConfig.technicians.clear();
        newConfig.technicians.addAll(techniciansToAdminister);
        newConfig.groups.clear();
        newConfig.groups.addAll(Arrays.asList(groupsUserCanAdmin));
        return newConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteTechniciansInGroups(TechGroup[] groupsUserCanAdmin, ServerConfig configToApplyFrom) {
        Object object = this.LOCK;
        synchronized (object) {
            this.overwriteTechniciansInGroupsStatic(groupsUserCanAdmin, this.technicians, configToApplyFrom.technicians);
            this.overwriteTechniciansInGroupsStatic(groupsUserCanAdmin, this.anonymousTechnicians, configToApplyFrom.anonymousTechnicians);
        }
    }

    private static boolean isInGroups(TechUser user, TechGroup[] groups) {
        for (TechGroup group : groups) {
            if (!user.isInGroup(group)) continue;
            return true;
        }
        return false;
    }

    private void overwriteTechniciansInGroupsStatic(TechGroup[] groupsUserCanAdmin, ArrayList<TechUser> technicians, ArrayList<TechUser> newTechnicians) {
        ArrayList<TechUser> usersToReplace = new ArrayList<TechUser>();
        for (TechUser existingTechnician : technicians) {
            if (!ServerConfig.isInGroups(existingTechnician, groupsUserCanAdmin)) continue;
            usersToReplace.add(existingTechnician);
        }
        technicians.removeAll(usersToReplace);
        technicians.addAll(newTechnicians);
    }

    public boolean encryptLogs() {
        return this.encryptLogs && !ServerManagement.isDevelopmentServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLDAPAttributeMappingFor(String shAttribute) {
        Object object = this.LOCK;
        synchronized (object) {
            for (LDAPAuthenticator.LDAPAttributeMapping mapping : this.ldapMappings) {
                if (!mapping.shAttribute.equalsIgnoreCase(shAttribute)) continue;
                return mapping.ldapAttributes;
            }
        }
        return null;
    }

    public String getCondenserToken() {
        if (this.condenserToken == null || this.condenserToken.isNull()) {
            return null;
        }
        return this.condenserToken.getDecryptedPassword();
    }

    public void setCondensorToken(String authToken) {
        if (this.condenserToken == null) {
            this.condenserToken = new LazyEncryptedPassword(authToken);
        } else {
            this.condenserToken.setDecryptedPassword(authToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTechnician(TechUser existingUser) {
        Object object = this.LOCK;
        synchronized (object) {
            if (existingUser.isAnonymous()) {
                this.anonymousTechnicians.remove(existingUser);
            } else {
                this.technicians.remove(existingUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TechUser> getAllTechnicians(boolean includeSimpleHelpAdmin) {
        ArrayList<TechUser> allUsers = new ArrayList<TechUser>();
        Object object = this.LOCK;
        synchronized (object) {
            allUsers.addAll(this.technicians);
            allUsers.addAll(this.anonymousTechnicians);
            if (includeSimpleHelpAdmin) {
                allUsers.add(this.serverAdmin);
            }
        }
        return allUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TechUser> getAllAdminTechnicians(boolean includeSimpleHelpAdmin) {
        ArrayList<TechUser> allUsers = new ArrayList<TechUser>();
        Object object = this.LOCK;
        synchronized (object) {
            for (TechUser user : this.technicians) {
                if (!user.isServerAdmin()) continue;
                allUsers.add(user);
            }
            for (TechUser user : this.anonymousTechnicians) {
                if (!user.isServerAdmin()) continue;
                allUsers.add(user);
            }
            if (includeSimpleHelpAdmin) {
                allUsers.add(this.serverAdmin);
            }
        }
        return allUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTechnicians(ArrayList<TechUser> techs) {
        Object object = this.LOCK;
        synchronized (object) {
            this.technicians.clear();
            this.technicians.addAll(techs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnonymousTechnicians(ArrayList<TechUser> techs) {
        Object object = this.LOCK;
        synchronized (object) {
            this.anonymousTechnicians.clear();
            this.anonymousTechnicians.addAll(techs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TechUser> getTechnicians(boolean includeSimpleHelpAdmin) {
        ArrayList<TechUser> allUsers;
        Object object = this.LOCK;
        synchronized (object) {
            allUsers = new ArrayList<TechUser>(this.technicians);
            if (includeSimpleHelpAdmin) {
                allUsers.add(this.serverAdmin);
            }
        }
        return allUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTechnician(TechUser user) {
        Object object = this.LOCK;
        synchronized (object) {
            if (user.isAnonymous()) {
                this.anonymousTechnicians.add(user);
            } else {
                this.technicians.add(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(TechGroup existingGroup) {
        Object object = this.LOCK;
        synchronized (object) {
            this.groups.remove(existingGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(TechGroup group) {
        Object object = this.LOCK;
        synchronized (object) {
            this.groups.add(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(TechGroup[] newGroups) {
        Object object = this.LOCK;
        synchronized (object) {
            this.groups.clear();
            Collections.addAll(this.groups, newGroups);
        }
    }

    public static class BlockedRemoteMachine {
        public MachineName name;
        public String machineID;

        public String toString() {
            return this.name.toString();
        }
    }

    public class HTTPHeader {
        public final String name;
        public final String value;

        public HTTPHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class RadiusConfig
    implements MultiServerPanel.ServerConfiguration {
        public int index;
        public String radiusHostname = null;
        public String radiusSecret = null;
        public int radiusPort = 1812;
        public String radiusAuthProtocol = null;

        @Override
        public String getSummary() {
            return this.radiusHostname;
        }

        public void fromMessage(Message m) {
            this.radiusHostname = m.getNextString();
            this.radiusSecret = m.getNextString();
            this.radiusPort = m.getNextInt();
            this.radiusAuthProtocol = m.getNextString();
        }

        public Message toMessage() {
            Message m = new Message();
            m.append(this.radiusHostname);
            m.append(this.radiusSecret);
            m.append(this.radiusPort);
            m.append(this.radiusAuthProtocol);
            return m;
        }

        public boolean equals(Object o) {
            if (o instanceof RadiusConfig) {
                RadiusConfig rc = (RadiusConfig)o;
                return rc.index == this.index && rc.radiusHostname.equals(this.radiusHostname) && rc.radiusSecret.equals(this.radiusSecret) && rc.radiusPort == this.radiusPort && rc.radiusAuthProtocol.equals(this.radiusAuthProtocol);
            }
            return false;
        }
    }

    public static class ServerStartFailureException
    extends Exception {
        public ServerStartFailureException(String string, Exception e) {
            super(string, e);
        }
    }
}

