/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.authentication;

import bcutil.BCUtil;
import com.aem.shelp.proxy.authentication.TOTPConfig;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;
import utils.string.Base32;

public class TOTPAuthenticator {
    private final TOTPConfig config;
    private static final int TIME_STEP_SIZE_MS = 30000;
    private static final int BASE32 = 0;
    private static final int BASE64 = 1;
    private static final int KEY_REPRESETATION = 0;
    private static final String HMAC_HASH_FUNCTION = "HmacSHA1";
    private static final int SCRATCH_CODE_INVALID = -1;

    public TOTPAuthenticator(TOTPConfig totpConfig) {
        this.config = totpConfig;
    }

    private int calculateCode(byte[] key, long tm) throws Exception {
        byte[] data = new byte[8];
        long value = tm;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        try {
            SecretKeySpec signKey = new SecretKeySpec(key, HMAC_HASH_FUNCTION);
            Mac mac = Mac.getInstance(HMAC_HASH_FUNCTION);
            mac.init(signKey);
            byte[] hash = mac.doFinal(data);
            int offset = hash[hash.length - 1] & 0xF;
            long truncatedHash = 0L;
            for (int i2 = 0; i2 < 4; ++i2) {
                truncatedHash <<= 8;
                truncatedHash |= (long)(hash[offset + i2] & 0xFF);
            }
            truncatedHash &= Integer.MAX_VALUE;
            return (int)(truncatedHash %= (long)this.config.getKeyModulus());
        }
        catch (Exception ex) {
            throw new Exception("Error calculating the authenticator code", ex);
        }
    }

    private long getTimeWindowFromTime(long time) {
        return time / 30000L;
    }

    public boolean checkCode(String secret, long code, long timestamp) {
        byte[] decodedKey = this.decodeSecret(secret);
        long timeWindow = this.getTimeWindowFromTime(timestamp);
        for (int i = -((this.config.getWindowSize() - 1) / 2); i <= this.config.getWindowSize() / 2; ++i) {
            try {
                long hash = this.calculateCode(decodedKey, timeWindow + (long)i);
                if (hash != code) continue;
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private byte[] decodeSecret(String secret) {
        try {
            switch (0) {
                case 0: {
                    return Base32.decode(secret);
                }
                case 1: {
                    return Base64.decode(secret);
                }
            }
            throw new IllegalArgumentException("Unknown key representation type.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TOTPKey createCredentials() throws Exception {
        byte[] buffer = new byte[this.config.getSecretSizeBytes() + this.config.getScratchCodeCount() * this.config.getBytesPerScratchCode()];
        BCUtil.getSecureRandom().nextBytes(buffer);
        byte[] secretKey = new byte[this.config.getSecretSizeBytes()];
        System.arraycopy(buffer, 0, secretKey, 0, Math.min(buffer.length, this.config.getSecretSizeBytes()));
        String generatedKey = this.calculateSecretKey(secretKey);
        int validationCode = this.calculateValidationCode(secretKey);
        List<Integer> scratchCodes = this.calculateScratchCodes(buffer);
        return new TOTPKey(generatedKey, validationCode, scratchCodes);
    }

    private static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private List<Integer> calculateScratchCodes(byte[] buffer) {
        ArrayList<Integer> scratchCodes = new ArrayList<Integer>();
        while (scratchCodes.size() < this.config.getScratchCodeCount()) {
            byte[] scratchCodeBuffer = TOTPAuthenticator.copyOfRange(buffer, this.config.getSecretSizeBytes() + this.config.getBytesPerScratchCode() * scratchCodes.size(), this.config.getSecretSizeBytes() + this.config.getBytesPerScratchCode() * scratchCodes.size() + this.config.getBytesPerScratchCode());
            int scratchCode = this.calculateScratchCode(scratchCodeBuffer);
            if (scratchCode != -1) {
                scratchCodes.add(scratchCode);
                continue;
            }
            scratchCodes.add(this.generateScratchCode());
        }
        return scratchCodes;
    }

    private int calculateScratchCode(byte[] scratchCodeBuffer) {
        if (scratchCodeBuffer.length < this.config.getBytesPerScratchCode()) {
            throw new IllegalArgumentException(String.format("The provided random byte buffer is too small: %d.", scratchCodeBuffer.length));
        }
        int scratchCode = 0;
        for (int i = 0; i < this.config.getBytesPerScratchCode(); ++i) {
            scratchCode = (scratchCode << 8) + (scratchCodeBuffer[i] & 0xFF);
        }
        if (this.validateScratchCode(scratchCode = (scratchCode & Integer.MAX_VALUE) % this.config.getScratchCodeModulus())) {
            return scratchCode;
        }
        return -1;
    }

    private boolean validateScratchCode(int scratchCode) {
        return scratchCode >= this.config.getScratchCodeModulus() / 10;
    }

    private int generateScratchCode() {
        byte[] scratchCodeBuffer;
        int scratchCode;
        do {
            scratchCodeBuffer = new byte[this.config.getBytesPerScratchCode()];
            BCUtil.getSecureRandom().nextBytes(scratchCodeBuffer);
        } while ((scratchCode = this.calculateScratchCode(scratchCodeBuffer)) == -1);
        return scratchCode;
    }

    private int calculateValidationCode(byte[] secretKey) throws Exception {
        return this.calculateCode(secretKey, 0L);
    }

    private String calculateSecretKey(byte[] secretKey) {
        switch (0) {
            case 0: {
                return Base32.encode(secretKey);
            }
            case 1: {
                return new String(Base64.encode(secretKey));
            }
        }
        throw new IllegalArgumentException("Unknown key representation type.");
    }

    public static class TOTPKey {
        String key;
        int validationCode;
        List<Integer> scratchCodes;

        TOTPKey(String key, int validationCode, List<Integer> scratchCodes) {
            this.key = key;
            this.validationCode = validationCode;
            this.scratchCodes = scratchCodes;
        }

        public String getSecret() {
            return this.key;
        }

        public void debugSetSecret(String key) {
            this.key = key;
        }
    }

    public static class TOTPRequest {
        public String username;
        public String hostname;
        public String key;
        public int digits;
        public String issuer;
    }
}

