/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.adminclient;

import com.aem.nodelink.NodeLink;
import com.aem.shelp.common.PC;
import com.aem.shelp.proxy.adminclient.AdminClientHandlerInterface;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageUtils;

public class AdminClientHandler
implements AdminClientHandlerInterface,
PC {
    private final InputStream in;
    private final OutputStream out;
    private final NodeLink sock;

    public AdminClientHandler(NodeLink sock, InputStream in, OutputStream out) {
        this.sock = sock;
        this.in = in;
        this.out = out;
    }

    private Message transact(Message m) throws IOException {
        MessageUtils.writeMessage((OutputStream)this.out, (Message)m);
        Message ret = MessageUtils.readMessage((InputStream)this.in);
        if (ret.getType() != 1) {
            throw new IOException("Error received from AdminSubServer when performing " + m.getType());
        }
        return ret;
    }

    @Override
    public byte[] getServerKeysDat() throws IOException {
        Message m = new Message(5008000);
        Message ret = this.transact(m);
        return ret.getNextByteArray();
    }

    @Override
    public String getBigPipeAuthToken(String clientHostname) throws IOException {
        Message m = new Message(5009000);
        m.append(clientHostname);
        Message ret = this.transact(m);
        return ret.getNextString();
    }

    @Override
    public String getServerPeerName() throws IOException {
        Message m = new Message(5007000);
        Message ret = this.transact(m);
        return ret.getNextString();
    }

    @Override
    public void setUpPeer(PeerConfig config) throws IOException {
        Message m = new Message(5003000);
        m.append(config.toMessage());
        this.transact(m);
    }

    @Override
    public void reloadPeers() throws IOException {
        Message m = new Message(5005000);
        this.transact(m);
    }

    @Override
    public void shutdown() {
        try {
            Message m = new Message(5001000);
            MessageUtils.writeMessage((OutputStream)this.out, (Message)m);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sock.stop("AdminClient shut down as requested");
    }
}

