/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.proxy.TechGroupPermissions;

public class TechPermissionsHandler {
    private boolean needToRequestScreen;
    private boolean needToRequestControl;
    private TechGroupPermissions permissions;

    public TechPermissionsHandler(TechGroupPermissions permissions, boolean technicianWishesToRequestControl) {
        this.permissions = permissions;
        this.needToRequestControl = permissions.mustRequestControl || technicianWishesToRequestControl;
        this.needToRequestScreen = permissions.mustRequestScreen;
    }

    public boolean needToRequestControl() {
        return this.needToRequestControl;
    }

    public boolean needToRequestScreen() {
        return this.needToRequestScreen;
    }

    public boolean canControl() {
        return this.canView() && this.permissions.canControlSessions && !this.needToRequestControl;
    }

    public boolean canControlOrRequestControl() {
        return this.canView() && this.permissions.canControlSessions;
    }

    public boolean canView() {
        return !this.needToRequestScreen;
    }

    public void requestControlApproved() {
        this.needToRequestControl = false;
    }

    public void requestScreenApproved() {
        this.needToRequestScreen = false;
    }

    public TechGroupPermissions getPermissions() {
        return this.permissions;
    }
}

