/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.common.notifications.AlertNotification;
import com.aem.shelp.proxy.common.notifications.ReportNotification;
import com.aem.shelp.tech.reporting.ReportResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.progtools.DataUtil;

public class ServerNotificationUtil {
    private static final Object LOCK = new Object();

    public static Notification getReportCreatedNotification(ReportResult reportResult) {
        return new ReportNotification(reportResult);
    }

    public static Notification getAlertNotification(String title, String message, String alertID, String machineID) {
        return new AlertNotification(title, message, alertID, machineID);
    }

    public static Notification getEventNotification(String title, String message, String eventID) {
        return new Notification(2, 1, System.currentTimeMillis(), title, message, null);
    }

    public static Notification getSupportFinishingNotification(int daysTillFinished, String expiryDate) {
        String message;
        String title;
        if (daysTillFinished <= 0) {
            title = "${SIMPLEHELP_SUPPORT_EXPIRED}";
            message = "${SIMPLEHELP_SUPPORT_EXPIRED_MSG," + expiryDate + "} ${SIMPLEHELP_SUPPORT_ADDENDUM}";
        } else {
            title = "${SIMPLEHELP_SUPPORT_EXPIRING}";
            message = "${SIMPLEHELP_SUPPORT_EXPIRING_MSG," + daysTillFinished + "} ${SIMPLEHELP_SUPPORT_ADDENDUM}";
        }
        return new Notification(0, 1, System.currentTimeMillis(), title, message.toString(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification getNewVersionNotification(boolean isNewVersion, String shortVersion, String fullVersion, boolean inSupportPeriod) {
        Object object = LOCK;
        synchronized (object) {
            File previouslyNotifiedVersionFile = new File("configuration", "latestversion");
            try {
                AtomicFileOutputStream.prepareForReading((File)previouslyNotifiedVersionFile);
                String previouslyQueriedVersion = FileUtil.readFileAsStringUTF8((File)previouslyNotifiedVersionFile);
                if (previouslyQueriedVersion.equals(fullVersion)) {
                    return null;
                }
            }
            catch (FileNotFoundException previouslyQueriedVersion) {
            }
            catch (IOException ex) {
                System.out.println("[ServerNotificationUtil] Unable to read " + previouslyNotifiedVersionFile);
                ex.printStackTrace();
            }
            try (AtomicFileOutputStream afos = new AtomicFileOutputStream(previouslyNotifiedVersionFile);){
                afos.write(fullVersion.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                System.out.println("[ServerNotificationUtil] Unable to write " + previouslyNotifiedVersionFile);
                ex.printStackTrace();
            }
        }
        String title = isNewVersion ? "${SIMPLEHELP_NEW_VERSION," + shortVersion + "}" : "${SIMPLEHELP_NEW_BUILD," + shortVersion + "}";
        StringBuilder message = new StringBuilder();
        if (inSupportPeriod) {
            message.append("${SIMPLEHELP_INSTALL_FREE}");
        } else {
            message.append("${SIMPLEHELP_INSTALL}");
        }
        Notification n = new Notification(0, 0, System.currentTimeMillis(), title, message.toString(), null);
        return n;
    }

    public static Notification getAlertExceededLimitNotification(int machines, int limit) {
        return new Notification(0, 3, System.currentTimeMillis(), "${ALERT_LIMIT_EXCEEDED_TITLE}", "${ALERT_LIMIT_EXCEEDED_MSG," + machines + "," + limit + "}", null);
    }

    public static Notification getMemoryLimitWarning(int percentageUsed, String maxMemory) {
        return new Notification(0, 4, System.currentTimeMillis(), "${MEMORY_LIMIT_WARNING_TITLE}", "${MEMORY_LIMIT_USED," + DataUtil.getSensiblePercentage((int)percentageUsed) + "}. ${MEMORY_LIMIT_WARNING_MSG}", null);
    }

    public static Notification getMemoryLimitError(int percentageUsed, String maxMemory) {
        return new Notification(0, 5, System.currentTimeMillis(), "${MEMORY_LIMIT_ERROR_TITLE}", "${MEMORY_LIMIT_USED," + DataUtil.getSensiblePercentage((int)percentageUsed) + "}. ${MEMORY_LIMIT_ERROR_MSG}", null);
    }
}

