/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.ServerManagement;
import com.aem.shelp.licence.License;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.config.ServerConfig;
import java.io.File;
import java.io.IOException;
import utils.message.Message;

public class LicenseConfig {
    private static LicenseConfig CURRENT_INSTANCE = new LicenseConfig();
    private transient LicenseSet licenses = new LicenseSet();
    private String licenseErrorMessage;

    public static LicenseConfig get() {
        return CURRENT_INSTANCE;
    }

    public byte[] getRecoveryHash() {
        if (this.licenses.size() > 0) {
            return this.licenses.getFirstLicense().getRecoveryHash();
        }
        return null;
    }

    public void loadLicense(License lic) throws IOException {
        if (ServerConfig.get().feature_multiLicense) {
            this.licenses.addLicense(lic);
            return;
        }
        if (!lic.supportsServerBuild()) {
            System.out.println("**************************************************************");
            System.out.println("WARNING: Your license is too old to run this build of " + ServerManagement.getServerName() + ".");
            System.out.println();
            System.out.println("         This server version does not fall within your license maintenance period.");
            System.out.println("         Please visit http://www.simple-help.com/purchase for additional details, ");
            System.out.println("         or to update your license.");
            System.out.println("**************************************************************\n");
            this.licenseErrorMessage = "VALID_LICENSE_EXPIRED";
            throw new IOException(this.licenseErrorMessage);
        }
        System.out.println("[License] SimpleSuite license present");
        this.licenses.setLicenses(lic);
    }

    public void loadLicense(File licenseFile) throws IOException {
        try {
            License lic = License.read(licenseFile);
            this.loadLicense(lic);
        }
        catch (License.ExpiredException x) {
            System.out.println("[License] Expired");
        }
    }

    public boolean hasLicense(boolean validOnly) {
        if (!validOnly) {
            return this.getLicenseSet().size() > 0;
        }
        return this.getLicenseSet().getValidLicenseCount() > 0;
    }

    public String getErrorMessage() {
        return this.licenseErrorMessage;
    }

    public int getMaxSHSessions() {
        return this.licenses.getSessionCount();
    }

    public int getMaxSGSessions() {
        return this.licenses.getSessionCount();
    }

    public boolean isOutOfDate() {
        return this.licenses.isOutOfSupport();
    }

    public boolean isExpiredTrial() {
        return this.licenses.isExpiredTrial();
    }

    public boolean allowsRebranding() {
        return this.licenses.allowsRebranding();
    }

    public int getMaxSDemoAttendees() {
        return this.licenses.getDemoAttendees();
    }

    public void saveToMessage(Message licenseMessage) {
        licenseMessage.append(this.licenses.toMessage());
    }

    public static void fromMessage(Message licenseMessage, LicenseSet set) throws IOException {
        Message m = licenseMessage.getNextMessage();
        set.loadFrom(m);
    }

    public void dumpLicenseDetails() {
        if (LicenseConfig.get().hasLicense(true)) {
            if (ServerConfig.get().feature_multiLicense) {
                LicenseSet set = LicenseConfig.get().licenses;
                System.out.println("Found valid SimpleSuite licenses [" + set.size() + "]:\n\n");
                System.out.println(set);
            } else {
                System.out.println("Found valid SimpleSuite license:\n\n" + LicenseConfig.get().licenses.getFirstLicense());
            }
        } else if (LicenseConfig.get().getErrorMessage() == null) {
            System.out.println("No SimpleSuite license file ('shlicense.txt') found\n");
            System.out.println("SimpleSuite Evaluation allowed for up to one connected session for 21 days from installation date");
        }
        System.out.println("");
    }

    private static void readAllSingleLicenses() {
        File[] possibles = new File[]{new File("configuration/shlicense.txt"), new File("license.txt"), new File("License.txt"), new File("sglicense.txt"), new File("shlicense.txt")};
        LicenseConfig.get().licenses.clear();
        for (File f : possibles) {
            try {
                LicenseConfig.get().loadLicense(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isUnlicensedTrial() {
        return this.licenses.isUnlicensedTrial();
    }

    public boolean isLicensedTrial() {
        return this.licenses.isLicensedTrial();
    }

    public boolean isLicensed() {
        return this.licenses.isLicensed();
    }

    public String getSecRandomFirst128BitsAsHex() {
        if (this.hasLicense(true)) {
            String secRandom = this.licenses.getFirstLicense().getSecRandom();
            if (secRandom == null) {
                return null;
            }
            if (secRandom.length() > 32) {
                return secRandom.substring(0, 32);
            }
            return secRandom;
        }
        return null;
    }

    public LicenseSet getLicenseSet() {
        return this.licenses;
    }

    public void reloadLicense() {
        this.licenses.clear();
        if (ServerConfig.get().feature_multiLicense) {
            File licensesFolder = new File("configuration", "licenses");
            File[] children = licensesFolder.listFiles();
            if (children != null) {
                for (File file : children) {
                    if (!file.getName().endsWith(".txt")) continue;
                    try {
                        LicenseConfig.get().loadLicense(file);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        } else {
            LicenseConfig.readAllSingleLicenses();
        }
        LicenseConfig.get().dumpLicenseDetails();
    }

    public boolean containsLicense(License lic) {
        return this.licenses.containsLicenseWithID(lic.getV2LicenseID());
    }
}

