/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.transports;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.util.BandwidthReporting;
import com.aem.shelp.util.HttpClientSocketTracker;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import utils.message.Message;
import utils.message.MessageUtils;

public class HttpClientLossyTransport
implements LossyTransport {
    String addr;
    String machineRegistryID;
    static HashMap locks = new HashMap();
    static Object locks_LOCK = new Object();
    Object largeSendLOCK = new Object();

    public HttpClientLossyTransport(String host, int port, String machineRegistryID) {
        this.addr = "http://" + host + ":" + port + "/lossyproc";
        this.machineRegistryID = machineRegistryID;
    }

    public HttpClientLossyTransport(String addr, String machineRegistryID) {
        this.addr = addr + "/lossyproc";
        this.machineRegistryID = machineRegistryID;
    }

    @Override
    public boolean providesGuaranteedDelivery() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Singleton getSingleton(String addr) {
        Object object = locks_LOCK;
        synchronized (object) {
            Singleton lock = (Singleton)locks.get(addr);
            if (lock == null) {
                lock = new Singleton();
                locks.put(addr, lock);
            }
            return lock;
        }
    }

    @Override
    public void sendMessage(LossyClient client, Message message) {
        Singleton sg = HttpClientLossyTransport.getSingleton(this.addr);
        sg.sendMessage(client, message, this.addr, this.machineRegistryID, this);
    }

    @Override
    public String getUnderlyingProtocolDescription() {
        return "HTTP";
    }

    @Override
    public Object getLargeSendLock() {
        return this.largeSendLOCK;
    }

    private static class Singleton {
        Object addrLOCK = new Object();
        HttpClientSocketTracker sockTracker = new HttpClientSocketTracker("Lossy");
        int newSockets;

        private Singleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(LossyClient client, Message message, String addr, String machineRegistryID, HttpClientLossyTransport transport) {
            try {
                if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                    System.out.println("[SecmsgInitial] HttpClient asked to send " + message);
                }
                long startedWaiting = SafeClock.currentTimeMillis();
                Object object = this.addrLOCK;
                synchronized (object) {
                    if (SafeClock.currentTimeMillis() - startedWaiting > 110000L) {
                        System.out.println("[SecmsgInitial] ***WARNING HttpClient unable to get addr lock within 110s, exiting to clear");
                        return;
                    }
                    URL url = new URL(addr + "?rand=" + Math.random() + "" + Math.random());
                    URLConnection conn = url.openConnection();
                    conn.setDoOutput(true);
                    conn.setReadTimeout(120000);
                    conn.setUseCaches(false);
                    conn.connect();
                    if (this.sockTracker.checkForNewSocket(conn)) {
                        ++this.newSockets;
                        System.out.println("[LossyTransport] New HTTP client (ns=" + this.newSockets + ") for " + url);
                    }
                    BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
                    DataUtils.writeStringUTF8(out, machineRegistryID);
                    byte[] datOut = MessageUtils.messageToBytes((Message)message);
                    DataUtils.writeBytes(out, datOut);
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                    if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                        System.out.println("[SecmsgInitial] POSTed the message, waiting for messages in response");
                    }
                    InputStream in = conn.getInputStream();
                    if (CentralDebugging.SG_BANDWIDTH_REPORTING) {
                        BandwidthReporting.sentHttp("Lossy Transport " + url.getHost(), datOut.length);
                    }
                    byte[] dat = DataUtils.readAll(in);
                    if (CentralDebugging.SG_BANDWIDTH_REPORTING) {
                        BandwidthReporting.receivedHttp("Lossy Transport " + url.getHost(), dat.length);
                    }
                    if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                        System.out.println("[SecmsgInitial] Read messages in response to post which included " + message + ", size is " + dat.length);
                    }
                    if (dat.length > 0) {
                        Message list = MessageUtils.bytesToMessage((byte[])dat);
                        for (int i = 0; i < list.length(); ++i) {
                            Message rec = (Message)list.get(i);
                            if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                                System.out.println("[SecmsgInitial] Read messages in response to post which included " + message + ", " + i + " is " + rec);
                            }
                            client.lossyMessageReceived(transport, rec, null);
                        }
                    }
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }
}

