/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.fs;

import com.aem.shelp.mdupload.fs.FSConstants;
import com.aem.shelp.mdupload.fs.FSProgress;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.GVolume;
import com.aem.shelp.mdupload.fs.GenericFS;
import com.aem.shelp.mdupload.fs.journal.FSEvent;
import com.aem.shelp.mdupload.fs.journal.FSJournal;
import com.aem.shelp.mdupload.fs.journal.FSJournalListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import utils.files.FileUtil;
import utils.files.rafcache.PooledRAFile;
import utils.ostools.OS;
import utils.string.FnvHash;
import utils.swing.components.path.elements.OSXVolumeUtil;

public class LocalFS
implements GenericFS {
    private File[] ancestorFolders = null;
    private FileNameComparator fileNameComparator = new FileNameComparator();
    private PooledRAFile rafiles = new PooledRAFile(100);
    Object journals_LOCK = new Object();
    HashMap<String, FSJournal> journals = new HashMap();

    public LocalFS() {
    }

    public LocalFS(File[] permittedFolders) {
        this.ancestorFolders = permittedFolders;
        try {
            for (int i = 0; i < this.ancestorFolders.length; ++i) {
                this.ancestorFolders[i] = this.ancestorFolders[i].getCanonicalFile();
            }
        }
        catch (IOException ex) {
            System.out.println("[LocalFS] WARNING: unable to compute canonical file of ancestor folder restriction.");
            ex.printStackTrace();
        }
    }

    public void checkFileAccessPermitted(File file) throws IOException {
        if (this.ancestorFolders == null) {
            return;
        }
        File child = file.getCanonicalFile();
        for (File f : this.ancestorFolders) {
            if (!FileUtil.isDescendentOf((File)child, (File)f) && !child.equals(f)) continue;
            return;
        }
        throw new IOException("File " + file.getCanonicalPath() + " access is not permitted.");
    }

    @Override
    public void closeFile(GFile gf) throws IOException {
        File rafile = new File(gf.path());
        this.checkFileAccessPermitted(rafile);
        this.rafiles.close(rafile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFileChunk(GFile gf, long start, int len) throws IOException {
        File rafile = new File(gf.path());
        this.checkFileAccessPermitted(rafile);
        this.rafiles.seek(rafile, start);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            byte[] dat = new byte[4096];
            int tot = 0;
            int n = 0;
            while (tot < len && n != -1) {
                n = this.rafiles.read(rafile, dat, 0, Math.min(dat.length, len - tot));
                if (n <= 0) continue;
                bout.write(dat, 0, n);
                tot += n;
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFileChunk(GFile gf, long start, byte[] dat, int datstart, int datlen, long lastmod) throws IOException {
        File target = new File(gf.path());
        this.checkFileAccessPermitted(target);
        File dir = target.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.rafiles.seek(target, start);
        try {
            this.rafiles.write(target, dat, datstart, datlen);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        if (lastmod != -1L) {
            target.setLastModified(lastmod);
        }
    }

    public void deleteFiles(String[] paths) throws IOException {
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(paths[i]);
            System.out.println("[LocalFS] Asked to delete " + f);
            this.checkFileAccessPermitted(f);
            System.out.println("[LocalFS] Deleting " + f);
            FileUtil.deleteDir((File)f);
        }
    }

    private static String getPath(File f) throws IOException {
        String path = f.getCanonicalPath();
        if (path.equals("/") || path.equals("\\")) {
            return path;
        }
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static GFile getFile(File f) throws IOException {
        GFile gf = new GFile(LocalFS.getPath(f), f.getName(), f.lastModified(), f.length(), f.isDirectory(), f.isHidden());
        return gf;
    }

    @Override
    public GVolume[] listRoots() throws IOException {
        if (OS.isMacOS()) {
            File[] roots = OSXVolumeUtil.getMacRoots();
            GVolume[] volumes = new GVolume[roots.length];
            for (int i = 0; i < volumes.length; ++i) {
                File root = roots[i];
                boolean isRoot = OSXVolumeUtil.isOSXRootDrive(root);
                String name = root.getName();
                String path = root.getCanonicalPath();
                if (isRoot) {
                    name = OSXVolumeUtil.getOSXVolumeName();
                }
                volumes[i] = new GVolume(name, path, isRoot);
            }
            return volumes;
        }
        File[] roots = File.listRoots();
        GVolume[] volumes = new GVolume[roots.length];
        for (int i = 0; i < volumes.length; ++i) {
            String name;
            File root = roots[i];
            try {
                name = FileSystemView.getFileSystemView().getSystemDisplayName(root);
            }
            catch (Throwable t) {
                System.out.println("[LocalFS] Unable to query FileSystemView: " + t.getMessage() + " (" + t.getClass() + ")");
                name = root.getName();
            }
            String path = root.getCanonicalPath();
            if (name.length() == 0) {
                name = path;
            }
            volumes[i] = new GVolume(name, path, false);
        }
        return volumes;
    }

    @Override
    public void deleteFiles(GFile[] paths) throws IOException {
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(paths[i].path());
            this.checkFileAccessPermitted(f);
            System.out.println("[FS] Delete " + paths[i].path());
            FileUtil.deleteDir((File)f);
        }
    }

    @Override
    public GFile renameFile(GFile path, String newname) throws IOException {
        File orig = new File(path.path());
        this.checkFileAccessPermitted(orig);
        File newfile = new File(orig.getParentFile(), newname);
        System.out.println("[FS] Renaming " + orig + " to " + newfile);
        orig.renameTo(newfile);
        return LocalFS.getFile(newfile);
    }

    @Override
    public boolean isWindowsFS() {
        return File.separator.equals("\\");
    }

    @Override
    public GFile[] listDir(GFile path) throws IOException {
        File dir = new File(path.path());
        this.checkFileAccessPermitted(dir);
        File[] tmp = dir.listFiles();
        if (tmp == null) {
            return new GFile[0];
        }
        Arrays.sort(tmp, this.fileNameComparator);
        GFile[] gfs = new GFile[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            gfs[i] = LocalFS.getFile(tmp[i]);
        }
        return gfs;
    }

    @Override
    public GFile createFolder(GFile path, String newname) throws IOException {
        File parent = new File(path.path());
        File f = new File(parent, newname);
        this.checkFileAccessPermitted(parent);
        f.mkdirs();
        return LocalFS.getFile(f);
    }

    @Override
    public GFile createFolder(GFile path) throws IOException {
        File f = new File(path.path());
        this.checkFileAccessPermitted(f);
        f.mkdirs();
        return LocalFS.getFile(f);
    }

    @Override
    public GFile getParent(GFile path) throws IOException {
        File file = new File(path.path());
        this.checkFileAccessPermitted(file);
        File parent = file.getParentFile();
        if (parent == null) {
            return new GFile("", "", 0L, 0L, true, false);
        }
        return LocalFS.getFile(parent);
    }

    @Override
    public void requestFastTransport() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJournalListener(GFile file, FSJournalListener listener) {
        Object object = this.journals_LOCK;
        synchronized (object) {
            FSJournal jj = this.journals.get(file.path());
            if (jj != null) {
                jj.registerListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startJournaling(GFile file) {
        Object object = this.journals_LOCK;
        synchronized (object) {
            FSJournal jj = this.journals.get(file.path());
            if (jj == null) {
                jj = new FSJournal(this, new File(file.path()));
                this.journals.put(file.path(), jj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopJournaling(GFile file) {
        Object object = this.journals_LOCK;
        synchronized (object) {
            FSJournal jj = this.journals.remove(file.path());
            if (jj != null) {
                jj.stopJournaling();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyJournalFileCreated(GFile journal, GFile localFile) throws IOException {
        Object object = this.journals_LOCK;
        synchronized (object) {
            FSJournal jj = this.journals.get(journal.path());
            jj.notifyFileCreated(localFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyJournalFileDeleted(GFile journal, GFile localFile) throws IOException {
        Object object = this.journals_LOCK;
        synchronized (object) {
            FSJournal jj = this.journals.get(journal.path());
            jj.notifyFileDeleted(localFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FSEvent> getJournalEvents(GFile file, long latestLogicalEvent) throws IOException {
        Object object = this.journals_LOCK;
        synchronized (object) {
            FSJournal jj = this.journals.get(file.path());
            return jj.getEvents(latestLogicalEvent);
        }
    }

    @Override
    public long getFileSize(GFile gFile) throws IOException {
        File file = new File(gFile.path());
        this.checkFileAccessPermitted(file);
        if (file.exists()) {
            return file.length();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getHashes(GFile gFile, boolean forEntireFile) throws IOException {
        int chunkSize = 204800;
        byte[] tmp = new byte[chunkSize];
        File file = new File(gFile.path());
        this.checkFileAccessPermitted(file);
        if (file.exists()) {
            if (forEntireFile) {
                int[] nArray;
                int chunkCount = 0;
                chunkCount = (int)(file.length() / (long)chunkSize);
                if (file.length() % (long)chunkSize > 0L) {
                    ++chunkCount;
                }
                int[] result = new int[chunkCount];
                BufferedInputStream in = null;
                in = new BufferedInputStream(new FileInputStream(file));
                try {
                    int chunkIndex = 0;
                    int read = 0;
                    while (read != -1) {
                        int readSoFar = 0;
                        while (read < chunkSize && (read = ((InputStream)in).read(tmp, read, chunkSize - read)) != -1) {
                            readSoFar += read;
                        }
                        if (readSoFar <= 0) continue;
                        result[chunkIndex++] = FnvHash.hash((byte[])tmp, (int)0, (int)readSoFar, (int)3);
                    }
                    nArray = result;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return new int[0];
                    }
                }
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return nArray;
            }
            try {
                return new int[]{FnvHash.hash((byte[])FileUtil.readFirst((File)file, (long)chunkSize), (int)3), FnvHash.hash((byte[])FileUtil.readLast((File)file, (long)chunkSize), (int)3)};
            }
            catch (IOException e) {
                e.printStackTrace();
                return new int[0];
            }
        }
        return new int[0];
    }

    @Override
    public long getRemoteTime() throws IOException {
        return System.currentTimeMillis();
    }

    @Override
    public long getLastModifiedTime(GFile gFile) throws IOException {
        File file = new File(gFile.path());
        this.checkFileAccessPermitted(file);
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    @Override
    public void setLength(GFile target, long sourceLength) throws IOException {
        File file = new File(target.path());
        this.checkFileAccessPermitted(file);
        if (file.exists()) {
            this.rafiles.setLength(file, sourceLength);
        }
    }

    @Override
    public void setLastModifiedTime(GFile gFile, long time) throws IOException {
        File file = new File(gFile.path());
        this.checkFileAccessPermitted(file);
        if (file.exists()) {
            file.setLastModified(time);
        }
    }

    @Override
    public GFile uploadIntoDir(File local, GFile remoteDir, FSProgress progress) throws IOException {
        GFile remote = GFile.getFileRelativeTo(LocalFS.getFile(local.getParentFile()), LocalFS.getFile(local), remoteDir);
        LocalFS.uploadFile(this, local, remote, progress);
        return remote;
    }

    @Override
    public File downloadIntoDir(File localDir, GFile remoteFileOrDir, FSProgress progress) throws IOException {
        File localFile = new File(localDir, remoteFileOrDir.name);
        LocalFS.downloadFile(this, localFile, remoteFileOrDir, progress);
        return localFile;
    }

    public static void uploadFile(GenericFS fs, File local, GFile remote, FSProgress progress) throws IOException {
        System.out.println("[LocalFS] Asked to upload " + local + " to " + remote.path());
        if (local.isDirectory()) {
            remote = fs.createFolder(remote);
            File[] childs = local.listFiles();
            if (childs != null) {
                for (File child : childs) {
                    GFile remchild = GFile.getFileRelativeTo(LocalFS.getFile(local), LocalFS.getFile(child), remote);
                    LocalFS.uploadFile(fs, child, remchild, progress);
                }
            }
        } else {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(local));
            long locLastModified = local.lastModified();
            byte[] dat = new byte[FSConstants.FILE_DOWNLOAD_CHUNK];
            int n = 0;
            long tot = 0L;
            fs.closeFile(remote);
            long transferred = 0L;
            long nextProgress = 0L;
            while (n != -1) {
                n = ((InputStream)in).read(dat);
                if (n <= 0) continue;
                fs.writeFileChunk(remote, tot, dat, 0, n, locLastModified);
                transferred += (long)n;
                if (progress != null && System.currentTimeMillis() > nextProgress) {
                    nextProgress = System.currentTimeMillis() + 100L;
                    progress.transferredBytes(transferred);
                    transferred = 0L;
                }
                tot += (long)n;
            }
            if (progress != null && System.currentTimeMillis() > nextProgress) {
                nextProgress = System.currentTimeMillis() + 100L;
                progress.transferredBytes(transferred);
                transferred = 0L;
            }
            fs.closeFile(remote);
            ((InputStream)in).close();
        }
    }

    public static void downloadFile(GenericFS fs, File local, GFile remote, FSProgress progress) throws IOException {
        System.out.println("[LocalFS] Asked to download " + remote.path() + " to " + local);
        System.out.println("[AbstractFS] Downloading " + remote.name + " to " + local.getAbsolutePath());
        if (remote.dir) {
            GFile[] all;
            local.mkdirs();
            for (GFile anAll : all = fs.listDir(remote)) {
                File child = new File(local, anAll.name);
                LocalFS.downloadFile(fs, child, anAll, progress);
            }
        } else {
            BufferedOutputStream target = new BufferedOutputStream(new FileOutputStream(local));
            long transferred = 0L;
            long nextProgress = 0L;
            int z = 0;
            while ((long)z < remote.size) {
                byte[] dat = fs.readFileChunk(remote, z, FSConstants.FILE_DOWNLOAD_CHUNK);
                ((OutputStream)target).write(dat);
                transferred += (long)dat.length;
                if (progress != null && System.currentTimeMillis() > nextProgress) {
                    nextProgress = System.currentTimeMillis() + 100L;
                    progress.transferredBytes(transferred);
                    transferred = 0L;
                }
                z += FSConstants.FILE_DOWNLOAD_CHUNK;
            }
            ((OutputStream)target).close();
            if (progress != null && System.currentTimeMillis() > nextProgress) {
                nextProgress = System.currentTimeMillis() + 100L;
                progress.transferredBytes(transferred);
                transferred = 0L;
            }
            fs.closeFile(remote);
            local.setLastModified(remote.lastmodified);
        }
    }

    static class FileNameComparator
    implements Comparator<File> {
        FileNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
        }
    }
}

