/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer.ui;

import com.aem.SafeResourceBundle;
import com.aem.nodelink.utils.DataUtils;
import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class ConnectOptionGlassDialog
extends ScaledGlassDialog
implements ActionListener,
KeyListener {
    private JButton bdone;
    private JButton connectNowButton;
    private boolean incorrectWarning = false;
    private CodeField codePart1;
    private CodeField codePart2;
    private CodeField codePart3;
    private String invitationCode;

    public ConnectOptionGlassDialog(RootPaneContainer frame, boolean incorrectWarning) {
        super(frame, 300, 360, true, true, false);
        this.incorrectWarning = incorrectWarning;
        this.setModal(true);
        this.initUI();
        this.initFocus();
        this.setVisible(true);
    }

    private void initFocus() {
        this.setFocusComponent(this.codePart1);
    }

    private void initUI() {
        this.setTitle(Language.get("REMOTE_SUPPORT_SESSION"));
        this.connectNowButton = new JButton(Language.get("CONNECT_WITH_DETAILS"));
        RoundBorderPanel topPanel = new RoundBorderPanel();
        GbPanelWrapper panelTop = new GbPanelWrapper((Container)topPanel);
        JWrapLabel connectNowDesc = new JWrapLabel("<html><center>" + Language.get("CONNECT_DIALOG_DESC") + "</center></html>");
        panelTop.add((Component)connectNowDesc, 0, 0, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(5, 20, 0, 20));
        panelTop.add((Component)this.connectNowButton, 0, 1, 1, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(10, 0, 5, 0));
        this.connectNowButton.addActionListener(this);
        RoundBorderPanel bottomPanel = new RoundBorderPanel();
        GbPanelWrapper panel = new GbPanelWrapper((Container)bottomPanel);
        JWrapLabel desc = new JWrapLabel("<html><center>" + Language.get("INVITATION_CODE_DIALOG_DESC") + "</center></html>");
        desc.setHorizontalAlignment(0);
        JLabel example = new JLabel(Language.get("EXAMPLE") + ": A1 - B2 - C3");
        example.setFont(SHStyle.smallFont);
        example.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        example.setHorizontalAlignment(0);
        JLabel warning = new JLabel(Language.get("INVITATION_INVALID_CODE"));
        warning.setForeground(SHStyle.ERROR_TEXT_COLOR);
        warning.setHorizontalAlignment(0);
        this.codePart3 = new CodeField(2, null);
        this.codePart2 = new CodeField(2, this.codePart3);
        this.codePart1 = new CodeField(2, this.codePart2);
        Font font = this.codePart1.getFont().deriveFont(SimpleHelpLookAndFeel.scale((float)24.0f));
        this.codePart1.setFont(font);
        this.codePart2.setFont(font);
        this.codePart3.setFont(font);
        this.codePart1.setHorizontalAlignment(0);
        this.codePart2.setHorizontalAlignment(0);
        this.codePart3.setHorizontalAlignment(0);
        JLabel dash1 = new JLabel("-");
        dash1.setFont(font);
        JLabel dash2 = new JLabel("-");
        dash2.setFont(font);
        int Y = 0;
        int X = 0;
        panel.add((Component)desc, 0, Y++, 5, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(5, 20, 10, 20));
        panel.add((Component)this.codePart1, X++, Y, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 30, 10, 10));
        panel.add((Component)dash1, X++, Y, 1, 1, 0, 1, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        panel.add((Component)this.codePart2, X++, Y, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 10, 10, 10));
        panel.add((Component)dash2, X++, Y, 1, 1, 0, 1, 10, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        panel.add((Component)this.codePart3, X++, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 10, 10, 30));
        if (this.incorrectWarning) {
            panel.add((Component)warning, 0, Y++, 5, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(10, 40, 10, 40));
        } else {
            panel.add((Component)example, 0, Y++, 5, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 40, 5, 40));
        }
        panel.add(this.initButtonsPanel(), 0, Y++, 5, 1, 1, 0, 15, 2);
        this.codePart1.addKeyListener(this);
        this.codePart2.addKeyListener(this);
        this.codePart3.addKeyListener(this);
        JLabel orLabel = new JLabel("-OR-");
        orLabel.setHorizontalAlignment(0);
        GbPanel mainPanel = new GbPanel();
        mainPanel.add((Component)topPanel, 0, 0, 1, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(0, 5, 0, 5));
        mainPanel.add((Component)orLabel, 0, 1, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 5, 0, 5));
        mainPanel.add((Component)bottomPanel, 0, 2, 1, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(0, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", (Component)mainPanel);
    }

    private Component initButtonsPanel() {
        this.bdone = new JButton(Language.get("CONNECT_WITH_INVITATION"));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(0, 10, 0, 10));
        buttonsPanel.add((Component)this.bdone, 0, 0, 1, 1, 1, 1, 10, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        buttonsPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.bdone.addActionListener(this);
        this.bdone.setEnabled(false);
        return buttonsPanel;
    }

    private void updateEnabled() {
        if (this.codePart1.getText().length() == 2 && this.codePart2.getText().length() == 2 && this.codePart3.getText().length() == 2) {
            this.bdone.setEnabled(true);
        } else {
            this.bdone.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.bdone.hasFocus()) {
                this.actionPerformed(this.bdone);
            } else if (this.connectNowButton.hasFocus()) {
                this.actionPerformed(this.connectNowButton);
            }
        } else if (e.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void actionPerformed(Object o) {
        if (o == this.bdone) {
            this.invitationCode = this.codePart1.getText() + this.codePart2.getText() + this.codePart3.getText();
            this.setVisible(false);
        } else if (o == this.connectNowButton) {
            this.invitationCode = null;
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateEnabled();
        if (Character.isDigit(e.getKeyChar()) || Character.isLetter(e.getKeyChar())) {
            if (this.codePart1.getText().length() == 2) {
                if (this.codePart2.getText().length() == 2) {
                    this.requestFocus(this.codePart3);
                } else {
                    this.requestFocus(this.codePart2);
                }
            } else {
                this.requestFocus(this.codePart1);
            }
        }
    }

    private void requestFocus(Object source) {
        if (source.equals(this.codePart1)) {
            if (this.codePart1.getText().length() == 2) {
                this.codePart2.requestFocusInWindow();
                this.codePart2.selectAll();
            } else {
                this.codePart1.requestFocusInWindow();
            }
        } else if (source.equals(this.codePart2)) {
            if (this.codePart2.getText().length() == 2) {
                this.codePart3.requestFocusInWindow();
                this.codePart3.selectAll();
            } else {
                this.codePart2.requestFocusInWindow();
            }
        } else if (source.equals(this.codePart3)) {
            if (this.codePart3.getText().length() == 2) {
                this.bdone.requestFocusInWindow();
            } else {
                this.codePart3.requestFocusInWindow();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    public static void main(String[] args) throws IOException {
        SafeResourceBundle language;
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(700, 500);
        frame.setVisible(true);
        FileInputStream urlin = new FileInputStream("lib/translations/en.txt");
        byte[] tmp = DataUtils.readAll(urlin);
        ((InputStream)urlin).close();
        Language.DEFLANG = language = new SafeResourceBundle(new ByteArrayInputStream(tmp));
        ConnectOptionGlassDialog dialog = new ConnectOptionGlassDialog((RootPaneContainer)frame, false);
    }

    public String getInvitationCode() {
        return this.invitationCode;
    }

    public static class CodeField
    extends JTextField {
        private JTextField next;

        public CodeField(int i, JTextField next) {
            super(i);
            this.next = next;
            this.setDocument(this.createDefaultModel());
        }

        @Override
        protected Document createDefaultModel() {
            Document nextDoc = null;
            if (this.next != null) {
                nextDoc = this.next.getDocument();
            }
            return new UpperCaseDocument(this, nextDoc);
        }
    }

    static class UpperCaseDocument
    extends PlainDocument {
        private Document nextDocument;
        private CodeField codeField;

        public UpperCaseDocument(CodeField codeField, Document nextDocument) {
            this.nextDocument = nextDocument;
            this.codeField = codeField;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            str = str.toUpperCase();
            int currentLength = this.getLength();
            int allowed = 2 - currentLength;
            String remainder = "";
            if (str.length() > allowed) {
                remainder = str.substring(allowed);
                str = str.substring(0, allowed);
            }
            super.insertString(offs, str, a);
            if (this.nextDocument != null) {
                this.nextDocument.insertString(this.nextDocument.getLength(), remainder, a);
            }
        }
    }
}

