/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.customer;

import com.aem.CentralDebugging;
import com.aem.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.RootPaneContainer;
import jwrapper.updater.JWLaunchProperties;

public class ParameterHandler {
    Properties parameterProperties;
    RootPaneContainer rpc;
    String codeBase;

    public ParameterHandler(RootPaneContainer rpc, String codeBase) {
        this.rpc = rpc;
        this.codeBase = codeBase;
    }

    public String getParameter(String key) {
        String value = null;
        if (this.rpc instanceof JApplet) {
            value = ((JApplet)this.rpc).getParameter(key);
        }
        if (value == null && JWLaunchProperties.isJWrapperSetup() && (value = JWLaunchProperties.getPropertyPossiblyNull((String)key)) == null) {
            value = JWLaunchProperties.getPropertyPossiblyNull((String)key.toLowerCase());
        }
        if (value == null) {
            value = (String)this.parameterProperties.get(key);
        }
        return value;
    }

    public boolean retrieveParametersFromServer() throws Exception {
        try {
            this.parameterProperties = new Properties();
            URL url = new URL(this.codeBase + "server_side_parameters");
            System.out.println("[ParameterHandler] Retrieving parameters from " + url);
            URLConnection urlc = url.openConnection();
            urlc.setUseCaches(false);
            InputStream in = urlc.getInputStream();
            byte[] data = StreamUtils.readAll(in);
            ByteArrayInputStream bout = new ByteArrayInputStream(data);
            this.parameterProperties.load(bout);
            in.close();
            System.out.println("[ParameterHandler] Retrieved Parameters From Server (" + this.parameterProperties.size() + ").");
            CentralDebugging.loadCentralisedSwitchesFromProperties(this.parameterProperties);
            System.out.println("[ParameterHandler] Delegated properties to CentralDebugging");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("[ParameterHandler] Failed to fetch parameters: assuming default values.");
            throw ex;
        }
    }
}

