/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.SafeResourceBundle;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import jwrapper.jwutils.JWInstallApp;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;

public class Language {
    private static final String ALL_LANGUAGES = "en,gb,de,da,es,fr,it,nl,pt,sv";
    private static final String UTF8_LANGUAGE = "it,de,nl,pt,sv,fr";
    private static final String ISO88591_LANGUAGE = "da,es";
    public static SafeResourceBundle DEFLANG = SafeResourceBundle.getEmptyBundle();
    public static byte[] DEFLANG_SRC = null;
    public static String DEFLANG_ID = "en";

    public static String get(String key) {
        return DEFLANG.getString(key);
    }

    public static String get(String key, Object ... arguments) {
        return DEFLANG.getString(key, arguments);
    }

    public static boolean isUTF8(String language) {
        if (language == null) {
            return false;
        }
        return UTF8_LANGUAGE.contains(language);
    }

    public static boolean isISO88591(String language) {
        if (language == null) {
            return false;
        }
        return ISO88591_LANGUAGE.contains(language);
    }

    public static boolean isSupportedLanguage(String language) {
        if (language == null) {
            return false;
        }
        return ALL_LANGUAGES.contains(language);
    }

    public static String getSelectedLanguage() throws IOException {
        if (!JWLaunchProperties.isJWrapperSetup()) {
            return "en";
        }
        String requestedLanguage = JWInstallApp.getChosenLanguage();
        System.out.println("[Language] Chosen language is " + requestedLanguage);
        if (requestedLanguage != null && !Language.isSupportedLanguage(requestedLanguage = requestedLanguage.trim())) {
            System.out.println("[Language] Language " + requestedLanguage + " is not supported.");
            requestedLanguage = null;
        }
        if (requestedLanguage == null) {
            String[] supportedLanguages = JWSystem.getSupportedLanguages();
            String defaultLanguage = "en";
            if (supportedLanguages.length == 1) {
                defaultLanguage = supportedLanguages[0];
            }
            requestedLanguage = Language.isSupportedLanguage(defaultLanguage) ? defaultLanguage : (supportedLanguages.length > 0 ? supportedLanguages[0] : "en");
        }
        System.out.println("[Language] Got requested language: " + requestedLanguage);
        return requestedLanguage;
    }

    public static void loadTranslations() throws IOException {
        File appFolder = JWSystem.getAppFolder();
        Language.loadTranslationsFrom(appFolder, Language.getSelectedLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCachedSecondaryTranslations() throws IOException {
        System.out.println("[Language] Loading alternative translations from disk");
        File altFile = Language.getAlternativeLanguageFile();
        if (altFile.exists()) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(altFile));){
                byte[] languageFileBytes = StreamUtils.readAll(bis);
                SafeResourceBundle customBundle = new SafeResourceBundle(new ByteArrayInputStream(languageFileBytes));
                DEFLANG.setSubstitutionBundle(customBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTranslationsFrom(File appFolder, String requestedLanguageCode) throws IOException {
        byte[] languageFileBytes;
        File desiredTranslation;
        String requestedLanguage = requestedLanguageCode;
        boolean isGB = requestedLanguage.equals("gb");
        if (isGB) {
            isGB = true;
            requestedLanguage = "en";
        }
        System.out.println("[Language] Loading language: " + requestedLanguage + " from: " + appFolder.getName());
        File translationsFolder = new File(appFolder, "translations");
        if (!translationsFolder.exists()) {
            translationsFolder = new File("../Branding/simplehelp/lib/translations");
        }
        if (!translationsFolder.exists()) {
            translationsFolder = new File("Branding/simplehelp/lib/translations");
        }
        if (!translationsFolder.exists()) {
            translationsFolder = new File("./lib/translations");
        }
        if (!(desiredTranslation = new File(translationsFolder, requestedLanguage + ".txt")).exists()) {
            requestedLanguage = "en";
            desiredTranslation = new File(translationsFolder, requestedLanguage + ".txt");
        }
        try (BufferedInputStream fin = new BufferedInputStream(new FileInputStream(desiredTranslation));){
            languageFileBytes = StreamUtils.readAll(fin);
        }
        if (isGB) {
            languageFileBytes = Language.makeGB(languageFileBytes);
        }
        System.out.println("[Language] Processing language file (size= " + languageFileBytes.length + ") ...");
        DEFLANG = new SafeResourceBundle(new ByteArrayInputStream(languageFileBytes));
        DEFLANG_SRC = languageFileBytes;
        DEFLANG_ID = requestedLanguageCode;
    }

    public static byte[] makeGB(byte[] enLanguageBytes) throws UnsupportedEncodingException {
        String source = new String(enLanguageBytes, StandardCharsets.UTF_8);
        source = source.replace("rganization", "rganisation");
        source = source.replace("ustomized", "ustomised");
        source = source.replace("avorite", "avourite");
        source = source.replace("Color", "Colour");
        source = source.replace("color", "colour");
        return source.getBytes(StandardCharsets.UTF_8);
    }

    public static String getAllSupportedLanguages() {
        return ALL_LANGUAGES;
    }

    private static File getAlternativeLanguageFile() throws IOException {
        File appFolder = JWSystem.getAppFolder();
        String selectedLanguage = Language.getSelectedLanguage();
        return new File(appFolder, "translations/" + selectedLanguage + "_alt.txt");
    }

    public static void justLoadSecondaryTranslations() throws IOException {
        File altFile = Language.getAlternativeLanguageFile();
        if (altFile.exists() && altFile.length() > 0L) {
            byte[] languageFileBytes = FileUtil.readFile((File)altFile);
            SafeResourceBundle customBundle = new SafeResourceBundle(new ByteArrayInputStream(languageFileBytes));
            DEFLANG.setSubstitutionBundle(customBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadSecondaryTranslations(String codebase) throws IOException {
        byte[] languageFileBytes;
        if (!codebase.endsWith("/")) {
            codebase = codebase + "/";
        }
        System.out.println("[CommonHelpUtil] Retrieving customised language file");
        String url = codebase + "translations_user/" + Language.getSelectedLanguage() + ".txt";
        System.out.println("[CommonHelpUtil] Querying " + url);
        System.out.println("[Language] Querying for updated user translations from " + url);
        File altFile = Language.getAlternativeLanguageFile();
        URL urlobj = new URL(url);
        URLConnection urlobjc = urlobj.openConnection();
        urlobjc.setUseCaches(false);
        int length = urlobjc.getContentLength();
        if (length <= 0) {
            if (altFile.exists()) {
                altFile.delete();
            }
            return;
        }
        long lastModified = urlobjc.getLastModified();
        if (!altFile.exists() || lastModified != altFile.lastModified()) {
            System.out.println("[Language] Need to redownload alternative translations");
            InputStream urlin = urlobjc.getInputStream();
            try {
                languageFileBytes = StreamUtils.readAll(urlin);
            }
            finally {
                try {
                    if (urlobjc instanceof HttpURLConnection) {
                        ((HttpURLConnection)urlobjc).disconnect();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    urlin.close();
                }
                catch (Throwable throwable) {}
            }
            System.out.println("[Language] Downloaded " + languageFileBytes.length + " bytes");
            if (languageFileBytes == null || languageFileBytes.length == 0) {
                if (altFile.exists()) {
                    altFile.delete();
                }
                return;
            }
            try {
                System.out.println("[Language] Saving to " + altFile);
                try (BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(altFile));){
                    fout.write(languageFileBytes);
                }
                altFile.setLastModified(lastModified);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            System.out.println("[Language] Loading alternative translations from disk");
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(altFile));){
                languageFileBytes = StreamUtils.readAll(bis);
            }
        }
        SafeResourceBundle customBundle = new SafeResourceBundle(new ByteArrayInputStream(languageFileBytes));
        DEFLANG.setSubstitutionBundle(customBundle);
    }

    public static boolean exists(String key) {
        return !Language.get(key).equals(key);
    }
}

