/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.common;

import com.aem.sgateway.common.AbstractServiceUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.MiniClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;

public class SGServiceStopUtil
extends AbstractServiceUtil {
    TechClient client;
    Machine machine;
    String error;
    boolean v3;

    public SGServiceStopUtil(TechClient client, Machine machine) {
        this.client = client;
        this.machine = machine;
        this.v3 = machine.needsUpgrading();
    }

    /*
     * Loose catch block
     */
    @Override
    public int doUpdate(String machinePassword, String username, String password) {
        MiniClient mc;
        block20: {
            if (this.v3) {
                try {
                    this.client.stopAndDisableV3Machine(new String[]{this.machine.getMachineName().toString()});
                    return RESULT_OK;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    this.error = Language.get("SERVICE_UI_ERROR_GENERAL");
                    System.out.println("[SGServiceStopUtil] Stopping V3 " + this.machine + " failed: " + this.error);
                    return RESULT_ERROR;
                }
            }
            System.out.println("[SGServiceStopUtil] Attempting to stop " + this.machine);
            try {
                mc = this.client.startMiniSession(this.machine.getMachineID());
            }
            catch (Exception x) {
                this.error = Language.get("SERVICE_UI_ERROR_CONNECT");
                System.out.println("[SGServiceStopUtil] Stopping " + this.machine + " failed: " + this.error);
                return RESULT_ERROR;
            }
            if (mc.isElevated()) break block20;
            try {
                mc.doElevate(username, password);
            }
            catch (Exception x) {
                this.error = Language.get("SERVICE_UI_ERROR_CREDENTIALS");
                System.out.println("[SGServiceStopUtil] Stopping " + this.machine + " failed: " + this.error);
                try {
                    System.out.println("[SGServiceStopUtil] Closing mini session to " + this.machine);
                    mc.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return RESULT_CREDENTIALS;
            }
            {
                catch (Exception x) {
                    x.printStackTrace();
                    this.error = Language.get("SERVICE_UI_ERROR_GENERAL");
                    System.out.println("[SGServiceStopUtil] Update of " + this.machine + " failed: " + this.error + " - " + x);
                    return RESULT_ERROR;
                }
            }
        }
        try {
            mc.doSGv4Uninstall();
            System.out.println("[SGServiceStopUtil] Stopping " + this.machine + " was successful");
            try {
                System.out.println("[SGServiceStopUtil] Closing mini session to " + this.machine);
                mc.close();
            }
            catch (Throwable x) {
                // empty catch block
            }
            try {
                this.client.removeOfflineMachine(new Machine[]{this.machine});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return RESULT_OK;
        }
        catch (Exception x) {
            x.printStackTrace();
            this.error = Language.get("SERVICE_UI_ERROR_GENERAL");
            System.out.println("[SGServiceStopUtil] Stopping (V4 Uninstall) of " + this.machine + " failed: " + this.error + " - " + x);
            try {
                System.out.println("[SGServiceStopUtil] Closing mini session to " + this.machine);
                mc.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return RESULT_ERROR;
        }
    }

    @Override
    public String getErrorExplanation() {
        return this.error;
    }
}

